/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.misc.threebeans;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.tests.ejb30.common.helper.TLogger;
import com.sun.ts.tests.ejb30.common.helper.TestFailedException;
import com.sun.ts.tests.ejb30.misc.threebeans.OneRemoteIF;
import com.sun.ts.tests.ejb30.misc.threebeans.ThreeRemoteIF;
import com.sun.ts.tests.ejb30.misc.threebeans.TwoRemoteIF;
import jakarta.ejb.EJB;
import jakarta.ejb.EJBException;
import java.util.Properties;

public class Client
extends EETest {
    @EJB(name="oneRemote")
    private static OneRemoteIF oneRemote;
    @EJB(name="twoRemote")
    private static TwoRemoteIF twoRemote;
    @EJB(beanName="ThreeBean", name="threeRemote")
    private static ThreeRemoteIF threeRemote;
    @EJB(beanName="FourBean", name="fourRemote")
    private static ThreeRemoteIF fourRemote;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
    }

    public void cleanup() throws Exception {
    }

    public void testOne() throws Exception {
        String expected = "OneBean";
        String beanName = oneRemote.getShortName();
        if (!"OneBean".equals(beanName)) {
            throw new Exception("Expecting OneBean, but got " + beanName);
        }
        TLogger.log("Got expected beanName: OneBean");
    }

    public void testException() throws TestFailedException {
        String expected = "testException";
        String result = oneRemote.testException();
        if (!"testException".equals(result)) {
            throw new TestFailedException("Expecting testException, but got " + result);
        }
        TLogger.log("Got expected result: testException");
        result = twoRemote.testException();
        if (!"testException".equals(result)) {
            throw new TestFailedException("Expecting testException, but got " + result);
        }
        TLogger.log("Got expected result: testException");
    }

    public void testNumber() throws Exception {
        String result;
        String expected = Integer.TYPE.getName();
        if (!expected.equals(result = oneRemote.testNumber(2))) {
            throw new Exception("Expecting " + expected + ", but got " + result);
        }
        TLogger.log("Got expected return value from method testNumber(int):" + expected);
        expected = Integer.class.getName();
        result = oneRemote.testNumber(new Integer(2));
        if (!expected.equals(result)) {
            throw new Exception("Expecting " + expected + ", but got " + result);
        }
        TLogger.log("Got expected return value from method testNumber(Integer):" + expected);
        expected = Double.TYPE.getName();
        result = oneRemote.testNumber(2.0);
        if (!expected.equals(result)) {
            throw new Exception("Expecting " + expected + ", but got " + result);
        }
        TLogger.log("Got expected return value from method testNumber(double):" + expected);
        try {
            result = oneRemote.testNumber(new Double(2.0));
            throw new Exception("Expecting EJBException, but got return value: " + result);
        }
        catch (EJBException e) {
            TLogger.log("Got expected EJBException", e.toString());
            return;
        }
    }

    public void testTwo() throws Exception {
        String expected = "TwoBean";
        String beanName = twoRemote.getShortName();
        if (!"TwoBean".equals(beanName)) {
            throw new Exception("Expecting TwoBean, but got " + beanName);
        }
        TLogger.log("Got expected beanName: TwoBean");
    }

    public void testThree() throws Exception {
        String expected = "ThreeBean";
        String beanName = threeRemote.getShortName();
        if (!"ThreeBean".equals(beanName)) {
            throw new Exception("Expecting ThreeBean, but got " + beanName);
        }
        TLogger.log("Got expected beanName: ThreeBean");
    }

    public void testFour() throws Exception {
        String expected = "FourBean";
        String beanName = fourRemote.getShortName();
        if (!"FourBean".equals(beanName)) {
            throw new Exception("Expecting FourBean, but got " + beanName);
        }
        TLogger.log("Got expected beanName: FourBean");
    }
}

