/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jdbc.ee.prepStmt.prepStmt2;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TSNamingContextInterface;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.ServiceEETest;
import com.sun.ts.tests.jdbc.ee.common.DataSourceConnection;
import com.sun.ts.tests.jdbc.ee.common.DriverManagerConnection;
import com.sun.ts.tests.jdbc.ee.common.JDBCTestMsg;
import com.sun.ts.tests.jdbc.ee.common.csSchema;
import com.sun.ts.tests.jdbc.ee.common.dbSchema;
import com.sun.ts.tests.jdbc.ee.common.rsSchema;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Properties;
import javax.sql.DataSource;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="jdbc"), @Tag(value="platform")})
public class prepStmtClient2
extends ServiceEETest
implements Serializable {
    private static final String testName = "jdbc.ee.prepStmt.prepStmt2";
    private TSNamingContextInterface jc = null;
    private transient Connection conn = null;
    private ResultSet rs = null;
    private Statement stmt = null;
    private DataSource ds1 = null;
    private dbSchema dbSch = null;
    private rsSchema rsSch = null;
    private csSchema csSch = null;
    private String drManager = null;
    private transient DatabaseMetaData dbmd = null;
    private Properties sqlp = null;
    private Properties props = null;
    private PreparedStatement pstmt = null;
    private JDBCTestMsg msg = null;

    public static void main(String[] args) {
        prepStmtClient2 theTests = new prepStmtClient2();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            try {
                this.drManager = p.getProperty("DriverManager", "");
                if (this.drManager.length() == 0) {
                    throw new Exception("Invalid DriverManager Name");
                }
                this.props = p;
                this.sqlp = p;
                if (this.drManager.equals("yes")) {
                    this.logTrace("Using DriverManager");
                    DriverManagerConnection dmCon = new DriverManagerConnection();
                    this.conn = dmCon.getConnection(p);
                } else {
                    this.logTrace("Using DataSource");
                    DataSourceConnection dsCon = new DataSourceConnection();
                    this.conn = dsCon.getConnection(p);
                }
                this.stmt = this.conn.createStatement();
                this.dbmd = this.conn.getMetaData();
                this.rsSch = new rsSchema();
                this.csSch = new csSchema();
                this.msg = new JDBCTestMsg();
            }
            catch (SQLException ex) {
                this.logErr("SQL Exception: : " + ex.getMessage(), ex);
            }
        }
        catch (Exception e) {
            this.logErr("Setup Failed!");
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetInt02() throws Exception {
        int maxIntegerVal = 0;
        int rIntegerVal = 0;
        try {
            this.rsSch.createTab("Integer_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Integer_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("to extract the Value of Maximum value to be Updated");
            String smaxIntegerVal = this.rsSch.extractVal("Integer_Tab", 1, this.sqlp, this.conn);
            maxIntegerVal = Integer.parseInt(smaxIntegerVal);
            this.msg.setMsg("get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setInt(1, maxIntegerVal);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Integer_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rIntegerVal = this.rs.getInt(1);
            this.msg.addOutputMsg("" + maxIntegerVal, "" + rIntegerVal);
            if (rIntegerVal == maxIntegerVal) {
                this.msg.setMsg("setInt Method sets the designated parameter to a int value ");
            } else {
                this.msg.printTestError("setInteger Method does not set the designated parameter to a int value ", "Call to setInt is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setInt is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setInt Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Integer_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetDate01() throws Exception {
        Date mfgDateVal = null;
        Date rDateVal = null;
        String smfgDateVal = null;
        try {
            this.rsSch.createTab("Date_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Date_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("to extract the Value of Maximum value to be Updated");
            smfgDateVal = this.rsSch.extractVal("Date_Tab", 1, this.sqlp, this.conn);
            smfgDateVal = smfgDateVal.substring(smfgDateVal.indexOf(39) + 1, smfgDateVal.lastIndexOf(39));
            mfgDateVal = Date.valueOf(smfgDateVal);
            this.msg.setMsg(" get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setDate(1, mfgDateVal);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Date_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rDateVal = this.rs.getDate(1);
            this.msg.addOutputMsg("" + mfgDateVal, "" + rDateVal);
            if (rDateVal.equals(mfgDateVal)) {
                this.msg.setMsg("setDate Method sets the designated parameter to a Date value ");
            } else {
                this.msg.printTestError("setDate Method does not set the designated parameter to a Date value ", "Call to setDate is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setDate is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setDate is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Date_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetDate02() throws Exception {
        Date mfgDateVal = null;
        Date rDateVal = null;
        String smfgDateVal = null;
        Calendar cal = null;
        try {
            this.rsSch.createTab("Date_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Date_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("to extract the Value of Maximum value to be Updated");
            smfgDateVal = this.rsSch.extractVal("Date_Tab", 1, this.sqlp, this.conn);
            smfgDateVal = smfgDateVal.substring(smfgDateVal.indexOf(39) + 1, smfgDateVal.lastIndexOf(39));
            mfgDateVal = Date.valueOf(smfgDateVal);
            cal = Calendar.getInstance();
            this.msg.setMsg(" get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setDate(1, mfgDateVal, cal);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Date_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rDateVal = this.rs.getDate(1, cal);
            this.msg.addOutputMsg("" + mfgDateVal, "" + rDateVal);
            if (rDateVal.equals(mfgDateVal)) {
                this.msg.setMsg("setDate Method sets the designated parameter to a Date value ");
            } else {
                this.msg.printTestError("setDate Method does not set the designated parameter to a Date value ", "Call to setDate is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setDate is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setDate is Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Date_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetDouble01() throws Exception {
        double rDoubleVal = 0.0;
        double minDoubleVal = 0.0;
        try {
            this.rsSch.createTab("Double_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Double_Tab_Max_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("to extract the Value of Minimum value to be Updated");
            String sminDoubleVal = this.rsSch.extractVal("Double_Tab", 2, this.sqlp, this.conn);
            minDoubleVal = Double.parseDouble(sminDoubleVal);
            this.msg.setMsg(" get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setDouble(1, minDoubleVal);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Max_Val_Query = this.sqlp.getProperty("Double_Query_Max", "");
            this.msg.setMsg(Max_Val_Query);
            this.rs = this.stmt.executeQuery(Max_Val_Query);
            this.rs.next();
            rDoubleVal = this.rs.getDouble(1);
            this.msg.addOutputMsg("" + minDoubleVal, "" + rDoubleVal);
            if (rDoubleVal == minDoubleVal) {
                this.msg.setMsg("setDouble Method sets the designated parameter to a Double value ");
            } else {
                this.msg.printTestError("setDouble Method does not set the designated parameter to a Double value ", "Call to setDouble is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setDouble is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setDouble Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Double_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetDouble02() throws Exception {
        double maxDoubleVal = 0.0;
        double rDoubleVal = 0.0;
        try {
            this.rsSch.createTab("Double_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Double_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("to extract the Value of Maximum value to be Updated");
            String smaxDoubleVal = this.rsSch.extractVal("Double_Tab", 1, this.sqlp, this.conn);
            maxDoubleVal = Double.parseDouble(smaxDoubleVal);
            this.msg.setMsg(" get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setDouble(1, maxDoubleVal);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Double_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rDoubleVal = this.rs.getDouble(1);
            this.msg.addOutputMsg("" + maxDoubleVal, "" + rDoubleVal);
            if (rDoubleVal == maxDoubleVal) {
                this.msg.setMsg("setDouble Method sets the designated parameter to a Double value ");
            } else {
                this.msg.printTestError("setDouble Method does not set the designated parameter to a Double value ", "Call to setDouble is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setDouble is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setDouble Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Double_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetLong01() throws Exception {
        long rLongVal = 0L;
        long minLongVal = 0L;
        try {
            this.rsSch.createTab("Bigint_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Bigint_Tab_Max_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("to extract the Value of Minimum value to be Updated");
            String sminLongVal = this.rsSch.extractVal("Bigint_Tab", 2, this.sqlp, this.conn);
            minLongVal = Long.parseLong(sminLongVal);
            this.msg.setMsg(" get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setLong(1, minLongVal);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Max_Val_Query = this.sqlp.getProperty("Bigint_Query_Max", "");
            this.msg.setMsg(Max_Val_Query);
            this.rs = this.stmt.executeQuery(Max_Val_Query);
            this.rs.next();
            rLongVal = this.rs.getLong(1);
            this.msg.addOutputMsg("" + minLongVal, "" + rLongVal);
            if (rLongVal == minLongVal) {
                this.msg.setMsg("setLong Method sets the designated parameter to a long value ");
            } else {
                this.msg.printTestError("setLong Method does not set the designated parameter to a long value ", "Call to setLong is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setLong is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setLong Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Bigint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetLong02() throws Exception {
        long maxLongVal = 0L;
        long rLongVal = 0L;
        try {
            this.rsSch.createTab("Bigint_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Bigint_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("to extract the Value of Maximum value to be Updated");
            String smaxLongVal = this.rsSch.extractVal("Bigint_Tab", 1, this.sqlp, this.conn);
            maxLongVal = Long.parseLong(smaxLongVal);
            this.msg.setMsg(" get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setLong(1, maxLongVal);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Bigint_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rLongVal = this.rs.getLong(1);
            this.msg.addOutputMsg("" + maxLongVal, "" + rLongVal);
            if (rLongVal == maxLongVal) {
                this.msg.setMsg("setLong Method sets the designated parameter to a long value ");
            } else {
                this.msg.printTestError("setLong Method does not set the designated parameter to a long value ", "Call to setLong is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setLong is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setLong Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Bigint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetShort01() throws Exception {
        short rShortVal = 0;
        short minShortVal = 0;
        try {
            this.rsSch.createTab("Smallint_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Smallint_Tab_Max_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("to extract the Value of Minimum value to be Updated ");
            String sminShortVal = this.rsSch.extractVal("Smallint_Tab", 2, this.sqlp, this.conn);
            minShortVal = Short.parseShort(sminShortVal);
            this.msg.setMsg(" get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setShort(1, minShortVal);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Max_Val_Query = this.sqlp.getProperty("Smallint_Query_Max", "");
            this.msg.setMsg(Max_Val_Query);
            this.rs = this.stmt.executeQuery(Max_Val_Query);
            this.rs.next();
            rShortVal = this.rs.getShort(1);
            this.msg.addOutputMsg("" + minShortVal, "" + rShortVal);
            if (rShortVal == minShortVal) {
                this.msg.setMsg("setShort Method sets the designated parameter to a Short value ");
            } else {
                this.msg.printTestError("setShort Method does not set the designated parameter to a Short value ", "Call to setShort is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setShort is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setShort Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Smallint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetShort02() throws Exception {
        short maxShortVal = 0;
        short rShortVal = 0;
        try {
            this.rsSch.createTab("Smallint_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Smallint_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg("to extract the Value of Maximum value to be Updated");
            String smaxShortVal = this.rsSch.extractVal("Smallint_Tab", 1, this.sqlp, this.conn);
            maxShortVal = Short.parseShort(smaxShortVal);
            this.msg.setMsg(" get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setShort(1, maxShortVal);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Smallint_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rShortVal = this.rs.getShort(1);
            this.msg.addOutputMsg("" + maxShortVal, "" + rShortVal);
            if (rShortVal == maxShortVal) {
                this.msg.setMsg("setShort Method sets the designated parameter to a Short value ");
            } else {
                this.msg.printTestError("setShort Method does not set the designated parameter to a Short value ", "Call to setShort is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setShort is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setShort Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Smallint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetNull01() throws Exception {
        int rIntegerVal = 0;
        try {
            this.rsSch.createTab("Integer_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Integer_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg(" get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setNull(1, 4);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Integer_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rIntegerVal = this.rs.getInt(1);
            boolean nullFlag = this.rs.wasNull();
            this.msg.addOutputMsg("true", "" + nullFlag);
            if (nullFlag) {
                this.msg.setMsg("setNull Method sets the designated parameter to a SQL Null");
            } else {
                this.msg.printTestError("setNull Method does not set the designated parameter to a SQL Null ", "Call to setNull is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setNull is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setShort Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Integer_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetNull02() throws Exception {
        float rFloatVal = 0.0f;
        try {
            this.rsSch.createTab("Float_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Float_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String :" + sPrepStmt);
            this.msg.setMsg(" get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setNull(1, 6);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Float_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rFloatVal = this.rs.getFloat(1);
            boolean nullFlag = this.rs.wasNull();
            this.msg.addOutputMsg("true", "" + nullFlag);
            if (nullFlag) {
                this.msg.setMsg("setNull Method sets the designated parameter to a SQL Null");
            } else {
                this.msg.printTestError("setNull Method does not set the designated parameter to a SQL Null ", "Call to setNull is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setNull is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setNull Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Float_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetNull03() throws Exception {
        short rShortVal = 0;
        try {
            this.rsSch.createTab("Smallint_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Smallint_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String :" + sPrepStmt);
            this.msg.setMsg(" get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setNull(1, 5);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Smallint_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rShortVal = this.rs.getShort(1);
            boolean nullFlag = this.rs.wasNull();
            this.msg.addOutputMsg("true", "" + nullFlag);
            if (nullFlag) {
                this.msg.setMsg("setNull Method sets the designated parameter to a SQL Null");
            } else {
                this.msg.printTestError("setNull Method does not set the designated parameter to a SQL Null ", "Call to setNull is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setNull is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setNull Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Smallint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetNull04() throws Exception {
        String rStringVal = null;
        try {
            this.rsSch.createTab("Char_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Char_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg(" get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setNull(1, 1);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Char_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rStringVal = this.rs.getString(1);
            boolean nullFlag = this.rs.wasNull();
            this.msg.addOutputMsg("true", "" + nullFlag);
            if (nullFlag) {
                this.msg.setMsg("setNull Method sets the designated parameter to a SQL Null");
            } else {
                this.msg.printTestError("setNull Method does not set the designated parameter to a SQL Null ", "Call to setNull is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setNull is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setNull Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Char_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetNull05() throws Exception {
        Time rTimeVal = null;
        try {
            this.rsSch.createTab("Time_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Time_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg(" get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setNull(1, 92);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Time_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rTimeVal = this.rs.getTime(1);
            boolean nullFlag = this.rs.wasNull();
            this.msg.addOutputMsg("true", "" + nullFlag);
            if (nullFlag) {
                this.msg.setMsg("setNull Method sets the designated parameter to a SQL Null");
            } else {
                this.msg.printTestError("setNull Method does not set the designated parameter to a SQL Null ", "Call to setNull is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setNull is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setNull Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Time_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetNull06() throws Exception {
        Timestamp rTimestampVal = null;
        try {
            this.rsSch.createTab("Timestamp_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Timestamp_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg(" get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setNull(1, 93);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Timestamp_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rTimestampVal = this.rs.getTimestamp(1);
            boolean nullFlag = this.rs.wasNull();
            this.msg.addOutputMsg("true", "" + nullFlag);
            if (nullFlag) {
                this.msg.setMsg("setNull Method sets the designated parameter to a SQL Null");
            } else {
                this.msg.printTestError("setNull Method does not set the designated parameter to a SQL Null ", "Call to setNull is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setNull is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setNull Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Timestamp_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetNull07() throws Exception {
        Date rDateVal = null;
        try {
            this.rsSch.createTab("Date_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Date_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg(" get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setNull(1, 91);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Date_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rDateVal = this.rs.getDate(1);
            boolean nullFlag = this.rs.wasNull();
            this.msg.addOutputMsg("true", "" + nullFlag);
            if (nullFlag) {
                this.msg.setMsg("setNull Method sets the designated parameter to a SQL Null");
            } else {
                this.msg.printTestError("setNull Method does not set the designated parameter to a SQL Null ", "Call to setNull is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setNull is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setNull Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Date_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetNull08() throws Exception {
        BigDecimal rBigDecimalVal = null;
        try {
            this.rsSch.createTab("Numeric_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Numeric_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg(" get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setNull(1, 2);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Numeric_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rBigDecimalVal = this.rs.getBigDecimal(1);
            boolean nullFlag = this.rs.wasNull();
            this.msg.addOutputMsg("true", "" + nullFlag);
            if (nullFlag) {
                this.msg.setMsg("setNull Method sets the designated parameter to a SQL Null");
            } else {
                this.msg.printTestError("setNull Method does not set the designated parameter to a SQL Null ", "Call to setNull is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setNull is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setNull Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Numeric_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetNull09() throws Exception {
        byte rByteVal = 0;
        try {
            this.rsSch.createTab("Tinyint_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Tinyint_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg(" get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setNull(1, -6);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Tinyint_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rByteVal = this.rs.getByte(1);
            boolean nullFlag = this.rs.wasNull();
            this.msg.addOutputMsg("true", "" + nullFlag);
            if (nullFlag) {
                this.msg.setMsg("setNull Method sets the designated parameter to a SQL Null");
            } else {
                this.msg.printTestError("setNull Method does not set the designated parameter to a SQL Null ", "Call to setNull is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setNull is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setNull Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Tinyint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetNull10() throws Exception {
        double rDoubleVal = 0.0;
        try {
            this.rsSch.createTab("Double_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Double_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg(" get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setNull(1, 8);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Double_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rDoubleVal = this.rs.getDouble(1);
            boolean nullFlag = this.rs.wasNull();
            this.msg.addOutputMsg("true", "" + nullFlag);
            if (nullFlag) {
                this.msg.setMsg("setNull Method sets the designated parameter to a SQL Null");
            } else {
                this.msg.printTestError("setNull Method does not set the designated parameter to a SQL Null ", "Call to setNull is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setNull is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setNull Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Double_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetNull11() throws Exception {
        long rLongVal = 0L;
        try {
            this.rsSch.createTab("Bigint_Tab", this.sqlp, this.conn);
            String sPrepStmt = this.sqlp.getProperty("Bigint_Tab_Null_Update", "");
            this.msg.setMsg("Prepared Statement String: " + sPrepStmt);
            this.msg.setMsg(" get the PreparedStatement object");
            this.pstmt = this.conn.prepareStatement(sPrepStmt);
            this.pstmt.setNull(1, -5);
            this.pstmt.executeUpdate();
            this.msg.setMsg("to query from the database to check the call of pstmt.executeUpdate");
            String Null_Val_Query = this.sqlp.getProperty("Bigint_Query_Null", "");
            this.msg.setMsg(Null_Val_Query);
            this.rs = this.stmt.executeQuery(Null_Val_Query);
            this.rs.next();
            rLongVal = this.rs.getLong(1);
            boolean nullFlag = this.rs.wasNull();
            this.msg.addOutputMsg("true", "" + nullFlag);
            if (nullFlag) {
                this.msg.setMsg("setNull Method sets the designated parameter to a SQL Null");
            } else {
                this.msg.printTestError("setNull Method does not set the designated parameter to a SQL Null ", "Call to setNull is Failed!");
            }
            this.msg.printTestMsg();
            this.msg.printOutputMsg();
        }
        catch (SQLException sqle) {
            this.msg.printSQLError(sqle, "Call to setNull is Failed!");
        }
        catch (Exception e) {
            this.msg.printError(e, "Call to setNull Failed!");
        }
        finally {
            try {
                if (this.rs != null) {
                    this.rs.close();
                    this.rs = null;
                }
                if (this.pstmt != null) {
                    this.pstmt.close();
                    this.pstmt = null;
                }
                if (this.stmt != null) {
                    this.stmt.close();
                    this.stmt = null;
                }
                this.rsSch.dropTab("Bigint_Tab", this.conn);
            }
            catch (Exception sqle) {}
        }
    }

    public void cleanup() throws Exception {
        try {
            if (this.pstmt != null) {
                this.pstmt.close();
                this.pstmt = null;
            }
            if (this.stmt != null) {
                this.stmt.close();
                this.stmt = null;
            }
            this.rsSch.dbUnConnect(this.conn);
            this.logMsg("Cleanup ok;");
        }
        catch (Exception e) {
            this.logErr("An error occurred while closing the database connection", e);
        }
    }
}

