/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.appclient.txtopictests;

import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.ServiceEETest;
import com.sun.ts.tests.jms.common.JmsTool;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicConnection;
import jakarta.jms.TopicPublisher;
import jakarta.jms.TopicSession;
import jakarta.jms.TopicSubscriber;
import java.util.ArrayList;
import java.util.Properties;

public class TxTopicTests
extends ServiceEETest {
    private static final String testName = "com.sun.ts.tests.jms.ee.ejbjspservlet.txtopictests.TxTopicTests";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private Properties props = null;
    private transient JmsTool tool = null;
    long timeout;
    private String jmsUser;
    private String jmsPassword;
    private String mode;
    public static final int TOPIC = 1;
    ArrayList connections = null;

    public static void main(String[] args) {
        TxTopicTests theTests = new TxTopicTests();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        try {
            this.logTrace("In setup");
            this.jmsUser = p.getProperty("user");
            this.jmsPassword = p.getProperty("password");
            this.timeout = Long.parseLong(p.getProperty("jms_timeout"));
            this.mode = p.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'timeout' (milliseconds) in ts.jte must be > 0");
            }
            this.connections = new ArrayList(5);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    public void cleanup() throws Exception {
        try {
            if (this.tool != null) {
                this.logMsg("Cleanup: Closing Topic Connections");
                this.tool.closeAllConnections(this.connections);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            this.logErr("An error occurred while cleaning");
            throw new Exception("Cleanup failed!", e);
        }
    }

    public void commitAckMsgTopicTest() throws Exception {
        String lookup = "DURABLE_SUB_CONNECTION_FACTORY";
        try {
            TextMessage mSent = null;
            TextMessage mReceived = null;
            TopicSession tSess = null;
            TopicPublisher tPub = null;
            TopicSubscriber tSub = null;
            String msg = "test message for commitAckMsgTest";
            String subscriptionName = "commitAckMsgTopicTestSubscription";
            this.tool = new JmsTool(5, this.jmsUser, this.jmsPassword, lookup, this.mode);
            this.tool.getDefaultTopicSubscriber().close();
            tSess = this.tool.getDefaultTopicSession();
            tPub = this.tool.getDefaultTopicPublisher();
            tSub = tSess.createDurableSubscriber(this.tool.getDefaultTopic(), subscriptionName);
            this.tool.getDefaultTopicConnection().start();
            this.logTrace("Send first message");
            mSent = tSess.createTextMessage();
            mSent.setBooleanProperty("lastMessage", false);
            mSent.setText(msg);
            mSent.setStringProperty("COM_SUN_JMS_TESTNAME", "commitAckMsgTopicTest1");
            tPub.publish((Message)mSent);
            tSess.commit();
            this.logTrace("Send second message");
            mSent.setBooleanProperty("lastMessage", true);
            tPub.publish((Message)mSent);
            tSess.commit();
            this.logTrace("Message sent. Receive with tx session, do not acknowledge.");
            mReceived = (TextMessage)tSub.receive(this.timeout);
            if (mReceived == null) {
                this.logMsg("Did not receive message!");
                throw new Exception("Did not receive message first time");
            }
            this.logTrace("Received message: \"" + mReceived.getText() + "\"");
            this.logTrace("Call commit() without calling acknowledge().");
            tSess.commit();
            this.logTrace("Close session and create new one.");
            tSess.close();
            tSess = this.tool.getDefaultTopicConnection().createTopicSession(false, 1);
            tSub = tSess.createDurableSubscriber(this.tool.getDefaultTopic(), subscriptionName);
            mReceived = (TextMessage)tSub.receive(this.timeout);
            if (mReceived == null) {
                this.logMsg("Did not receive message!");
                throw new Exception("Did not receive expected message");
            }
            if (!mReceived.getBooleanProperty("lastMessage")) {
                this.logMsg("Received orignal message again. Was not acknowledged by commit().");
                throw new Exception("Message not acknowledged by commit");
            }
            if (mReceived.getBooleanProperty("lastMessage")) {
                this.logMsg("Pass: received proper message");
            }
            tSub.close();
            tSess.unsubscribe(subscriptionName);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("commitAckMsgTopicTest");
        }
    }

    public void rollbackRecoverTopicTest() throws Exception {
        String lookup = "MyTopicConnectionFactory";
        try {
            TextMessage mSent = null;
            TextMessage mReceived = null;
            TopicSession tSess = null;
            TopicPublisher tPub = null;
            TopicSubscriber tSub = null;
            String msg = "test message for rollbackRecoverTest";
            this.tool = new JmsTool(3, this.jmsUser, this.jmsPassword, lookup, this.mode);
            this.tool.getDefaultTopicSession().close();
            tSess = this.tool.getDefaultTopicConnection().createTopicSession(true, 1);
            tPub = tSess.createPublisher(this.tool.getDefaultTopic());
            tSub = tSess.createSubscriber(this.tool.getDefaultTopic());
            this.tool.getDefaultTopicConnection().start();
            mSent = tSess.createTextMessage();
            mSent.setText(msg);
            mSent.setStringProperty("COM_SUN_JMS_TESTNAME", "rollbackRecoverTopicTest");
            tPub.publish((Message)mSent);
            tSess.commit();
            this.logTrace("Message sent. Receive with tx session, do not acknowledge.");
            mReceived = (TextMessage)tSub.receive(this.timeout);
            if (mReceived == null) {
                this.logMsg("Did not receive message!");
                throw new Exception("Did not receive message first time");
            }
            this.logTrace("Received message: \"" + mReceived.getText() + "\"");
            this.logTrace("Call rollback() without acknowledging message.");
            tSess.rollback();
            this.logTrace("Attempt to receive message again");
            mReceived = (TextMessage)tSub.receive(this.timeout);
            if (mReceived == null) {
                this.logMsg("Did not receive message!");
                throw new Exception("Did not receive expected message");
            }
            if (!mReceived.getText().equals(msg)) {
                throw new Exception("Received unexpected message");
            }
            this.logMsg("Received orignal message again. Was not acknowledged.");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("rollbackRecoverTopicTest");
        }
    }

    public void redeliveredFlagTxTopicTest() throws Exception {
        String lookup = "MyTopicConnectionFactory";
        try {
            TextMessage sentMsg = null;
            TextMessage recMsg = null;
            this.tool = new JmsTool(3, this.jmsUser, this.jmsPassword, lookup, this.mode);
            this.tool.getDefaultTopicConnection().start();
            this.logTrace("publish and receive one message");
            sentMsg = this.tool.getDefaultTopicSession().createTextMessage();
            sentMsg.setText("test message for redelivered flag");
            sentMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "redeliveredFlagTxTopicTest");
            this.tool.getDefaultTopicPublisher().publish((Message)sentMsg);
            this.tool.getDefaultTopicSession().commit();
            recMsg = (TextMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            if (recMsg == null) {
                this.logMsg("Did not receive expected message!");
                throw new Exception("Did not receive message");
            }
            this.logTrace("Message received. Check redelivered flag.");
            boolean redelivered = recMsg.getJMSRedelivered();
            this.logTrace("redelivered = " + redelivered);
            if (redelivered) {
                throw new Exception("Message redelivered flag should be false");
            }
            this.logTrace("calling rollback()");
            this.tool.getDefaultTopicSession().rollback();
            this.logTrace("receive message again");
            recMsg = (TextMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            this.tool.getDefaultTopicSession().commit();
            redelivered = recMsg.getJMSRedelivered();
            this.logTrace("redelivered flag = " + redelivered);
            if (!redelivered) {
                throw new Exception("Message redelivered flag should be true");
            }
        }
        catch (Exception e) {
            this.logMsg("Error: " + e);
            throw new Exception("redeliveredFlagTxTopicTest", e);
        }
    }

    public void transactionRollbackOnSessionCloseReceiveTopicTest() throws Exception {
        String lookup = "DURABLE_SUB_CONNECTION_FACTORY";
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            String subscriptionName = "TxTopicTestSubscription";
            this.tool = new JmsTool(5, this.jmsUser, this.jmsPassword, lookup, this.mode);
            this.tool.getDefaultTopicSubscriber().close();
            TopicSession newTopicSess = this.tool.getDefaultTopicConnection().createTopicSession(true, 0);
            TopicSubscriber newSubscriber = newTopicSess.createDurableSubscriber(this.tool.getDefaultTopic(), subscriptionName);
            this.logTrace("Start connection");
            this.tool.getDefaultTopicConnection().start();
            messageSent = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent.setBooleanProperty("lastMessage", false);
            messageSent.setText("transaction message test");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "transactionRollbackOnSessionCloseReceiveTopicTest");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            this.tool.getDefaultTopicSession().commit();
            messageReceived = (TextMessage)newSubscriber.receive(this.timeout);
            newTopicSess.commit();
            if (!messageReceived.getText().equals(messageSent.getText())) {
                throw new Exception("didn't get the right message");
            }
            this.logTrace("Message text: \"" + messageReceived.getText() + "\"");
            this.logTrace("Received correct message");
            messageSent.setBooleanProperty("lastMessage", true);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            this.tool.getDefaultTopicSession().commit();
            this.logTrace("Receive message and call close()");
            messageReceived = (TextMessage)newSubscriber.receive(this.timeout);
            newTopicSess.close();
            this.logTrace("Create new session and attempt to receive message");
            newTopicSess = this.tool.getDefaultTopicConnection().createTopicSession(true, 0);
            newSubscriber = newTopicSess.createDurableSubscriber(this.tool.getDefaultTopic(), subscriptionName);
            messageReceived = (TextMessage)newSubscriber.receive(this.timeout);
            newTopicSess.commit();
            newSubscriber.close();
            newTopicSess.unsubscribe(subscriptionName);
            if (messageReceived == null) {
                throw new Exception("Fail: Should have received message");
            }
            if (messageReceived.getBooleanProperty("lastMessage")) {
                this.logTrace("Pass: received message again, previous tx was rolled back");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("transactionRollbackOnSessionCloseReceiveTopicTest");
        }
    }

    public void transactionRollbackOnPublishTopicTest() throws Exception {
        String lookup = "DURABLE_SUB_CONNECTION_FACTORY";
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            String subscriptionName = "TxTopicTestSubscription";
            this.tool = new JmsTool(5, this.jmsUser, this.jmsPassword, lookup, this.mode);
            this.tool.getDefaultTopicSubscriber().close();
            TopicSubscriber tSub = this.tool.getDefaultTopicSession().createDurableSubscriber(this.tool.getDefaultTopic(), subscriptionName);
            this.logTrace("Start connection");
            this.tool.getDefaultTopicConnection().start();
            TopicSession newTopicSess = this.tool.getDefaultTopicConnection().createTopicSession(true, 0);
            TopicPublisher newPublisher = newTopicSess.createPublisher(this.tool.getDefaultTopic());
            this.logTrace("Creating 1 message");
            messageSent = newTopicSess.createTextMessage();
            messageSent.setBooleanProperty("lastMessage", false);
            messageSent.setText("transaction message test");
            this.logTrace("Publish the  message");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "transactionRollbackOnPublishTopicTest");
            newPublisher.publish((Message)messageSent);
            this.logTrace("Call commit");
            newTopicSess.commit();
            this.logTrace("Receiving message");
            messageReceived = (TextMessage)tSub.receive(this.timeout);
            if (!messageReceived.getText().equals(messageSent.getText())) {
                throw new Exception("didn't get the right message");
            }
            this.logTrace("Message text: \"" + messageReceived.getText() + "\"");
            this.logTrace("Received correct message");
            this.logTrace("Publish a message, but then rollback");
            newPublisher.publish((Message)messageSent);
            newTopicSess.rollback();
            this.logTrace("Publish 3rd message");
            messageSent.setBooleanProperty("lastMessage", true);
            newPublisher.publish((Message)messageSent);
            newTopicSess.commit();
            this.logTrace("Attempt to receive last message only");
            messageReceived = (TextMessage)tSub.receive(this.timeout);
            this.tool.getDefaultTopicSession().commit();
            if (messageReceived == null) {
                throw new Exception("Fail: Should have received message");
            }
            if (messageReceived.getBooleanProperty("lastMessage")) {
                this.logTrace("Pass: last msg received, proper message was rolledback");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("transactionRollbackOnPublishTopicTest");
        }
    }

    public void transactionRollbackOnRecTopicTest() throws Exception {
        String lookup = "MyTopicConnectionFactory";
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            TextMessage messageReceived2 = null;
            this.tool = new JmsTool(3, this.jmsUser, this.jmsPassword, lookup, this.mode);
            this.logTrace("Start connection");
            this.tool.getDefaultTopicConnection().start();
            TopicSession newTopicSess = this.tool.getDefaultTopicConnection().createTopicSession(true, 1);
            TopicPublisher newPublisher = newTopicSess.createPublisher(this.tool.getDefaultTopic());
            this.logTrace("Creating 1 message");
            messageSent = newTopicSess.createTextMessage();
            messageSent.setText("transaction message test");
            this.logTrace("Sending message");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "transactionRollbackOnRecTopicTest");
            newPublisher.publish((Message)messageSent);
            this.logTrace("Call commit");
            newTopicSess.commit();
            this.logTrace("Receiving message");
            messageReceived = (TextMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            this.logTrace("Call commit");
            this.tool.getDefaultTopicSession().commit();
            if (!messageReceived.getText().equals(messageSent.getText())) {
                throw new Exception("didn't get the right message");
            }
            this.logTrace("Message text: \"" + messageReceived.getText() + "\"");
            this.logTrace("Received correct message");
            this.logTrace("Publish the message and commit it");
            newPublisher.publish((Message)messageSent);
            newTopicSess.commit();
            messageReceived = (TextMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            this.logTrace("Rollback after getting the message");
            this.tool.getDefaultTopicSession().rollback();
            this.logTrace("Doing a second receive - getting messageReceived2 ");
            messageReceived2 = (TextMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            this.logTrace("Since the receive was not committed, I expect the message to still be there");
            if (messageReceived2 == null) {
                throw new Exception("Fail: message was not rolled back to the topic");
            }
            if (!messageReceived.getText().equals(messageReceived2.getText())) {
                throw new Exception("Did not receive expected message after not doing the commit");
            }
            this.logTrace("Message text: \"" + messageReceived.getText() + "\"");
            this.logTrace("Message2 text: \"" + messageReceived2.getText() + "\"");
            this.logTrace("Pass: Message was recovered");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("transactionRollbackOnRecTopicTest");
        }
    }

    public void txRollbackOnConnectionCloseReceiveTopicTest() throws Exception {
        String lookup = "DURABLE_SUB_CONNECTION_FACTORY";
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            String subscriptionName = "TxTopicTestSubscription";
            String clientID = null;
            this.tool = new JmsTool(5, this.jmsUser, this.jmsPassword, lookup, this.mode);
            clientID = this.tool.getDefaultTopicConnection().getClientID();
            this.tool.getDefaultTopicSubscriber().close();
            TopicSubscriber tSub = this.tool.getDefaultTopicSession().createDurableSubscriber(this.tool.getDefaultTopic(), subscriptionName);
            this.logTrace("Start connection");
            this.tool.getDefaultTopicConnection().start();
            messageSent = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent.setBooleanProperty("lastMessage", false);
            messageSent.setText("transaction message test");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "txRollbackOnConnectionCloseReceiveTopicTest");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            this.tool.getDefaultTopicSession().commit();
            messageReceived = (TextMessage)tSub.receive(this.timeout);
            this.tool.getDefaultTopicSession().commit();
            if (!messageReceived.getText().equals(messageSent.getText())) {
                throw new Exception("didn't get the right message");
            }
            this.logTrace("Message text: \"" + messageReceived.getText() + "\"");
            this.logTrace("Received correct message");
            this.logTrace("send second message");
            messageSent.setBooleanProperty("lastMessage", true);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            this.tool.getDefaultTopicSession().commit();
            this.logTrace("Receive message");
            messageReceived = (TextMessage)tSub.receive(this.timeout);
            if (messageReceived == null) {
                throw new Exception("Should have received second message");
            }
            this.logTrace("Call connection.close()");
            this.tool.getDefaultTopicConnection().close();
            this.logTrace("Create new connection and attempt to receive message");
            TopicConnection newConn = (TopicConnection)this.tool.getNewConnection(4, this.jmsUser, this.jmsPassword, lookup);
            this.connections.add(newConn);
            String newClientID = newConn.getClientID();
            if (newClientID == null || !newClientID.equals(clientID)) {
                try {
                    newConn.setClientID(clientID);
                }
                catch (JMSException je) {
                    TestUtil.printStackTrace((Throwable)je);
                    this.logMsg("Warning: cannot set client ID to match first connection.\nTest may not be able to use same durable subscription");
                }
            }
            TopicSession newTopicSess = newConn.createTopicSession(true, 0);
            TopicSubscriber newSubscriber = newTopicSess.createDurableSubscriber(this.tool.getDefaultTopic(), subscriptionName);
            newConn.start();
            this.logTrace("receive message");
            messageReceived = (TextMessage)newSubscriber.receive(this.timeout);
            newTopicSess.commit();
            newSubscriber.close();
            newTopicSess.unsubscribe(subscriptionName);
            newConn.close();
            if (messageReceived == null) {
                throw new Exception("Fail: Should have received message");
            }
            if (messageReceived.getBooleanProperty("lastMessage")) {
                this.logTrace("Pass: received message again, previous tx was rolled back");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("txRollbackOnConnectionCloseReceiveTopicTest");
        }
    }

    public void commitRollbackMultiMsgsTest() throws Exception {
        boolean pass = true;
        int numMessages = 3;
        try {
            int i;
            TextMessage tempMsg = null;
            this.tool = new JmsTool(16, this.jmsUser, this.jmsPassword, this.mode);
            Destination destination = this.tool.getDefaultDestination();
            Session session = this.tool.getDefaultSession();
            Connection connection = this.tool.getDefaultConnection();
            MessageProducer producer = this.tool.getDefaultProducer();
            MessageConsumer consumer = this.tool.getDefaultConsumer();
            Topic topic = (Topic)destination;
            connection.start();
            TestUtil.logMsg((String)("Send " + numMessages + " messages to Topic and call rollback()"));
            for (i = 1; i <= numMessages; ++i) {
                tempMsg = session.createTextMessage("Message " + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "commitRollbackMultiMsgsTest" + i);
                producer.send((Message)tempMsg);
                TestUtil.logMsg((String)("Message " + i + " sent"));
            }
            session.rollback();
            TestUtil.logMsg((String)"Should not consume any messages in Topic since rollback() was called");
            tempMsg = (TextMessage)consumer.receive(this.timeout);
            if (tempMsg != null) {
                TestUtil.logErr((String)("Received message " + tempMsg.getText() + ", expected NULL (NO MESSAGES)"));
                pass = false;
            }
            TestUtil.logMsg((String)("Send " + numMessages + " messages to Topic and call commit()"));
            for (i = 1; i <= numMessages; ++i) {
                tempMsg = session.createTextMessage("Message " + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "commitRollbackMultiMsgsTest" + i);
                producer.send((Message)tempMsg);
                TestUtil.logMsg((String)("Message " + i + " sent"));
            }
            session.commit();
            TestUtil.logMsg((String)"Should consume all messages in Topic since commit() was called");
            for (int msgCount = 1; msgCount <= numMessages; ++msgCount) {
                tempMsg = (TextMessage)consumer.receive(this.timeout);
                if (tempMsg == null) {
                    TestUtil.logErr((String)"MessageConsumer.receive() returned NULL");
                    TestUtil.logErr((String)("Message " + msgCount + " missing from Topic"));
                    pass = false;
                    continue;
                }
                if (!tempMsg.getText().equals("Message " + msgCount)) {
                    TestUtil.logErr((String)("Received [" + tempMsg.getText() + "] expected [Message " + msgCount + "]"));
                    pass = false;
                    continue;
                }
                TestUtil.logMsg((String)("Received message: " + tempMsg.getText()));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e));
            throw new Exception("commitRollbackMultiMsgsTest");
        }
        if (!pass) {
            throw new Exception("commitRollbackMultiMsgsTest failed");
        }
    }
}

