/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.persistence.core.annotations.elementcollection;

import com.sun.ts.lib.harness.Status;
import ee.jakarta.tck.persistence.common.PMClientBase;
import ee.jakarta.tck.persistence.core.annotations.elementcollection.Customer;
import ee.jakarta.tck.persistence.core.annotations.elementcollection.CustomerXML;
import java.util.ArrayList;
import java.util.Properties;

public class Client2
extends PMClientBase {
    public static void main(String[] args) {
        Client2 theTests = new Client2();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.logTrace("setup");
        try {
            super.setup(args, p);
            this.removeCustTestData();
        }
        catch (Exception e) {
            this.logErr("Exception: ", e);
            throw new Exception("Setup failed:", e);
        }
    }

    public void elementCollectionBasicType() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            Customer expected = new Customer("1");
            ArrayList<String> expectedphones = new ArrayList<String>();
            expectedphones.add("781-442-2010");
            expectedphones.add("781-442-2011");
            expectedphones.add("781-442-2012");
            expected.setPhones(expectedphones);
            this.logTrace("Persisting Customer:" + expected.toString());
            this.getEntityManager().persist((Object)expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            this.logTrace("find the previously persisted Customer and Country and verify them");
            Customer cust = (Customer)this.getEntityManager().find(Customer.class, (Object)expected.getId());
            if (cust != null) {
                this.logTrace("Found Customer: " + cust.toString());
                if (cust.getPhones().containsAll(expectedphones) && expectedphones.containsAll(cust.getPhones()) && cust.getPhones().size() == expectedphones.size()) {
                    this.logTrace("Received expected Phones:");
                    for (String s : cust.getPhones()) {
                        this.logTrace("phone:" + s);
                    }
                    pass = true;
                } else {
                    this.logErr("Did not get expected results.");
                    for (String s : expectedphones) {
                        this.logErr("expected:" + s);
                    }
                    this.logErr("actual:");
                    for (String s : cust.getPhones()) {
                        this.logErr("actual:" + s);
                    }
                }
            } else {
                this.logErr("Find returned null Customer");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logErr("Unexpected exception occurred: ", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("elementCollectionBasicType failed");
        }
    }

    public void elementCollectionBasicTypeXMLTest() throws Exception {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            CustomerXML expected = new CustomerXML("1");
            ArrayList<String> expectedphones = new ArrayList<String>();
            expectedphones.add("781-442-2010");
            expectedphones.add("781-442-2011");
            expectedphones.add("781-442-2012");
            expected.setPhones(expectedphones);
            this.logTrace("Persisting Customer:" + expected.toString());
            this.getEntityManager().persist((Object)expected);
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
            this.clearCache();
            this.getEntityTransaction().begin();
            this.logTrace("find the previously persisted Customer and Country and verify them");
            CustomerXML cust = (CustomerXML)this.getEntityManager().find(CustomerXML.class, (Object)expected.getId());
            if (cust != null) {
                this.logTrace("Found CustomerXML: " + cust.toString());
                if (cust.getPhones().containsAll(expectedphones) && expectedphones.containsAll(cust.getPhones()) && cust.getPhones().size() == expectedphones.size()) {
                    this.logTrace("Received expected Phones:");
                    for (String s : cust.getPhones()) {
                        this.logTrace("phone:" + s);
                    }
                    pass = true;
                } else {
                    this.logErr("Did not get expected results.");
                    for (String s : expectedphones) {
                        this.logErr("expected:" + s);
                    }
                    this.logErr("actual:");
                    for (String s : cust.getPhones()) {
                        this.logErr("actual:" + s);
                    }
                }
            } else {
                this.logErr("Find returned null Customer");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logErr("Unexpected exception occurred: ", e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("elementCollectionBasicTypeXMLTest failed");
        }
    }

    public void cleanupCust() throws Exception {
        this.logTrace("cleanup");
        this.removeCustTestData();
        this.logTrace("cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeCustTestData() {
        this.logTrace("removeCustTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM CUST_TABLE").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM PHONES").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            this.logErr("Exception encountered while removing entities:", e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                this.logErr("Unexpected Exception in removeTestData:", re);
            }
        }
    }
}

