/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.integration.session.jspejbjdbc;

import com.sun.ts.lib.harness.Fault;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.base.EETest;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;

public class URLClient
extends EETest {
    private static final String TESTNAME = "Teller";
    private static final String PROTOCOL = "http";
    private static final String HOSTNAME = "yacko";
    private static final int PORTNUM = 8000;
    private static final String JSP = "/int_S_jspejbjdbc_web/jsp2ejb.jsp";
    private static final String JSPBEAN = "/int_S_jspejbjdbc_web/jspbean2ejb.jsp";
    private static final String WEBSERVERHOSTPROP = "webServerHost";
    private static final String WEBSERVERPORTPROP = "webServerPort";
    private static final String EXPECTED_BALANCE = "10490.75";
    private static final String EXPECTED_DEPOSIT = "10590.75";
    private static final String EXPECTED_WITHDRAW = "10540.75";
    private TSURL ctsurl = new TSURL();
    private URL url = null;
    private URLConnection urlConn = null;
    private Properties props = null;
    private String hostname = "yacko";
    private int portnum = 8000;

    public static void main(String[] args) {
        URLClient theTests = new URLClient();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Fault {
        this.props = p;
        boolean pass = true;
        try {
            this.hostname = p.getProperty(WEBSERVERHOSTPROP);
            if (this.hostname == null) {
                pass = false;
            } else if (this.hostname.equals("")) {
                pass = false;
            }
            try {
                this.portnum = Integer.parseInt(p.getProperty(WEBSERVERPORTPROP));
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                pass = false;
            }
        }
        catch (Exception e) {
            throw new Fault("Setup failed:", (Throwable)e);
        }
        if (!pass) {
            TestUtil.logErr((String)"Please specify host & port of web server in config properties: webServerHost, webServerPort");
            throw new Fault("Setup failed:");
        }
    }

    public void test1() throws Fault {
        try {
            boolean pass = true;
            this.url = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, JSP);
            this.urlConn = TestUtil.sendPostData((Properties)this.props, (URL)this.url);
            TestUtil.logMsg((String)("Getting response from url connection: " + this.url.toString()));
            TestUtil.logMsg((String)"Response is ................");
            Properties p = TestUtil.getResponseProperties((URLConnection)this.urlConn);
            TestUtil.list((Properties)p);
            String balance = p.getProperty("Balance");
            String deposit = p.getProperty("Deposit");
            String withdraw = p.getProperty("Withdraw");
            if (!balance.equals(EXPECTED_BALANCE)) {
                TestUtil.logErr((String)("Balance of account incorrect: expected: 10490.75 Received: " + balance));
                pass = false;
            } else {
                TestUtil.logMsg((String)("Balance of account is correct: " + balance));
            }
            if (!deposit.equals(EXPECTED_DEPOSIT)) {
                TestUtil.logErr((String)("Deposit of account incorrect: expected: 10590.75 Received: " + deposit));
                pass = false;
            } else {
                TestUtil.logMsg((String)("Deposit of account is correct: " + deposit));
            }
            if (!withdraw.equals(EXPECTED_WITHDRAW)) {
                TestUtil.logErr((String)("Withdraw of account incorrect: expected: 10540.75 Received: " + withdraw));
                pass = false;
            } else {
                TestUtil.logMsg((String)("Withdraw of account is correct: " + withdraw));
            }
            if (!pass) {
                throw new Fault("test1 failed");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new Fault("test1 failed", (Throwable)e);
        }
    }

    public void test2() throws Fault {
        try {
            boolean pass = true;
            this.url = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, JSPBEAN);
            this.urlConn = TestUtil.sendPostData((Properties)this.props, (URL)this.url);
            TestUtil.logMsg((String)("Getting response from url connection: " + this.url.toString()));
            TestUtil.logMsg((String)"Response is ................");
            Properties p = TestUtil.getResponseProperties((URLConnection)this.urlConn);
            TestUtil.list((Properties)p);
            String balance = p.getProperty("Balance");
            String deposit = p.getProperty("Deposit");
            String withdraw = p.getProperty("Withdraw");
            if (!balance.equals(EXPECTED_BALANCE)) {
                TestUtil.logErr((String)("Balance of account incorrect: expected: 10490.75 Received: " + balance));
                pass = false;
            } else {
                TestUtil.logMsg((String)("Balance of account is correct: " + balance));
            }
            if (!deposit.equals(EXPECTED_DEPOSIT)) {
                TestUtil.logErr((String)("Deposit of account incorrect: expected: 10590.75 Received: " + deposit));
                pass = false;
            } else {
                TestUtil.logMsg((String)("Deposit of account is correct: " + deposit));
            }
            if (!withdraw.equals(EXPECTED_WITHDRAW)) {
                TestUtil.logErr((String)("Withdraw of account incorrect: expected: 10540.75 Received: " + withdraw));
                pass = false;
            } else {
                TestUtil.logMsg((String)("Withdraw of account is correct: " + withdraw));
            }
            if (!pass) {
                throw new Fault("test2 failed");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new Fault("test2 failed", (Throwable)e);
        }
    }

    public void cleanup() throws Fault {
        this.logMsg("cleanup ok");
    }
}

