/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrs.jaxrs21.platform.providers.jsonb;

import com.sun.ts.tests.jaxrs.common.JAXRSCommonClient;
import com.sun.ts.tests.jaxrs.common.client.JaxrsCommonClient;
import com.sun.ts.tests.jaxrs.jaxrs21.platform.providers.jsonb.Resource;
import com.sun.ts.tests.jaxrs.jaxrs21.platform.providers.jsonb.TSAppConfig;
import jakarta.json.bind.Jsonb;
import jakarta.json.bind.JsonbBuilder;
import jakarta.json.bind.JsonbException;
import jakarta.ws.rs.core.MediaType;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Tags;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
@Tags(value={@Tag(value="jaxrs"), @Tag(value="platform"), @Tag(value="web")})
public class JAXRSClientIT
extends JaxrsCommonClient {
    private static final long serialVersionUID = 21L;

    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_jaxrs21_platform_providers_jsonb_web/resource");
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_jaxrs21_platform_providers_jsonb_web.war");
        archive.addClasses(new Class[]{Resource.class, TSAppConfig.class});
        archive.addAsWebInfResource(JAXRSClientIT.class.getPackage(), "web.xml.template", "web.xml");
        return archive;
    }

    @Test
    public void serverJsonBStringReturnTest() throws Exception {
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "tostring"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, "This.is.some.message");
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(JAXRSClientIT.getJsonType()));
        this.invoke();
    }

    @Test
    public void serverJsonBCharReturnTest() throws Exception {
        Jsonb jsonb = JsonbBuilder.create();
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "tochar"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, jsonb.toJson((Object)Character.valueOf("This.is.some.message".charAt(0))));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(JAXRSClientIT.getJsonType()));
        this.invoke();
    }

    @Test
    public void serverJsonBByteReturnTest() throws Exception {
        Jsonb jsonb = JsonbBuilder.create();
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "tobyte"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, jsonb.toJson((Object)127));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(JAXRSClientIT.getJsonType()));
        this.invoke();
    }

    @Test
    public void serverJsonBShortReturnTest() throws Exception {
        Jsonb jsonb = JsonbBuilder.create();
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "toshort"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, jsonb.toJson((Object)Short.MAX_VALUE));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(JAXRSClientIT.getJsonType()));
        this.invoke();
    }

    @Test
    public void serverJsonBIntReturnTest() throws Exception {
        Jsonb jsonb = JsonbBuilder.create();
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "toint"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, jsonb.toJson((Object)Integer.MAX_VALUE));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(JAXRSClientIT.getJsonType()));
        this.invoke();
    }

    @Test
    public void serverJsonBLongReturnTest() throws Exception {
        Jsonb jsonb = JsonbBuilder.create();
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "tolong"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, jsonb.toJson((Object)Long.MAX_VALUE));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(JAXRSClientIT.getJsonType()));
        this.invoke();
    }

    @Test
    public void serverJsonBNumberReturnTest() throws Exception {
        Jsonb jsonb = JsonbBuilder.create();
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "tonumber"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, jsonb.toJson((Object)BigDecimal.valueOf(Long.MAX_VALUE)));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(JAXRSClientIT.getJsonType()));
        this.invoke();
    }

    @Test
    public void serverJsonBBigIntegerReturnTest() throws Exception {
        Jsonb jsonb = JsonbBuilder.create();
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "tobiginteger"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, jsonb.toJson((Object)BigInteger.valueOf(Long.MAX_VALUE)));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(JAXRSClientIT.getJsonType()));
        this.invoke();
    }

    @Test
    public void serverJsonBURIReturnTest() throws Exception, JsonbException, URISyntaxException {
        Jsonb jsonb = JsonbBuilder.create();
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "touri"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, jsonb.toJson((Object)new URI("http://tck.cts.oracle.com:12345")));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(JAXRSClientIT.getJsonType()));
        this.invoke();
    }

    @Test
    public void serverJsonBURLReturnTest() throws Exception, JsonbException, MalformedURLException {
        Jsonb jsonb = JsonbBuilder.create();
        this.setProperty(JAXRSCommonClient.Property.REQUEST, this.buildRequest(JAXRSCommonClient.Request.GET, "tourl"));
        this.setProperty(JAXRSCommonClient.Property.SEARCH_STRING, jsonb.toJson((Object)new URL("http://tck.cts.oracle.com:12345")));
        this.setProperty(JAXRSCommonClient.Property.REQUEST_HEADERS, JAXRSClientIT.buildAccept(JAXRSClientIT.getJsonType()));
        this.invoke();
    }

    private static MediaType getJsonType() {
        return MediaType.APPLICATION_JSON_TYPE;
    }
}

