/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.appclient.queueconn;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import jakarta.jms.Message;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueReceiver;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.TextMessage;
import java.util.ArrayList;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class QueueConnTestsIT {
    private static final String testName = "com.sun.ts.tests.jms.core.appclient.queueconn.QueueConnTestsIT";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private static final System.Logger logger = System.getLogger(QueueConnTestsIT.class.getName());
    private transient JmsTool tool = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    ArrayList queues = null;
    ArrayList connections = null;

    @BeforeEach
    public void setup() throws Exception {
        try {
            this.timeout = Long.parseLong(System.getProperty("jms_timeout"));
            this.user = System.getProperty("user");
            this.password = System.getProperty("password");
            this.mode = System.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'timeout' (milliseconds) must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' is null");
            }
            if (this.password == null) {
                throw new Exception("'password' is null");
            }
            if (this.mode == null) {
                throw new Exception("'mode' is null");
            }
            this.queues = new ArrayList(2);
            this.connections = new ArrayList(5);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            if (this.tool != null) {
                logger.log(System.Logger.Level.INFO, "Cleanup: Closing Queue Connections");
                this.tool.doClientQueueTestCleanup(this.connections, this.queues);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            logger.log(System.Logger.Level.ERROR, "An error occurred while cleaning");
            throw new Exception("Cleanup failed!", e);
        }
    }

    @Test
    public void connStoppedQueueTest() throws Exception {
        boolean pass = true;
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            this.tool.getDefaultQueueConnection().stop();
            logger.log(System.Logger.Level.TRACE, "Creating 1 TextMessage");
            messageSent = this.tool.getDefaultQueueSession().createTextMessage();
            messageSent.setText("Message from connStoppedQueueTest");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "connStoppedQueueTest");
            logger.log(System.Logger.Level.TRACE, "Sending a TextMessage");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            this.tool.getDefaultQueueConnection().start();
            messageReceived = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (!messageReceived.getText().equals(messageSent.getText())) {
                throw new Exception("didn't get the right message");
            }
            logger.log(System.Logger.Level.INFO, "Pass: Received correct message");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "connStoppedQueueTest failed: ", (Throwable)e);
            throw new Exception("connStoppedQueueTest", e);
        }
    }

    @Test
    public void closedQueueConnectionNoForcedAckTest() throws Exception {
        boolean pass = true;
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            QueueSession qSession = null;
            QueueReceiver qReceiver = null;
            QueueSender qSender = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            QueueConnection newConn = (QueueConnection)this.tool.getNewConnection(0, this.user, this.password);
            this.connections.add(newConn);
            qSession = newConn.createQueueSession(false, 2);
            this.tool.getDefaultQueueReceiver().close();
            this.tool.getDefaultQueueSession().close();
            qReceiver = qSession.createReceiver(this.tool.getDefaultQueue());
            qSender = qSession.createSender(this.tool.getDefaultQueue());
            logger.log(System.Logger.Level.INFO, "create a new connection");
            newConn.start();
            logger.log(System.Logger.Level.INFO, "Creating 1 TextMessage");
            messageSent = qSession.createTextMessage();
            messageSent.setText("just a test");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "closedQueueConnectionNoForcedAckTest");
            logger.log(System.Logger.Level.INFO, "Sending a TextMessage");
            qSender.send((Message)messageSent);
            logger.log(System.Logger.Level.INFO, "Receive the TextMessage");
            messageReceived = (TextMessage)qReceiver.receive(this.timeout);
            qReceiver.close();
            logger.log(System.Logger.Level.INFO, "Close the connection with no ack of message received");
            newConn.close();
            logger.log(System.Logger.Level.INFO, "Use default connection to retrieve the unacknowledged message");
            qSession = this.tool.getDefaultQueueConnection().createQueueSession(false, 2);
            qReceiver = qSession.createReceiver(this.tool.getDefaultQueue());
            this.tool.getDefaultQueueConnection().start();
            messageReceived = (TextMessage)qReceiver.receive(this.timeout);
            if (messageReceived == null) {
                logger.log(System.Logger.Level.ERROR, "Fail: no message received.");
                pass = false;
            } else if (messageReceived.getText().equals(messageSent.getText())) {
                logger.log(System.Logger.Level.INFO, "Pass: received correct msg");
            } else {
                logger.log(System.Logger.Level.ERROR, "Fail: didnt get correct msg");
                pass = false;
            }
            try {
                messageReceived.acknowledge();
            }
            catch (Exception e) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Exception thrown on ack!", (Throwable)e);
            }
            if (!pass) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("closedQueueConnectionNoForcedAckTest");
        }
    }
}

