/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.bytesMsgTopic;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import jakarta.jms.BytesMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageNotWriteableException;
import java.util.ArrayList;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class BytesMsgTopicTestsIT {
    private static final String testName = "com.sun.ts.tests.jms.core.bytesMsgTopic.BytesMsgTopicTestsIT";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private static final System.Logger logger = System.getLogger(BytesMsgTopicTestsIT.class.getName());
    private transient JmsTool tool = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    ArrayList connections = null;

    @BeforeEach
    public void setup() throws Exception {
        try {
            this.timeout = Long.parseLong(System.getProperty("jms_timeout"));
            this.user = System.getProperty("user");
            this.password = System.getProperty("password");
            this.mode = System.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' is null");
            }
            if (this.password == null) {
                throw new Exception("'password' is null");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' is null");
            }
            logger.log(System.Logger.Level.INFO, "Getting Administrator and deleting any leftover destinations.");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            if (this.tool != null) {
                logger.log(System.Logger.Level.INFO, "Cleanup: Closing Queue and Topic Connections");
                this.tool.closeAllConnections(this.connections);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            logger.log(System.Logger.Level.ERROR, "An error occurred while cleaning");
            throw new Exception("Cleanup failed!", e);
        }
    }

    @Test
    public void bytesMsgNullStreamTopicTest() throws Exception {
        boolean pass = true;
        int nInt = 1000;
        try {
            BytesMessage messageSentBytesMessage = null;
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            try {
                logger.log(System.Logger.Level.INFO, "Writing a null stream to byte message should throw a NullPointerException");
                messageSentBytesMessage = this.tool.getDefaultTopicSession().createBytesMessage();
                messageSentBytesMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "bytesMsgNullStreamTopicTest");
                messageSentBytesMessage.writeObject(null);
                logger.log(System.Logger.Level.INFO, "Fail: message did not throw NullPointerException exception as expected");
                pass = false;
            }
            catch (NullPointerException np) {
                logger.log(System.Logger.Level.TRACE, "Pass: NullPointerException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.INFO, "Error: " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: bytesMsgNullStreamTopicTest test failure");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("bytesMsgNullStreamTopicTest");
        }
    }

    @Test
    public void bytesMessageTopicTestsFullMsg() throws Exception {
        try {
            BytesMessage messageSent = null;
            BytesMessage messageReceived = null;
            boolean pass = true;
            boolean booleanValue = false;
            byte byteValue = 127;
            byte[] bytesValue = new byte[]{127, -127, 1, 0};
            byte[] bytesValueRecvd = new byte[]{0, 0, 0, 0};
            char charValue = 'Z';
            double doubleValue = 6.02E23;
            float floatValue = 6.02E23f;
            int intValue = Integer.MAX_VALUE;
            long longValue = Long.MAX_VALUE;
            Integer nInteger = new Integer(Integer.MIN_VALUE);
            short shortValue = Short.MIN_VALUE;
            String utfValue = "what";
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = this.tool.getDefaultTopicSession().createBytesMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "bytesMessageTopicTestsFullMsg");
            logger.log(System.Logger.Level.INFO, "Writing one of each primitive type to the message");
            messageSent.writeBoolean(booleanValue);
            messageSent.writeByte(byteValue);
            messageSent.writeChar(charValue);
            messageSent.writeDouble(doubleValue);
            messageSent.writeFloat(floatValue);
            messageSent.writeInt(intValue);
            messageSent.writeLong(longValue);
            messageSent.writeObject((Object)nInteger);
            messageSent.writeShort(shortValue);
            messageSent.writeUTF(utfValue);
            messageSent.writeBytes(bytesValue);
            messageSent.writeBytes(bytesValue, 0, 1);
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (BytesMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            try {
                if (messageReceived.readBoolean() == booleanValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: boolean returned ok");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: boolean not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.INFO, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            try {
                if (messageReceived.readByte() == byteValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: Byte returned ok");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: Byte not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.INFO, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            try {
                if (messageReceived.readChar() == charValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: correct char");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: char not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.INFO, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            try {
                if (messageReceived.readDouble() == doubleValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: correct double");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: double not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.INFO, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            try {
                if (messageReceived.readFloat() == floatValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: correct float");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: float not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.INFO, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            try {
                if (messageReceived.readInt() == intValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: correct int");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: int not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.INFO, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            try {
                if (messageReceived.readLong() == longValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: correct long");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: long not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.INFO, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            try {
                if (messageReceived.readInt() == nInteger.intValue()) {
                    logger.log(System.Logger.Level.TRACE, "Pass: correct Integer returned");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: Integer not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.INFO, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            try {
                if (messageReceived.readShort() == shortValue) {
                    logger.log(System.Logger.Level.TRACE, "Pass: correct short");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: short not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.INFO, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            try {
                if (messageReceived.readUTF().equals(utfValue)) {
                    logger.log(System.Logger.Level.TRACE, "Pass: correct UTF");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: UTF not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.INFO, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            try {
                int nCount = messageReceived.readBytes(bytesValueRecvd);
                for (int i = 0; i < nCount; ++i) {
                    if (bytesValueRecvd[i] != bytesValue[i]) {
                        logger.log(System.Logger.Level.INFO, "Fail: bytes value incorrect");
                        pass = false;
                        continue;
                    }
                    logger.log(System.Logger.Level.TRACE, "Pass: byte value " + i + " ok");
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.INFO, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            try {
                int nCount = messageReceived.readBytes(bytesValueRecvd);
                logger.log(System.Logger.Level.TRACE, "count returned " + nCount);
                if (bytesValueRecvd[0] != bytesValue[0]) {
                    logger.log(System.Logger.Level.INFO, "Fail: bytes value incorrect");
                    pass = false;
                } else {
                    logger.log(System.Logger.Level.TRACE, "Pass: byte value ok");
                }
                if (nCount == 1) {
                    logger.log(System.Logger.Level.TRACE, "Pass: correct count");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: count not returned as expected");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.INFO, "Error: unexpected exception" + e.getClass().getName() + "was thrown");
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("bytesMessageTopicTestsFullMsg", e);
        }
    }

    @Test
    public void bytesMessageTNotWriteable() throws Exception {
        try {
            BytesMessage messageSent = null;
            BytesMessage messageReceived = null;
            boolean pass = true;
            byte bValue = 127;
            byte[] bbValue = new byte[]{127, -127, 1, 0};
            char cValue = 'Z';
            double dValue = 6.02E23;
            float fValue = 6.02E23f;
            int iValue = Integer.MAX_VALUE;
            long lValue = Long.MAX_VALUE;
            short sValue = Short.MIN_VALUE;
            String ssValue = "what";
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = this.tool.getDefaultTopicSession().createBytesMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "bytesMessageTNotWriteable");
            messageSent.writeBytes(bbValue);
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (BytesMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            logger.log(System.Logger.Level.INFO, "Writing a boolean ... ");
            try {
                messageReceived.writeBoolean(pass);
                logger.log(System.Logger.Level.ERROR, "Shouldn't get here");
                throw new Exception("Error: test failed to be able to writeBoolean");
            }
            catch (MessageNotWriteableException e) {
                logger.log(System.Logger.Level.INFO, "Got Expected MessageNotWriteableException with writeBoolean");
                logger.log(System.Logger.Level.INFO, "Writing a byte ... ");
                try {
                    messageReceived.writeByte(bValue);
                    logger.log(System.Logger.Level.ERROR, "Shouldn't get here");
                    throw new Exception("Error: test failed to be able to writeByte");
                }
                catch (MessageNotWriteableException e2) {
                    logger.log(System.Logger.Level.INFO, "Got Expected MessageNotWriteableException with writeByte");
                    logger.log(System.Logger.Level.INFO, "Writing a short ... ");
                    try {
                        messageReceived.writeShort(sValue);
                        logger.log(System.Logger.Level.ERROR, "Shouldn't get here");
                        throw new Exception("Error: test failed to be able to writeShort");
                    }
                    catch (MessageNotWriteableException e3) {
                        logger.log(System.Logger.Level.INFO, "Got Expected MessageNotWriteableException with writeShort");
                        logger.log(System.Logger.Level.INFO, "Writing a char ... ");
                        try {
                            messageReceived.writeChar(cValue);
                            logger.log(System.Logger.Level.ERROR, "Shouldn't get here");
                            throw new Exception("Error: test failed to be able to writeChar");
                        }
                        catch (MessageNotWriteableException e4) {
                            logger.log(System.Logger.Level.INFO, "Got Expected MessageNotWriteableException with writeChar");
                            logger.log(System.Logger.Level.INFO, "Writing a int ... ");
                            try {
                                messageReceived.writeInt(iValue);
                                logger.log(System.Logger.Level.ERROR, "Shouldn't get here");
                                throw new Exception("Error: test failed to be able to writeInt");
                            }
                            catch (MessageNotWriteableException e5) {
                                logger.log(System.Logger.Level.INFO, "Got Expected MessageNotWriteableException with writeInt");
                                logger.log(System.Logger.Level.INFO, "Writing a long ... ");
                                try {
                                    messageReceived.writeLong(lValue);
                                    logger.log(System.Logger.Level.ERROR, "Shouldn't get here");
                                    throw new Exception("Error: test failed to be able to writeLong");
                                }
                                catch (MessageNotWriteableException e6) {
                                    logger.log(System.Logger.Level.INFO, "Got Expected MessageNotWriteableException with writeLong");
                                    logger.log(System.Logger.Level.INFO, "Writing a float ... ");
                                    try {
                                        messageReceived.writeFloat(fValue);
                                        logger.log(System.Logger.Level.ERROR, "Shouldn't get here");
                                        throw new Exception("Error: test failed to be able to writeFloat");
                                    }
                                    catch (MessageNotWriteableException e7) {
                                        logger.log(System.Logger.Level.INFO, "Got Expected MessageNotWriteableException with writeFloat");
                                        logger.log(System.Logger.Level.INFO, "Writing a double ... ");
                                        try {
                                            messageReceived.writeDouble(dValue);
                                            logger.log(System.Logger.Level.ERROR, "Shouldn't get here");
                                            throw new Exception("Error: test failed to be able to writeDouble");
                                        }
                                        catch (MessageNotWriteableException e8) {
                                            logger.log(System.Logger.Level.INFO, "Got Expected MessageNotWriteableException with writeDouble");
                                            logger.log(System.Logger.Level.INFO, "Writing a bytes... ");
                                            try {
                                                messageReceived.writeBytes(bbValue);
                                                logger.log(System.Logger.Level.ERROR, "Shouldn't get here");
                                                throw new Exception("Error: test failed to be able to writeBytes");
                                            }
                                            catch (MessageNotWriteableException e9) {
                                                logger.log(System.Logger.Level.INFO, "Got Expected MessageNotWriteableException with writeBytes");
                                                logger.log(System.Logger.Level.INFO, "Writing a bytes... ");
                                                try {
                                                    messageReceived.writeBytes(bbValue, 0, 2);
                                                    logger.log(System.Logger.Level.ERROR, "Shouldn't get here");
                                                    throw new Exception("Error: test failed to be able to writeBytes");
                                                }
                                                catch (MessageNotWriteableException e10) {
                                                    logger.log(System.Logger.Level.INFO, "Got Expected MessageNotWriteableException with writeBytes");
                                                    logger.log(System.Logger.Level.INFO, "Writing a UTF ... ");
                                                    try {
                                                        messageReceived.writeUTF(ssValue);
                                                        logger.log(System.Logger.Level.ERROR, "Shouldn't get here");
                                                        throw new Exception("Error: test failed to be able to writeUTF");
                                                    }
                                                    catch (MessageNotWriteableException e11) {
                                                        logger.log(System.Logger.Level.INFO, "Got Expected MessageNotWriteableException with writeUTF");
                                                        logger.log(System.Logger.Level.INFO, "Writing a object ... ");
                                                        try {
                                                            messageReceived.writeObject((Object)new Integer(iValue));
                                                            logger.log(System.Logger.Level.ERROR, "Shouldn't get here");
                                                            throw new Exception("Error: test failed to be able to writeObject");
                                                        }
                                                        catch (MessageNotWriteableException e12) {
                                                            logger.log(System.Logger.Level.INFO, "Got Expected MessageNotWriteableException with writeObject");
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("BytesMessageQueueNotWriteable", e);
        }
    }
}

