/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.foreignMsgTopic;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.BytesMessageTestImpl;
import com.sun.ts.tests.jms.common.JmsTool;
import com.sun.ts.tests.jms.common.MapMessageTestImpl;
import com.sun.ts.tests.jms.common.MessageTestImpl;
import com.sun.ts.tests.jms.common.ObjectMessageTestImpl;
import com.sun.ts.tests.jms.common.StreamMessageTestImpl;
import com.sun.ts.tests.jms.common.TextMessageTestImpl;
import jakarta.jms.BytesMessage;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.ObjectMessage;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ForeignMsgTopicTestsIT {
    private static final String testName = "com.sun.ts.tests.jms.core.foreignMsgTopic.ForeignMsgTopicTestsIT";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private static final System.Logger logger = System.getLogger(ForeignMsgTopicTestsIT.class.getName());
    private transient JmsTool tool = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    ArrayList connections = null;
    boolean testBoolean = true;
    byte testByte = (byte)100;
    char testChar = (char)97;
    int testInt = 10;
    Object testObject = new Double(3.141);
    String testString = "java";

    @BeforeEach
    public void setup() throws Exception {
        try {
            this.timeout = Long.parseLong(System.getProperty("jms_timeout"));
            this.user = System.getProperty("user");
            this.password = System.getProperty("password");
            this.mode = System.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'timeout' (milliseconds) in must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' is null");
            }
            if (this.password == null) {
                throw new Exception("'password' is null");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            if (this.tool != null) {
                logger.log(System.Logger.Level.INFO, "Cleanup: Closing Queue and Topic Connections");
                this.tool.closeAllConnections(this.connections);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            logger.log(System.Logger.Level.ERROR, "An error occurred while cleaning");
            throw new Exception("Cleanup failed!", e);
        }
    }

    @Test
    public void sendReceiveBytesMsgTopicTest() throws Exception {
        boolean pass = true;
        try {
            BytesMessageTestImpl messageSent = null;
            BytesMessage messageReceived = null;
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = new BytesMessageTestImpl();
            logger.log(System.Logger.Level.TRACE, "Setting test values in message");
            long bodyLength = 22L;
            BytesMessageTestImpl messageSentImpl = messageSent;
            messageSentImpl.setBodyLength(bodyLength);
            messageSent.writeBoolean(this.testBoolean);
            messageSent.writeByte(this.testByte);
            messageSent.writeChar(this.testChar);
            messageSent.writeInt(this.testInt);
            messageSent.writeObject(this.testObject);
            messageSent.writeUTF(this.testString);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "sendReceiveBytesMsgTopicTest");
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (BytesMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            if (messageReceived == null) {
                throw new Exception("Did not receive message");
            }
            logger.log(System.Logger.Level.TRACE, "Check received message");
            if (messageReceived.readBoolean() == this.testBoolean) {
                logger.log(System.Logger.Level.TRACE, "Received correct boolean value");
            } else {
                logger.log(System.Logger.Level.INFO, "incorrect boolean value -- BAD");
                pass = false;
            }
            if (messageReceived.readByte() == this.testByte) {
                logger.log(System.Logger.Level.TRACE, "Received correct byte value");
            } else {
                logger.log(System.Logger.Level.INFO, "incorrect byte value -- BAD");
                pass = false;
            }
            if (messageReceived.readChar() == this.testChar) {
                logger.log(System.Logger.Level.TRACE, "Received correct char value");
            } else {
                logger.log(System.Logger.Level.INFO, "incorrect char value -- BAD");
                pass = false;
            }
            if (messageReceived.readInt() == this.testInt) {
                logger.log(System.Logger.Level.TRACE, "Received correct int value");
            } else {
                logger.log(System.Logger.Level.INFO, "incorrect int value -- BAD");
                pass = false;
            }
            if (messageReceived.readDouble() == ((Double)this.testObject).doubleValue()) {
                logger.log(System.Logger.Level.TRACE, "Received correct object");
            } else {
                logger.log(System.Logger.Level.INFO, "incorrect object -- BAD");
                pass = false;
            }
            if (messageReceived.readUTF().equals(this.testString)) {
                logger.log(System.Logger.Level.TRACE, "Received correct String");
            } else {
                logger.log(System.Logger.Level.INFO, "incorrect string -- BAD");
                pass = false;
            }
            if (!pass) {
                logger.log(System.Logger.Level.INFO, "Test failed -- see above");
                throw new Exception();
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("sendReceiveBytesMsgTopicTest");
        }
    }

    @Test
    public void sendReceiveMsgTopicTest() throws Exception {
        try {
            MessageTestImpl messageSent = null;
            Message messageReceived = null;
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            logger.log(System.Logger.Level.INFO, "Creating 1 message");
            messageSent = new MessageTestImpl();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "sendReceiveMsgTopicTest");
            logger.log(System.Logger.Level.INFO, "sending: " + (Message)messageSent);
            logger.log(System.Logger.Level.INFO, "Sending message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            logger.log(System.Logger.Level.INFO, "Receiving message");
            messageReceived = this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            logger.log(System.Logger.Level.INFO, "received: " + messageReceived);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("sendReceiveMsgTopicTest");
        }
    }

    @Test
    public void sendReceiveMapMsgTopicTest() throws Exception {
        boolean pass = true;
        try {
            MapMessageTestImpl messageSent = null;
            MapMessage messageReceived = null;
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = new MapMessageTestImpl();
            logger.log(System.Logger.Level.TRACE, "Setting test values in message");
            messageSent.setBoolean("TestBoolean", this.testBoolean);
            messageSent.setByte("TestByte", this.testByte);
            messageSent.setChar("TestChar", this.testChar);
            messageSent.setInt("TestInt", this.testInt);
            messageSent.setObject("TestDouble", this.testObject);
            messageSent.setString("TestString", this.testString);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "sendReceiveMapMsgTopicTest");
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (MapMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            if (messageReceived == null) {
                throw new Exception("Did not receive message");
            }
            logger.log(System.Logger.Level.TRACE, "Check received message");
            if (messageReceived.getBoolean("TestBoolean") == this.testBoolean) {
                logger.log(System.Logger.Level.TRACE, "Received correct boolean value");
            } else {
                logger.log(System.Logger.Level.INFO, "incorrect boolean value -- BAD");
                pass = false;
            }
            if (messageReceived.getByte("TestByte") == this.testByte) {
                logger.log(System.Logger.Level.TRACE, "Received correct byte value");
            } else {
                logger.log(System.Logger.Level.INFO, "incorrect byte value -- BAD");
                pass = false;
            }
            if (messageReceived.getChar("TestChar") == this.testChar) {
                logger.log(System.Logger.Level.TRACE, "Received correct char value");
            } else {
                logger.log(System.Logger.Level.INFO, "incorrect char value -- BAD");
                pass = false;
            }
            if (messageReceived.getInt("TestInt") == this.testInt) {
                logger.log(System.Logger.Level.TRACE, "Received correct int value");
            } else {
                logger.log(System.Logger.Level.INFO, "incorrect int value -- BAD");
                pass = false;
            }
            if (messageReceived.getDouble("TestDouble") == ((Double)this.testObject).doubleValue()) {
                logger.log(System.Logger.Level.TRACE, "Received correct object");
            } else {
                logger.log(System.Logger.Level.INFO, "incorrect object -- BAD");
                pass = false;
            }
            if (messageReceived.getString("TestString").equals(this.testString)) {
                logger.log(System.Logger.Level.TRACE, "Received correct String");
            } else {
                logger.log(System.Logger.Level.INFO, "incorrect string -- BAD");
                pass = false;
            }
            if (!pass) {
                logger.log(System.Logger.Level.INFO, "Test failed -- see above");
                throw new Exception();
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("sendReceiveMapMsgTopicTest");
        }
    }

    @Test
    public void sendReceiveObjectMsgTopicTest() throws Exception {
        try {
            ObjectMessageTestImpl messageSent = null;
            ObjectMessage messageReceived = null;
            String text = "test";
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            logger.log(System.Logger.Level.INFO, "Creating 1 message");
            messageSent = new ObjectMessageTestImpl();
            messageSent.setObject((Serializable)((Object)text));
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "sendReceiveObjectMsgTopicTest");
            logger.log(System.Logger.Level.INFO, "Sending message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            logger.log(System.Logger.Level.INFO, "Receiving message");
            messageReceived = (ObjectMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            if (messageReceived == null) {
                throw new Exception("Did not receive message");
            }
            if (!((String)((Object)messageReceived.getObject())).equals(text)) {
                throw new Exception("Did not receive correct message");
            }
            logger.log(System.Logger.Level.INFO, "Received correct object");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("sendReceiveObjectMsgTopicTest");
        }
    }

    @Test
    public void sendReceiveStreamMsgTopicTest() throws Exception {
        boolean pass = true;
        try {
            StreamMessageTestImpl messageSent = null;
            StreamMessage messageReceived = null;
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            logger.log(System.Logger.Level.INFO, "Creating 1 message");
            messageSent = new StreamMessageTestImpl();
            logger.log(System.Logger.Level.TRACE, "Setting test values in message");
            messageSent.writeBoolean(this.testBoolean);
            messageSent.writeByte(this.testByte);
            messageSent.writeChar(this.testChar);
            messageSent.writeInt(this.testInt);
            messageSent.writeObject(this.testObject);
            messageSent.writeString(this.testString);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "sendReceiveStreamMsgTopicTest");
            logger.log(System.Logger.Level.INFO, "Sending message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            logger.log(System.Logger.Level.INFO, "Receiving message");
            messageReceived = (StreamMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            if (messageReceived == null) {
                throw new Exception("Did not receive message");
            }
            logger.log(System.Logger.Level.TRACE, "Check received message");
            if (messageReceived.readBoolean() == this.testBoolean) {
                logger.log(System.Logger.Level.TRACE, "Received correct boolean value");
            } else {
                logger.log(System.Logger.Level.INFO, "incorrect boolean value -- BAD");
                pass = false;
            }
            if (messageReceived.readByte() == this.testByte) {
                logger.log(System.Logger.Level.TRACE, "Received correct byte value");
            } else {
                logger.log(System.Logger.Level.INFO, "incorrect byte value -- BAD");
                pass = false;
            }
            if (messageReceived.readChar() == this.testChar) {
                logger.log(System.Logger.Level.TRACE, "Received correct char value");
            } else {
                logger.log(System.Logger.Level.INFO, "incorrect char value -- BAD");
                pass = false;
            }
            if (messageReceived.readInt() == this.testInt) {
                logger.log(System.Logger.Level.TRACE, "Received correct int value");
            } else {
                logger.log(System.Logger.Level.INFO, "incorrect int value -- BAD");
                pass = false;
            }
            if (messageReceived.readDouble() == ((Double)this.testObject).doubleValue()) {
                logger.log(System.Logger.Level.TRACE, "Received correct object");
            } else {
                logger.log(System.Logger.Level.INFO, "incorrect object -- BAD");
                pass = false;
            }
            if (messageReceived.readString().equals(this.testString)) {
                logger.log(System.Logger.Level.TRACE, "Received correct String");
            } else {
                logger.log(System.Logger.Level.INFO, "incorrect string -- BAD");
                pass = false;
            }
            if (!pass) {
                logger.log(System.Logger.Level.INFO, "Test failed -- see above");
                throw new Exception();
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("sendReceiveStreamMsgTopicTest");
        }
    }

    @Test
    public void sendReceiveTextMsgTopicTest() throws Exception {
        try {
            TextMessageTestImpl messageSent = null;
            TextMessage messageReceived = null;
            String text = "test";
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            this.tool.getDefaultTopicConnection().start();
            logger.log(System.Logger.Level.INFO, "Creating 1 message");
            messageSent = new TextMessageTestImpl();
            messageSent.setText(text);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "sendReceiveTextMsgTopicTest");
            logger.log(System.Logger.Level.INFO, "Sending message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            logger.log(System.Logger.Level.INFO, "Receiving message");
            messageReceived = (TextMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            if (messageReceived == null) {
                throw new Exception("Did not receive message");
            }
            if (!messageReceived.getText().equals(text)) {
                throw new Exception("Did not receive correct message");
            }
            logger.log(System.Logger.Level.INFO, "Received correct text");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("sendReceiveTextMsgTopicTest");
        }
    }

    @Test
    public void sendSetsJMSDestinationTopicTest() throws Exception {
        try {
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            logger.log(System.Logger.Level.INFO, "Creating 1 message");
            MessageTestImpl message = new MessageTestImpl();
            message.setStringProperty("COM_SUN_JMS_TESTNAME", "sendSetsJMSDestinationTopicTest");
            message.setJMSDestination(null);
            logger.log(System.Logger.Level.INFO, "Publishing message");
            this.tool.getDefaultTopicPublisher().publish((Message)message);
            logger.log(System.Logger.Level.TRACE, "Check header value");
            if (!((Topic)message.getJMSDestination()).getTopicName().equals(this.tool.getDefaultTopic().getTopicName())) {
                throw new Exception("Header not set correctly");
            }
            logger.log(System.Logger.Level.TRACE, "Header set correctly");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("sendSetsJMSDestinationTopicTest");
        }
    }

    @Test
    public void sendSetsJMSExpirationTopicTest() throws Exception {
        try {
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            logger.log(System.Logger.Level.INFO, "Creating 1 message");
            MessageTestImpl message = new MessageTestImpl();
            message.setStringProperty("COM_SUN_JMS_TESTNAME", "sendSetsJMSExpirationTopicTest");
            logger.log(System.Logger.Level.TRACE, "Set JMSExpiration to 9999");
            message.setJMSExpiration(9999L);
            logger.log(System.Logger.Level.INFO, "Publishing message");
            this.tool.getDefaultTopicPublisher().publish((Message)message);
            long mode = message.getJMSExpiration();
            logger.log(System.Logger.Level.TRACE, "Check header value");
            if (mode == 9999L) {
                logger.log(System.Logger.Level.TRACE, "JMSExpiration for message is " + mode);
                throw new Exception("Header not set correctly");
            }
            logger.log(System.Logger.Level.TRACE, "Header set correctly");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("sendSetsJMSExpirationTopicTest");
        }
    }

    @Test
    public void sendSetsJMSPriorityTopicTest() throws Exception {
        try {
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            logger.log(System.Logger.Level.INFO, "Creating 1 message");
            MessageTestImpl message = new MessageTestImpl();
            message.setStringProperty("COM_SUN_JMS_TESTNAME", "sendSetsJMSPriorityTopicTest");
            logger.log(System.Logger.Level.TRACE, "Set JMSPriority to 9999");
            message.setJMSPriority(9999);
            logger.log(System.Logger.Level.INFO, "Publishing message");
            this.tool.getDefaultTopicPublisher().publish((Message)message);
            int mode = message.getJMSPriority();
            logger.log(System.Logger.Level.TRACE, "Check header value");
            if (mode == 9999) {
                logger.log(System.Logger.Level.TRACE, "JMSPriority for message is " + mode);
                throw new Exception("Header not set correctly");
            }
            logger.log(System.Logger.Level.TRACE, "Header set correctly: " + mode);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("sendSetsJMSPriorityTopicTest");
        }
    }

    @Test
    public void sendSetsJMSMessageIDTopicTest() throws Exception {
        try {
            String id0 = "foo";
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            logger.log(System.Logger.Level.INFO, "Creating 1 message");
            MessageTestImpl message = new MessageTestImpl();
            message.setStringProperty("COM_SUN_JMS_TESTNAME", "sendSetsJMSMessageIDTopicTest");
            logger.log(System.Logger.Level.TRACE, "Set JMSMessageID to \"" + id0 + "\"");
            message.setJMSMessageID(id0);
            logger.log(System.Logger.Level.INFO, "Publishing message");
            this.tool.getDefaultTopicPublisher().publish((Message)message);
            String id1 = message.getJMSMessageID();
            logger.log(System.Logger.Level.TRACE, "Check header value");
            if (id1.equals(id0)) {
                logger.log(System.Logger.Level.TRACE, "JMSMessageID for message is " + id1);
                throw new Exception("Header not set correctly");
            }
            logger.log(System.Logger.Level.TRACE, "Header set correctly: " + id1);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("sendSetsJMSMessageIDTopicTest");
        }
    }

    @Test
    public void sendSetsJMSTimestampTopicTest() throws Exception {
        try {
            this.tool = new JmsTool(1, this.user, this.password, this.mode);
            logger.log(System.Logger.Level.INFO, "Creating 1 message");
            MessageTestImpl message = new MessageTestImpl();
            message.setStringProperty("COM_SUN_JMS_TESTNAME", "sendSetsJMSTimestampTopicTest");
            logger.log(System.Logger.Level.TRACE, "Set JMSTimestamp to 9999");
            message.setJMSTimestamp(9999L);
            logger.log(System.Logger.Level.INFO, "Publishing message");
            this.tool.getDefaultTopicPublisher().publish((Message)message);
            long mode = message.getJMSTimestamp();
            logger.log(System.Logger.Level.TRACE, "Check header value");
            if (mode == 9999L) {
                logger.log(System.Logger.Level.TRACE, "JMSTimestamp for message is " + mode);
                throw new Exception("Header not set correctly");
            }
            logger.log(System.Logger.Level.TRACE, "Header set correctly: " + mode);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("sendSetsJMSTimestampTopicTest");
        }
    }
}

