/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.messageQueue;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import jakarta.jms.BytesMessage;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageNotReadableException;
import jakarta.jms.MessageNotWriteableException;
import jakarta.jms.ObjectMessage;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MessageQueueTestIT {
    private static final String testName = "com.sun.ts.tests.jms.core.messageQueue.MessageQueueTestIT";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private static final System.Logger logger = System.getLogger(MessageQueueTestIT.class.getName());
    private transient JmsTool tool = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    ArrayList queues = null;
    ArrayList connections = null;

    @BeforeEach
    public void setup() throws Exception {
        try {
            this.timeout = Long.parseLong(System.getProperty("jms_timeout"));
            this.user = System.getProperty("user");
            this.password = System.getProperty("password");
            this.mode = System.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' is null");
            }
            if (this.password == null) {
                throw new Exception("'numProducers' is null");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' is null");
            }
            this.queues = new ArrayList(2);
            this.connections = new ArrayList(5);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            if (this.tool != null) {
                logger.log(System.Logger.Level.INFO, "Cleanup: Closing Queue and Topic Connections");
                this.tool.doClientQueueTestCleanup(this.connections, this.queues);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            logger.log(System.Logger.Level.ERROR, "An error occurred while cleaning");
            throw new Exception("Cleanup failed!", e);
        }
    }

    @Test
    public void msgClearBodyQueueTest() throws Exception {
        boolean pass = true;
        byte bValue = 127;
        byte bValue2 = 22;
        Object id = null;
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            StreamMessage messageSentStreamMessage = null;
            StreamMessage messageReceivedStreamMessage = null;
            BytesMessage messageSentBytesMessage = null;
            BytesMessage messageReceivedBytesMessage = null;
            MapMessage messageReceivedMapMessage = null;
            MapMessage messageSentMapMessage = null;
            ObjectMessage messageSentObjectMsg = null;
            ObjectMessage messageReceivedObjectMsg = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            logger.log(System.Logger.Level.TRACE, "Send ObjectMessage to Queue.");
            messageSentObjectMsg = this.tool.getDefaultQueueSession().createObjectMessage();
            messageSentObjectMsg.setObject((Serializable)((Object)"Initial message"));
            messageSentObjectMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "msgClearBodyQueueTest");
            this.tool.getDefaultQueueSender().send((Message)messageSentObjectMsg);
            messageReceivedObjectMsg = (ObjectMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            try {
                logger.log(System.Logger.Level.TRACE, "Testing Object message");
                logger.log(System.Logger.Level.TRACE, "read 1st contents");
                logger.log(System.Logger.Level.TRACE, "  " + messageReceivedObjectMsg.getObject());
                logger.log(System.Logger.Level.TRACE, "Call to clearBody !!!!!!!!!!!!!!!");
                messageReceivedObjectMsg.clearBody();
                if (messageReceivedObjectMsg.getObject() == null) {
                    logger.log(System.Logger.Level.TRACE, "Empty body after clearBody as expected: null");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: message body was not empty");
                    pass = false;
                }
                if (messageSentObjectMsg.getStringProperty("COM_SUN_JMS_TESTNAME").equals("msgClearBodyQueueTest")) {
                    logger.log(System.Logger.Level.TRACE, "Pass: Object properties read ok after clearBody called");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: Object properties cleared after clearBody called");
                    pass = false;
                }
                logger.log(System.Logger.Level.TRACE, "write 2nd contents");
                messageReceivedObjectMsg.setObject((Serializable)((Object)"new stuff here!!!!!!"));
                logger.log(System.Logger.Level.TRACE, "read 2nd contents");
                if (messageReceivedObjectMsg.getObject().equals("new stuff here!!!!!!")) {
                    logger.log(System.Logger.Level.TRACE, "Pass:");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: ");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.INFO, "Error: " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "Send MapMessage to Queue.");
            messageSentMapMessage = this.tool.getDefaultQueueSession().createMapMessage();
            messageSentMapMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgClearBodyQueueTest");
            messageSentMapMessage.setString("aString", "Initial message");
            this.tool.getDefaultQueueSender().send((Message)messageSentMapMessage);
            messageReceivedMapMessage = (MapMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            try {
                logger.log(System.Logger.Level.TRACE, "Test for MapMessage ");
                logger.log(System.Logger.Level.TRACE, "read 1st contents");
                logger.log(System.Logger.Level.TRACE, "  " + messageReceivedMapMessage.getString("aString"));
                logger.log(System.Logger.Level.TRACE, "Call to clearBody !!!!!!!!!!!!!!!");
                messageReceivedMapMessage.clearBody();
                if (messageReceivedMapMessage.getString("aString") == null) {
                    logger.log(System.Logger.Level.TRACE, "Empty body after clearBody as expected: null");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: message body was not empty");
                    pass = false;
                }
                if (messageReceivedMapMessage.getStringProperty("COM_SUN_JMS_TESTNAME").equals("msgClearBodyQueueTest")) {
                    logger.log(System.Logger.Level.TRACE, "Pass: Map properties read ok after clearBody called");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: Map properties cleared after clearBody called");
                    pass = false;
                }
                logger.log(System.Logger.Level.TRACE, "write 2nd contents");
                messageReceivedMapMessage.setString("yes", "new stuff !!!!!");
                logger.log(System.Logger.Level.TRACE, "read 2nd contents");
                if (messageReceivedMapMessage.getString("yes").equals("new stuff !!!!!")) {
                    logger.log(System.Logger.Level.TRACE, "PASS:");
                } else {
                    logger.log(System.Logger.Level.INFO, "FAIL:");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.INFO, "Error: " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "Send BytesMessage to Queue.");
            messageSentBytesMessage = this.tool.getDefaultQueueSession().createBytesMessage();
            messageSentBytesMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgClearBodyQueueTest");
            messageSentBytesMessage.writeByte(bValue);
            this.tool.getDefaultQueueSender().send((Message)messageSentBytesMessage);
            messageReceivedBytesMessage = (BytesMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            try {
                logger.log(System.Logger.Level.TRACE, "Test BytesMessage ");
                logger.log(System.Logger.Level.TRACE, "read 1st contents");
                logger.log(System.Logger.Level.TRACE, "  " + messageReceivedBytesMessage.readByte());
                logger.log(System.Logger.Level.TRACE, "Call to clearBody !!!!!!!!!!!!!!!");
                messageReceivedBytesMessage.clearBody();
                logger.log(System.Logger.Level.TRACE, "Bytes message body should now be empty and in writeonly mode");
                try {
                    byte b = messageReceivedBytesMessage.readByte();
                    logger.log(System.Logger.Level.TRACE, "Fail: MessageNotReadableException not thrown as expected");
                    pass = false;
                }
                catch (Exception e) {
                    if (e instanceof MessageNotReadableException) {
                        logger.log(System.Logger.Level.TRACE, "Pass: MessageEOFException thrown as expected");
                    }
                    logger.log(System.Logger.Level.INFO, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                    pass = false;
                }
                if (messageReceivedBytesMessage.getStringProperty("COM_SUN_JMS_TESTNAME").equals("msgClearBodyQueueTest")) {
                    logger.log(System.Logger.Level.TRACE, "Pass: Bytes msg properties read ok after clearBody called");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: Bytes msg properties cleared after clearBody called");
                    pass = false;
                }
                logger.log(System.Logger.Level.TRACE, "write 2nd contents");
                messageReceivedBytesMessage.writeByte(bValue2);
                logger.log(System.Logger.Level.TRACE, "read 2nd contents");
                messageReceivedBytesMessage.reset();
                if (messageReceivedBytesMessage.readByte() == bValue2) {
                    logger.log(System.Logger.Level.TRACE, "Pass:");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail:");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.INFO, "Error: " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "sending a Stream message");
            messageSentStreamMessage = this.tool.getDefaultQueueSession().createStreamMessage();
            messageSentStreamMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgClearBodyQueueTest");
            messageSentStreamMessage.writeString("Testing...");
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSentStreamMessage);
            messageReceivedStreamMessage = (StreamMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            try {
                logger.log(System.Logger.Level.TRACE, "Test StreamMessage ");
                logger.log(System.Logger.Level.TRACE, "read 1st contents");
                logger.log(System.Logger.Level.TRACE, "  " + messageReceivedStreamMessage.readString());
                logger.log(System.Logger.Level.TRACE, "Call to clearBody !!!!!!!!!!!!!!!");
                messageReceivedStreamMessage.clearBody();
                logger.log(System.Logger.Level.TRACE, "Stream message body should now be empty and in writeonly mode");
                try {
                    String s = messageReceivedStreamMessage.readString();
                    logger.log(System.Logger.Level.INFO, "Fail: MessageNotReadableException should have been thrown");
                    pass = false;
                }
                catch (Exception e) {
                    if (e instanceof MessageNotReadableException) {
                        logger.log(System.Logger.Level.TRACE, "Pass: MessageNotReadableException thrown as expected");
                    }
                    logger.log(System.Logger.Level.INFO, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                    pass = false;
                }
                if (messageReceivedStreamMessage.getStringProperty("COM_SUN_JMS_TESTNAME").equals("msgClearBodyQueueTest")) {
                    logger.log(System.Logger.Level.TRACE, "Pass: Stream msg properties read ok after clearBody called");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: Stream msg properties cleared after clearBody called");
                    pass = false;
                }
                logger.log(System.Logger.Level.TRACE, "write 2nd contents");
                messageReceivedStreamMessage.writeString("new data");
                logger.log(System.Logger.Level.TRACE, "read 2nd contents");
                messageReceivedStreamMessage.reset();
                if (messageReceivedStreamMessage.readString().equals("new data")) {
                    logger.log(System.Logger.Level.TRACE, "Pass:");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail:");
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.INFO, "Error: " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            messageSent = this.tool.getDefaultQueueSession().createTextMessage();
            messageSent.setText("sending a Text message");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "msgClearBodyQueueTest");
            logger.log(System.Logger.Level.TRACE, "sending a Text message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            messageReceived = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            try {
                logger.log(System.Logger.Level.TRACE, "Test TextMessage ");
                logger.log(System.Logger.Level.TRACE, "read 1st contents");
                logger.log(System.Logger.Level.TRACE, "  " + messageReceived.getText());
                logger.log(System.Logger.Level.TRACE, "Call to clearBody !!!!!!!!!!!!!!!");
                messageReceived.clearBody();
                if (messageReceived.getText() == null) {
                    logger.log(System.Logger.Level.TRACE, "Empty body after clearBody as expected: null");
                } else {
                    logger.log(System.Logger.Level.TRACE, "Fail: message body was not empty");
                    pass = false;
                }
                if (messageReceived.getStringProperty("COM_SUN_JMS_TESTNAME").equals("msgClearBodyQueueTest")) {
                    logger.log(System.Logger.Level.TRACE, "Pass: Text properties read ok after clearBody called");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: Text properties cleared after clearBody called");
                    pass = false;
                }
                logger.log(System.Logger.Level.TRACE, "write and read 2nd contents");
                messageReceived.setText("new data");
                if (messageReceived.getText().equals("new data")) {
                    logger.log(System.Logger.Level.TRACE, "Pass:");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail:");
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.INFO, "Error: " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: clearBody test failure");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("msgClearBodyQueueTest");
        }
    }

    @Test
    public void msgResetQueueTest() throws Exception {
        boolean pass = true;
        int nInt = 1000;
        try {
            StreamMessage messageSentStreamMessage = null;
            BytesMessage messageSentBytesMessage = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            try {
                logger.log(System.Logger.Level.TRACE, "creating a Stream message");
                messageSentStreamMessage = this.tool.getDefaultQueueSession().createStreamMessage();
                messageSentStreamMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgResetQueueTest1");
                messageSentStreamMessage.writeString("Testing...");
                logger.log(System.Logger.Level.INFO, "reset stream message -  now  should be in readonly mode");
                messageSentStreamMessage.reset();
                messageSentStreamMessage.writeString("new data");
                logger.log(System.Logger.Level.INFO, "Fail: message did not throw MessageNotWriteable exception as expected");
                pass = false;
            }
            catch (MessageNotWriteableException nw) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageNotWriteable thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.INFO, "Error: " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            try {
                logger.log(System.Logger.Level.TRACE, "creating a Byte message");
                messageSentBytesMessage = this.tool.getDefaultQueueSession().createBytesMessage();
                messageSentBytesMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgResetQueueTest2");
                messageSentBytesMessage.writeInt(nInt);
                logger.log(System.Logger.Level.INFO, "reset Byte message -  now  should be in readonly mode");
                messageSentBytesMessage.reset();
                messageSentBytesMessage.writeInt(nInt);
                logger.log(System.Logger.Level.INFO, "Fail: message did not throw MessageNotWriteable exception as expected");
                pass = false;
            }
            catch (MessageNotWriteableException nw) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageNotWriteable thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.INFO, "Error: " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: msgResetQueueTest test failure");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("msgResetQueueTest");
        }
    }

    @Test
    public void readNullCharNotValidQueueTest() throws Exception {
        try {
            StreamMessage messageSent = null;
            StreamMessage messageReceived = null;
            MapMessage mapSent = null;
            MapMessage mapReceived = null;
            boolean pass = true;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createStreamMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "readNullCharNotValidQueueTest");
            logger.log(System.Logger.Level.TRACE, "Write a null string to the stream message object with StreamMessage.writeString");
            messageSent.writeString(null);
            logger.log(System.Logger.Level.TRACE, " Send the message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            messageReceived = (StreamMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "Use readChar to read a null  ");
            try {
                messageReceived.readChar();
                logger.log(System.Logger.Level.TRACE, "Fail: NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: NullPointerException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.INFO, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            mapSent = this.tool.getDefaultQueueSession().createMapMessage();
            mapSent.setStringProperty("COM_SUN_JMS_TESTNAME", "readNullCharNotValidQueueTest");
            logger.log(System.Logger.Level.TRACE, "Write a null string to the map message object with mapMessage.setString");
            mapSent.setString("WriteANull", null);
            logger.log(System.Logger.Level.TRACE, " Send the message");
            this.tool.getDefaultQueueSender().send((Message)mapSent);
            mapReceived = (MapMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "Use readChar to read a null  ");
            try {
                mapReceived.getChar("WriteANull");
                logger.log(System.Logger.Level.INFO, "Fail: NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: NullPointerException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.INFO, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: failures occurred during tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("readNullCharNotValidQueueTest", e);
        }
    }

    @Test
    public void messageQIllegalarg() throws Exception {
        try {
            TextMessage messageSent = null;
            boolean pass = true;
            byte bValue = 127;
            short sValue = Short.MAX_VALUE;
            int cValue = 65535;
            int iValue = Integer.MAX_VALUE;
            long lValue = Long.MAX_VALUE;
            float fValue = 0.0f;
            double dValue = -0.0;
            String ssValue = "abc";
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            logger.log(System.Logger.Level.TRACE, "Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createTextMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "messageQIllegalarg");
            logger.log(System.Logger.Level.INFO, "Writing a boolean property ... ");
            try {
                messageSent.setBooleanProperty("", pass);
                logger.log(System.Logger.Level.ERROR, "Shouldn't get here");
                throw new Exception("Error: test failed to be able to setBooleanProperty");
            }
            catch (IllegalArgumentException e) {
                logger.log(System.Logger.Level.INFO, "Got Expected IllegalArgumentException with setBooleanProperty");
                logger.log(System.Logger.Level.INFO, "Writing a byte Property ... ");
                try {
                    messageSent.setByteProperty("", bValue);
                    logger.log(System.Logger.Level.ERROR, "Shouldn't get here");
                    throw new Exception("Error: test failed to be able to setByteProperty");
                }
                catch (IllegalArgumentException e2) {
                    logger.log(System.Logger.Level.INFO, "Got Expected IllegalArgumentException with setByteProperty");
                    logger.log(System.Logger.Level.INFO, "Writing a short Property... ");
                    try {
                        messageSent.setShortProperty("", sValue);
                        logger.log(System.Logger.Level.ERROR, "Shouldn't get here");
                        throw new Exception("Error: test failed to be able to setShortProperty");
                    }
                    catch (IllegalArgumentException e3) {
                        logger.log(System.Logger.Level.INFO, "Got Expected IllegalArgumentException with setShortProperty");
                        logger.log(System.Logger.Level.INFO, "Writing a int Property ... ");
                        try {
                            messageSent.setIntProperty("", iValue);
                            logger.log(System.Logger.Level.ERROR, "Shouldn't get here");
                            throw new Exception("Error: test failed to be able to setIntProperty");
                        }
                        catch (IllegalArgumentException e4) {
                            logger.log(System.Logger.Level.INFO, "Got Expected IllegalArgumentException with setIntProperty");
                            logger.log(System.Logger.Level.INFO, "Writing a long Property ... ");
                            try {
                                messageSent.setLongProperty("", lValue);
                                logger.log(System.Logger.Level.ERROR, "Shouldn't get here");
                                throw new Exception("Error: test failed to be able to setLongProperty");
                            }
                            catch (IllegalArgumentException e5) {
                                logger.log(System.Logger.Level.INFO, "Got Expected IllegalArgumentException with setLongProperty");
                                logger.log(System.Logger.Level.INFO, "Writing a float Property ... ");
                                try {
                                    messageSent.setFloatProperty("", fValue);
                                    logger.log(System.Logger.Level.ERROR, "Shouldn't get here");
                                    throw new Exception("Error: test failed to be able to setFloatProperty");
                                }
                                catch (IllegalArgumentException e6) {
                                    logger.log(System.Logger.Level.INFO, "Got Expected IllegalArgumentException with setFloatProperty");
                                    logger.log(System.Logger.Level.INFO, "Writing a double Property ... ");
                                    try {
                                        messageSent.setDoubleProperty("", dValue);
                                        logger.log(System.Logger.Level.ERROR, "Shouldn't get here");
                                        throw new Exception("Error: test failed to be able to setDoubleProperty");
                                    }
                                    catch (IllegalArgumentException e7) {
                                        logger.log(System.Logger.Level.INFO, "Got Expected IllegalArgumentException with setDoubleProperty");
                                        logger.log(System.Logger.Level.INFO, "Writing a string Property ... ");
                                        try {
                                            messageSent.setStringProperty("", ssValue);
                                            logger.log(System.Logger.Level.ERROR, "Shouldn't get here");
                                            throw new Exception("Error: test failed to be able to setStringProperty");
                                        }
                                        catch (IllegalArgumentException e8) {
                                            logger.log(System.Logger.Level.INFO, "Got Expected IllegalArgumentException with setStringProperty");
                                            logger.log(System.Logger.Level.INFO, "Writing a object Property ... ");
                                            try {
                                                messageSent.setObjectProperty("", (Object)new Integer(iValue));
                                                logger.log(System.Logger.Level.ERROR, "Shouldn't get here");
                                                throw new Exception("Error: test failed to be able to setObjectProperty");
                                            }
                                            catch (IllegalArgumentException e9) {
                                                logger.log(System.Logger.Level.INFO, "Got Expected IllegalArgumentException with setObjectProperty");
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("messageQIllegalarg", e);
        }
    }
}

