/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.queueMsgHeaders;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import jakarta.jms.BytesMessage;
import jakarta.jms.Destination;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class QueueHeaderTestsIT {
    private static final String testName = "com.sun.ts.tests.jms.core.queueMsgHeaders.QueueHeaderTestsIT";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private static final System.Logger logger = System.getLogger(QueueHeaderTestsIT.class.getName());
    private transient JmsTool tool = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    ArrayList queues = null;
    ArrayList connections = null;

    @BeforeEach
    public void setup() throws Exception {
        try {
            this.timeout = Long.parseLong(System.getProperty("jms_timeout"));
            this.user = System.getProperty("user");
            this.password = System.getProperty("password");
            this.mode = System.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' is null");
            }
            if (this.password == null) {
                throw new Exception("'password' is null");
            }
            if (this.mode == null) {
                throw new Exception("'mode' is null");
            }
            this.queues = new ArrayList(2);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            if (this.tool != null) {
                logger.log(System.Logger.Level.INFO, "Cleanup: Closing Queue and Topic Connections");
                this.tool.doClientQueueTestCleanup(this.connections, this.queues);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            logger.log(System.Logger.Level.ERROR, "An error occurred while cleaning");
            throw new Exception("Cleanup failed!", e);
        }
    }

    @Test
    private boolean chkMessageID(String id) {
        String[] status = new String[]{"Pass", "Fail"};
        boolean retcode = true;
        int index = 0;
        if (id != null && !id.startsWith("ID:")) {
            index = 1;
            retcode = false;
        }
        logger.log(System.Logger.Level.TRACE, "Results: " + status[index]);
        return retcode;
    }

    @Test
    public void msgHdrIDQTest() throws Exception {
        boolean pass = true;
        byte bValue = 127;
        String id = null;
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            StreamMessage messageSentS = null;
            StreamMessage messageReceivedS = null;
            BytesMessage messageSentB = null;
            BytesMessage messageReceivedB = null;
            MapMessage messageReceivedM = null;
            MapMessage messageSentM = null;
            ObjectMessage messageSentO = null;
            ObjectMessage messageReceivedO = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            logger.log(System.Logger.Level.TRACE, "Send ObjectMessage to Queue.");
            messageSentO = this.tool.getDefaultQueueSession().createObjectMessage();
            messageSentO.setObject((Serializable)((Object)"msgHdrIDQTest for ObjectMessage"));
            messageSentO.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrIDQTest");
            this.tool.getDefaultQueueSender().send((Message)messageSentO);
            messageReceivedO = (ObjectMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "getJMSMessageID ");
            logger.log(System.Logger.Level.TRACE, " " + messageReceivedO.getJMSMessageID());
            id = messageReceivedO.getJMSMessageID();
            if (!this.chkMessageID(id)) {
                logger.log(System.Logger.Level.INFO, "ObjectMessage error: JMSMessageID does not start with ID:");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "Send MapMessage to Queue.");
            messageSentM = this.tool.getDefaultQueueSession().createMapMessage();
            messageSentM.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrIDQTest");
            messageSentM.setString("aString", "value");
            this.tool.getDefaultQueueSender().send((Message)messageSentM);
            messageReceivedM = (MapMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "getJMSMessageID ");
            logger.log(System.Logger.Level.TRACE, " " + messageReceivedM.getJMSMessageID());
            id = messageReceivedM.getJMSMessageID();
            if (!this.chkMessageID(id)) {
                logger.log(System.Logger.Level.INFO, "MapMessage error: JMSMessageID does not start with ID:");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "Send BytesMessage to Queue.");
            messageSentB = this.tool.getDefaultQueueSession().createBytesMessage();
            messageSentB.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrIDQTest");
            messageSentB.writeByte(bValue);
            this.tool.getDefaultQueueSender().send((Message)messageSentB);
            messageReceivedB = (BytesMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "getJMSMessageID ");
            logger.log(System.Logger.Level.TRACE, " " + messageReceivedB.getJMSMessageID());
            id = messageReceivedB.getJMSMessageID();
            if (!this.chkMessageID(id)) {
                logger.log(System.Logger.Level.INFO, "BytesMessage error: JMSMessageID does not start with ID:");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "sending a StreamMessage");
            messageSentS = this.tool.getDefaultQueueSession().createStreamMessage();
            messageSentS.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrIDQTest");
            messageSentS.writeString("Testing...");
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSentS);
            messageReceivedS = (StreamMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "getJMSMessageID ");
            logger.log(System.Logger.Level.TRACE, " " + messageReceivedS.getJMSMessageID());
            id = messageReceivedS.getJMSMessageID();
            if (!this.chkMessageID(id)) {
                logger.log(System.Logger.Level.INFO, "StreamMessage error: JMSMessageID does not start with ID:");
                pass = false;
            }
            messageSent = this.tool.getDefaultQueueSession().createTextMessage();
            messageSent.setText("sending a TextMessage");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrIDQTest");
            logger.log(System.Logger.Level.TRACE, "sending a TextMessage");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            messageReceived = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "getJMSMessageID ");
            logger.log(System.Logger.Level.TRACE, " " + messageReceived.getJMSMessageID());
            id = messageReceived.getJMSMessageID();
            if (!this.chkMessageID(id)) {
                logger.log(System.Logger.Level.INFO, "TextMessage error: JMSMessageID does not start with ID:");
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: invalid JMSMessageID returned from JMSMessageID");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("msgHdrIDQTest");
        }
    }

    @Test
    public void msgHdrTimeStampQTest() throws Exception {
        boolean pass = true;
        byte bValue = 127;
        try {
            TextMessage messageSent = null;
            StreamMessage messageSentS = null;
            BytesMessage messageSentB = null;
            MapMessage messageSentM = null;
            ObjectMessage messageSentO = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            logger.log(System.Logger.Level.TRACE, "Send ObjectMessage to Queue.");
            messageSentO = this.tool.getDefaultQueueSession().createObjectMessage();
            messageSentO.setObject((Serializable)((Object)"msgHdrTimeStampQTest for ObjectMessage"));
            messageSentO.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrTimeStampQTest");
            long timeBeforeSend = System.currentTimeMillis();
            this.tool.getDefaultQueueSender().send((Message)messageSentO);
            long timeAfterSend = System.currentTimeMillis();
            logger.log(System.Logger.Level.TRACE, " getJMSTimestamp");
            logger.log(System.Logger.Level.TRACE, " " + messageSentO.getJMSTimestamp());
            logger.log(System.Logger.Level.TRACE, "Time at send is: " + timeBeforeSend);
            logger.log(System.Logger.Level.TRACE, "Time after return fromsend is:" + timeAfterSend);
            if (timeBeforeSend <= messageSentO.getJMSTimestamp() && timeAfterSend >= messageSentO.getJMSTimestamp()) {
                logger.log(System.Logger.Level.TRACE, "ObjectMessage TimeStamp pass");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: invalid timestamp from ObjectMessage");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "Send MapMessage to Queue.");
            messageSentM = this.tool.getDefaultQueueSession().createMapMessage();
            messageSentM.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrTimeStampQTest");
            messageSentM.setString("aString", "value");
            timeBeforeSend = System.currentTimeMillis();
            this.tool.getDefaultQueueSender().send((Message)messageSentM);
            timeAfterSend = System.currentTimeMillis();
            logger.log(System.Logger.Level.TRACE, " getJMSTimestamp");
            logger.log(System.Logger.Level.TRACE, " " + messageSentM.getJMSTimestamp());
            logger.log(System.Logger.Level.TRACE, "Time at send is: " + timeBeforeSend);
            logger.log(System.Logger.Level.TRACE, "Time after return fromsend is:" + timeAfterSend);
            if (timeBeforeSend > messageSentM.getJMSTimestamp() && timeAfterSend >= messageSentM.getJMSTimestamp()) {
                logger.log(System.Logger.Level.ERROR, "Error: invalid timestamp from MapMessage");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "Send BytesMessage to Queue.");
            messageSentB = this.tool.getDefaultQueueSession().createBytesMessage();
            messageSentB.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrTimeStampQTest");
            messageSentB.writeByte(bValue);
            timeBeforeSend = System.currentTimeMillis();
            this.tool.getDefaultQueueSender().send((Message)messageSentB);
            timeAfterSend = System.currentTimeMillis();
            logger.log(System.Logger.Level.TRACE, " getJMSTimestamp");
            logger.log(System.Logger.Level.TRACE, " " + messageSentB.getJMSTimestamp());
            logger.log(System.Logger.Level.TRACE, "Time at send is: " + timeBeforeSend);
            logger.log(System.Logger.Level.TRACE, "Time after return fromsend is:" + timeAfterSend);
            if (timeBeforeSend <= messageSentB.getJMSTimestamp() && timeAfterSend >= messageSentB.getJMSTimestamp()) {
                logger.log(System.Logger.Level.TRACE, "BytesMessage TimeStamp pass");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: invalid timestamp from BytesMessage");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "sending a StreamMessage");
            messageSentS = this.tool.getDefaultQueueSession().createStreamMessage();
            messageSentS.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrTimeStampQTest");
            messageSentS.writeString("Testing...");
            logger.log(System.Logger.Level.TRACE, "Sending message");
            timeBeforeSend = System.currentTimeMillis();
            this.tool.getDefaultQueueSender().send((Message)messageSentS);
            timeAfterSend = System.currentTimeMillis();
            logger.log(System.Logger.Level.TRACE, " getJMSTimestamp");
            logger.log(System.Logger.Level.TRACE, " " + messageSentS.getJMSTimestamp());
            logger.log(System.Logger.Level.TRACE, "Time at send is: " + timeBeforeSend);
            logger.log(System.Logger.Level.TRACE, "Time after return fromsend is:" + timeAfterSend);
            if (timeBeforeSend <= messageSentS.getJMSTimestamp() && timeAfterSend >= messageSentS.getJMSTimestamp()) {
                logger.log(System.Logger.Level.TRACE, "StreamMessage TimeStamp pass");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: invalid timestamp from StreamMessage");
                pass = false;
            }
            messageSent = this.tool.getDefaultQueueSession().createTextMessage();
            messageSent.setText("sending a TextMessage");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrTimeStampQTest");
            logger.log(System.Logger.Level.TRACE, "sending a TextMessage");
            timeBeforeSend = System.currentTimeMillis();
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            timeAfterSend = System.currentTimeMillis();
            logger.log(System.Logger.Level.TRACE, " getJMSTimestamp");
            logger.log(System.Logger.Level.TRACE, " " + messageSent.getJMSTimestamp());
            logger.log(System.Logger.Level.TRACE, "Time at send is: " + timeBeforeSend);
            logger.log(System.Logger.Level.TRACE, "Time after return fromsend is:" + timeAfterSend);
            if (timeBeforeSend > messageSent.getJMSTimestamp() && timeAfterSend >= messageSent.getJMSTimestamp()) {
                logger.log(System.Logger.Level.ERROR, "Error: invalid timestamp from TextMessage");
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: invalid TimeStamp returned from JMSTimeStamp");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("msgHdrTimeStampQTest");
        }
    }

    @Test
    public void msgHdrCorlIdQTest() throws Exception {
        boolean pass = true;
        byte bValue = 127;
        String jmsCorrelationID = "testCorrelationid";
        String testName = "msgHdrCorlIdQTest";
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            StreamMessage messageSentS = null;
            StreamMessage messageReceivedS = null;
            BytesMessage messageSentB = null;
            BytesMessage messageReceivedB = null;
            MapMessage messageReceivedM = null;
            MapMessage messageSentM = null;
            ObjectMessage messageSentO = null;
            ObjectMessage messageReceivedO = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            messageSent = this.tool.getDefaultQueueSession().createTextMessage();
            messageSent.setText("sending a message");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            logger.log(System.Logger.Level.TRACE, "Send TextMessage to Queue.");
            messageSent.setJMSCorrelationID(jmsCorrelationID);
            try {
                this.tool.getDefaultQueueSender().send((Message)messageSent);
                messageReceived = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
                if (messageReceived == null) {
                    logger.log(System.Logger.Level.ERROR, "messageReceived is null");
                    pass = false;
                } else if (messageReceived.getJMSCorrelationID() == null) {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "TextMessage Error: JMSCorrelationID returned a  null");
                } else if (!messageReceived.getJMSCorrelationID().equals(jmsCorrelationID)) {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "TextMessage Error: JMSCorrelationID is incorrect");
                }
            }
            catch (Exception e) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Unexpected Exception: ", (Throwable)e);
            }
            logger.log(System.Logger.Level.TRACE, "Send MapMessage to Queue.");
            messageSentM = this.tool.getDefaultQueueSession().createMapMessage();
            messageSentM.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            messageSentM.setJMSCorrelationID(jmsCorrelationID);
            messageSentM.setString("aString", "value");
            this.tool.getDefaultQueueSender().send((Message)messageSentM);
            messageReceivedM = (MapMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceivedM.getJMSCorrelationID() == null) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "MapMessage Error: JMSCorrelationID returned a  null");
            } else if (!messageReceivedM.getJMSCorrelationID().equals(jmsCorrelationID)) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "MapMessage Error: JMSCorrelationID is incorrect");
            }
            logger.log(System.Logger.Level.TRACE, "Send BytesMessage to Queue.");
            messageSentB = this.tool.getDefaultQueueSession().createBytesMessage();
            messageSentB.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            messageSentB.setJMSCorrelationID(jmsCorrelationID);
            messageSentB.writeByte(bValue);
            this.tool.getDefaultQueueSender().send((Message)messageSentB);
            messageReceivedB = (BytesMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceivedB.getJMSCorrelationID() == null) {
                pass = false;
                logger.log(System.Logger.Level.INFO, "BytesMessage Error: JMSCorrelationID returned a  null");
            } else if (!messageReceivedB.getJMSCorrelationID().equals(jmsCorrelationID)) {
                pass = false;
                logger.log(System.Logger.Level.INFO, "Byte Message Error: JMSCorrelationID is incorrect");
            }
            logger.log(System.Logger.Level.TRACE, "sending a StreamMessage");
            messageSentS = this.tool.getDefaultQueueSession().createStreamMessage();
            messageSentS.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            messageSentS.setJMSCorrelationID(jmsCorrelationID);
            messageSentS.writeString("Testing...");
            this.tool.getDefaultQueueSender().send((Message)messageSentS);
            messageReceivedS = (StreamMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceivedS.getJMSCorrelationID() == null) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "StreamMessage Error: JMSCorrelationID returned a  null");
            } else if (!messageReceivedS.getJMSCorrelationID().equals(jmsCorrelationID)) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "StreamMessage Error: JMSCorrelationID is incorrect");
            }
            logger.log(System.Logger.Level.TRACE, "Send ObjectMessage to Queue.");
            messageSentO = this.tool.getDefaultQueueSession().createObjectMessage();
            messageSentO.setObject((Serializable)((Object)"msgHdrIDQTest for ObjectMessage"));
            messageSentO.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            messageSentO.setJMSCorrelationID(jmsCorrelationID);
            this.tool.getDefaultQueueSender().send((Message)messageSentO);
            messageReceivedO = (ObjectMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceivedO.getJMSCorrelationID() == null) {
                pass = false;
                logger.log(System.Logger.Level.INFO, "ObjectMessage Error: JMSCorrelationID returned a  null");
            } else if (!messageReceivedO.getJMSCorrelationID().equals(jmsCorrelationID)) {
                pass = false;
                logger.log(System.Logger.Level.INFO, "ObjectMessage Error: JMSCorrelationID is incorrect");
            }
            if (!pass) {
                throw new Exception("Error: invalid JMSCorrelationID returned from JMS Header");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception(testName);
        }
    }

    @Test
    public void msgHdrReplyToQTest() throws Exception {
        boolean pass = true;
        Queue replyQueue = null;
        byte bValue = 127;
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            StreamMessage messageSentS = null;
            StreamMessage messageReceivedS = null;
            BytesMessage messageSentB = null;
            BytesMessage messageReceivedB = null;
            MapMessage messageReceivedM = null;
            MapMessage messageSentM = null;
            ObjectMessage messageSentO = null;
            ObjectMessage messageReceivedO = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            messageSent = this.tool.getDefaultQueueSession().createTextMessage();
            messageSent.setText("sending a message");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrReplyToQTest");
            logger.log(System.Logger.Level.TRACE, "Send Text message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            messageReceived = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceived.getJMSReplyTo() == null) {
                logger.log(System.Logger.Level.TRACE, " as expected replyto field is null");
            } else {
                logger.log(System.Logger.Level.INFO, "ERROR: expected replyto field should have been null for this case");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "Set ReplyTo and resend msg");
            messageSent.setJMSReplyTo((Destination)this.tool.getDefaultQueue());
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            messageReceived = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            replyQueue = (Queue)messageReceived.getJMSReplyTo();
            logger.log(System.Logger.Level.TRACE, "Queue name is " + replyQueue.getQueueName());
            if (replyQueue.getQueueName().equals(this.tool.getDefaultQueue().getQueueName())) {
                logger.log(System.Logger.Level.TRACE, "Pass ");
            } else {
                logger.log(System.Logger.Level.INFO, "TextMessage Failed");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "Send ObjectMessage to Queue.");
            messageSentO = this.tool.getDefaultQueueSession().createObjectMessage();
            messageSentO.setObject((Serializable)((Object)"msgHdrReplyToQTest for ObjectMessage"));
            messageSentO.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrReplyToQTest");
            this.tool.getDefaultQueueSender().send((Message)messageSentO);
            messageReceivedO = (ObjectMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceivedO.getJMSReplyTo() == null) {
                logger.log(System.Logger.Level.TRACE, " as expected replyto field is null");
            } else {
                replyQueue = (Queue)messageReceivedO.getJMSReplyTo();
                logger.log(System.Logger.Level.INFO, "ReplyTo is: " + replyQueue.toString());
                logger.log(System.Logger.Level.INFO, "ERROR: expected replyto field to be null in this case");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "Set ReplyTo and resend msg");
            messageSentO.setJMSReplyTo((Destination)this.tool.getDefaultQueue());
            this.tool.getDefaultQueueSender().send((Message)messageSentO);
            messageReceivedO = (ObjectMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            replyQueue = (Queue)messageReceivedO.getJMSReplyTo();
            logger.log(System.Logger.Level.TRACE, "Queue name is " + replyQueue.getQueueName());
            if (replyQueue.getQueueName().equals(this.tool.getDefaultQueue().getQueueName())) {
                logger.log(System.Logger.Level.TRACE, "Pass ");
            } else {
                logger.log(System.Logger.Level.INFO, "ObjectMessage ReplyTo Failed");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "Send MapMessage to Queue.");
            messageSentM = this.tool.getDefaultQueueSession().createMapMessage();
            messageSentM.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrReplyToQTest");
            messageSentM.setString("aString", "value");
            this.tool.getDefaultQueueSender().send((Message)messageSentM);
            messageReceivedM = (MapMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceivedM.getJMSReplyTo() == null) {
                logger.log(System.Logger.Level.TRACE, " as expected replyto field is null");
            } else {
                logger.log(System.Logger.Level.INFO, "ERROR: expected replyto field to be null in this case");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "Set ReplyTo and resend msg");
            messageSentM.setJMSReplyTo((Destination)this.tool.getDefaultQueue());
            this.tool.getDefaultQueueSender().send((Message)messageSentM);
            messageReceivedM = (MapMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "Received Map message ");
            replyQueue = (Queue)messageReceivedM.getJMSReplyTo();
            logger.log(System.Logger.Level.TRACE, "Queue name is " + replyQueue.getQueueName());
            if (replyQueue.getQueueName().equals(this.tool.getDefaultQueue().getQueueName())) {
                logger.log(System.Logger.Level.TRACE, "Pass ");
            } else {
                logger.log(System.Logger.Level.INFO, "MapMessage ReplyTo Failed");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "Send BytesMessage to Queue.");
            messageSentB = this.tool.getDefaultQueueSession().createBytesMessage();
            messageSentB.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrReplyToQTest");
            messageSentB.writeByte(bValue);
            this.tool.getDefaultQueueSender().send((Message)messageSentB);
            messageReceivedB = (BytesMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceivedB.getJMSReplyTo() == null) {
                logger.log(System.Logger.Level.TRACE, " as expected replyto field is null");
            } else {
                logger.log(System.Logger.Level.INFO, "ERROR: expected replyto field to be null in this case");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "Set ReplyTo and resend msg");
            messageSentB.setJMSReplyTo((Destination)this.tool.getDefaultQueue());
            this.tool.getDefaultQueueSender().send((Message)messageSentB);
            messageReceivedB = (BytesMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "Received Bytes message ");
            replyQueue = (Queue)messageReceivedB.getJMSReplyTo();
            logger.log(System.Logger.Level.TRACE, "Queue name is " + replyQueue.getQueueName());
            if (replyQueue.getQueueName().equals(this.tool.getDefaultQueue().getQueueName())) {
                logger.log(System.Logger.Level.TRACE, "Pass ");
            } else {
                logger.log(System.Logger.Level.INFO, "BytesMessage ReplyTo Failed");
                pass = false;
            }
            messageSentS = this.tool.getDefaultQueueSession().createStreamMessage();
            messageSentS.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrReplyToQTest");
            messageSentS.writeString("Testing...");
            logger.log(System.Logger.Level.TRACE, "Sending StreamMessage");
            this.tool.getDefaultQueueSender().send((Message)messageSentS);
            messageReceivedS = (StreamMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceivedS.getJMSReplyTo() == null) {
                logger.log(System.Logger.Level.TRACE, " as expected replyto field is null");
            } else {
                replyQueue = (Queue)messageReceivedS.getJMSReplyTo();
                logger.log(System.Logger.Level.INFO, "ERROR: expected replyto field to be null in this case");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "Set ReplyTo and resend msg");
            messageSentS.setJMSReplyTo((Destination)this.tool.getDefaultQueue());
            this.tool.getDefaultQueueSender().send((Message)messageSentS);
            messageReceivedS = (StreamMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "Received Stream message ");
            replyQueue = (Queue)messageReceivedS.getJMSReplyTo();
            logger.log(System.Logger.Level.TRACE, "Queue name is " + replyQueue.getQueueName());
            if (replyQueue.getQueueName().equals(this.tool.getDefaultQueue().getQueueName())) {
                logger.log(System.Logger.Level.TRACE, "Pass ");
            } else {
                logger.log(System.Logger.Level.INFO, "StreamMessage ReplyTo Failed");
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: invalid Replyto returned from JMS Header");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("msgHdrReplyToQTest");
        }
    }

    @Test
    public void msgHdrJMSTypeQTest() throws Exception {
        boolean pass = true;
        byte bValue = 127;
        String type = "TESTMSG";
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            StreamMessage messageSentS = null;
            StreamMessage messageReceivedS = null;
            BytesMessage messageSentB = null;
            BytesMessage messageReceivedB = null;
            MapMessage messageReceivedM = null;
            MapMessage messageSentM = null;
            ObjectMessage messageSentO = null;
            ObjectMessage messageReceivedO = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            messageSent = this.tool.getDefaultQueueSession().createTextMessage();
            messageSent.setText("sending a message");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSTypeQTest");
            logger.log(System.Logger.Level.TRACE, "JMSType test - Send a TextMessage");
            messageSent.setJMSType(type);
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            messageReceived = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "JMSType is " + messageReceived.getJMSType());
            if (messageReceived.getJMSType().equals(type)) {
                logger.log(System.Logger.Level.TRACE, "Pass ");
            } else {
                logger.log(System.Logger.Level.INFO, "TextMessage Failed");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "JMSType test - Send ObjectMessage to Queue.");
            messageSentO = this.tool.getDefaultQueueSession().createObjectMessage();
            messageSentO.setObject((Serializable)((Object)"msgHdrJMSTypeQTest for ObjectMessage"));
            messageSentO.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSTypeQTest");
            messageSentO.setJMSType(type);
            this.tool.getDefaultQueueSender().send((Message)messageSentO);
            messageReceivedO = (ObjectMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "JMSType is " + messageReceivedO.getJMSType());
            if (messageReceivedO.getJMSType().equals(type)) {
                logger.log(System.Logger.Level.TRACE, "Pass ");
            } else {
                logger.log(System.Logger.Level.INFO, "ObjectMessage JMSType Failed");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "JMSType test - Send MapMessage to Queue.");
            messageSentM = this.tool.getDefaultQueueSession().createMapMessage();
            messageSentM.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSTypeQTest");
            messageSentM.setString("aString", "value");
            messageSentM.setJMSType(type);
            this.tool.getDefaultQueueSender().send((Message)messageSentM);
            messageReceivedM = (MapMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "JMSType is " + messageReceivedM.getJMSType());
            if (messageReceivedM.getJMSType().equals(type)) {
                logger.log(System.Logger.Level.TRACE, "Pass ");
            } else {
                logger.log(System.Logger.Level.INFO, "MapMessage JMSType Failed");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "JMSType test - Send BytesMessage to Queue.");
            messageSentB = this.tool.getDefaultQueueSession().createBytesMessage();
            messageSentB.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSTypeQTest");
            messageSentB.writeByte(bValue);
            messageSentB.setJMSType(type);
            this.tool.getDefaultQueueSender().send((Message)messageSentB);
            messageReceivedB = (BytesMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "JMSType is " + messageReceivedB.getJMSType());
            if (messageReceivedB.getJMSType().equals(type)) {
                logger.log(System.Logger.Level.TRACE, "Pass ");
            } else {
                logger.log(System.Logger.Level.INFO, "BytesMessage JMSType Failed");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "JMSType test - sending a StreamMessage");
            messageSentS = this.tool.getDefaultQueueSession().createStreamMessage();
            messageSentS.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSTypeQTest");
            messageSentS.writeString("Testing...");
            messageSentS.setJMSType(type);
            this.tool.getDefaultQueueSender().send((Message)messageSentS);
            messageReceivedS = (StreamMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "JMSType is " + messageReceivedS.getJMSType());
            if (messageReceivedS.getJMSType().equals(type)) {
                logger.log(System.Logger.Level.TRACE, "Pass ");
            } else {
                logger.log(System.Logger.Level.INFO, "StreamMessage JMSType Failed");
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: invalid JMSType returned from JMS Header");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("msgHdrJMSTypeQTest");
        }
    }

    @Test
    public void msgHdrJMSPriorityQTest() throws Exception {
        boolean pass = true;
        byte bValue = 127;
        int priority = 2;
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            StreamMessage messageSentS = null;
            StreamMessage messageReceivedS = null;
            BytesMessage messageSentB = null;
            BytesMessage messageReceivedB = null;
            MapMessage messageReceivedM = null;
            MapMessage messageSentM = null;
            ObjectMessage messageSentO = null;
            ObjectMessage messageReceivedO = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            messageSent = this.tool.getDefaultQueueSession().createTextMessage();
            messageSent.setText("sending a message");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSPriorityQTest");
            logger.log(System.Logger.Level.TRACE, "JMSPriority test - Send a TextMessage");
            this.tool.getDefaultQueueSender().setPriority(priority);
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            messageReceived = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "JMSPriority is " + messageReceived.getJMSPriority());
            if (messageReceived.getJMSPriority() == priority) {
                logger.log(System.Logger.Level.TRACE, "Pass ");
            } else {
                logger.log(System.Logger.Level.INFO, "TextMessage Failed");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "JMSPriority test - Send ObjectMessage to Queue.");
            messageSentO = this.tool.getDefaultQueueSession().createObjectMessage();
            messageSentO.setObject((Serializable)((Object)"msgHdrJMSPriorityQTest for ObjectMessage"));
            messageSentO.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSPriorityQTest");
            this.tool.getDefaultQueueSender().setPriority(priority);
            this.tool.getDefaultQueueSender().send((Message)messageSentO);
            messageReceivedO = (ObjectMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "JMSPriority is " + messageReceivedO.getJMSPriority());
            if (messageReceivedO.getJMSPriority() == priority) {
                logger.log(System.Logger.Level.TRACE, "Pass ");
            } else {
                logger.log(System.Logger.Level.INFO, "ObjectMessage JMSPriority Failed");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "JMSPriority test - Send MapMessage to Queue.");
            messageSentM = this.tool.getDefaultQueueSession().createMapMessage();
            messageSentM.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSPriorityQTest");
            messageSentM.setString("aString", "value");
            this.tool.getDefaultQueueSender().setPriority(priority);
            this.tool.getDefaultQueueSender().send((Message)messageSentM);
            messageReceivedM = (MapMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "JMSPriority is " + messageReceivedM.getJMSPriority());
            if (messageReceivedM.getJMSPriority() == priority) {
                logger.log(System.Logger.Level.TRACE, "Pass ");
            } else {
                logger.log(System.Logger.Level.INFO, "MapMessage JMSPriority Failed");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "JMSPriority test - Send BytesMessage to Queue.");
            messageSentB = this.tool.getDefaultQueueSession().createBytesMessage();
            messageSentB.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSPriorityQTest");
            messageSentB.writeByte(bValue);
            this.tool.getDefaultQueueSender().setPriority(priority);
            this.tool.getDefaultQueueSender().send((Message)messageSentB);
            messageReceivedB = (BytesMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "JMSPriority is " + messageReceivedB.getJMSPriority());
            if (messageReceivedB.getJMSPriority() == priority) {
                logger.log(System.Logger.Level.TRACE, "Pass ");
            } else {
                logger.log(System.Logger.Level.INFO, "BytesMessage JMSPriority Failed");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "JMSPriority test - sending a StreamMessage");
            messageSentS = this.tool.getDefaultQueueSession().createStreamMessage();
            messageSentS.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSPriorityQTest");
            messageSentS.writeString("Testing...");
            this.tool.getDefaultQueueSender().setPriority(priority);
            this.tool.getDefaultQueueSender().send((Message)messageSentS);
            messageReceivedS = (StreamMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "JMSPriority is " + messageReceivedS.getJMSPriority());
            if (messageReceivedS.getJMSPriority() == priority) {
                logger.log(System.Logger.Level.TRACE, "Pass ");
            } else {
                logger.log(System.Logger.Level.INFO, "StreamMessage JMSPriority Failed");
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: invalid JMSPriority returned from JMS Header");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("msgHdrJMSPriorityQTest");
        }
    }

    @Test
    public void msgHdrJMSExpirationQueueTest() throws Exception {
        boolean pass = true;
        byte bValue = 127;
        long forever = 0L;
        long timeToLive = this.timeout;
        String testName = "msgHdrJMSExpirationQueueTest";
        long timeBeforeSend = 0L;
        long timeAfterSend = 0L;
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            StreamMessage messageSentS = null;
            StreamMessage messageReceivedS = null;
            BytesMessage messageSentB = null;
            BytesMessage messageReceivedB = null;
            MapMessage messageReceivedM = null;
            MapMessage messageSentM = null;
            ObjectMessage messageSentO = null;
            ObjectMessage messageReceivedO = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            logger.log(System.Logger.Level.TRACE, "JMSExpiration test - Send a TextMessage");
            messageSent = this.tool.getDefaultQueueSession().createTextMessage();
            messageSent.setText("sending a TextMessage");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            this.tool.getDefaultQueueSender().setTimeToLive(forever);
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            messageReceived = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceived.getJMSExpiration() != forever) {
                logger.log(System.Logger.Level.ERROR, "TextMessage Failed");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "JMSExpiration test - Send a TextMessage");
            this.tool.getDefaultQueueSender().setTimeToLive(timeToLive);
            timeBeforeSend = System.currentTimeMillis();
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            timeAfterSend = System.currentTimeMillis();
            long exp = messageSent.getJMSExpiration();
            logger.log(System.Logger.Level.TRACE, "JMSExpiration is set to=" + exp);
            logger.log(System.Logger.Level.TRACE, "Time before send=" + timeBeforeSend);
            logger.log(System.Logger.Level.TRACE, "Time after send=" + timeAfterSend);
            logger.log(System.Logger.Level.TRACE, "Time to Live =" + timeToLive);
            messageReceived = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceived.getJMSExpiration() != exp) {
                logger.log(System.Logger.Level.ERROR, "TextMessage Failed: JMSExpiration didnot set correctly = " + messageReceived.getJMSExpiration());
                logger.log(System.Logger.Level.ERROR, "JMSExpiration was set to=" + exp);
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "JMSExpiration test - Send ObjectMessage to Queue.");
            messageSentO = this.tool.getDefaultQueueSession().createObjectMessage();
            messageSentO.setObject((Serializable)((Object)"msgHdrJMSExpirationQueueTest for ObjectMessage"));
            messageSentO.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            this.tool.getDefaultQueueSender().setTimeToLive(forever);
            this.tool.getDefaultQueueSender().send((Message)messageSentO);
            messageReceivedO = (ObjectMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceivedO.getJMSExpiration() != forever) {
                logger.log(System.Logger.Level.INFO, "ObjectMessage JMSExpiration Failed");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "JMSExpiration test - Send an ObjectMessage");
            this.tool.getDefaultQueueSender().setTimeToLive(timeToLive);
            timeBeforeSend = System.currentTimeMillis();
            this.tool.getDefaultQueueSender().send((Message)messageSentO);
            timeAfterSend = System.currentTimeMillis();
            exp = messageSentO.getJMSExpiration();
            logger.log(System.Logger.Level.TRACE, "JMSExpiration is set to=" + exp);
            logger.log(System.Logger.Level.TRACE, "Time before send=" + timeBeforeSend);
            logger.log(System.Logger.Level.TRACE, "Time after send=" + timeAfterSend);
            logger.log(System.Logger.Level.TRACE, "Time to Live =" + timeToLive);
            messageReceivedO = (ObjectMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceivedO.getJMSExpiration() != exp) {
                logger.log(System.Logger.Level.ERROR, "ObjectMessage Failed: JMSExpiration didnot set correctly = " + messageReceivedO.getJMSExpiration());
                logger.log(System.Logger.Level.ERROR, "JMSExpiration was set to=" + exp);
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "JMSExpiration test - Send MapMessage to Queue.");
            messageSentM = this.tool.getDefaultQueueSession().createMapMessage();
            messageSentM.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            messageSentM.setString("aString", "value");
            this.tool.getDefaultQueueSender().setTimeToLive(forever);
            this.tool.getDefaultQueueSender().send((Message)messageSentM);
            messageReceivedM = (MapMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceivedM.getJMSExpiration() != forever) {
                logger.log(System.Logger.Level.INFO, "MapMessage JMSExpiration Failed");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "JMSExpiration test - Send a MapMessage");
            this.tool.getDefaultQueueSender().setTimeToLive(timeToLive);
            timeBeforeSend = System.currentTimeMillis();
            this.tool.getDefaultQueueSender().send((Message)messageSentM);
            timeAfterSend = System.currentTimeMillis();
            exp = messageSentM.getJMSExpiration();
            logger.log(System.Logger.Level.TRACE, "JMSExpiration is set to=" + exp);
            logger.log(System.Logger.Level.TRACE, "Time before send=" + timeBeforeSend);
            logger.log(System.Logger.Level.TRACE, "Time after send=" + timeAfterSend);
            logger.log(System.Logger.Level.TRACE, "Time to Live =" + timeToLive);
            messageReceivedM = (MapMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceivedM.getJMSExpiration() != exp) {
                logger.log(System.Logger.Level.ERROR, "MapMessage Failed: JMSExpiration didnot set correctly = " + messageReceivedM.getJMSExpiration());
                logger.log(System.Logger.Level.ERROR, "JMSExpiration was set to=" + exp);
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "JMSExpiration test - Send BytesMessage to Queue.");
            messageSentB = this.tool.getDefaultQueueSession().createBytesMessage();
            messageSentB.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            messageSentB.writeByte(bValue);
            this.tool.getDefaultQueueSender().setTimeToLive(forever);
            this.tool.getDefaultQueueSender().send((Message)messageSentB);
            messageReceivedB = (BytesMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceivedB.getJMSExpiration() != forever) {
                logger.log(System.Logger.Level.INFO, "BytesMessage JMSExpiration Failed");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "JMSExpiration test - Send a BytesMessage");
            this.tool.getDefaultQueueSender().setTimeToLive(timeToLive);
            timeBeforeSend = System.currentTimeMillis();
            this.tool.getDefaultQueueSender().send((Message)messageSentB);
            timeAfterSend = System.currentTimeMillis();
            exp = messageSentB.getJMSExpiration();
            logger.log(System.Logger.Level.TRACE, "JMSExpiration is set to=" + exp);
            logger.log(System.Logger.Level.TRACE, "Time before send=" + timeBeforeSend);
            logger.log(System.Logger.Level.TRACE, "Time after send=" + timeAfterSend);
            logger.log(System.Logger.Level.TRACE, "Time to Live =" + timeToLive);
            messageReceivedB = (BytesMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceivedB.getJMSExpiration() != exp) {
                logger.log(System.Logger.Level.ERROR, "BytesMessage Failed: JMSExpiration didnot set correctly = " + messageReceivedB.getJMSExpiration());
                logger.log(System.Logger.Level.ERROR, "JMSExpiration was set to=" + exp);
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "JMSExpiration test - sending a StreamMessage");
            messageSentS = this.tool.getDefaultQueueSession().createStreamMessage();
            messageSentS.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            messageSentS.writeString("Testing...");
            this.tool.getDefaultQueueSender().setTimeToLive(forever);
            this.tool.getDefaultQueueSender().send((Message)messageSentS);
            messageReceivedS = (StreamMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceivedS.getJMSExpiration() != forever) {
                logger.log(System.Logger.Level.INFO, "StreamMessage JMSExpiration Failed");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "JMSExpiration test - Send a StreamMessage");
            this.tool.getDefaultQueueSender().setTimeToLive(timeToLive);
            timeBeforeSend = System.currentTimeMillis();
            this.tool.getDefaultQueueSender().send((Message)messageSentS);
            timeAfterSend = System.currentTimeMillis();
            exp = messageSentS.getJMSExpiration();
            logger.log(System.Logger.Level.TRACE, "JMSExpiration is set to=" + exp);
            logger.log(System.Logger.Level.TRACE, "Time before send=" + timeBeforeSend);
            logger.log(System.Logger.Level.TRACE, "Time after send=" + timeAfterSend);
            logger.log(System.Logger.Level.TRACE, "Time to Live =" + timeToLive);
            messageReceivedS = (StreamMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceivedS.getJMSExpiration() != exp) {
                logger.log(System.Logger.Level.ERROR, "StreamMessage Failed: JMSExpiration didnot set correctly = " + messageReceivedS.getJMSExpiration());
                logger.log(System.Logger.Level.ERROR, "JMSExpiration was set to=" + exp);
                pass = false;
            }
            if (!pass) {
                throw new Exception("Error: invalid JMSExpiration returned from JMS Header");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception(testName);
        }
    }

    @Test
    public void msgHdrJMSDestinationQTest() throws Exception {
        boolean pass = true;
        byte bValue = 127;
        Queue replyDestination = null;
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            StreamMessage messageSentS = null;
            StreamMessage messageReceivedS = null;
            BytesMessage messageSentB = null;
            BytesMessage messageReceivedB = null;
            MapMessage messageReceivedM = null;
            MapMessage messageSentM = null;
            ObjectMessage messageSentO = null;
            ObjectMessage messageReceivedO = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            messageSent = this.tool.getDefaultQueueSession().createTextMessage();
            messageSent.setText("sending a message");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSDestinationQTest");
            logger.log(System.Logger.Level.TRACE, "Send TextMessage to Queue.");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            messageReceived = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "JMSDestination:  " + messageReceived.getJMSDestination());
            replyDestination = (Queue)messageReceived.getJMSDestination();
            if (replyDestination == null) {
                pass = false;
                logger.log(System.Logger.Level.INFO, "TextMessage Error: JMSDestination returned a  null");
            } else {
                logger.log(System.Logger.Level.TRACE, "Queue name is " + replyDestination.getQueueName());
                if (replyDestination.getQueueName().equals(this.tool.getDefaultQueue().getQueueName())) {
                    logger.log(System.Logger.Level.TRACE, "Pass ");
                } else {
                    logger.log(System.Logger.Level.INFO, "TextMessage Failed");
                    pass = false;
                }
            }
            logger.log(System.Logger.Level.TRACE, "Send ObjectMessage to Queue.");
            messageSentO = this.tool.getDefaultQueueSession().createObjectMessage();
            messageSentO.setObject((Serializable)((Object)"msgHdrJMSDestinationQTest for ObjectMessage"));
            messageSentO.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSDestinationQTest");
            this.tool.getDefaultQueueSender().send((Message)messageSentO);
            messageReceivedO = (ObjectMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "JMSDestination:  " + messageReceivedO.getJMSDestination());
            replyDestination = (Queue)messageReceived.getJMSDestination();
            if (replyDestination == null) {
                pass = false;
                logger.log(System.Logger.Level.INFO, "ObjectMessage Error: JMSDestination returned a  null");
            } else {
                logger.log(System.Logger.Level.TRACE, "Queue name is " + replyDestination.getQueueName());
                if (replyDestination.getQueueName().equals(this.tool.getDefaultQueue().getQueueName())) {
                    logger.log(System.Logger.Level.TRACE, "Pass ");
                } else {
                    logger.log(System.Logger.Level.INFO, "ObjectMessage Failed");
                    pass = false;
                }
            }
            logger.log(System.Logger.Level.TRACE, "Send MapMessage to Queue.");
            messageSentM = this.tool.getDefaultQueueSession().createMapMessage();
            messageSentM.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSDestinationQTest");
            messageSentM.setString("aString", "value");
            this.tool.getDefaultQueueSender().send((Message)messageSentM);
            messageReceivedM = (MapMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "JMSDestination:  " + messageReceivedM.getJMSDestination());
            replyDestination = (Queue)messageReceived.getJMSDestination();
            if (replyDestination == null) {
                pass = false;
                logger.log(System.Logger.Level.INFO, "MapMessage Error: JMSDestination returned a  null");
            } else {
                logger.log(System.Logger.Level.TRACE, "Queue name is " + replyDestination.getQueueName());
                if (replyDestination.getQueueName().equals(this.tool.getDefaultQueue().getQueueName())) {
                    logger.log(System.Logger.Level.TRACE, "Pass ");
                } else {
                    logger.log(System.Logger.Level.INFO, "MapMessage Failed");
                    pass = false;
                }
            }
            logger.log(System.Logger.Level.TRACE, "Send BytesMessage to Queue.");
            messageSentB = this.tool.getDefaultQueueSession().createBytesMessage();
            messageSentB.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSDestinationQTest");
            messageSentB.writeByte(bValue);
            this.tool.getDefaultQueueSender().send((Message)messageSentB);
            messageReceivedB = (BytesMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "JMSDestination:  " + messageReceivedB.getJMSDestination());
            replyDestination = (Queue)messageReceived.getJMSDestination();
            if (replyDestination == null) {
                pass = false;
                logger.log(System.Logger.Level.INFO, "BytesMessage Error: JMSDestination returned a  null");
            } else {
                logger.log(System.Logger.Level.TRACE, "Queue name is " + replyDestination.getQueueName());
                if (replyDestination.getQueueName().equals(this.tool.getDefaultQueue().getQueueName())) {
                    logger.log(System.Logger.Level.TRACE, "Pass ");
                } else {
                    logger.log(System.Logger.Level.INFO, "BytesMessage Failed");
                    pass = false;
                }
            }
            logger.log(System.Logger.Level.TRACE, "sending a StreamMessage");
            messageSentS = this.tool.getDefaultQueueSession().createStreamMessage();
            messageSentS.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSDestinationQTest");
            messageSentS.writeString("Testing...");
            logger.log(System.Logger.Level.TRACE, "Sending StreamMessage");
            this.tool.getDefaultQueueSender().send((Message)messageSentS);
            messageReceivedS = (StreamMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "JMSDestination:  " + messageReceivedS.getJMSDestination());
            replyDestination = (Queue)messageReceived.getJMSDestination();
            if (replyDestination == null) {
                pass = false;
                logger.log(System.Logger.Level.INFO, "StreamMessage Error: JMSDestination returned a  null");
            } else {
                logger.log(System.Logger.Level.TRACE, "Queue name is " + replyDestination.getQueueName());
                if (replyDestination.getQueueName().equals(this.tool.getDefaultQueue().getQueueName())) {
                    logger.log(System.Logger.Level.TRACE, "Pass ");
                } else {
                    logger.log(System.Logger.Level.INFO, "StreamMessage Failed");
                    pass = false;
                }
            }
            if (!pass) {
                throw new Exception("Error: invalid JMSDestination returned from JMS Header");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("msgHdrJMSDestinationQTest");
        }
    }

    @Test
    public void msgHdrJMSDeliveryModeQTest() throws Exception {
        boolean pass = true;
        byte bValue = 127;
        String testName = "msgHdrJMSDeliveryModeQTest";
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            StreamMessage messageSentS = null;
            StreamMessage messageReceivedS = null;
            BytesMessage messageSentB = null;
            BytesMessage messageReceivedB = null;
            MapMessage messageReceivedM = null;
            MapMessage messageSentM = null;
            ObjectMessage messageSentO = null;
            ObjectMessage messageReceivedO = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            logger.log(System.Logger.Level.TRACE, "send TextMessage to Queue.");
            messageSent = this.tool.getDefaultQueueSession().createTextMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            messageReceived = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceived.getJMSDeliveryMode() != 2) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "TextMessage Error: JMSDeliveryMode should be set to persistent as default");
            }
            messageReceived.setJMSDeliveryMode(1);
            if (messageReceived.getJMSDeliveryMode() != 1) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "TextMessage Error: JMSDeliveryMode not set correctly by setJMSDeliveryMode");
            }
            logger.log(System.Logger.Level.TRACE, "send ObjectMessage to Queue.");
            messageSentO = this.tool.getDefaultQueueSession().createObjectMessage();
            messageSentO.setObject((Serializable)((Object)"Test for ObjectMessage"));
            messageSentO.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            this.tool.getDefaultQueueSender().send((Message)messageSentO);
            messageReceivedO = (ObjectMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceivedO.getJMSDeliveryMode() != 2) {
                pass = false;
                logger.log(System.Logger.Level.INFO, "ObjectMessage Error: JMSDeliveryMode should be set to persistent as default");
            }
            messageReceivedO.setJMSDeliveryMode(1);
            if (messageReceivedO.getJMSDeliveryMode() != 1) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "ObjectMessage Error: JMSDeliveryMode not set correctly by setJMSDeliveryMode");
            }
            logger.log(System.Logger.Level.TRACE, "send MapMessage to Queue.");
            messageSentM = this.tool.getDefaultQueueSession().createMapMessage();
            messageSentM.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            messageSentM.setString("aString", "value");
            this.tool.getDefaultQueueSender().send((Message)messageSentM);
            messageReceivedM = (MapMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceivedM.getJMSDeliveryMode() != 2) {
                pass = false;
                logger.log(System.Logger.Level.INFO, "MapMessage Error: JMSDeliveryMode should be set to persistent as default");
            }
            messageReceivedM.setJMSDeliveryMode(1);
            if (messageReceivedM.getJMSDeliveryMode() != 1) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "MapMessage Error: JMSDeliveryMode not set correctly by setJMSDeliveryMode");
            }
            logger.log(System.Logger.Level.TRACE, "send BytesMessage to Queue.");
            messageSentB = this.tool.getDefaultQueueSession().createBytesMessage();
            messageSentB.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            messageSentB.writeByte(bValue);
            this.tool.getDefaultQueueSender().send((Message)messageSentB);
            messageReceivedB = (BytesMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceivedB.getJMSDeliveryMode() != 2) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "BytesMessage Error: JMSDeliveryMode should be set to persistent as default");
            }
            messageReceivedB.setJMSDeliveryMode(1);
            if (messageReceivedB.getJMSDeliveryMode() != 1) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "BytesMessage Error: JMSDeliveryMode not set correctly by setJMSDeliveryMode");
            }
            logger.log(System.Logger.Level.TRACE, "sending a StreamMessage");
            messageSentS = this.tool.getDefaultQueueSession().createStreamMessage();
            messageSentS.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            messageSentS.writeString("Testing...");
            this.tool.getDefaultQueueSender().send((Message)messageSentS);
            messageReceivedS = (StreamMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceivedS.getJMSDeliveryMode() != 2) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "StreamMessage Error: JMSDeliveryMode should be set to persistent as default");
            }
            messageReceivedS.setJMSDeliveryMode(1);
            if (messageReceivedS.getJMSDeliveryMode() != 1) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "StreamMessage Error: JMSDeliveryMode not set correctly by setJMSDeliveryMode");
            }
            logger.log(System.Logger.Level.TRACE, "send TextMessage to Queue.");
            this.tool.getDefaultQueueSender().setDeliveryMode(1);
            messageSent = this.tool.getDefaultQueueSession().createTextMessage();
            messageSent.setText("sending a message");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            messageReceived = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceived.getJMSDeliveryMode() != 1) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "TextMessage Error: JMSDeliveryMode should be set to NON_PERSISTENT");
            }
            messageReceived.setJMSDeliveryMode(2);
            if (messageReceived.getJMSDeliveryMode() != 2) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "TextMessage Error: JMSDeliveryMode not set correctly by setJMSDeliveryMode");
            }
            logger.log(System.Logger.Level.TRACE, "send ObjectMessage to Queue.");
            messageSentO = this.tool.getDefaultQueueSession().createObjectMessage();
            messageSentO.setObject((Serializable)((Object)"msgHdrJMSDeliveryModeQTest for ObjectMessage"));
            messageSentO.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            this.tool.getDefaultQueueSender().send((Message)messageSentO);
            messageReceivedO = (ObjectMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceivedO.getJMSDeliveryMode() != 1) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "ObjectMessage Error: JMSDeliveryMode should be set to NON_PERSISTENT");
            }
            messageReceivedO.setJMSDeliveryMode(2);
            if (messageReceivedO.getJMSDeliveryMode() != 2) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "ObjectMessage Error: JMSDeliveryMode not set correctly by setJMSDeliveryMode");
            }
            logger.log(System.Logger.Level.TRACE, "send MapMessage to Queue.");
            messageSentM = this.tool.getDefaultQueueSession().createMapMessage();
            messageSentM.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            messageSentM.setString("aString", "value");
            this.tool.getDefaultQueueSender().send((Message)messageSentM);
            messageReceivedM = (MapMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceivedM.getJMSDeliveryMode() != 1) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "MapMessage Error: JMSDeliveryMode should be set to NON_PERSISTENT");
            }
            messageReceivedM.setJMSDeliveryMode(2);
            if (messageReceivedM.getJMSDeliveryMode() != 2) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "MapMessage Error: JMSDeliveryMode not set correctly by setJMSDeliveryMode");
            }
            logger.log(System.Logger.Level.TRACE, "send BytesMessage to Queue.");
            messageSentB = this.tool.getDefaultQueueSession().createBytesMessage();
            messageSentB.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            messageSentB.writeByte(bValue);
            this.tool.getDefaultQueueSender().send((Message)messageSentB);
            messageReceivedB = (BytesMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceivedB.getJMSDeliveryMode() != 1) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "BytesMessage Error: JMSDeliveryMode should be set to NON_PERSISTENT");
            }
            messageReceivedB.setJMSDeliveryMode(2);
            if (messageReceivedB.getJMSDeliveryMode() != 2) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "BytesMessage Error: JMSDeliveryMode not set correctly by setJMSDeliveryMode");
            }
            logger.log(System.Logger.Level.TRACE, "sending a StreamMessage");
            messageSentS = this.tool.getDefaultQueueSession().createStreamMessage();
            messageSentS.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            messageSentS.writeString("Testing...");
            this.tool.getDefaultQueueSender().send((Message)messageSentS);
            messageReceivedS = (StreamMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceivedS.getJMSDeliveryMode() != 1) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "StreamMessage Error: JMSDeliveryMode should be set to NON_PERSISTENT");
            }
            messageReceivedS.setJMSDeliveryMode(2);
            if (messageReceivedS.getJMSDeliveryMode() != 2) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "StreamMessage Error: JMSDeliveryMode not set correctly by setJMSDeliveryMode");
            }
            if (!pass) {
                throw new Exception("Error: invalid JMSDeliveryMode returned from JMS Header");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception(testName);
        }
    }

    @Test
    public void msgHdrJMSRedeliveredTest() throws Exception {
        boolean pass = true;
        byte bValue = 127;
        String testName = "msgHdrJMSRedeliveredTest";
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            StreamMessage messageSentS = null;
            StreamMessage messageReceivedS = null;
            BytesMessage messageSentB = null;
            BytesMessage messageReceivedB = null;
            MapMessage messageReceivedM = null;
            MapMessage messageSentM = null;
            ObjectMessage messageSentO = null;
            ObjectMessage messageReceivedO = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            logger.log(System.Logger.Level.TRACE, "send TextMessage to Queue.");
            messageSent = this.tool.getDefaultQueueSession().createTextMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            messageReceived = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceived.getJMSRedelivered()) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "TextMessage Error: JMSRedelivered should be false");
            }
            messageReceived.setJMSRedelivered(true);
            if (!messageReceived.getJMSRedelivered()) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "TextMessage Error: JMSRedelivered not set correctly by setJMSRedelivered");
            }
            logger.log(System.Logger.Level.TRACE, "send ObjectMessage to Queue.");
            messageSentO = this.tool.getDefaultQueueSession().createObjectMessage();
            messageSentO.setObject((Serializable)((Object)"Test for ObjectMessage"));
            messageSentO.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            this.tool.getDefaultQueueSender().send((Message)messageSentO);
            messageReceivedO = (ObjectMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceivedO.getJMSRedelivered()) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "ObjectMessage Error: JMSRedelivered should be false");
            }
            messageReceivedO.setJMSRedelivered(true);
            if (!messageReceivedO.getJMSRedelivered()) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "ObjectMessage Error: JMSRedelivered not set correctly by setJMSRedelivered");
            }
            logger.log(System.Logger.Level.TRACE, "send MapMessage to Queue.");
            messageSentM = this.tool.getDefaultQueueSession().createMapMessage();
            messageSentM.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            messageSentM.setString("aString", "value");
            this.tool.getDefaultQueueSender().send((Message)messageSentM);
            messageReceivedM = (MapMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceivedM.getJMSRedelivered()) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "MapMessage Error: JMSRedelivered should be false");
            }
            messageReceivedM.setJMSRedelivered(true);
            if (!messageReceivedM.getJMSRedelivered()) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "MapMessage Error: JMSRedelivered not set correctly by setJMSRedelivered");
            }
            logger.log(System.Logger.Level.TRACE, "send BytesMessage to Queue.");
            messageSentB = this.tool.getDefaultQueueSession().createBytesMessage();
            messageSentB.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            messageSentB.writeByte(bValue);
            this.tool.getDefaultQueueSender().send((Message)messageSentB);
            messageReceivedB = (BytesMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceivedB.getJMSRedelivered()) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "BytesMessage Error: JMSRedelivered should be false");
            }
            messageReceivedB.setJMSRedelivered(true);
            if (!messageReceivedB.getJMSRedelivered()) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "BytesMessage Error: JMSRedelivered not set correctly by setJMSRedelivered");
            }
            logger.log(System.Logger.Level.TRACE, "sending a StreamMessage");
            messageSentS = this.tool.getDefaultQueueSession().createStreamMessage();
            messageSentS.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            messageSentS.writeString("Testing...");
            this.tool.getDefaultQueueSender().send((Message)messageSentS);
            messageReceivedS = (StreamMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceivedS.getJMSRedelivered()) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "StreamMessage Error: JMSRedelivered should be false");
            }
            messageReceivedS.setJMSRedelivered(true);
            if (!messageReceivedS.getJMSRedelivered()) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "StreamMessage Error: JMSRedelivered not set correctly by setJMSRedelivered");
            }
            if (!pass) {
                throw new Exception("Error: invalid JMSDeliveryMode returned from JMS Header");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception(testName);
        }
    }
}

