/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.queuetests;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueReceiver;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.Session;
import jakarta.jms.StreamMessage;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TextMessage;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class QueueTestsIT {
    private static final String testName = "com.sun.ts.tests.jms.core.queuetests.QueueTestsIT";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private static final System.Logger logger = System.getLogger(QueueTestsIT.class.getName());
    private transient JmsTool tool = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    ArrayList queues = null;
    ArrayList connections = null;
    private static final int numMessages = 3;
    private static final int iterations = 5;

    private void checkExceptionPass(boolean passed) throws Exception {
        if (!passed) {
            logger.log(System.Logger.Level.INFO, "Didn't get expected exception");
            throw new Exception("Didn't catch expected exception");
        }
    }

    @BeforeEach
    public void setup() throws Exception {
        try {
            this.timeout = Long.parseLong(System.getProperty("jms_timeout"));
            this.user = System.getProperty("user");
            this.password = System.getProperty("password");
            this.mode = System.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' is null ");
            }
            if (this.password == null) {
                throw new Exception("'password' is null ");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' is null");
            }
            this.queues = new ArrayList(10);
            this.connections = new ArrayList(5);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.INFO, "Cleanup: Closing Queue Connections");
            this.tool.doClientQueueTestCleanup(this.connections, this.queues);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "An error occurred while cleaning", (Throwable)e);
            throw new Exception("Cleanup failed!", e);
        }
    }

    @Test
    public void emptyMsgsQueueTest() throws Exception {
        try {
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueSender().setDeliveryMode(1);
            this.tool.getDefaultQueueConnection().start();
            logger.log(System.Logger.Level.INFO, "Send generic Message to Queue.");
            Message msg = this.tool.getDefaultQueueSession().createMessage();
            msg.setStringProperty("COM_SUN_JMS_TESTNAME", "emptyMsgsQueueTest");
            this.tool.getDefaultQueueSender().send(msg);
            if (this.tool.getDefaultQueueReceiver().receive(this.timeout) == null) {
                throw new Exception("Did not receive message");
            }
            logger.log(System.Logger.Level.INFO, "Send BytesMessage to Queue.");
            BytesMessage bMsg = this.tool.getDefaultQueueSession().createBytesMessage();
            bMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "emptyMsgsQueueTest");
            this.tool.getDefaultQueueSender().send((Message)bMsg);
            if (this.tool.getDefaultQueueReceiver().receive(this.timeout) == null) {
                throw new Exception("Did not receive message");
            }
            logger.log(System.Logger.Level.INFO, "Send MapMessage to Queue.");
            MapMessage mMsg = this.tool.getDefaultQueueSession().createMapMessage();
            mMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "emptyMsgsQueueTest");
            this.tool.getDefaultQueueSender().send((Message)mMsg);
            if (this.tool.getDefaultQueueReceiver().receive(this.timeout) == null) {
                throw new Exception("Did not receive message");
            }
            logger.log(System.Logger.Level.INFO, "Send ObjectMessage to Queue.");
            ObjectMessage oMsg = this.tool.getDefaultQueueSession().createObjectMessage();
            oMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "emptyMsgsQueueTest");
            this.tool.getDefaultQueueSender().send((Message)oMsg);
            if (this.tool.getDefaultQueueReceiver().receive(this.timeout) == null) {
                throw new Exception("Did not receive message");
            }
            logger.log(System.Logger.Level.INFO, "Send SreamMessage to Queue.");
            StreamMessage sMsg = this.tool.getDefaultQueueSession().createStreamMessage();
            sMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "emptyMsgsQueueTest");
            this.tool.getDefaultQueueSender().send((Message)sMsg);
            if (this.tool.getDefaultQueueReceiver().receive(this.timeout) == null) {
                throw new Exception("Did not receive message");
            }
            logger.log(System.Logger.Level.INFO, "Send TextMessage to Queue.");
            TextMessage tMsg = this.tool.getDefaultQueueSession().createTextMessage();
            tMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "emptyMsgsQueueTest");
            this.tool.getDefaultQueueSender().send((Message)tMsg);
            if (this.tool.getDefaultQueueReceiver().receive(this.timeout) == null) {
                throw new Exception("Did not receive message");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("emptyMsgsQueueTest failed");
        }
    }

    @Test
    public void autoAckQueueTest() throws Exception {
        try {
            Message messageSent = null;
            Message messageReceived = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            messageSent = this.tool.getDefaultQueueSession().createMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "autoAckQueueTest");
            logger.log(System.Logger.Level.TRACE, "send two messages");
            messageSent.setBooleanProperty("lastMessage", false);
            this.tool.getDefaultQueueSender().send(messageSent);
            messageSent.setBooleanProperty("lastMessage", true);
            this.tool.getDefaultQueueSender().send(messageSent);
            messageReceived = this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceived == null) {
                throw new Exception("Did not receive message");
            }
            if (messageReceived.getBooleanProperty("lastMessage")) {
                throw new Exception("Error: received second message first");
            }
            logger.log(System.Logger.Level.TRACE, "Message received. Call recover.");
            this.tool.getDefaultQueueSession().recover();
            messageReceived = this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceived == null) {
                throw new Exception("Did not receive second message as expected");
            }
            if (!messageReceived.getBooleanProperty("lastMessage")) {
                throw new Exception("Received original message again");
            }
            logger.log(System.Logger.Level.INFO, "Did not receive message again - GOOD");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("autoAckQueueTest");
        }
    }

    @Test
    public void simpleSendReceiveQueueTest() throws Exception {
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            logger.log(System.Logger.Level.INFO, "Creating 1 message");
            messageSent = this.tool.getDefaultQueueSession().createTextMessage();
            messageSent.setText("just a test");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "simpleSendReceiveQueueTest");
            logger.log(System.Logger.Level.INFO, "Sending message");
            this.tool.getDefaultQueueSender().send((Message)messageSent);
            logger.log(System.Logger.Level.INFO, "Receiving message");
            messageReceived = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (!messageReceived.getText().equals(messageSent.getText())) {
                throw new Exception("didn't get the right message");
            }
            logger.log(System.Logger.Level.INFO, "Message text: \"" + messageReceived.getText() + "\"");
            logger.log(System.Logger.Level.INFO, "Received correct message");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("simpleSendReceiveQueueTest failed");
        }
    }

    @Test
    public void messageOrderQueueTest() throws Exception {
        try {
            TextMessage tempMsg;
            int i;
            String[] text = new String[3];
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            for (i = 0; i < 3; ++i) {
                text[i] = "message order test " + i;
                tempMsg = this.tool.getDefaultQueueSession().createTextMessage();
                tempMsg.setText(text[i]);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "messageOrderQueueTest" + i);
                this.tool.getDefaultQueueSender().send((Message)tempMsg);
                logger.log(System.Logger.Level.TRACE, "Sent message: " + tempMsg.getText());
            }
            for (i = 0; i < 3; ++i) {
                tempMsg = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
                if (tempMsg == null) {
                    throw new Exception("cannot receive message");
                }
                logger.log(System.Logger.Level.TRACE, "Received message: " + tempMsg.getText());
                if (tempMsg.getText().equals(text[i])) continue;
                logger.log(System.Logger.Level.INFO, "Received message: " + tempMsg.getText());
                logger.log(System.Logger.Level.INFO, "Should have: " + text[i]);
                throw new Exception("received wrong message");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("messageOrderQueueTest failed");
        }
    }

    @Test
    public void temporaryQueueNotConsumableTest() throws Exception {
        boolean passed = false;
        try {
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            logger.log(System.Logger.Level.INFO, "Creating TemporaryQueue");
            TemporaryQueue tempQ = this.tool.getDefaultQueueSession().createTemporaryQueue();
            logger.log(System.Logger.Level.INFO, "Creating new Connection");
            QueueConnection newQConn = (QueueConnection)this.tool.getNewConnection(0, this.user, this.password);
            this.connections.add(newQConn);
            logger.log(System.Logger.Level.INFO, "Create new Session");
            QueueSession newQSess = newQConn.createQueueSession(false, 1);
            logger.log(System.Logger.Level.INFO, "Create new sender for TemporaryQueue");
            QueueSender newQSender = newQSess.createSender((Queue)tempQ);
            logger.log(System.Logger.Level.INFO, "Send message to TemporaryQueue");
            Message msg = this.tool.getDefaultQueueSession().createMessage();
            msg.setStringProperty("COM_SUN_JMS_TESTNAME", "temporaryQueueNotConsumableTest");
            newQSender.send(msg);
            logger.log(System.Logger.Level.INFO, "Attempt to create receiver for TemporaryQueue from another Session");
            try {
                QueueReceiver newQReceiver = newQSess.createReceiver((Queue)tempQ);
                if (newQReceiver != null) {
                    logger.log(System.Logger.Level.TRACE, "newQReceiver=" + newQReceiver);
                }
            }
            catch (JMSException e) {
                logger.log(System.Logger.Level.INFO, "Received expected JMSException -- GOOD");
                passed = true;
            }
            logger.log(System.Logger.Level.TRACE, "Closing new QueueConnection");
            newQConn.close();
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("temporaryQueueNotConsumableTest failed");
        }
    }

    @Test
    public void messageSelectorMsgRemainsOnQueueTest() throws Exception {
        boolean pass = true;
        try {
            Message messageSent = null;
            Message messageReceived = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            logger.log(System.Logger.Level.INFO, "Creating receiver with message selector");
            this.tool.getDefaultQueueReceiver().close();
            QueueReceiver qSelectiveReceiver = this.tool.getDefaultQueueSession().createReceiver(this.tool.getDefaultQueue(), "TEST = 'test'");
            this.tool.getDefaultQueueConnection().start();
            logger.log(System.Logger.Level.TRACE, "Sending two Messages");
            messageSent = this.tool.getDefaultQueueSession().createMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "messageSelectorMsgRemainsOnQueueTest");
            messageSent.setBooleanProperty("lastMessage", false);
            this.tool.getDefaultQueueSender().send(messageSent);
            messageSent.setStringProperty("TEST", "test");
            messageSent.setBooleanProperty("lastMessage", true);
            this.tool.getDefaultQueueSender().send(messageSent);
            logger.log(System.Logger.Level.TRACE, "Receiving message with selective receiver");
            messageReceived = qSelectiveReceiver.receive(this.timeout);
            if (messageReceived == null) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Did not receive any message");
            } else if (!messageReceived.getBooleanProperty("lastMessage")) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Received incorrect message");
            } else {
                logger.log(System.Logger.Level.INFO, "Selective Receiver received correct message");
            }
            qSelectiveReceiver.close();
            QueueReceiver qRec = this.tool.getDefaultQueueSession().createReceiver(this.tool.getDefaultQueue());
            messageReceived = qRec.receive(this.timeout);
            if (messageReceived == null) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Un-received message did not remain on queue");
            } else if (messageReceived.getBooleanProperty("lastMessage")) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "received incorrect message");
            } else {
                logger.log(System.Logger.Level.INFO, "Corrected Message left on Queue is received");
            }
            if (!pass) {
                throw new Exception("messageSelectorMsgRemainsOnQueueTest Failed!!");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("messageSelectorMsgRemainsOnQueueTest failed");
        }
    }

    @Test
    public void msgSelectorMsgHeaderQueueTest() throws Exception {
        boolean pass = true;
        try {
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            logger.log(System.Logger.Level.INFO, "Creating receiver with message selector");
            this.tool.getDefaultQueueReceiver().close();
            QueueReceiver qSelectiveReceiver = this.tool.getDefaultQueueSession().createReceiver(this.tool.getDefaultQueue(), "JMSType = 'test_message'");
            this.tool.getDefaultQueueConnection().start();
            Message m = this.tool.getDefaultQueueSession().createMessage();
            m.setStringProperty("COM_SUN_JMS_TESTNAME", "msgSelectorMsgHeaderQueueTest");
            logger.log(System.Logger.Level.TRACE, "Sending message not matching selector");
            m.setJMSType("foo");
            m.setBooleanProperty("lastMessage", false);
            this.tool.getDefaultQueueSender().send(m);
            logger.log(System.Logger.Level.TRACE, "Sending test message with header property JMSType");
            m.setJMSType("test_message");
            m.setBooleanProperty("lastMessage", true);
            this.tool.getDefaultQueueSender().send(m);
            logger.log(System.Logger.Level.INFO, "Attempt to receive 'good' message");
            Message msg1 = qSelectiveReceiver.receive(this.timeout);
            qSelectiveReceiver.close();
            if (msg1 == null) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Did not receive any message");
            } else if (msg1.getBooleanProperty("lastMessage")) {
                logger.log(System.Logger.Level.INFO, "Received correct message -- GOOD");
            } else {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Received message not matching header");
            }
            QueueReceiver qRec = this.tool.getDefaultQueueSession().createReceiver(this.tool.getDefaultQueue());
            msg1 = qRec.receive(this.timeout);
            if (msg1 == null) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "No message received.");
            } else if (!msg1.getBooleanProperty("lastMessage")) {
                logger.log(System.Logger.Level.INFO, "Received correct message left");
            } else {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Received incorrect message");
            }
            if (!pass) {
                throw new Exception("msgSelectorMsgHeaderQueueTest failed!!");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("msgSelectorMsgHeaderQueueTest failed");
        }
    }

    @Test
    public void queueBrowserMsgsRemainOnQueueTest() throws Exception {
        try {
            TextMessage tempMsg = null;
            QueueReceiver lastMessageReceiver = null;
            QueueReceiver qRec = null;
            QueueBrowser qBrowser = null;
            Enumeration msgs = null;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueReceiver().close();
            lastMessageReceiver = this.tool.getDefaultQueueSession().createReceiver(this.tool.getDefaultQueue(), "lastMessage = TRUE");
            this.tool.getDefaultQueueConnection().start();
            for (int i = 0; i <= 3; ++i) {
                tempMsg = this.tool.getDefaultQueueSession().createTextMessage();
                if (i == 3) {
                    tempMsg.setBooleanProperty("lastMessage", true);
                } else {
                    tempMsg.setBooleanProperty("lastMessage", false);
                }
                tempMsg.setText("message" + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "queueBrowserMsgsRemainOnQueueTest" + i);
                this.tool.getDefaultQueueSender().send((Message)tempMsg);
                logger.log(System.Logger.Level.TRACE, "message " + i + " sent");
            }
            tempMsg = (TextMessage)lastMessageReceiver.receive(this.timeout);
            if (tempMsg == null) {
                throw new Exception("Did not receive expected message");
            }
            logger.log(System.Logger.Level.TRACE, "Received last sent message, lastMessage=" + tempMsg.getBooleanProperty("lastMessage"));
            lastMessageReceiver.close();
            logger.log(System.Logger.Level.TRACE, "Creating QueueBrowser");
            qBrowser = this.tool.getDefaultQueueSession().createBrowser(this.tool.getDefaultQueue());
            logger.log(System.Logger.Level.INFO, "Checking for 3 messages with QueueBrowser");
            int msgCount = 0;
            msgs = qBrowser.getEnumeration();
            while (msgs.hasMoreElements()) {
                tempMsg = (TextMessage)msgs.nextElement();
                ++msgCount;
            }
            logger.log(System.Logger.Level.TRACE, "found " + msgCount + " messages total in browser");
            if (msgCount != 3) {
                logger.log(System.Logger.Level.INFO, "Warning: browser did not find all messages");
            }
            qBrowser.close();
            qRec = this.tool.getDefaultQueueSession().createReceiver(this.tool.getDefaultQueue());
            logger.log(System.Logger.Level.INFO, "Receive all remaining messages to verify still in queue");
            for (msgCount = 0; msgCount < 3; ++msgCount) {
                tempMsg = (TextMessage)qRec.receive(this.timeout);
                if (tempMsg == null) {
                    throw new Exception("Message " + msgCount + " missing from queue");
                }
                logger.log(System.Logger.Level.TRACE, "received message: " + tempMsg.getText());
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("queueBrowserMsgsRemainOnQueueTest failed");
        }
    }

    @Test
    public void inactiveClientReceiveQueueTest() throws Exception {
        try {
            TextMessage tempMsg;
            int i;
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueReceiver().close();
            this.tool.getDefaultQueueConnection().start();
            for (i = 0; i < 3; ++i) {
                tempMsg = this.tool.getDefaultQueueSession().createTextMessage();
                tempMsg.setText("message" + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "inactiveClientReceiveQueueTest" + i);
                this.tool.getDefaultQueueSender().send((Message)tempMsg);
                logger.log(System.Logger.Level.TRACE, "message " + i + " sent");
            }
            this.tool.getDefaultQueueSession().close();
            QueueSession qSession = this.tool.getDefaultQueueConnection().createQueueSession(false, 1);
            QueueReceiver qReceiver = qSession.createReceiver(this.tool.getDefaultQueue());
            for (i = 0; i < 3; ++i) {
                tempMsg = (TextMessage)qReceiver.receive(this.timeout);
                if (tempMsg == null) {
                    throw new Exception("Did not receive all messages");
                }
                logger.log(System.Logger.Level.TRACE, "received message " + i);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("inactiveClientReceiveQueueTest failed");
        }
    }

    @Test
    public void msgProducerNullDestinationQueueTest() throws Exception {
        boolean pass = true;
        QueueSender qSender = null;
        Queue nullQ = null;
        TextMessage messageSent = null;
        TextMessage messageReceived = null;
        try {
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            logger.log(System.Logger.Level.TRACE, "Creating  1 message");
            messageSent = this.tool.getDefaultQueueSession().createTextMessage();
            messageSent.setText("test creating a producer without specifying the destination");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "msgProducerNullDestinationQueueTest");
            logger.log(System.Logger.Level.INFO, "Test createSender(null) - This is valid");
            try {
                qSender = this.tool.getDefaultQueueSession().createSender(nullQ);
                logger.log(System.Logger.Level.TRACE, "PASS: null allowed for unidentified producer");
            }
            catch (Exception ee) {
                TestUtil.printStackTrace((Throwable)ee);
                logger.log(System.Logger.Level.INFO, "Error: unexpected error " + ee.getClass().getName() + " was thrown");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "Send a message");
            qSender.send(this.tool.getDefaultQueue(), (Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receive a message");
            messageReceived = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
            if (messageReceived == null) {
                pass = false;
            } else {
                logger.log(System.Logger.Level.TRACE, "Got message - OK");
            }
            if (!pass) {
                throw new Exception("Error: failures occurred during msgProducerNullDestinationQueueTest tests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("msgProducerNullDestinationQueueTest failed");
        }
    }

    @Test
    public void multipleCloseQueueConnectionTest() throws Exception {
        try {
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            logger.log(System.Logger.Level.TRACE, "Call close on a connection ");
            this.tool.getDefaultQueueConnection().close();
            logger.log(System.Logger.Level.TRACE, "Call close on a connection a second time");
            this.tool.getDefaultQueueConnection().close();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("multipleCloseQueueConnectionTest failed");
        }
    }

    @Test
    public void messageOrderDeliveryModeQueueTest() throws Exception {
        try {
            TextMessage tempMsg;
            int i;
            String[] text = new String[3];
            this.tool = new JmsTool(0, this.user, this.password, this.mode);
            this.tool.getDefaultQueueConnection().start();
            this.tool.getDefaultQueueSender().setDeliveryMode(1);
            for (i = 0; i < 3; ++i) {
                text[i] = "message order test " + i;
                tempMsg = this.tool.getDefaultQueueSession().createTextMessage();
                tempMsg.setText(text[i]);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "messageOrderDeliveryModeQueueTest" + i);
                this.tool.getDefaultQueueSender().send((Message)tempMsg);
                logger.log(System.Logger.Level.TRACE, "Sent message: " + tempMsg.getText());
            }
            for (i = 0; i < 3; ++i) {
                tempMsg = (TextMessage)this.tool.getDefaultQueueReceiver().receive(this.timeout);
                if (tempMsg == null) {
                    throw new Exception("cannot receive message");
                }
                logger.log(System.Logger.Level.TRACE, "Received message: " + tempMsg.getText());
                if (tempMsg.getText().equals(text[i])) continue;
                logger.log(System.Logger.Level.INFO, "Received message: " + tempMsg.getText());
                logger.log(System.Logger.Level.INFO, "Should have: " + text[i]);
                throw new Exception("received wrong message");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("messageOrderDeliveryModeQueueTest failed");
        }
    }

    @Test
    public void tempQueueTests() throws Exception {
        boolean pass = true;
        String testName = "tempQueueTests";
        String message = "Just a test from tempQueueTests";
        TemporaryQueue tempQ = null;
        Connection newConn = null;
        try {
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.tool.getDefaultProducer().close();
            this.tool.getDefaultConsumer().close();
            this.tool.getDefaultConnection().start();
            logger.log(System.Logger.Level.INFO, "Creating TemporaryQueue");
            tempQ = this.tool.getDefaultSession().createTemporaryQueue();
            logger.log(System.Logger.Level.INFO, "Create new sender for TemporaryQueue");
            MessageProducer sender = this.tool.getDefaultSession().createProducer((Destination)tempQ);
            MessageConsumer receiver = this.tool.getDefaultSession().createConsumer((Destination)tempQ);
            logger.log(System.Logger.Level.INFO, "Send message to TemporaryQueue");
            TextMessage msgSent = this.tool.getDefaultSession().createTextMessage();
            msgSent.setText(message);
            msgSent.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            sender.send((Message)msgSent);
            TextMessage msgReceived = (TextMessage)receiver.receive(this.timeout);
            if (msgReceived == null) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "didnot receive message");
            } else if (!msgReceived.getText().equals(message)) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Received wrong message=" + msgReceived.getText());
                logger.log(System.Logger.Level.ERROR, "Should have: " + message);
            }
            try {
                tempQ.delete();
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Didn't throw expected JMSException calling TemporaryQueue.delete()");
            }
            catch (JMSException em) {
                logger.log(System.Logger.Level.TRACE, "Received expected JMSException: ");
            }
            receiver.close();
            try {
                tempQ.delete();
                logger.log(System.Logger.Level.TRACE, "Succesfully calling TemporaryQueue.delete() after closing Receiver");
            }
            catch (Exception e) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Received unexpected Exception: ", (Throwable)e);
            }
            tempQ = this.tool.getDefaultSession().createTemporaryQueue();
            newConn = this.tool.getNewConnection(13, this.user, this.password);
            this.connections.add(newConn);
            Session newSess = newConn.createSession(false, 1);
            logger.log(System.Logger.Level.INFO, "Attempt to create MessageConsumer for TemporaryQueue from another Connection");
            try {
                MessageConsumer newReceiver = newSess.createConsumer((Destination)tempQ);
                if (newReceiver != null) {
                    logger.log(System.Logger.Level.TRACE, "newReceiver=" + newReceiver);
                }
                logger.log(System.Logger.Level.TRACE, "FAIL: expected IllegalStateException");
                logger.log(System.Logger.Level.ERROR, "Didn't throw expected JMSException calling Session.createConsumer(TemporaryQueue)");
            }
            catch (JMSException e) {
                logger.log(System.Logger.Level.TRACE, "Received expected JMSException from createConsumer.");
            }
            if (!pass) {
                throw new Exception(testName + " failed");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception(testName);
        }
    }
}

