/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.topictests;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Session;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicConnection;
import jakarta.jms.TopicPublisher;
import jakarta.jms.TopicSession;
import jakarta.jms.TopicSubscriber;
import java.util.ArrayList;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TopicTestsIT {
    private static final String testName = "com.sun.ts.tests.jms.core.topictests.TopicTestsIT";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private static final System.Logger logger = System.getLogger(TopicTestsIT.class.getName());
    private Properties props = null;
    private transient JmsTool tool = null;
    long timeout;
    private String jmsUser;
    private String jmsPassword;
    private String mode;
    public static final int TOPIC = 1;
    ArrayList connections = null;

    private void cleanupSubscription(TopicSubscriber sub, TopicSession session, String subName) {
        if (sub != null) {
            try {
                logger.log(System.Logger.Level.TRACE, "Closing durable subscriber: " + sub);
                sub.close();
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "exception during close: ", (Throwable)e);
            }
        }
        if (session != null) {
            try {
                logger.log(System.Logger.Level.TRACE, "Unsubscribing \"" + subName + "\"");
                session.unsubscribe(subName);
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "exception during unsubscribe: ", (Throwable)e);
            }
        }
    }

    private void checkExceptionPass(boolean passed) throws Exception {
        if (!passed) {
            logger.log(System.Logger.Level.INFO, "Didn't get expected exception");
            throw new Exception("Didn't catch expected exception");
        }
    }

    @BeforeEach
    public void setup() throws Exception {
        try {
            logger.log(System.Logger.Level.TRACE, "In setup");
            this.jmsUser = System.getProperty("user");
            this.jmsPassword = System.getProperty("password");
            this.mode = System.getProperty("platform.mode");
            this.timeout = Long.parseLong(System.getProperty("jms_timeout"));
            if (this.timeout < 1L) {
                throw new Exception("'timeout' (milliseconds) in must be > 0");
            }
            this.connections = new ArrayList(10);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.INFO, "Cleanup: Closing Topic Connections");
            this.tool.closeAllConnections(this.connections);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "An error occurred while cleaning", (Throwable)e);
            throw new Exception("Cleanup failed!", e);
        }
    }

    @Test
    public void simpleSendReceiveTopicTest() throws Exception {
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            this.tool = new JmsTool(1, this.jmsUser, this.jmsPassword, this.mode);
            this.tool.getDefaultTopicConnection().start();
            logger.log(System.Logger.Level.INFO, "Creating 1 message");
            messageSent = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent.setText("just a test");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "simpleSendReceiveTopicTest");
            logger.log(System.Logger.Level.INFO, "Sending message");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            logger.log(System.Logger.Level.INFO, "Receiving message");
            messageReceived = (TextMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            if (messageReceived == null) {
                throw new Exception("didn't get any message");
            }
            if (!messageReceived.getText().equals(messageSent.getText())) {
                throw new Exception("didn't get the right message");
            }
            logger.log(System.Logger.Level.INFO, "Message text: \"" + messageReceived.getText() + "\"");
            logger.log(System.Logger.Level.INFO, "Received message");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("simpleSendReceiveTopicTest");
        }
    }

    @Test
    public void inactiveNonDurableSubscriberTopicRecTest() throws Exception {
        TopicSubscriber tSub = null;
        TopicSession tSession = null;
        TopicConnection newTConn = null;
        String lookup = "MyTopicConnectionFactory";
        try {
            TextMessage messageSent = null;
            TextMessage messageSent2 = null;
            TextMessage messageReceived = null;
            logger.log(System.Logger.Level.TRACE, "Set up JmsTool for Topic");
            this.tool = new JmsTool(1, this.jmsUser, this.jmsPassword, lookup, this.mode);
            logger.log(System.Logger.Level.TRACE, "Getting default subscriber");
            tSub = this.tool.getDefaultTopicSubscriber();
            logger.log(System.Logger.Level.TRACE, "Start Connection");
            this.tool.getDefaultTopicConnection().start();
            logger.log(System.Logger.Level.TRACE, "Create and publish first message");
            messageSent = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent.setText("just a test");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "inactiveNonDurableSubscriberTopicRecTest");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receive first message");
            messageReceived = (TextMessage)tSub.receive(this.timeout);
            logger.log(System.Logger.Level.TRACE, "Verify that first message is received");
            if (!messageReceived.getText().equals(messageSent.getText())) {
                throw new Exception("didn't get the right message");
            }
            logger.log(System.Logger.Level.TRACE, "Message text: \"" + messageReceived.getText() + "\"");
            logger.log(System.Logger.Level.INFO, "Received correct message");
            logger.log(System.Logger.Level.TRACE, "Close default subscriber");
            tSub.close();
            logger.log(System.Logger.Level.TRACE, "Create and publish second message");
            messageSent2 = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent2.setText("test that messages are nondurable");
            messageSent2.setStringProperty("COM_SUN_JMS_TESTNAME", "inactiveNonDurableSubscriberTopicRecTest");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent2);
            this.tool.getDefaultTopicConnection().close();
            logger.log(System.Logger.Level.TRACE, "Recreate default subscriber");
            newTConn = (TopicConnection)this.tool.getNewConnection(1, this.jmsUser, this.jmsPassword, lookup);
            this.connections.add(newTConn);
            tSession = newTConn.createTopicSession(false, 1);
            tSub = tSession.createSubscriber(this.tool.getDefaultTopic());
            newTConn.start();
            logger.log(System.Logger.Level.TRACE, "Try to receive second message (should not receive a message)");
            messageReceived = (TextMessage)tSub.receive(this.timeout);
            if (messageReceived != null) {
                throw new Exception("Received second message. (Expected NO messages)");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("inactiveNonDurableSubscriberTopicRecTest");
        }
    }

    @Test
    public void noLocalDeliveryTopicTest() throws Exception {
        String lookup = "MyTopicConnectionFactory";
        try {
            int i;
            int num = 10;
            TopicSubscriber tSubNoLocal = null;
            TopicConnection newConn = null;
            TopicSession newSess = null;
            TopicPublisher newPub = null;
            TopicSubscriber newSub = null;
            Message messageSent = null;
            Message messageReceived = null;
            this.tool = new JmsTool(1, this.jmsUser, this.jmsPassword, this.mode);
            tSubNoLocal = this.tool.getDefaultTopicSession().createSubscriber(this.tool.getDefaultTopic(), "", true);
            this.tool.getDefaultTopicConnection().start();
            logger.log(System.Logger.Level.TRACE, "Sending " + num + " messages to topic");
            messageSent = this.tool.getDefaultTopicSession().createMessage();
            messageSent.setBooleanProperty("lastMessage", false);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "noLocalDeliveryTopicTest");
            for (i = 0; i < num; ++i) {
                this.tool.getDefaultTopicPublisher().publish(messageSent);
            }
            logger.log(System.Logger.Level.INFO, "Attempting to receive messages");
            for (i = 0; i < num; ++i) {
                messageReceived = this.tool.getDefaultTopicSubscriber().receive(this.timeout);
                if (messageReceived != null) continue;
                throw new Exception("Should have received message");
            }
            logger.log(System.Logger.Level.INFO, "Creating new connection");
            newConn = (TopicConnection)this.tool.getNewConnection(1, this.jmsUser, this.jmsPassword, lookup);
            this.connections.add(newConn);
            newSess = newConn.createTopicSession(false, 1);
            newSub = newSess.createSubscriber(this.tool.getDefaultTopic());
            newPub = newSess.createPublisher(this.tool.getDefaultTopic());
            newConn.start();
            this.tool.getDefaultTopicPublisher().publish(messageSent);
            messageReceived = newSub.receive(this.timeout);
            if (messageReceived == null) {
                throw new Exception("new connection should have received message");
            }
            logger.log(System.Logger.Level.TRACE, "New connection sending message");
            messageSent.setBooleanProperty("lastMessage", true);
            newPub.publish(messageSent);
            logger.log(System.Logger.Level.TRACE, "Closing new connection");
            newConn.close();
            logger.log(System.Logger.Level.TRACE, "Try to receive only message from new connection");
            messageReceived = tSubNoLocal.receive(this.timeout);
            if (messageReceived == null) {
                throw new Exception("No_local subscriber did not receive any message");
            }
            if (!messageReceived.getBooleanProperty("lastMessage")) {
                throw new Exception("No_local subscriber received local message");
            }
            logger.log(System.Logger.Level.TRACE, "Received correct message");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("noLocalDeliveryTopicTest");
        }
    }

    @Test
    public void simpleDurableSubscriberTopicTest() throws Exception {
        TopicSubscriber durableTS = null;
        String lookup = "DURABLE_SUB_CONNECTION_FACTORY";
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            this.tool = new JmsTool(4, this.jmsUser, this.jmsPassword, lookup, this.mode);
            logger.log(System.Logger.Level.INFO, "Create DurableSubscriber");
            this.tool.getDefaultTopicSubscriber().close();
            durableTS = this.tool.getDefaultTopicSession().createDurableSubscriber(this.tool.getDefaultTopic(), "myDurableTopicSubscriber");
            this.tool.getDefaultTopicConnection().start();
            logger.log(System.Logger.Level.INFO, "Creating and sending 1 message");
            messageSent = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent.setText("just a test");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "simpleDurableSubscriberTopicTest");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            logger.log(System.Logger.Level.INFO, "Receiving message");
            messageReceived = (TextMessage)durableTS.receive(this.timeout);
            if (!messageReceived.getText().equals(messageSent.getText())) {
                throw new Exception("didn't get the right message");
            }
            logger.log(System.Logger.Level.INFO, "Message text: \"" + messageReceived.getText() + "\"");
            logger.log(System.Logger.Level.INFO, "Received correct message");
            this.cleanupSubscription(durableTS, this.tool.getDefaultTopicSession(), "myDurableTopicSubscriber");
        }
        catch (Exception e) {
            try {
                TestUtil.printStackTrace((Throwable)e);
                throw new Exception("simpleDurableSubscriberTopicTest");
            }
            catch (Throwable throwable) {
                this.cleanupSubscription(durableTS, this.tool.getDefaultTopicSession(), "myDurableTopicSubscriber");
                throw throwable;
            }
        }
    }

    @Test
    public void temporaryTopicConnectionClosesTest() throws Exception {
        boolean passed = false;
        String lookup = "MyTopicConnectionFactory";
        try {
            this.tool = new JmsTool(1, this.jmsUser, this.jmsPassword, this.mode);
            this.tool.getDefaultTopicConnection().start();
            logger.log(System.Logger.Level.TRACE, "Creating TemporaryTopic");
            TemporaryTopic tempT = this.tool.getDefaultTopicSession().createTemporaryTopic();
            logger.log(System.Logger.Level.TRACE, "Creating new Connection");
            TopicConnection newTConn = (TopicConnection)this.tool.getNewConnection(1, this.jmsUser, this.jmsPassword, lookup);
            this.connections.add(newTConn);
            logger.log(System.Logger.Level.TRACE, "Create new Session");
            TopicSession newTSess = newTConn.createTopicSession(false, 1);
            logger.log(System.Logger.Level.TRACE, "Create new sender for TemporaryTopic");
            TopicPublisher newTPublisher = newTSess.createPublisher((Topic)tempT);
            logger.log(System.Logger.Level.TRACE, "Send message to TemporaryTopic");
            TextMessage tMsg = newTSess.createTextMessage();
            tMsg.setText("test message");
            tMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "temporaryTopicConnectionClosesTest");
            logger.log(System.Logger.Level.TRACE, "TextMessage created. Now publishing");
            newTPublisher.publish((Message)tMsg);
            logger.log(System.Logger.Level.TRACE, "Close original Connection");
            this.tool.getDefaultTopicConnection().close();
            logger.log(System.Logger.Level.TRACE, "Close new TopicConnection");
            newTConn.close();
            passed = true;
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("temporaryTopicConnectionClosesTest");
        }
    }

    @Test
    public void temporaryTopicNotConsumableTest() throws Exception {
        boolean passed = false;
        String lookup = "MyTopicConnectionFactory";
        try {
            this.tool = new JmsTool(1, this.jmsUser, this.jmsPassword, this.mode);
            this.tool.getDefaultTopicConnection().start();
            logger.log(System.Logger.Level.INFO, "Creating TemporaryTopic");
            TemporaryTopic tempT = this.tool.getDefaultTopicSession().createTemporaryTopic();
            logger.log(System.Logger.Level.INFO, "Creating new Connection");
            TopicConnection newTConn = (TopicConnection)this.tool.getNewConnection(1, this.jmsUser, this.jmsPassword, lookup);
            this.connections.add(newTConn);
            logger.log(System.Logger.Level.INFO, "Create new Session");
            TopicSession newTSess = newTConn.createTopicSession(false, 1);
            logger.log(System.Logger.Level.INFO, "Create new publisher for TemporaryTopic");
            TopicPublisher newTPublisher = newTSess.createPublisher((Topic)tempT);
            logger.log(System.Logger.Level.INFO, "Send message to TemporaryTopic");
            TextMessage tMsg = newTSess.createTextMessage();
            tMsg.setText("test message");
            tMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "temporaryTopicNotConsumableTest");
            logger.log(System.Logger.Level.INFO, "TextMessage created. Now publishing");
            newTPublisher.publish((Message)tMsg);
            logger.log(System.Logger.Level.INFO, "Attempt to create subscriber for TemporaryTopic from another Session");
            try {
                TopicSubscriber newTSubscriber = newTSess.createSubscriber((Topic)tempT);
                if (newTSubscriber != null) {
                    logger.log(System.Logger.Level.TRACE, "newTSubscriber=" + newTSubscriber);
                }
            }
            catch (JMSException e) {
                logger.log(System.Logger.Level.INFO, "Received expected JMSException -- GOOD");
                logger.log(System.Logger.Level.INFO, "Received Exception:", (Throwable)e);
                passed = true;
            }
            logger.log(System.Logger.Level.TRACE, "Close new TopicConnection");
            newTConn.close();
            this.checkExceptionPass(passed);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("temporaryTopicNotConsumableTest");
        }
    }

    @Test
    public void msgSelectorMsgHeaderTopicTest() throws Exception {
        try {
            this.tool = new JmsTool(1, this.jmsUser, this.jmsPassword, this.mode);
            logger.log(System.Logger.Level.INFO, "Creating subscriber with message selector");
            TopicSubscriber tSelectiveSubscriber = this.tool.getDefaultTopicSession().createSubscriber(this.tool.getDefaultTopic(), "JMSType = 'test_message'", false);
            this.tool.getDefaultTopicConnection().start();
            Message m = this.tool.getDefaultTopicSession().createMessage();
            m.setStringProperty("COM_SUN_JMS_TESTNAME", "msgSelectorMsgHeaderTopicTest");
            logger.log(System.Logger.Level.TRACE, "Sending message not matching selector");
            m.setJMSType("foo");
            m.setBooleanProperty("lastMessage", false);
            this.tool.getDefaultTopicPublisher().publish(m);
            logger.log(System.Logger.Level.TRACE, "Sending message that matches selector");
            m.setJMSType("test_message");
            m.setBooleanProperty("lastMessage", true);
            this.tool.getDefaultTopicPublisher().publish(m);
            logger.log(System.Logger.Level.INFO, "Attempt to receive 'good' message");
            Message msg1 = tSelectiveSubscriber.receive(this.timeout);
            if (msg1 == null) {
                throw new Exception("Did not receive expected message");
            }
            if (!msg1.getBooleanProperty("lastMessage")) {
                logger.log(System.Logger.Level.INFO, "Received message not matching header");
                throw new Exception("Received incorrect message");
            }
            logger.log(System.Logger.Level.INFO, "Received correct message -- GOOD");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("msgSelectorMsgHeaderTopicTest");
        }
    }

    @Test
    public void inactiveDurableSubscriberTopicRecTest() throws Exception {
        TopicSubscriber durableTS = null;
        TopicSession tSession = null;
        TopicConnection newTConn = null;
        String lookup = "DURABLE_SUB_CONNECTION_FACTORY";
        try {
            TextMessage messageSent = null;
            TextMessage messageSent1 = null;
            TextMessage messageReceived = null;
            this.tool = new JmsTool(4, this.jmsUser, this.jmsPassword, lookup, this.mode);
            logger.log(System.Logger.Level.TRACE, "Create DurableSubscriber");
            this.tool.getDefaultTopicSubscriber().close();
            durableTS = this.tool.getDefaultTopicSession().createDurableSubscriber(this.tool.getDefaultTopic(), "inactiveDurableSubscriberTopicRecTest");
            logger.log(System.Logger.Level.TRACE, "Start Connection");
            this.tool.getDefaultTopicConnection().start();
            logger.log(System.Logger.Level.TRACE, "Creating and sending 1 message");
            messageSent = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent.setText("just a test");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "inactiveDurableSubscriberTopicRecTest");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (TextMessage)durableTS.receive(this.timeout);
            if (!messageReceived.getText().equals(messageSent.getText())) {
                throw new Exception("didn't get the right message");
            }
            logger.log(System.Logger.Level.TRACE, "Message text: \"" + messageReceived.getText() + "\"");
            logger.log(System.Logger.Level.INFO, "Received correct message");
            durableTS.close();
            messageSent1 = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent1.setText("test that messages are durable");
            messageSent1.setStringProperty("COM_SUN_JMS_TESTNAME", "inactiveDurableSubscriberTopicRecTest");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent1);
            this.tool.getDefaultTopicConnection().close();
            newTConn = (TopicConnection)this.tool.getNewConnection(4, this.jmsUser, this.jmsPassword, lookup);
            this.connections.add(newTConn);
            tSession = newTConn.createTopicSession(false, 1);
            durableTS = tSession.createDurableSubscriber(this.tool.getDefaultTopic(), "inactiveDurableSubscriberTopicRecTest");
            newTConn.start();
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (TextMessage)durableTS.receive(this.timeout);
            if (!messageReceived.getText().equals(messageSent1.getText())) {
                throw new Exception("Received incorrect message.");
            }
            logger.log(System.Logger.Level.TRACE, "Message text: \"" + messageReceived.getText() + "\"");
            logger.log(System.Logger.Level.TRACE, "Received correct message");
            this.cleanupSubscription(durableTS, tSession, "inactiveDurableSubscriberTopicRecTest");
        }
        catch (Exception e) {
            try {
                TestUtil.printStackTrace((Throwable)e);
                throw new Exception("inactiveDurableSubscriberTopicRecTest");
            }
            catch (Throwable throwable) {
                this.cleanupSubscription(durableTS, tSession, "inactiveDurableSubscriberTopicRecTest");
                throw throwable;
            }
        }
    }

    @Test
    public void durableSubscriberTopicNoLocalTest() throws Exception {
        TopicSubscriber tSubNoLocal = null;
        String subscriptionName = "DurableSubscriberTopicNoLocalTestSubscription";
        String lookup = "DURABLE_SUB_CONNECTION_FACTORY";
        String lookup2 = "MyTopicConnectionFactory";
        try {
            int num = 10;
            TopicConnection newConn = null;
            TopicSession newSess = null;
            TopicPublisher newPub = null;
            TopicSubscriber newSub = null;
            Message messageSent = null;
            Message messageReceived = null;
            this.tool = new JmsTool(4, this.jmsUser, this.jmsPassword, lookup, this.mode);
            logger.log(System.Logger.Level.TRACE, "Create DurableSubscriber");
            tSubNoLocal = this.tool.getDefaultTopicSession().createDurableSubscriber(this.tool.getDefaultTopic(), subscriptionName, "", true);
            this.tool.getDefaultTopicConnection().start();
            logger.log(System.Logger.Level.TRACE, "Sending " + num + " messages to topic");
            messageSent = this.tool.getDefaultTopicSession().createMessage();
            messageSent.setBooleanProperty("lastMessage", false);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "noLocalDeliveryTopicTest");
            TopicPublisher defaultPub = this.tool.getDefaultTopicPublisher();
            for (int i = 0; i < num; ++i) {
                defaultPub.publish(messageSent);
            }
            logger.log(System.Logger.Level.INFO, "Attempting to receive messages");
            TopicSubscriber defaultSub = this.tool.getDefaultTopicSubscriber();
            for (int i = 0; i < num; ++i) {
                messageReceived = defaultSub.receive(this.timeout);
                if (messageReceived != null) continue;
                throw new Exception("Should have received message");
            }
            logger.log(System.Logger.Level.INFO, "Creating new connection");
            newConn = (TopicConnection)this.tool.getNewConnection(1, this.jmsUser, this.jmsPassword, lookup2);
            this.connections.add(newConn);
            newSess = newConn.createTopicSession(false, 1);
            newSub = newSess.createSubscriber(this.tool.getDefaultTopic());
            newPub = newSess.createPublisher(this.tool.getDefaultTopic());
            newConn.start();
            defaultPub.publish(messageSent);
            messageReceived = newSub.receive(this.timeout);
            if (messageReceived == null) {
                throw new Exception("new connection should have received message");
            }
            logger.log(System.Logger.Level.TRACE, "New connection sending message");
            messageSent.setBooleanProperty("lastMessage", true);
            newPub.publish(messageSent);
            logger.log(System.Logger.Level.TRACE, "Closing new connection");
            newConn.close();
            logger.log(System.Logger.Level.TRACE, "Try to receive only message from default connection");
            messageReceived = tSubNoLocal.receive(this.timeout);
            if (messageReceived == null) {
                throw new Exception("No_local subscriber did not receive any message");
            }
            if (!messageReceived.getBooleanProperty("lastMessage")) {
                throw new Exception("No_local subscriber received local message");
            }
            logger.log(System.Logger.Level.TRACE, "Received correct message");
            this.cleanupSubscription(tSubNoLocal, this.tool.getDefaultTopicSession(), subscriptionName);
        }
        catch (Exception e) {
            try {
                TestUtil.printStackTrace((Throwable)e);
                throw new Exception("durableSubscriberTopicNoLocalTest");
            }
            catch (Throwable throwable) {
                this.cleanupSubscription(tSubNoLocal, this.tool.getDefaultTopicSession(), subscriptionName);
                throw throwable;
            }
        }
    }

    @Test
    public void durableSubscriberTopicNoLocalTest2() throws Exception {
        TopicSubscriber tSubNoLocal = null;
        String subscriptionName = "DurableSubscriberTopicNoLocalTest2Subscription";
        String lookup = "DURABLE_SUB_CONNECTION_FACTORY";
        try {
            int i;
            int num = 10;
            Message messageSent = null;
            Message messageReceived = null;
            this.tool = new JmsTool(4, this.jmsUser, this.jmsPassword, lookup, this.mode);
            logger.log(System.Logger.Level.TRACE, "Create DurableSubscriber with no_local=true");
            tSubNoLocal = this.tool.getDefaultTopicSession().createDurableSubscriber(this.tool.getDefaultTopic(), subscriptionName, "", true);
            this.tool.getDefaultTopicConnection().start();
            logger.log(System.Logger.Level.TRACE, "Sending " + num + " messages to topic");
            messageSent = this.tool.getDefaultTopicSession().createMessage();
            messageSent.setBooleanProperty("lastMessage", false);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "durableSubscriberTopicNoLocalTest2");
            TopicPublisher defaultPub = this.tool.getDefaultTopicPublisher();
            for (int i2 = 0; i2 < num; ++i2) {
                defaultPub.publish(messageSent);
            }
            logger.log(System.Logger.Level.INFO, "Attempting to receive messages from normal subscriber");
            TopicSubscriber defaultSub = this.tool.getDefaultTopicSubscriber();
            for (i = 0; i < num; ++i) {
                messageReceived = defaultSub.receive(this.timeout);
                if (messageReceived == null) {
                    throw new Exception("Should have received message");
                }
                if (messageReceived.getBooleanProperty("lastMessage")) {
                    throw new Exception("Received incorrect message lastMessage=true");
                }
                logger.log(System.Logger.Level.TRACE, "Received correct message lastMessage=false");
            }
            logger.log(System.Logger.Level.INFO, "Attempting to receive messages from (no_local=true) subscriber");
            messageReceived = tSubNoLocal.receive(this.timeout);
            if (messageReceived != null) {
                throw new Exception("Received unexpected message (incorrect)");
            }
            logger.log(System.Logger.Level.TRACE, "Did not receive message (correct)");
            logger.log(System.Logger.Level.TRACE, "Sending " + num + " messages to topic");
            for (i = 0; i < num; ++i) {
                defaultPub.publish(messageSent);
            }
            logger.log(System.Logger.Level.TRACE, "Close DurableSubscriber with no_local=true");
            tSubNoLocal.close();
            logger.log(System.Logger.Level.TRACE, "Create DurableSubscriber with no_local=false");
            tSubNoLocal = this.tool.getDefaultTopicSession().createDurableSubscriber(this.tool.getDefaultTopic(), subscriptionName, "", false);
            messageReceived = tSubNoLocal.receive(this.timeout);
            if (messageReceived != null) {
                throw new Exception("No_local=false subscriber received message (unexpected)");
            }
            logger.log(System.Logger.Level.INFO, "No_local=false subscriber did not receive any message (expected)");
            logger.log(System.Logger.Level.TRACE, "Sending " + num + " messages to topic");
            messageSent = this.tool.getDefaultTopicSession().createMessage();
            messageSent.setBooleanProperty("lastMessage", false);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "durableSubscriberTopicNoLocalTest2");
            for (i = 0; i < num; ++i) {
                defaultPub.publish(messageSent);
            }
            logger.log(System.Logger.Level.INFO, "Attempting to receive messages from (no_local=false) subscriber");
            for (i = 0; i < num; ++i) {
                messageReceived = tSubNoLocal.receive(this.timeout);
                if (messageReceived == null) {
                    throw new Exception("Should have received message");
                }
                if (messageReceived.getBooleanProperty("lastMessage")) {
                    throw new Exception("Received incorrect message lastMessage=true");
                }
                logger.log(System.Logger.Level.TRACE, "Received correct message lastMessage=false");
            }
            messageReceived = tSubNoLocal.receive(this.timeout);
            if (messageReceived != null) {
                throw new Exception("Received unexpected final message");
            }
            this.cleanupSubscription(tSubNoLocal, this.tool.getDefaultTopicSession(), subscriptionName);
        }
        catch (Exception e) {
            try {
                TestUtil.printStackTrace((Throwable)e);
                throw new Exception("durableSubscriberTopicNoLocalTest2");
            }
            catch (Throwable throwable) {
                this.cleanupSubscription(tSubNoLocal, this.tool.getDefaultTopicSession(), subscriptionName);
                throw throwable;
            }
        }
    }

    @Test
    public void durableSubscriberNewTopicTest() throws Exception {
        TopicSubscriber durableTS = null;
        String lookup = "DURABLE_SUB_CONNECTION_FACTORY";
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            Topic newTestTopic = null;
            this.tool = new JmsTool(4, this.jmsUser, this.jmsPassword, lookup, this.mode);
            newTestTopic = this.tool.createNewTopic("MY_TOPIC2");
            TopicPublisher newTestPublisher = this.tool.getDefaultTopicSession().createPublisher(newTestTopic);
            this.tool.getDefaultTopicSubscriber().close();
            durableTS = this.tool.getDefaultTopicSession().createDurableSubscriber(this.tool.getDefaultTopic(), "durableSubscriberNewTopicTest");
            this.tool.getDefaultTopicConnection().start();
            messageSent = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent.setText("For default topic");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "durableSubscriberNewTopicTest");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (TextMessage)durableTS.receive(this.timeout);
            if (!messageReceived.getText().equals(messageSent.getText())) {
                throw new Exception("didn't get the right message");
            }
            logger.log(System.Logger.Level.TRACE, "Message text: \"" + messageReceived.getText() + "\"");
            logger.log(System.Logger.Level.TRACE, "Received correct message");
            durableTS.close();
            durableTS = this.tool.getDefaultTopicSession().createDurableSubscriber(newTestTopic, "durableSubscriberNewTopicTest");
            messageSent = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent.setText("For new topic");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "durableSubscriberNewTopicTest");
            newTestPublisher.publish((Message)messageSent);
            messageReceived = (TextMessage)durableTS.receive(this.timeout);
            if (!messageReceived.getText().equals(messageSent.getText())) {
                throw new Exception("didn't get the right message");
            }
            logger.log(System.Logger.Level.TRACE, "Message text: \"" + messageReceived.getText() + "\"");
            logger.log(System.Logger.Level.TRACE, "Received correct message");
            this.cleanupSubscription(durableTS, this.tool.getDefaultTopicSession(), "durableSubscriberNewTopicTest");
        }
        catch (Exception e) {
            try {
                TestUtil.printStackTrace((Throwable)e);
                throw new Exception("durableSubscriberNewTopicTest");
            }
            catch (Throwable throwable) {
                this.cleanupSubscription(durableTS, this.tool.getDefaultTopicSession(), "durableSubscriberNewTopicTest");
                throw throwable;
            }
        }
    }

    @Test
    public void durableSubscriberChangeSelectorTest() throws Exception {
        TopicSubscriber durableTS = null;
        String lookup = "DURABLE_SUB_CONNECTION_FACTORY";
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            this.tool = new JmsTool(4, this.jmsUser, this.jmsPassword, lookup, this.mode);
            this.tool.getDefaultTopicSubscriber().close();
            durableTS = this.tool.getDefaultTopicSession().createDurableSubscriber(this.tool.getDefaultTopic(), "durableSubscriberChangeSelectorTest", "TEST = 'test'", false);
            this.tool.getDefaultTopicConnection().start();
            messageSent = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent.setStringProperty("TEST", "test");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "durableSubscriberChangeSelectorTest");
            messageSent.setText("For default topic ");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (TextMessage)durableTS.receive(this.timeout);
            if (!messageReceived.getText().equals(messageSent.getText())) {
                throw new Exception("didn't get the right message");
            }
            logger.log(System.Logger.Level.TRACE, "Message text: \"" + messageReceived.getText() + "\"");
            logger.log(System.Logger.Level.TRACE, "Received correct message");
            durableTS.close();
            durableTS = this.tool.getDefaultTopicSession().createDurableSubscriber(this.tool.getDefaultTopic(), "durableSubscriberChangeSelectorTest", "TEST = 'new one'", false);
            messageSent.setBooleanProperty("lastMessage", false);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            messageSent = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent.setStringProperty("TEST", "new one");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "durableSubscriberChangeSelectorTest");
            messageSent.setText("For new topic");
            messageSent.setBooleanProperty("lastMessage", true);
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            messageReceived = (TextMessage)durableTS.receive(this.timeout);
            if (messageReceived != null) {
                if (!messageReceived.getText().equals(messageSent.getText()) || !messageReceived.getBooleanProperty("lastMessage")) {
                    throw new Exception("didn't get the right message");
                }
            } else {
                throw new Exception("didn't get any message");
            }
            logger.log(System.Logger.Level.TRACE, "Message text: \"" + messageReceived.getText() + "\"");
            logger.log(System.Logger.Level.TRACE, "Received correct message");
            this.cleanupSubscription(durableTS, this.tool.getDefaultTopicSession(), "durableSubscriberChangeSelectorTest");
        }
        catch (Exception e) {
            try {
                TestUtil.printStackTrace((Throwable)e);
                throw new Exception("durableSubscriberChangeSelectorTest");
            }
            catch (Throwable throwable) {
                this.cleanupSubscription(durableTS, this.tool.getDefaultTopicSession(), "durableSubscriberChangeSelectorTest");
                throw throwable;
            }
        }
    }

    @Test
    public void durableSubscriberChangeSelectorTest2() throws Exception {
        TopicSubscriber durableTS = null;
        String lookup = "DURABLE_SUB_CONNECTION_FACTORY";
        try {
            TextMessage messageSent = null;
            TextMessage messageSent2 = null;
            TextMessage messageReceived = null;
            this.tool = new JmsTool(4, this.jmsUser, this.jmsPassword, lookup, this.mode);
            this.tool.getDefaultTopicSubscriber().close();
            logger.log(System.Logger.Level.TRACE, "Create durable subscription with MessageSelector=\"TEST='test'\",");
            logger.log(System.Logger.Level.TRACE, "TopicName=" + this.tool.getDefaultTopic().getTopicName() + " and SubscriptionName=durableSubscriberChangeSelectorTest2");
            durableTS = this.tool.getDefaultTopicSession().createDurableSubscriber(this.tool.getDefaultTopic(), "durableSubscriberChangeSelectorTest2", "TEST = 'test'", false);
            this.tool.getDefaultTopicConnection().start();
            logger.log(System.Logger.Level.TRACE, "Create/Send first message with string property \"TEST = 'test'\"");
            messageSent = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent.setStringProperty("TEST", "test");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "durableSubscriberChangeSelectorTest2");
            messageSent.setText("Message #1 with string property TEST='test'");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Create/Send second message with string property \"TEST = 'test again'\"");
            messageSent2 = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent2.setStringProperty("TEST", "test again");
            messageSent2.setStringProperty("COM_SUN_JMS_TESTNAME", "durableSubscriberChangeSelectorTest2");
            messageSent2.setText("Message #2 with string property TEST='test again'");
            this.tool.getDefaultTopicPublisher().publish((Message)messageSent2);
            logger.log(System.Logger.Level.TRACE, "Try receiving first message (should get message)");
            messageReceived = (TextMessage)durableTS.receive(this.timeout);
            if (messageReceived == null) {
                logger.log(System.Logger.Level.TRACE, "Did not receive any message (incorrect)");
                throw new Exception("didn't receive any message");
            }
            if (!messageReceived.getText().equals(messageSent.getText())) {
                logger.log(System.Logger.Level.TRACE, "Message text: \"" + messageReceived.getText() + "\"");
                throw new Exception("didn't get the right message");
            }
            logger.log(System.Logger.Level.TRACE, "Message text: \"" + messageReceived.getText() + "\"");
            logger.log(System.Logger.Level.TRACE, "Received correct first message");
            logger.log(System.Logger.Level.TRACE, "Try receiving second message (should not get message)");
            messageReceived = (TextMessage)durableTS.receive(this.timeout);
            if (messageReceived != null) {
                if (messageReceived.getText().equals(messageSent2.getText())) {
                    logger.log(System.Logger.Level.TRACE, "Message text: \"" + messageReceived.getText() + "\"");
                    throw new Exception("received second message (unexpected)");
                }
                logger.log(System.Logger.Level.TRACE, "Message text: \"" + messageReceived.getText() + "\"");
                throw new Exception("received unexpected message");
            }
            logger.log(System.Logger.Level.TRACE, "Did not receive second message (correct)");
            logger.log(System.Logger.Level.TRACE, "Close durable subscription");
            durableTS.close();
            logger.log(System.Logger.Level.TRACE, "Create new durable subscription with MessageSelector=\"TEST='test again'\",");
            logger.log(System.Logger.Level.TRACE, "TopicName=" + this.tool.getDefaultTopic().getTopicName() + " and SubscriptionName=durableSubscriberChangeSelectorTest2");
            durableTS = this.tool.getDefaultTopicSession().createDurableSubscriber(this.tool.getDefaultTopic(), "durableSubscriberChangeSelectorTest2", "TEST = 'test again'", false);
            messageReceived = (TextMessage)durableTS.receive(this.timeout);
            if (messageReceived != null) {
                logger.log(System.Logger.Level.TRACE, "Message text: \"" + messageReceived.getText() + "\"");
                throw new Exception("received unexpected message");
            }
            logger.log(System.Logger.Level.TRACE, "Did not receive any messages (correct)");
            this.cleanupSubscription(durableTS, this.tool.getDefaultTopicSession(), "durableSubscriberChangeSelectorTest2");
        }
        catch (Exception e) {
            try {
                TestUtil.printStackTrace((Throwable)e);
                throw new Exception("durableSubscriberChangeSelectorTest2");
            }
            catch (Throwable throwable) {
                this.cleanupSubscription(durableTS, this.tool.getDefaultTopicSession(), "durableSubscriberChangeSelectorTest2");
                throw throwable;
            }
        }
    }

    @Test
    public void msgProducerNullDestinationTopicTest() throws Exception {
        boolean pass = true;
        TopicPublisher tPublisher = null;
        Topic nullTopic = null;
        TextMessage messageSent = null;
        TextMessage messageReceived = null;
        String testName = "msgProducerNullDestinationTopicTest";
        String message = "Just a test from msgProducerNullDestinationTopicTest";
        try {
            this.tool = new JmsTool(1, this.jmsUser, this.jmsPassword, this.mode);
            this.tool.getDefaultTopicPublisher().close();
            try {
                tPublisher = this.tool.getDefaultTopicSession().createPublisher(nullTopic);
                logger.log(System.Logger.Level.TRACE, "PASS: null allowed for unidentified producer");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.ERROR, "Error: unexpected Exception: ", (Throwable)ee);
                pass = false;
            }
            this.tool.getDefaultTopicConnection().start();
            logger.log(System.Logger.Level.TRACE, "Creating  1 message");
            messageSent = this.tool.getDefaultTopicSession().createTextMessage();
            messageSent.setText(message);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            logger.log(System.Logger.Level.TRACE, "Publish a message");
            tPublisher.publish(this.tool.getDefaultTopic(), (Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receive a message");
            messageReceived = (TextMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            if (messageReceived == null) {
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Publish message the second time ");
            tPublisher.publish(this.tool.getDefaultTopic(), (Message)messageSent, 2, 4, 0L);
            logger.log(System.Logger.Level.INFO, "Receiving message again");
            messageReceived = (TextMessage)this.tool.getDefaultTopicSubscriber().receive(this.timeout);
            if (messageReceived == null) {
                logger.log(System.Logger.Level.ERROR, "didn't get any message");
                pass = false;
            } else if (!messageReceived.getText().equals(messageSent.getText())) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "didn't get the right message");
            }
            if (!pass) {
                throw new Exception("Error: failures occurred during msgProducerNullDestinationTopicTest tests");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Exception occurred! ", (Throwable)e);
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("msgProducerNullDestinationTopicTest");
        }
    }

    @Test
    public void multipleCloseTopicConnectionTest() throws Exception {
        try {
            this.tool = new JmsTool(1, this.jmsUser, this.jmsPassword, this.mode);
            this.tool.getDefaultTopicConnection().start();
            logger.log(System.Logger.Level.TRACE, "Call close on a connection ");
            this.tool.getDefaultTopicConnection().close();
            logger.log(System.Logger.Level.TRACE, "Call close on a connection a second time");
            this.tool.getDefaultTopicConnection().close();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("multipleCloseTopicConnectionTest");
        }
    }

    @Test
    public void consumerTests() throws Exception {
        String lookup = "MyTopicConnectionFactory";
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            Object tempMsg = null;
            int numMessages = 2;
            boolean pass = true;
            MessageConsumer defaultConsumer = null;
            MessageConsumer selectConsumer = null;
            MessageConsumer noLocalConsumer = null;
            Connection newConn = null;
            Session newSess = null;
            MessageProducer newPub = null;
            String testName = "consumerTests";
            this.tool = new JmsTool(14, this.jmsUser, this.jmsPassword, this.mode);
            newConn = this.tool.getNewConnection(14, this.jmsUser, this.jmsPassword, lookup);
            this.connections.add(newConn);
            newSess = newConn.createSession(false, 1);
            noLocalConsumer = newSess.createConsumer(this.tool.getDefaultDestination(), null, true);
            selectConsumer = newSess.createConsumer(this.tool.getDefaultDestination(), "TEST = 'test'", false);
            defaultConsumer = newSess.createConsumer(this.tool.getDefaultDestination());
            newPub = newSess.createProducer(this.tool.getDefaultDestination());
            this.tool.getDefaultConnection().start();
            newConn.start();
            messageSent = this.tool.getDefaultSession().createTextMessage();
            messageSent.setText("Just a test");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            logger.log(System.Logger.Level.TRACE, "Sending message to a Topic");
            messageSent.setBooleanProperty("lastMessage", false);
            newPub.send((Message)messageSent);
            messageSent.setStringProperty("TEST", "test");
            messageSent.setBooleanProperty("lastMessage", true);
            newPub.send((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "noLocalConsumer Receiving message");
            messageReceived = (TextMessage)noLocalConsumer.receive(this.timeout);
            if (messageReceived != null) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error:  No_local MessageConsumer did receive local message");
            }
            logger.log(System.Logger.Level.TRACE, "defaultConsumer Receiving message");
            for (int i = 0; i < numMessages; ++i) {
                messageReceived = (TextMessage)defaultConsumer.receive(this.timeout);
                if (messageReceived == null) {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "Error:  Did not receive message " + i);
                    continue;
                }
                if (messageReceived.getText().equals(messageSent.getText())) continue;
                logger.log(System.Logger.Level.ERROR, "Error: didn't get the right message " + i);
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "selectConsumer Receiving message");
            messageReceived = (TextMessage)selectConsumer.receive(this.timeout);
            if (messageReceived == null) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error:  Did not receive correct message");
            } else if (!messageReceived.getText().equals(messageSent.getText())) {
                logger.log(System.Logger.Level.ERROR, "Error: didn't get the right message");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "sending message from default connection");
            messageSent.setBooleanProperty("newConnection", true);
            this.tool.getDefaultProducer().send((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "noLocalConsumer Receiving message");
            messageReceived = (TextMessage)noLocalConsumer.receive(this.timeout);
            if (messageReceived == null) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error:  Did not receive correct message");
            } else if (messageReceived.getText().equals(messageSent.getText())) {
                logger.log(System.Logger.Level.INFO, "Message text: \"" + messageReceived.getText() + "\"");
                logger.log(System.Logger.Level.INFO, "Received correct message");
            } else {
                logger.log(System.Logger.Level.ERROR, "Error: didn't get the right message");
                pass = false;
            }
            noLocalConsumer.close();
            defaultConsumer.close();
            selectConsumer.close();
            try {
                logger.log(System.Logger.Level.TRACE, "Closing new connection");
                newConn.close();
            }
            catch (Exception ex) {
                logger.log(System.Logger.Level.ERROR, "Error closing the second Connection", (Throwable)ex);
            }
            if (!pass) {
                throw new Exception(testName + " Failed!");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception(testName);
        }
    }

    @Test
    public void tempTopicTests() throws Exception {
        boolean pass = true;
        String testName = "tempTopicTests";
        String message = "Just a test from tempTopicTests";
        TemporaryTopic tempT = null;
        Connection newConn = null;
        String lookup = "MyTopicConnectionFactory";
        try {
            this.tool = new JmsTool(14, this.jmsUser, this.jmsPassword, this.mode);
            this.tool.getDefaultProducer().close();
            this.tool.getDefaultConsumer().close();
            this.tool.getDefaultConnection().start();
            logger.log(System.Logger.Level.INFO, "Creating TemporaryTopic");
            tempT = this.tool.getDefaultSession().createTemporaryTopic();
            logger.log(System.Logger.Level.INFO, "Create new sender for TemporaryTopic");
            MessageProducer sender = this.tool.getDefaultSession().createProducer((Destination)tempT);
            MessageConsumer receiver = this.tool.getDefaultSession().createConsumer((Destination)tempT);
            logger.log(System.Logger.Level.INFO, "Send message to TemporaryTopic");
            TextMessage msgSent = this.tool.getDefaultSession().createTextMessage();
            msgSent.setText(message);
            msgSent.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            sender.send((Message)msgSent);
            TextMessage msgReceived = (TextMessage)receiver.receive(this.timeout);
            if (msgReceived == null) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "didnot receive message");
            } else if (!msgReceived.getText().equals(message)) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Received wrong message=" + msgReceived.getText());
                logger.log(System.Logger.Level.ERROR, "Should have: " + message);
            }
            try {
                tempT.delete();
                pass = false;
                logger.log(System.Logger.Level.ERROR, "TemporaryTopic.delete() didn't throw expected Exception");
            }
            catch (JMSException em) {
                logger.log(System.Logger.Level.TRACE, "Received expected JMSException: ");
            }
            receiver.close();
            try {
                tempT.delete();
            }
            catch (Exception e) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Received unexpected Exception: ", (Throwable)e);
            }
            tempT = this.tool.getDefaultSession().createTemporaryTopic();
            newConn = this.tool.getNewConnection(14, this.jmsUser, this.jmsPassword, lookup);
            Session newSess = newConn.createSession(false, 1);
            logger.log(System.Logger.Level.INFO, "Attempt to create MessageConsumer for TemporaryTopic from another Connection");
            try {
                MessageConsumer newReceiver = newSess.createConsumer((Destination)tempT);
                if (newReceiver != null) {
                    logger.log(System.Logger.Level.TRACE, "newReceiver=" + newReceiver);
                }
            }
            catch (JMSException e) {
                logger.log(System.Logger.Level.TRACE, "Received expected JMSException from createConsumer.");
            }
            if (!pass) {
                throw new Exception(testName + " failed");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception(testName);
        }
        finally {
            try {
                this.tool.getDefaultConnection().close();
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error closing Connection in " + testName, (Throwable)e);
            }
            try {
                newConn.close();
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error closing the new Connection in " + testName, (Throwable)e);
            }
        }
    }
}

