/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core20.appclient.listenerexceptiontests;

import jakarta.jms.Connection;
import jakarta.jms.IllegalStateException;
import jakarta.jms.IllegalStateRuntimeException;
import jakarta.jms.JMSConsumer;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageListener;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.ArrayList;

public class MyMessageListener
implements MessageListener {
    private String name = null;
    private Message message = null;
    private Connection connection = null;
    private Session session = null;
    private JMSConsumer jmsconsumer = null;
    private MessageConsumer msgconsumer = null;
    private ArrayList<Message> messages = new ArrayList();
    private Exception exception = null;
    private int numMessages = 1;
    boolean complete = false;
    boolean gotCorrectException = false;
    boolean gotException = false;
    private static final System.Logger logger = System.getLogger(MyMessageListener.class.getName());

    public MyMessageListener() {
        this("MyMessageListener");
    }

    public MyMessageListener(String name) {
        this.name = name;
    }

    public MyMessageListener(int numMessages) {
        this.numMessages = numMessages;
        this.messages.clear();
    }

    public MyMessageListener(Connection connection) {
        this.connection = connection;
    }

    public MyMessageListener(Session session) {
        this.session = session;
    }

    public MyMessageListener(JMSConsumer consumer) {
        this.jmsconsumer = consumer;
    }

    public MyMessageListener(MessageConsumer consumer) {
        this.msgconsumer = consumer;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Message getMessage() {
        return this.message;
    }

    public Message getMessage(int index) {
        return this.messages.get(index);
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    public Exception getException() {
        return this.exception;
    }

    public void setException(Exception exception) {
        this.exception = exception;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public boolean gotCorrectException() {
        return this.gotCorrectException;
    }

    public boolean gotException() {
        return this.gotException;
    }

    public boolean gotAllMsgs() {
        return this.messages.size() == this.numMessages;
    }

    public boolean haveMsg(int i) {
        return this.messages.size() > i;
    }

    public void setComplete(boolean complete) {
        this.complete = complete;
    }

    public void onMessage(Message message) {
        try {
            logger.log(System.Logger.Level.INFO, "onMessage(): Got Message: " + ((TextMessage)message).getText());
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
        }
        this.message = message;
        this.messages.add(message);
        if (message instanceof TextMessage) {
            TextMessage tMsg = (TextMessage)message;
            try {
                if (tMsg.getText().equals("Call connection close method")) {
                    logger.log(System.Logger.Level.INFO, "Calling Connection.close() MUST throw IllegalStateException");
                    if (this.connection != null) {
                        this.connection.close();
                    }
                } else if (tMsg.getText().equals("Call connection stop method")) {
                    logger.log(System.Logger.Level.INFO, "Calling Connection.stop() MUST throw IllegalStateException");
                    if (this.connection != null) {
                        this.connection.stop();
                    }
                } else if (tMsg.getText().equals("Call session close method")) {
                    logger.log(System.Logger.Level.INFO, "Calling Session.close() MUST throw IllegalStateException");
                    if (this.session != null) {
                        this.session.close();
                    }
                } else if (tMsg.getText().equals("Call MessageConsumer close method")) {
                    logger.log(System.Logger.Level.INFO, "Calling MessageConsumer.close() MUST be allowed");
                    if (this.msgconsumer != null) {
                        this.msgconsumer.close();
                    }
                }
            }
            catch (IllegalStateException e) {
                logger.log(System.Logger.Level.INFO, "onMessage(): Caught expected IllegalStateException");
                this.gotCorrectException = true;
                this.gotException = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "onMessage(): Caught unexpected exception: " + e);
                this.gotCorrectException = false;
                this.gotException = true;
                this.exception = e;
            }
            try {
                if (tMsg.getText().equals("Call JMSConsumer close method")) {
                    logger.log(System.Logger.Level.INFO, "Calling JMSConsumer.close() MUST be allowed");
                    if (this.jmsconsumer != null) {
                        this.jmsconsumer.close();
                    }
                }
            }
            catch (IllegalStateRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "onMessage(): Caught expected IllegalStateRuntimeException");
                this.gotCorrectException = true;
                this.gotException = true;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "onMessage(): Caught unexpected exception: " + e);
                this.gotCorrectException = false;
                this.gotException = true;
                this.exception = e;
            }
        }
        this.complete = true;
        logger.log(System.Logger.Level.INFO, "onMessage(): Leaving");
    }
}

