/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core20.jmscontextqueuetests;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.ConnectionMetaData;
import jakarta.jms.Destination;
import jakarta.jms.IllegalStateRuntimeException;
import jakarta.jms.InvalidDestinationRuntimeException;
import jakarta.jms.InvalidSelectorRuntimeException;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSException;
import jakarta.jms.JMSProducer;
import jakarta.jms.Message;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TextMessage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ClientIT {
    private static final String testName = "com.sun.ts.tests.jms.core20.jmscontextqueuetests.ClientIT";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private static final System.Logger logger = System.getLogger(ClientIT.class.getName());
    private transient JmsTool tool = null;
    private transient ConnectionFactory cf = null;
    private transient Queue queue = null;
    private transient Destination destination = null;
    private transient JMSContext context = null;
    private transient JMSContext contextToSendMsg = null;
    private transient JMSProducer producer = null;
    private transient JMSConsumer consumer = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    String vehicle = null;
    private static final int numMessages = 3;
    private static final int iterations = 5;
    ArrayList queues = null;
    ArrayList connections = null;

    private boolean verifyMetaData(ConnectionMetaData data) {
        String tmp;
        boolean pass = true;
        try {
            String tmp2 = data.getJMSVersion();
            logger.log(System.Logger.Level.INFO, "JMSVersion=" + tmp2);
            if (!tmp2.equals("3.1")) {
                logger.log(System.Logger.Level.ERROR, "Error: incorrect JMSVersion=" + tmp2);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Error: incorrect type returned for JMSVersion: ", (Throwable)e);
            pass = false;
        }
        try {
            int tmp3 = data.getJMSMajorVersion();
            logger.log(System.Logger.Level.INFO, "JMSMajorVersion=" + tmp3);
            if (tmp3 != 3) {
                logger.log(System.Logger.Level.ERROR, "Error: incorrect JMSMajorVersion=" + tmp3);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Error: incorrect type returned for JMSMajorVersion: ", (Throwable)e);
            pass = false;
        }
        try {
            int tmp4 = data.getJMSMinorVersion();
            logger.log(System.Logger.Level.INFO, "JMSMinorVersion=" + tmp4);
            if (tmp4 != 1) {
                logger.log(System.Logger.Level.ERROR, "Error: incorrect JMSMinorVersion=" + tmp4);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Error: incorrect type returned for JMSMinorVersion: ", (Throwable)e);
            pass = false;
        }
        try {
            tmp = data.getJMSProviderName();
            logger.log(System.Logger.Level.INFO, "JMSProviderName=" + tmp);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Error: incorrect type returned for JMSProviderName: ", (Throwable)e);
            pass = false;
        }
        try {
            tmp = data.getProviderVersion();
            logger.log(System.Logger.Level.INFO, "JMSProviderVersion=" + tmp);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Error: incorrect type returned for ProviderVersion: ", (Throwable)e);
            pass = false;
        }
        try {
            int tmp5 = data.getProviderMajorVersion();
            logger.log(System.Logger.Level.INFO, "ProviderMajorVersion=" + tmp5);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Error: incorrect type returned for ProviderMajorVersion: ", (Throwable)e);
            pass = false;
        }
        try {
            int tmp6 = data.getProviderMinorVersion();
            logger.log(System.Logger.Level.INFO, "ProviderMinorVersion=" + tmp6);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Error: incorrect type returned for ProviderMinorVersion: ", (Throwable)e);
            pass = false;
        }
        return pass;
    }

    private boolean chkMessageID(String id) {
        String[] status = new String[]{"Pass", "Fail"};
        boolean retcode = true;
        int index = 0;
        if (id != null && !id.startsWith("ID:")) {
            index = 1;
            retcode = false;
        }
        logger.log(System.Logger.Level.INFO, "Results: " + status[index]);
        return retcode;
    }

    @BeforeEach
    public void setup() throws Exception {
        try {
            this.timeout = Long.parseLong(System.getProperty("jms_timeout"));
            this.user = System.getProperty("user");
            this.password = System.getProperty("password");
            this.mode = System.getProperty("platform.mode");
            this.vehicle = System.getProperty("vehicle");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' is null ");
            }
            if (this.password == null) {
                throw new Exception("'password' is null ");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' is null");
            }
            this.queues = new ArrayList(3);
            this.connections = new ArrayList(5);
            logger.log(System.Logger.Level.INFO, "Setup JmsTool for COMMON_Q setup");
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.cf = this.tool.getConnectionFactory();
            this.destination = this.tool.getDefaultDestination();
            this.queue = (Queue)this.destination;
            this.tool.getDefaultConnection().close();
            logger.log(System.Logger.Level.INFO, "Create JMSContext with AUTO_ACKNOWLEDGE");
            this.context = this.cf.createContext(this.user, this.password, 1);
            this.contextToSendMsg = this.cf.createContext(this.user, this.password, 1);
            this.producer = this.contextToSendMsg.createProducer();
            this.consumer = this.context.createConsumer(this.destination);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            throw new Exception("setup failed!", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        boolean pass = true;
        try {
            logger.log(System.Logger.Level.INFO, "Close JMSContext Objects");
            if (this.context != null) {
                this.context.close();
            }
            this.context = null;
            if (this.contextToSendMsg != null) {
                this.contextToSendMsg.close();
            }
            this.contextToSendMsg = null;
            this.producer = null;
            logger.log(System.Logger.Level.INFO, "Flush any messages left on Queue");
            this.tool.flushDestination();
            logger.log(System.Logger.Level.INFO, "Close JMSConsumer objects");
            if (this.consumer != null) {
                this.consumer.close();
            }
            this.consumer = null;
            this.tool.closeAllResources();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            throw new Exception("cleanup failed!", e);
        }
        if (!pass) {
            throw new Exception("cleanup failed!");
        }
    }

    @Test
    public void createTemporayQueueTest() throws Exception {
        boolean pass = true;
        try {
            String sendMessage = "a text message";
            logger.log(System.Logger.Level.INFO, "Creating TemporaryQueue");
            TemporaryQueue tempQueue = this.context.createTemporaryQueue();
            logger.log(System.Logger.Level.INFO, "Create JMSConsumer");
            JMSConsumer smc = this.context.createConsumer((Destination)tempQueue);
            logger.log(System.Logger.Level.INFO, "Send message to temporaty queue using JMSProducer");
            this.producer.send((Destination)tempQueue, sendMessage);
            logger.log(System.Logger.Level.INFO, "Receive message from temporaty queue");
            String recvMessage = (String)smc.receiveBody(String.class, this.timeout);
            logger.log(System.Logger.Level.INFO, "Checking received message");
            if (recvMessage == null) {
                throw new Exception("Did not receive Message");
            }
            if (!recvMessage.equals(sendMessage)) {
                logger.log(System.Logger.Level.ERROR, "Unexpected message: received " + recvMessage + " , expected " + sendMessage);
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "received correct message: " + recvMessage + " as expected");
            }
            logger.log(System.Logger.Level.INFO, "Attempting to delete temporary queue with an open consumer should not be allowed");
            try {
                tempQueue.delete();
                pass = false;
                logger.log(System.Logger.Level.ERROR, "TemporaryQueue.delete() didn't throw expected Exception");
            }
            catch (JMSException em) {
                logger.log(System.Logger.Level.INFO, "Received expected JMSException: ");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Close JMSConsumer");
            smc.close();
            logger.log(System.Logger.Level.INFO, "Attempting to delete temporary queue with no open consumer should be allowed");
            try {
                tempQueue.delete();
            }
            catch (Exception e) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Received unexpected Exception: ", (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            throw new Exception("createTemporayQueueTest");
        }
        if (!pass) {
            throw new Exception("createTemporayQueueTest failed");
        }
    }

    @Test
    public void createQueueBrowserTest() throws Exception {
        boolean pass = true;
        try {
            TextMessage tempMsg = null;
            QueueBrowser qBrowser = null;
            Enumeration msgs = null;
            this.consumer.close();
            this.consumer = null;
            logger.log(System.Logger.Level.INFO, "Send 3 messages to Queue");
            for (int i = 1; i <= 3; ++i) {
                tempMsg = this.context.createTextMessage("Message " + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "createQueueBrowserTest" + i);
                String tmp = null;
                if (i == 3) {
                    tempMsg.setBooleanProperty("lastMessage", true);
                    tmp = "with boolean property lastMessage=true";
                } else {
                    tempMsg.setBooleanProperty("lastMessage", false);
                    tmp = "with boolean property lastMessage=false";
                }
                this.producer.send(this.destination, (Message)tempMsg);
                logger.log(System.Logger.Level.INFO, "Message " + i + " sent " + tmp);
            }
            logger.log(System.Logger.Level.INFO, "Create QueueBrowser to peek at last message in Queue using message selector (lastMessage = TRUE)");
            qBrowser = this.context.createBrowser(this.queue, "lastMessage = TRUE");
            logger.log(System.Logger.Level.INFO, "Check that browser has just the last message");
            int msgCount = 0;
            msgs = qBrowser.getEnumeration();
            while (msgs.hasMoreElements()) {
                tempMsg = (TextMessage)msgs.nextElement();
                logger.log(System.Logger.Level.INFO, "Text=" + tempMsg.getText() + ", lastMessage=" + tempMsg.getBooleanProperty("lastMessage"));
                if (!tempMsg.getText().equals("Message 3")) {
                    logger.log(System.Logger.Level.ERROR, "Found [" + tempMsg.getText() + "] in browser expected only [Message 3]");
                    pass = false;
                } else {
                    logger.log(System.Logger.Level.INFO, "Found [Message 3] in browser");
                }
                ++msgCount;
            }
            if (msgCount != 1) {
                logger.log(System.Logger.Level.ERROR, "Found " + msgCount + " messages in browser expected 1");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Found 1 message in browser (correct)");
            }
            qBrowser.close();
            logger.log(System.Logger.Level.INFO, "Create QueueBrowser to browse all messages in the Queue");
            qBrowser = this.context.createBrowser(this.queue);
            logger.log(System.Logger.Level.INFO, "Check that browser contains all 3 messages");
            msgCount = 0;
            int msgIndex = 1;
            msgs = qBrowser.getEnumeration();
            while (msgs.hasMoreElements()) {
                tempMsg = (TextMessage)msgs.nextElement();
                if (!tempMsg.getText().equals("Message " + msgIndex)) {
                    logger.log(System.Logger.Level.ERROR, "Found [" + tempMsg.getText() + "] in browser expected [Message " + msgIndex + "]");
                    pass = false;
                } else {
                    logger.log(System.Logger.Level.INFO, "Found [Message " + msgIndex + "] in browser (correct)");
                }
                ++msgCount;
                ++msgIndex;
            }
            if (msgCount != 3) {
                logger.log(System.Logger.Level.ERROR, "Found " + msgCount + " messages in browser expected 3");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Found 3 messages in browser (correct)");
            }
            qBrowser.close();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            throw new Exception("createQueueBrowserTest");
        }
        if (!pass) {
            throw new Exception("createQueueBrowserTest failed");
        }
    }

    @Test
    public void createConsumerTest() throws Exception {
        boolean pass = true;
        JMSConsumer consumerSelect = null;
        try {
            TextMessage tempMsg = null;
            Object msgs = null;
            this.consumer.close();
            this.consumer = null;
            logger.log(System.Logger.Level.INFO, "Create selective JMSConsumer with selector [\"lastMessage=TRUE\"]");
            consumerSelect = this.context.createConsumer(this.destination, "lastMessage=TRUE");
            logger.log(System.Logger.Level.INFO, "Send 3 messages to Queue");
            for (int i = 1; i <= 3; ++i) {
                tempMsg = this.context.createTextMessage("Message " + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "createConsumerTest" + i);
                String tmp = null;
                if (i == 3) {
                    tempMsg.setBooleanProperty("lastMessage", true);
                    tmp = "with boolean property lastMessage=true";
                } else {
                    tempMsg.setBooleanProperty("lastMessage", false);
                    tmp = "with boolean property lastMessage=false";
                }
                this.producer.send(this.destination, (Message)tempMsg);
                logger.log(System.Logger.Level.INFO, "Message " + i + " sent " + tmp);
            }
            logger.log(System.Logger.Level.INFO, "Receive last message with selective JMSConsumer and boolean property (lastMessage=TRUE)");
            tempMsg = (TextMessage)consumerSelect.receive(this.timeout);
            if (tempMsg == null) {
                logger.log(System.Logger.Level.ERROR, "JMSConsumer.receive() returned NULL");
                logger.log(System.Logger.Level.ERROR, "Message 3 missing from Queue");
                pass = false;
            } else if (!tempMsg.getText().equals("Message 3")) {
                logger.log(System.Logger.Level.ERROR, "Received [" + tempMsg.getText() + "] expected [Message 3]");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Received expected message: " + tempMsg.getText());
            }
            logger.log(System.Logger.Level.INFO, "Try receiving one more message (should get none)");
            tempMsg = (TextMessage)consumerSelect.receive(this.timeout);
            if (tempMsg != null) {
                logger.log(System.Logger.Level.ERROR, "JMSConsumer.receive() returned a message [" + tempMsg.getText() + "]");
                logger.log(System.Logger.Level.ERROR, "JMSConsumer with selector should have returned just 1 message");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Received no message (CORRECT)");
            }
            logger.log(System.Logger.Level.INFO, "Close selective JMSConsumer");
            consumerSelect.close();
            consumerSelect = null;
            logger.log(System.Logger.Level.INFO, "Create normal JMSConsumer");
            this.consumer = this.context.createConsumer(this.destination);
            logger.log(System.Logger.Level.INFO, "Receive rest of messages with normal JMSConsumer");
            for (int msgCount = 1; msgCount < 3; ++msgCount) {
                tempMsg = (TextMessage)this.consumer.receive(this.timeout);
                if (tempMsg == null) {
                    logger.log(System.Logger.Level.ERROR, "JMSConsumer.receive() returned NULL");
                    logger.log(System.Logger.Level.ERROR, "Message " + msgCount + " missing from Queue");
                    pass = false;
                    continue;
                }
                if (!tempMsg.getText().equals("Message " + msgCount)) {
                    logger.log(System.Logger.Level.ERROR, "Received [" + tempMsg.getText() + "] expected [Message " + msgCount + "]");
                    pass = false;
                    continue;
                }
                logger.log(System.Logger.Level.INFO, "Received message: " + tempMsg.getText());
            }
            logger.log(System.Logger.Level.INFO, "Try receiving one more message (should get none)");
            tempMsg = (TextMessage)this.consumer.receive(this.timeout);
            if (tempMsg != null) {
                logger.log(System.Logger.Level.ERROR, "JMSConsumer returned message " + tempMsg.getText() + " (expected None)");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Received no message (CORRECT)");
            }
            logger.log(System.Logger.Level.INFO, "Close normal JMSConsumer");
            this.consumer.close();
            this.consumer = null;
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("createConsumerTest");
        }
        finally {
            try {
                if (consumerSelect != null) {
                    consumerSelect.close();
                }
                if (this.consumer != null) {
                    this.consumer.close();
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            }
        }
        if (!pass) {
            throw new Exception("createConsumerTest failed");
        }
    }

    @Test
    public void getMetaDataTest() throws Exception {
        boolean pass = true;
        ConnectionMetaData data = null;
        try {
            data = this.context.getMetaData();
            if (!this.verifyMetaData(data)) {
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.INFO, "Caught unexpected exception: " + e);
            pass = false;
        }
        if (!pass) {
            throw new Exception("getMetaDataTest failed");
        }
    }

    @Test
    public void getSessionModeTest() throws Exception {
        boolean pass = true;
        JMSContext context = null;
        try {
            context = this.cf.createContext(this.user, this.password);
            int expSessionMode = 1;
            logger.log(System.Logger.Level.INFO, "Calling getSessionMode and expect " + expSessionMode + " to be returned");
            int actSessionMode = context.getSessionMode();
            if (actSessionMode != expSessionMode) {
                logger.log(System.Logger.Level.ERROR, "getSessionMode() returned " + actSessionMode + ", expected " + expSessionMode);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            throw new Exception("getSessionModeTest");
        }
        finally {
            try {
                if (context != null) {
                    context.close();
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            }
        }
        int[] expSessionMode = new int[]{0, 1, 2, 3};
        for (int i = 0; i < expSessionMode.length; ++i) {
            if (!(!this.vehicle.equals("ejb") && !this.vehicle.equals("jsp") && !this.vehicle.equals("servlet") || expSessionMode[i] != 0 && expSessionMode[i] != 2)) continue;
            try {
                logger.log(System.Logger.Level.INFO, "Creating context with session mode (" + expSessionMode[i] + ")");
                context = this.cf.createContext(this.user, this.password, expSessionMode[i]);
                logger.log(System.Logger.Level.INFO, "Calling getSessionMode and expect " + expSessionMode[i] + " to be returned");
                int actSessionMode = context.getSessionMode();
                if (actSessionMode == expSessionMode[i]) continue;
                logger.log(System.Logger.Level.ERROR, "getSessionMode() returned " + actSessionMode + ", expected " + expSessionMode[i]);
                pass = false;
                continue;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
                throw new Exception("getSessionModeTest");
            }
            finally {
                try {
                    if (context != null) {
                        context.close();
                    }
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                }
            }
        }
        if (!pass) {
            throw new Exception("getSessionModeTest failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void getTransactedTest() throws Exception {
        boolean pass = true;
        JMSContext context = null;
        try {
            context = this.cf.createContext(this.user, this.password, 1);
            logger.log(System.Logger.Level.INFO, "Calling getTransacted and expect false to be returned");
            boolean transacted = context.getTransacted();
            if (transacted) {
                logger.log(System.Logger.Level.ERROR, "getTransacted() returned true expected false");
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            pass = false;
        }
        finally {
            try {
                if (context != null) {
                    context.close();
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            }
        }
        if (this.vehicle.equals("appclient") || this.vehicle.equals("standalone")) {
            try {
                context = this.cf.createContext(this.user, this.password, 0);
                logger.log(System.Logger.Level.INFO, "Calling getTransacted and expect true to be returned");
                boolean transacted = context.getTransacted();
                if (!transacted) {
                    logger.log(System.Logger.Level.ERROR, "getTransacted() returned false expected true");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
                throw new Exception("getTransactedTest");
            }
            finally {
                try {
                    if (context != null) {
                        context.close();
                    }
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                }
            }
        }
        if (!pass) {
            throw new Exception("getTransactedTest failed");
        }
    }

    @Test
    public void getClientIDTest() throws Exception {
        boolean pass = true;
        try {
            String cid = this.context.getClientID();
            logger.log(System.Logger.Level.ERROR, "getClientID() returned " + cid + ", expected clientid");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            throw new Exception("getClientIDTest");
        }
        if (!pass) {
            throw new Exception("getClientIDTest failed");
        }
    }

    @Test
    public void setGetAutoStartTest() throws Exception {
        boolean actAutoStart;
        boolean expAutoStart;
        boolean pass = true;
        try {
            expAutoStart = true;
            logger.log(System.Logger.Level.INFO, "Calling getAutoStart and expect " + expAutoStart + " to be returned");
            actAutoStart = this.context.getAutoStart();
            if (actAutoStart != expAutoStart) {
                logger.log(System.Logger.Level.ERROR, "getAutoStart() returned " + actAutoStart + ", expected " + expAutoStart);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            pass = false;
        }
        try {
            expAutoStart = false;
            logger.log(System.Logger.Level.INFO, "Calling setAutoStart(" + expAutoStart + ")");
            this.context.setAutoStart(expAutoStart);
            logger.log(System.Logger.Level.INFO, "Calling getAutoStart and expect " + expAutoStart + " to be returned");
            actAutoStart = this.context.getAutoStart();
            if (actAutoStart != expAutoStart) {
                logger.log(System.Logger.Level.ERROR, "getAutoStart() returned " + actAutoStart + ", expected " + expAutoStart);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            throw new Exception("setGetAutoStartTest");
        }
        if (!pass) {
            throw new Exception("setGetAutoStartTest failed");
        }
    }

    @Test
    public void multipleCloseContextTest() throws Exception {
        try {
            logger.log(System.Logger.Level.INFO, "Call close on JMSContext created in setup.");
            this.context.close();
            logger.log(System.Logger.Level.INFO, "Call close on a JMSContext a second time");
            this.context.close();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.INFO, "Caught unexpected exception: " + e);
            throw new Exception("multipleCloseContextTest");
        }
    }

    @Test
    public void invalidDestinationRuntimeExceptionTests() throws Exception {
        boolean pass = true;
        Destination invalidDestination = null;
        Queue invalidQueue = null;
        String message = "Where are you!";
        byte[] bytesMsgSend = message.getBytes();
        HashMap<String, Object> mapMsgSend = new HashMap<String, Object>();
        mapMsgSend.put("StringValue", "sendAndRecvTest7");
        mapMsgSend.put("BooleanValue", true);
        mapMsgSend.put("IntValue", 10);
        try {
            logger.log(System.Logger.Level.INFO, "Creating TextMessage");
            TextMessage expTextMessage = this.context.createTextMessage(message);
            logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "invalidDestinationRuntimeExceptionTests");
            logger.log(System.Logger.Level.INFO, "Testing JMSProducer.send(Destination, Message) for InvalidDestinationRuntimeException");
            try {
                logger.log(System.Logger.Level.INFO, "Calling send(Destination, Message) -> expect InvalidDestinationRuntimeException");
                this.producer.send(invalidDestination, (Message)expTextMessage);
            }
            catch (InvalidDestinationRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Got InvalidDestinationRuntimeException as expected.");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected InvalidDestinationRuntimeException, received " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Testing JMSProducer.send(Destination, String) for InvalidDestinationRuntimeException");
            try {
                logger.log(System.Logger.Level.INFO, "Calling send(Destination, String) -> expect InvalidDestinationRuntimeException");
                this.producer.send(invalidDestination, message);
            }
            catch (InvalidDestinationRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Got InvalidDestinationRuntimeException as expected.");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected InvalidDestinationRuntimeException, received " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Testing JMSProducer.send(Destination, Serializable) for InvalidDestinationRuntimeException");
            logger.log(System.Logger.Level.INFO, "Send ObjectMessage");
            logger.log(System.Logger.Level.INFO, "Set some values in ObjectMessage");
            ObjectMessage om = this.context.createObjectMessage();
            StringBuffer sb = new StringBuffer(message);
            om.setObject((Serializable)sb);
            om.setStringProperty("COM_SUN_JMS_TESTNAME", "invalidDestinationRuntimeExceptionTests");
            try {
                logger.log(System.Logger.Level.INFO, "Calling send(Destination, Serializable) -> expect InvalidDestinationRuntimeException");
                this.producer.send(invalidDestination, (Message)om);
            }
            catch (InvalidDestinationRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Got InvalidDestinationRuntimeException as expected.");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected InvalidDestinationRuntimeException, received " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Testing JMSProducer.send(Destination, byte[]) for InvalidDestinationRuntimeException");
            try {
                logger.log(System.Logger.Level.INFO, "Calling send(Destination, byte[]) -> expect InvalidDestinationRuntimeException");
                this.producer.send(invalidDestination, bytesMsgSend);
            }
            catch (InvalidDestinationRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Got InvalidDestinationRuntimeException as expected.");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected InvalidDestinationRuntimeException, received " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Testing JMSProducer.send(Destination, Map) for InvalidDestinationRuntimeException");
            try {
                logger.log(System.Logger.Level.INFO, "Calling send(Destination, Map) -> expect InvalidDestinationRuntimeException");
                this.producer.send(invalidDestination, mapMsgSend);
            }
            catch (InvalidDestinationRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Got InvalidDestinationRuntimeException as expected.");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected InvalidDestinationRuntimeException, received " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Testing JMSContext.createConsumer(Destination) for InvalidDestinationRuntimeException");
            try {
                logger.log(System.Logger.Level.INFO, "Calling JMSContext.createConsumer(Destination) -> expect InvalidDestinationRuntimeException");
                this.context.createConsumer(invalidDestination);
            }
            catch (InvalidDestinationRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Got InvalidDestinationRuntimeException as expected.");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected InvalidDestinationRuntimeException, received " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Testing JMSContext.createConsumer(Destination, String) for InvalidDestinationRuntimeException");
            try {
                logger.log(System.Logger.Level.INFO, "Calling JMSContext.createConsumer(Destination, String) -> expect InvalidDestinationRuntimeException");
                this.context.createConsumer(invalidDestination, "lastMessage = TRUE");
            }
            catch (InvalidDestinationRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Got InvalidDestinationRuntimeException as expected.");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected InvalidDestinationRuntimeException, received " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Testing JMSContext.createConsumer(Destination, String, boolean) for InvalidDestinationRuntimeException");
            try {
                logger.log(System.Logger.Level.INFO, "Calling JMSContext.createConsumer(Destination, String, boolean) -> expect InvalidDestinationRuntimeException");
                this.context.createConsumer(invalidDestination, "lastMessage = TRUE", false);
            }
            catch (InvalidDestinationRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Got InvalidDestinationRuntimeException as expected.");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected InvalidDestinationRuntimeException, received " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Testing JMSContext.createBrowser(Queue, String) for InvalidDestinationRuntimeException");
            try {
                logger.log(System.Logger.Level.INFO, "Calling JMSContext.createBrowser(Queue, String) -> expect InvalidDestinationRuntimeException");
                this.context.createBrowser(invalidQueue, "lastMessage = TRUE");
            }
            catch (InvalidDestinationRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Got InvalidDestinationRuntimeException as expected.");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected InvalidDestinationRuntimeException, received " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Testing JMSContext.createBrowser(Queue) for InvalidDestinationRuntimeException");
            try {
                logger.log(System.Logger.Level.INFO, "Calling JMSContext.createBrowser(Queue) -> expect InvalidDestinationRuntimeException");
                this.context.createBrowser(invalidQueue);
            }
            catch (InvalidDestinationRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Got InvalidDestinationRuntimeException as expected.");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected InvalidDestinationRuntimeException, received " + e);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            throw new Exception("invalidDestinationRuntimeExceptionTests", e);
        }
        if (!pass) {
            throw new Exception("invalidDestinationRuntimeExceptionTests failed");
        }
    }

    @Test
    public void invalidSelectorRuntimeExceptionTests() throws Exception {
        boolean pass = true;
        String invalidMessageSelector = "=TEST 'test'";
        try {
            logger.log(System.Logger.Level.INFO, "Testing JMSContext.createConsumer(Destination, String) for InvalidSelectorRuntimeException");
            try {
                logger.log(System.Logger.Level.INFO, "Calling JMSContext.createConsumer(Destination, String) -> expect InvalidSelectorRuntimeException");
                this.context.createConsumer(this.destination, invalidMessageSelector);
            }
            catch (InvalidSelectorRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Got InvalidSelectorRuntimeException as expected.");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected InvalidSelectorRuntimeException, received " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Testing JMSContext.createConsumer(Destination, String, boolean) for InvalidSelectorRuntimeException");
            try {
                logger.log(System.Logger.Level.INFO, "Calling JMSContext.createConsumer(Destination, String, boolean) -> expect InvalidSelectorRuntimeException");
                this.context.createConsumer(this.destination, invalidMessageSelector, false);
            }
            catch (InvalidSelectorRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Got InvalidSelectorRuntimeException as expected.");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected InvalidSelectorRuntimeException, received " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Testing JMSContext.createBrowser(Queue, String) for InvalidSelectorRuntimeException");
            try {
                logger.log(System.Logger.Level.INFO, "Calling JMSContext.createBrowser(Queue, String) -> expect InvalidSelectorRuntimeException");
                this.context.createBrowser(this.queue, invalidMessageSelector);
            }
            catch (InvalidSelectorRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Got InvalidSelectorRuntimeException, as expected.");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected InvalidSelectorRuntimeException,, received " + e);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            throw new Exception("invalidSelectorRuntimeExceptionTests", e);
        }
        if (!pass) {
            throw new Exception("invalidSelectorRuntimeExceptionTests failed");
        }
    }

    @Test
    public void illegalStateRuntimeExceptionTest() throws Exception {
        boolean pass;
        block15: {
            pass = true;
            String message = "Where are you!";
            try {
                logger.log(System.Logger.Level.INFO, "Creating TextMessage");
                TextMessage expTextMessage = this.context.createTextMessage(message);
                logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
                expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "illegalStateRuntimeExceptionTest");
                logger.log(System.Logger.Level.INFO, "Sending message to the Queue");
                logger.log(System.Logger.Level.INFO, "Sending TextMessage via JMSProducer.send(Destination, Message)");
                this.producer.send(this.destination, (Message)expTextMessage);
                try {
                    logger.log(System.Logger.Level.INFO, "JMSContext.commit() on non-transacted session must throw IllegalStateRuntimeException");
                    this.context.commit();
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "Error: JMSContext.commit() didn't throw expected IllegalStateRuntimeException");
                }
                catch (IllegalStateRuntimeException e) {
                    logger.log(System.Logger.Level.INFO, "Got expected IllegalStateRuntimeException from JMSContext.commit()");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                    pass = false;
                }
                logger.log(System.Logger.Level.INFO, "Creating TextMessage");
                expTextMessage = this.context.createTextMessage(message);
                logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
                expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "illegalStateRuntimeExceptionTest");
                logger.log(System.Logger.Level.INFO, "Sending message to the Queue");
                logger.log(System.Logger.Level.INFO, "Sending TextMessage via JMSProducer.send(Destination, Message)");
                this.producer.send(this.destination, (Message)expTextMessage);
                try {
                    logger.log(System.Logger.Level.INFO, "JMSContext.rollback() on non-transacted session must throw IllegalStateRuntimeException");
                    this.context.rollback();
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "Error: JMSContext.rollback() didn't throw expected IllegalStateRuntimeException");
                }
                catch (IllegalStateRuntimeException e) {
                    logger.log(System.Logger.Level.INFO, "Got expected IllegalStateRuntimeException from JMSContext.rollback()");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                    pass = false;
                }
                if (!this.vehicle.equals("appclient") && !this.vehicle.equals("standalone")) break block15;
                JMSContext contextTX = this.cf.createContext(this.user, this.password, 0);
                JMSProducer producerTX = contextTX.createProducer();
                logger.log(System.Logger.Level.INFO, "Creating TextMessage");
                expTextMessage = contextTX.createTextMessage(message);
                logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
                expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "illegalStateRuntimeExceptionTest");
                logger.log(System.Logger.Level.INFO, "Sending message to the Queue");
                logger.log(System.Logger.Level.INFO, "Sending TextMessage via JMSProducer.send(Destination, Message)");
                producerTX.send(this.destination, (Message)expTextMessage);
                try {
                    logger.log(System.Logger.Level.INFO, "JMSContext.recover() on a transacted session must throw IllegalStateRuntimeException");
                    contextTX.recover();
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "Error: JMSContext.recover() didn't throw expected IllegalStateRuntimeException");
                }
                catch (IllegalStateRuntimeException e) {
                    logger.log(System.Logger.Level.INFO, "Got expected IllegalStateRuntimeException from JMSContext.recover()");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                    pass = false;
                }
                contextTX.close();
                try {
                    logger.log(System.Logger.Level.INFO, "Create JMSContext with CLIENT_ACKNOWLEDGE");
                    JMSContext msgcontext = this.cf.createContext(this.user, this.password, 2);
                    logger.log(System.Logger.Level.INFO, "Close JMSContext");
                    msgcontext.close();
                    logger.log(System.Logger.Level.INFO, "Call JMSContext.acknowledge() on a closed session which is illegal");
                    msgcontext.acknowledge();
                    logger.log(System.Logger.Level.ERROR, "Didn't throw IllegalStateRuntimeException");
                    pass = false;
                }
                catch (IllegalStateRuntimeException e) {
                    logger.log(System.Logger.Level.INFO, "Got expected IllegalStateRuntimeException from JMSContext.acknowledge()");
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.INFO, "Caught expected exception" + e);
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.INFO, "Caught unexpected exception: " + e);
                throw new Exception("illegalStateRuntimeExceptionTest");
            }
        }
        if (!pass) {
            throw new Exception("illegalStateRuntimeExceptionTest");
        }
    }
}

