/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core20.sessiontests;

import com.sun.ts.tests.jms.common.JmsTool;
import jakarta.jms.BytesMessage;
import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.IllegalStateException;
import jakarta.jms.InvalidDestinationException;
import jakarta.jms.InvalidSelectorException;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.Session;
import jakarta.jms.StreamMessage;
import jakarta.jms.TemporaryQueue;
import jakarta.jms.TemporaryTopic;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ClientIT {
    private static final String testName = "com.sun.ts.tests.jms.core20.sessiontests.ClientIT";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private static final System.Logger logger = System.getLogger(ClientIT.class.getName());
    private transient JmsTool toolT = null;
    private transient JmsTool toolT2 = null;
    private transient JmsTool toolQ = null;
    private transient ConnectionFactory cf = null;
    private transient Topic topic = null;
    private transient Queue queue = null;
    private transient Destination destination = null;
    private transient Connection connection = null;
    private transient Session session = null;
    private transient MessageProducer producer = null;
    private transient MessageConsumer consumer = null;
    private transient MessageConsumer consumer2 = null;
    private transient TopicSubscriber subscriber = null;
    private transient TopicSubscriber subscriber2 = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    String vehicle = null;
    private static final String lookupDurableTopicFactory = "DURABLE_SUB_CONNECTION_FACTORY";
    private static final String lookupNormalTopicFactory = "MyTopicConnectionFactory";
    private static final int numMessages = 3;
    private static final int iterations = 5;
    ArrayList connections = null;
    boolean queueTest = false;

    public void setupGlobalVarsQ() throws Exception {
        this.cf = this.toolQ.getConnectionFactory();
        this.destination = this.toolQ.getDefaultDestination();
        this.session = this.toolQ.getDefaultSession();
        this.connection = this.toolQ.getDefaultConnection();
        this.producer = this.toolQ.getDefaultProducer();
        this.consumer = this.toolQ.getDefaultConsumer();
        this.queue = (Queue)this.destination;
        this.connection.start();
        this.queueTest = true;
    }

    public void setupGlobalVarsT() throws Exception {
        this.cf = this.toolT.getConnectionFactory();
        this.destination = this.toolT.getDefaultDestination();
        this.session = this.toolT.getDefaultSession();
        this.connection = this.toolT.getDefaultConnection();
        this.producer = this.toolT.getDefaultProducer();
        this.consumer = this.toolT.getDefaultConsumer();
        this.topic = (Topic)this.destination;
        this.connection.start();
        this.queueTest = false;
    }

    public void setupGlobalVarsT2() throws Exception {
        this.cf = this.toolT2.getConnectionFactory();
        this.destination = this.toolT2.getDefaultDestination();
        this.session = this.toolT2.getDefaultSession();
        this.connection = this.toolT2.getDefaultConnection();
        this.producer = this.toolT2.getDefaultProducer();
        this.consumer = this.toolT2.getDefaultConsumer();
        this.topic = (Topic)this.destination;
        this.connection.start();
        this.queueTest = false;
    }

    @BeforeEach
    public void setup() throws Exception {
        try {
            this.timeout = Long.parseLong(System.getProperty("jms_timeout"));
            this.user = System.getProperty("user");
            this.password = System.getProperty("password");
            this.mode = System.getProperty("platform.mode");
            this.vehicle = System.getProperty("vehicle");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' is null ");
            }
            if (this.password == null) {
                throw new Exception("'password' is null ");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' is null");
            }
            this.connections = new ArrayList(5);
            this.toolT = new JmsTool(14, this.user, this.password, lookupNormalTopicFactory, this.mode);
            this.toolQ = new JmsTool(13, this.user, this.password, this.mode);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            throw new Exception("setup failed!", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.INFO, "Closing default Connection");
            this.toolQ.getDefaultConnection().close();
            this.toolT.getDefaultConnection().close();
            if (this.toolT2 != null) {
                this.toolT2.getDefaultConnection().close();
            }
            if (this.queueTest) {
                logger.log(System.Logger.Level.INFO, "Flush any messages left on Queue");
                this.toolQ.flushDestination();
            }
            this.toolQ.closeAllResources();
            this.toolT.closeAllResources();
            if (this.toolT2 != null) {
                this.toolT2.closeAllResources();
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            throw new Exception("cleanup failed!", e);
        }
    }

    private void cleanupSubscription(MessageConsumer consumer, Session session, String subName) {
        if (consumer != null) {
            try {
                logger.log(System.Logger.Level.TRACE, "Closing durable consumer: " + consumer);
                consumer.close();
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "exception during close: ", (Throwable)e);
            }
        }
        if (session != null) {
            try {
                logger.log(System.Logger.Level.TRACE, "Unsubscribing \"" + subName + "\"");
                session.unsubscribe(subName);
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "exception during unsubscribe: ", (Throwable)e);
            }
        }
    }

    private void cleanupSubscription(TopicSubscriber tSub, Session session, String subName) {
        if (tSub != null) {
            try {
                logger.log(System.Logger.Level.TRACE, "Closing durable subscriber: " + tSub);
                tSub.close();
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "exception during close: ", (Throwable)e);
            }
        }
        if (session != null) {
            try {
                logger.log(System.Logger.Level.TRACE, "Unsubscribing \"" + subName + "\"");
                session.unsubscribe(subName);
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "exception during unsubscribe: ", (Throwable)e);
            }
        }
    }

    @Test
    public void sendRecvMsgsOfEachMsgTypeTopicTest() throws Exception {
        boolean pass = true;
        try {
            this.setupGlobalVarsT();
            logger.log(System.Logger.Level.INFO, "Send Message");
            Message msg = this.session.createMessage();
            logger.log(System.Logger.Level.INFO, "Set some values in Message");
            msg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendRecvMsgsOfEachMsgTypeTopicTest");
            msg.setBooleanProperty("booleanProperty", true);
            this.producer.send(msg);
            logger.log(System.Logger.Level.INFO, "Receive Message");
            Message msgRecv = this.consumer.receive(this.timeout);
            if (msgRecv == null) {
                throw new Exception("Did not receive Message");
            }
            logger.log(System.Logger.Level.INFO, "Check the values in Message");
            if (msgRecv.getBooleanProperty("booleanProperty")) {
                logger.log(System.Logger.Level.INFO, "booleanproperty is correct");
            } else {
                logger.log(System.Logger.Level.INFO, "booleanproperty is incorrect");
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Send BytesMessage");
            BytesMessage bMsg = this.session.createBytesMessage();
            logger.log(System.Logger.Level.INFO, "Set some values in BytesMessage");
            bMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendRecvMsgsOfEachMsgTypeTopicTest");
            bMsg.writeByte((byte)1);
            bMsg.writeInt(22);
            this.producer.send((Message)bMsg);
            logger.log(System.Logger.Level.INFO, "Receive BytesMessage");
            BytesMessage bMsgRecv = (BytesMessage)this.consumer.receive(this.timeout);
            if (bMsgRecv == null) {
                throw new Exception("Did not receive BytesMessage");
            }
            logger.log(System.Logger.Level.INFO, "Check the values in BytesMessage");
            if (bMsgRecv.readByte() == 1) {
                logger.log(System.Logger.Level.INFO, "bytevalue is correct");
            } else {
                logger.log(System.Logger.Level.INFO, "bytevalue is incorrect");
                pass = false;
            }
            if (bMsgRecv.readInt() == 22) {
                logger.log(System.Logger.Level.INFO, "intvalue is correct");
            } else {
                logger.log(System.Logger.Level.INFO, "intvalue is incorrect");
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Send MapMessage");
            MapMessage mMsg = this.session.createMapMessage();
            logger.log(System.Logger.Level.INFO, "Set some values in MapMessage");
            mMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendRecvMsgsOfEachMsgTypeTopicTest");
            mMsg.setBoolean("booleanvalue", true);
            mMsg.setInt("intvalue", 10);
            this.producer.send((Message)mMsg);
            logger.log(System.Logger.Level.INFO, "Receive MapMessage");
            MapMessage mMsgRecv = (MapMessage)this.consumer.receive(this.timeout);
            if (mMsgRecv == null) {
                throw new Exception("Did not receive MapMessage");
            }
            logger.log(System.Logger.Level.INFO, "Check the values in MapMessage");
            Enumeration list = mMsgRecv.getMapNames();
            String name = null;
            while (list.hasMoreElements()) {
                name = (String)list.nextElement();
                if (name.equals("booleanvalue")) {
                    if (mMsgRecv.getBoolean(name)) {
                        logger.log(System.Logger.Level.INFO, "booleanvalue is correct");
                        continue;
                    }
                    logger.log(System.Logger.Level.ERROR, "booleanvalue is incorrect");
                    pass = false;
                    continue;
                }
                if (name.equals("intvalue")) {
                    if (mMsgRecv.getInt(name) == 10) {
                        logger.log(System.Logger.Level.INFO, "intvalue is correct");
                        continue;
                    }
                    logger.log(System.Logger.Level.ERROR, "intvalue is incorrect");
                    pass = false;
                    continue;
                }
                logger.log(System.Logger.Level.ERROR, "Unexpected name of [" + name + "] in MapMessage");
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Send ObjectMessage");
            StringBuffer sb1 = new StringBuffer("This is a StringBuffer");
            logger.log(System.Logger.Level.INFO, "Set some values in ObjectMessage");
            ObjectMessage oMsg = this.session.createObjectMessage();
            oMsg.setObject((Serializable)sb1);
            oMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendRecvMsgsOfEachMsgTypeTopicTest");
            this.producer.send((Message)oMsg);
            logger.log(System.Logger.Level.INFO, "Receive ObjectMessage");
            ObjectMessage oMsgRecv = (ObjectMessage)this.consumer.receive(this.timeout);
            if (oMsgRecv == null) {
                throw new Exception("Did not receive ObjectMessage");
            }
            logger.log(System.Logger.Level.INFO, "Check the value in ObjectMessage");
            StringBuffer sb2 = (StringBuffer)oMsgRecv.getObject();
            if (sb2.toString().equals(sb1.toString())) {
                logger.log(System.Logger.Level.INFO, "objectvalue is correct");
            } else {
                logger.log(System.Logger.Level.ERROR, "objectvalue is incorrect");
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Send ObjectMessage passing object as param");
            sb1 = new StringBuffer("This is a StringBuffer");
            logger.log(System.Logger.Level.INFO, "Set some values in ObjectMessage passing object as param");
            oMsg = this.session.createObjectMessage((Serializable)sb1);
            oMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendRecvMsgsOfEachMsgTypeTopicTest");
            this.producer.send((Message)oMsg);
            logger.log(System.Logger.Level.INFO, "Receive ObjectMessage");
            oMsgRecv = (ObjectMessage)this.consumer.receive(this.timeout);
            if (oMsgRecv == null) {
                throw new Exception("Did not receive ObjectMessage");
            }
            logger.log(System.Logger.Level.INFO, "Check the value in ObjectMessage");
            sb2 = (StringBuffer)oMsgRecv.getObject();
            if (sb2.toString().equals(sb1.toString())) {
                logger.log(System.Logger.Level.INFO, "objectvalue is correct");
            } else {
                logger.log(System.Logger.Level.ERROR, "objectvalue is incorrect");
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Send StreamMessage");
            StreamMessage sMsg = this.session.createStreamMessage();
            logger.log(System.Logger.Level.INFO, "Set some values in StreamMessage");
            sMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendRecvMsgsOfEachMsgTypeTopicTest");
            sMsg.writeBoolean(true);
            sMsg.writeInt(22);
            this.producer.send((Message)sMsg);
            logger.log(System.Logger.Level.INFO, "Receive StreamMessage");
            StreamMessage sMsgRecv = (StreamMessage)this.consumer.receive(this.timeout);
            if (sMsgRecv == null) {
                throw new Exception("Did not receive StreamMessage");
            }
            logger.log(System.Logger.Level.INFO, "Check the values in StreamMessage");
            if (sMsgRecv.readBoolean()) {
                logger.log(System.Logger.Level.INFO, "booleanvalue is correct");
            } else {
                logger.log(System.Logger.Level.INFO, "booleanvalue is incorrect");
                pass = false;
            }
            if (sMsgRecv.readInt() == 22) {
                logger.log(System.Logger.Level.INFO, "intvalue is correct");
            } else {
                logger.log(System.Logger.Level.INFO, "intvalue is incorrect");
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Send TextMessage");
            TextMessage tMsg = this.session.createTextMessage();
            logger.log(System.Logger.Level.INFO, "Set some values in MapMessage");
            tMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendRecvMsgsOfEachMsgTypeTopicTest");
            tMsg.setText("Hello There!");
            this.producer.send((Message)tMsg);
            logger.log(System.Logger.Level.INFO, "Receive TextMessage");
            TextMessage tMsgRecv = (TextMessage)this.consumer.receive(this.timeout);
            if (tMsgRecv == null) {
                throw new Exception("Did not receive TextMessage");
            }
            logger.log(System.Logger.Level.INFO, "Check the value in TextMessage");
            if (tMsgRecv.getText().equals("Hello There!")) {
                logger.log(System.Logger.Level.INFO, "TextMessage is correct");
            } else {
                logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect");
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Send TextMessage");
            tMsg = this.session.createTextMessage("Where are you!");
            logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
            tMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendRecvMsgsOfEachMsgTypeTopicTest");
            this.producer.send((Message)tMsg);
            logger.log(System.Logger.Level.INFO, "Receive TextMessage");
            tMsgRecv = (TextMessage)this.consumer.receive(this.timeout);
            if (tMsgRecv == null) {
                throw new Exception("Did not receive TextMessage");
            }
            logger.log(System.Logger.Level.INFO, "Check the value in TextMessage");
            if (tMsgRecv.getText().equals("Where are you!")) {
                logger.log(System.Logger.Level.INFO, "TextMessage is correct");
            } else {
                logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect");
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            e.printStackTrace();
            throw new Exception("sendRecvMsgsOfEachMsgTypeTopicTest", e);
        }
        if (!pass) {
            throw new Exception("sendRecvMsgsOfEachMsgTypeTopicTest failed");
        }
    }

    @Test
    public void createTemporayTopicTest() throws Exception {
        boolean pass = true;
        try {
            String message = "a text message";
            this.setupGlobalVarsT();
            logger.log(System.Logger.Level.INFO, "Creating TemporaryTopic");
            TemporaryTopic tempTopic = this.session.createTemporaryTopic();
            logger.log(System.Logger.Level.INFO, "Creating MessageConsumer for TemporaryTopic");
            MessageConsumer tConsumer = this.session.createConsumer((Destination)tempTopic);
            logger.log(System.Logger.Level.INFO, "Creating MessageProducer for TemporaryTopic");
            MessageProducer tProducer = this.session.createProducer((Destination)tempTopic);
            logger.log(System.Logger.Level.INFO, "Creating TextMessage with text [" + message + "]");
            TextMessage tMsg = this.session.createTextMessage(message);
            logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
            tMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "createTemporayTopicTest");
            logger.log(System.Logger.Level.INFO, "Send TextMessage to temporaty topic");
            tProducer.send((Message)tMsg);
            logger.log(System.Logger.Level.INFO, "Receive TextMessage from temporaty topic");
            TextMessage tMsgRecv = (TextMessage)tConsumer.receive(this.timeout);
            if (tMsgRecv == null) {
                throw new Exception("Did not receive TextMessage");
            }
            logger.log(System.Logger.Level.INFO, "Check the value in TextMessage");
            if (tMsgRecv.getText().equals(message)) {
                logger.log(System.Logger.Level.INFO, "TextMessage is correct");
            } else {
                logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect");
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Attempting to delete temporary topic with an open consumer should not be allowed");
            try {
                tempTopic.delete();
                pass = false;
                logger.log(System.Logger.Level.ERROR, "TemporaryTopic.delete() didn't throw expected Exception");
            }
            catch (JMSException em) {
                logger.log(System.Logger.Level.INFO, "Received expected JMSException: ");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Received unexpected Exception: " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Now close the open consumer");
            try {
                tConsumer.close();
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Attempting to delete temporary topic with no open consumer should be allowed");
            try {
                tempTopic.delete();
            }
            catch (Exception e) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Received unexpected Exception: ", (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            e.printStackTrace();
            throw new Exception("createTemporayTopicTest");
        }
        if (!pass) {
            throw new Exception("createTemporayTopicTest failed");
        }
    }

    @Test
    public void getTransactedTopicTest() throws Exception {
        boolean actTransacted;
        boolean pass = true;
        try {
            this.setupGlobalVarsT();
            this.session.close();
            this.session = this.connection.createSession(1);
            boolean expTransacted = false;
            logger.log(System.Logger.Level.INFO, "Calling getTransacted and expect " + expTransacted + " to be returned");
            actTransacted = this.session.getTransacted();
            if (actTransacted != expTransacted) {
                logger.log(System.Logger.Level.ERROR, "getTransacted() returned " + actTransacted + ", expected " + expTransacted);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            throw new Exception("getTransactedTopicTest", e);
        }
        finally {
            try {
                if (this.session != null) {
                    this.session.close();
                }
            }
            catch (Exception exception) {}
        }
        if (this.vehicle.equals("appclient") || this.vehicle.equals("standalone")) {
            try {
                this.session = this.connection.createSession(0);
                boolean expTransacted = true;
                logger.log(System.Logger.Level.INFO, "Calling getTransacted and expect " + expTransacted + " to be returned");
                actTransacted = this.session.getTransacted();
                if (actTransacted != expTransacted) {
                    logger.log(System.Logger.Level.ERROR, "getTransacted() returned " + actTransacted + ", expected " + expTransacted);
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
                throw new Exception("getTransactedTopicTest", e);
            }
            finally {
                try {
                    if (this.session != null) {
                        this.session.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        if (!pass) {
            throw new Exception("getTransactedTopicTest failed");
        }
    }

    @Test
    public void getAcknowledgeModeTopicTest() throws Exception {
        int actAcknowledgeMode;
        boolean pass = true;
        try {
            this.setupGlobalVarsT();
            this.session.close();
            this.session = this.connection.createSession(1);
            int expAcknowledgeMode = 1;
            logger.log(System.Logger.Level.INFO, "Calling getAcknowledgeMode and expect " + expAcknowledgeMode + " to be returned");
            actAcknowledgeMode = this.session.getAcknowledgeMode();
            if (actAcknowledgeMode != expAcknowledgeMode) {
                logger.log(System.Logger.Level.ERROR, "getAcknowledgeMode() returned " + actAcknowledgeMode + ", expected " + expAcknowledgeMode);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            throw new Exception("getAcknowledgeModeTopicTest", e);
        }
        finally {
            try {
                if (this.session != null) {
                    this.session.close();
                }
            }
            catch (Exception exception) {}
        }
        try {
            this.session = this.connection.createSession(3);
            int expAcknowledgeMode = 3;
            logger.log(System.Logger.Level.INFO, "Calling getAcknowledgeMode and expect " + expAcknowledgeMode + " to be returned");
            actAcknowledgeMode = this.session.getAcknowledgeMode();
            if (actAcknowledgeMode != expAcknowledgeMode) {
                logger.log(System.Logger.Level.ERROR, "getAcknowledgeMode() returned " + actAcknowledgeMode + ", expected " + expAcknowledgeMode);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            throw new Exception("getAcknowledgeModeTopicTest", e);
        }
        finally {
            try {
                if (this.session != null) {
                    this.session.close();
                }
            }
            catch (Exception exception) {}
        }
        if (this.vehicle.equals("appclient") || this.vehicle.equals("standalone")) {
            try {
                this.session = this.connection.createSession(0);
                int expAcknowledgeMode = 0;
                logger.log(System.Logger.Level.INFO, "Calling getAcknowledgeMode and expect " + expAcknowledgeMode + " to be returned");
                actAcknowledgeMode = this.session.getAcknowledgeMode();
                if (actAcknowledgeMode != expAcknowledgeMode) {
                    logger.log(System.Logger.Level.ERROR, "getAcknowledgeMode() returned " + actAcknowledgeMode + ", expected " + expAcknowledgeMode);
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
                throw new Exception("getAcknowledgeModeTopicTest", e);
            }
            finally {
                try {
                    if (this.session != null) {
                        this.session.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        if (!pass) {
            throw new Exception("getAcknowledgeModeTopicTest failed");
        }
    }

    @Test
    public void createConsumerProducerTopicTest() throws Exception {
        boolean pass = true;
        MessageConsumer consumerSelect = null;
        try {
            TextMessage tempMsg = null;
            Object msgs = null;
            this.setupGlobalVarsT();
            this.consumer.close();
            logger.log(System.Logger.Level.INFO, "Create selective consumer to consume messages in Topic with boolproperty (lastMessage=TRUE)");
            consumerSelect = this.session.createConsumer(this.destination, "lastMessage=TRUE");
            logger.log(System.Logger.Level.INFO, "Create normal consumer to consume all messages in Topic");
            this.consumer = this.session.createConsumer(this.destination);
            logger.log(System.Logger.Level.INFO, "Send 3 messsages to Topic");
            for (int i = 1; i <= 3; ++i) {
                tempMsg = this.session.createTextMessage("Message " + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "createConsumerProducerTopicTest" + i);
                tempMsg.setJMSType("");
                if (i == 3) {
                    tempMsg.setBooleanProperty("lastMessage", true);
                } else {
                    tempMsg.setBooleanProperty("lastMessage", false);
                }
                this.producer.send((Message)tempMsg);
                logger.log(System.Logger.Level.INFO, "Message " + i + " sent");
            }
            logger.log(System.Logger.Level.INFO, "Consume messages with selective consumer which has boolproperty (lastMessage=TRUE)");
            if (consumerSelect != null) {
                tempMsg = (TextMessage)consumerSelect.receive(this.timeout);
            }
            if (tempMsg == null) {
                logger.log(System.Logger.Level.ERROR, "MessageConsumer.receive() returned NULL");
                logger.log(System.Logger.Level.ERROR, "Message 3 missing from Topic");
                pass = false;
            } else if (!tempMsg.getText().equals("Message 3")) {
                logger.log(System.Logger.Level.ERROR, "Received [" + tempMsg.getText() + "] expected [Message 3]");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Received expected message: " + tempMsg.getText());
            }
            logger.log(System.Logger.Level.INFO, "Make sure selective consumer receives no more messages");
            if (consumerSelect != null) {
                tempMsg = (TextMessage)consumerSelect.receive(this.timeout);
            }
            if (tempMsg != null) {
                logger.log(System.Logger.Level.ERROR, "MessageConsumer.receive() returned a message [" + tempMsg.getText() + "] (Expected NULL)");
                logger.log(System.Logger.Level.ERROR, "MessageConsumer with selector should have returned just 1 message");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "No more messages for selective consumer (Correct)");
            }
            try {
                if (consumerSelect != null) {
                    consumerSelect.close();
                }
            }
            catch (Exception i) {
                // empty catch block
            }
            logger.log(System.Logger.Level.INFO, "Consume all messages with normal consumer");
            for (int msgCount = 1; msgCount <= 3; ++msgCount) {
                tempMsg = (TextMessage)this.consumer.receive(this.timeout);
                if (tempMsg == null) {
                    logger.log(System.Logger.Level.ERROR, "MessageConsumer.receive() returned NULL");
                    logger.log(System.Logger.Level.ERROR, "Message " + msgCount + " missing from Topic");
                    pass = false;
                    continue;
                }
                if (!tempMsg.getText().equals("Message " + msgCount)) {
                    logger.log(System.Logger.Level.ERROR, "Received [" + tempMsg.getText() + "] expected [Message " + msgCount + "]");
                    pass = false;
                    continue;
                }
                logger.log(System.Logger.Level.INFO, "Received message: " + tempMsg.getText());
            }
            logger.log(System.Logger.Level.INFO, "Make sure normal consumer receives no more messages");
            tempMsg = (TextMessage)this.consumer.receive(this.timeout);
            if (tempMsg != null) {
                logger.log(System.Logger.Level.ERROR, "Received [" + tempMsg.getText() + "] expected no message");
                logger.log(System.Logger.Level.ERROR, "MessageConsumer should have returned 3 messages");
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            e.printStackTrace();
            throw new Exception("createConsumerProducerTopicTest");
        }
        finally {
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                }
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new Exception("createConsumerProducerTopicTest failed");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void createDurableSubscriberTopicTest1() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        TopicSubscriber tSub = null;
        try {
            TextMessage expTextMessage = null;
            this.toolT.getDefaultConnection().close();
            this.toolT.closeAllResources();
            this.toolT2 = new JmsTool(14, this.user, this.password, lookupDurableTopicFactory, this.mode);
            this.setupGlobalVarsT2();
            logger.log(System.Logger.Level.INFO, "Create a Durable Subscription and a TopicSubscriber for it");
            tSub = this.session.createDurableSubscriber(this.topic, "createDurableSubscriberTopicTest1");
            logger.log(System.Logger.Level.INFO, "Send message to Topic");
            expTextMessage = this.session.createTextMessage(message);
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "createDurableSubscriberTopicTest1");
            this.producer.send((Message)expTextMessage);
            logger.log(System.Logger.Level.INFO, "Message sent");
            logger.log(System.Logger.Level.INFO, "Receive TextMessage");
            TextMessage actTextMessage = (TextMessage)tSub.receive(this.timeout);
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            logger.log(System.Logger.Level.INFO, "Check the value in TextMessage");
            if (actTextMessage.getText().equals(expTextMessage.getText())) {
                logger.log(System.Logger.Level.INFO, "TextMessage is correct");
            } else {
                logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText());
                pass = false;
            }
        }
        catch (Exception e) {
            try {
                logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
                e.printStackTrace();
                throw new Exception("createDurableSubscriberTopicTest1", e);
            }
            catch (Throwable throwable) {
                try {
                    this.cleanupSubscription(tSub, this.session, "createDurableSubscriberTopicTest1");
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            this.cleanupSubscription(tSub, this.session, "createDurableSubscriberTopicTest1");
        }
        catch (Exception expTextMessage) {}
        if (pass) return;
        throw new Exception("createDurableSubscriberTopicTest1 failed");
    }

    /*
     * Loose catch block
     */
    @Test
    public void createDurableSubscriberTopicTest2() throws Exception {
        TextMessage tempMsg;
        TopicSubscriber tSub;
        boolean pass;
        block29: {
            block27: {
                pass = true;
                String message = "Where are you!";
                tSub = null;
                this.toolT.getDefaultConnection().close();
                this.toolT.closeAllResources();
                this.toolT2 = new JmsTool(14, this.user, this.password, lookupDurableTopicFactory, this.mode);
                this.setupGlobalVarsT2();
                logger.log(System.Logger.Level.INFO, "Create a Durable Subscription and a TopicSubscriber for it");
                tSub = this.session.createDurableSubscriber(this.topic, "createDurableSubscriberTopicTest2", "lastMessage = TRUE", false);
                logger.log(System.Logger.Level.INFO, "Send 3 to Topic");
                for (int i = 1; i <= 3; ++i) {
                    tempMsg = this.session.createTextMessage("Message " + i);
                    tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "createDurableSubscriberTopicTest2" + i);
                    if (i == 3) {
                        tempMsg.setBooleanProperty("lastMessage", true);
                    } else {
                        tempMsg.setBooleanProperty("lastMessage", false);
                    }
                    this.producer.send((Message)tempMsg);
                    logger.log(System.Logger.Level.INFO, "Message " + i + " sent");
                }
                logger.log(System.Logger.Level.INFO, "Receive TextMessage");
                TextMessage expTextMessage = this.session.createTextMessage("Message 3");
                TextMessage actTextMessage = (TextMessage)tSub.receive(this.timeout);
                if (actTextMessage == null) {
                    throw new Exception("Did not receive TextMessage");
                }
                logger.log(System.Logger.Level.INFO, "Check the value in TextMessage");
                if (actTextMessage.getText().equals(expTextMessage.getText())) {
                    logger.log(System.Logger.Level.INFO, "TextMessage is correct");
                    break block27;
                }
                logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText());
                pass = false;
            }
            try {
                this.cleanupSubscription(tSub, this.session, "createDurableSubscriberTopicTest2");
            }
            catch (Exception expTextMessage) {}
            break block29;
            catch (Exception e) {
                try {
                    logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
                    e.printStackTrace();
                    throw new Exception("createDurableSubscriberTopicTest2", e);
                }
                catch (Throwable throwable) {
                    try {
                        this.cleanupSubscription(tSub, this.session, "createDurableSubscriberTopicTest2");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        try {
            logger.log(System.Logger.Level.INFO, "Create a Durable Subscription and a TopicSubscriber for it");
            tSub = this.session.createDurableSubscriber(this.topic, "createDurableSubscriberTopicTest2", "lastMessage = TRUE", true);
            logger.log(System.Logger.Level.INFO, "Send 3 to Topic");
            for (int i = 1; i <= 3; ++i) {
                tempMsg = this.session.createTextMessage("Message " + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "createDurableSubscriberTopicTest2" + i);
                if (i == 3) {
                    tempMsg.setBooleanProperty("lastMessage", true);
                } else {
                    tempMsg.setBooleanProperty("lastMessage", false);
                }
                this.producer.send((Message)tempMsg);
                logger.log(System.Logger.Level.INFO, "Message " + i + " sent");
            }
            logger.log(System.Logger.Level.INFO, "Receive TextMessage");
            TextMessage actTextMessage = (TextMessage)tSub.receive(this.timeout);
            if (actTextMessage != null) {
                logger.log(System.Logger.Level.ERROR, "message were delivered when noLocal=true");
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            e.printStackTrace();
            throw new Exception("createDurableSubscriberTopicTest2", e);
        }
        finally {
            try {
                this.cleanupSubscription(tSub, this.session, "createDurableSubscriberTopicTest2");
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new Exception("createDurableSubscriberTopicTest2 failed");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Test
    public void createDurableConsumerTopicTest1() throws Exception {
        boolean pass = true;
        String message1 = "Where are you!";
        String message2 = "Who are you!";
        MessageConsumer tCon = null;
        try {
            TextMessage expTextMessage = null;
            this.toolT.getDefaultConnection().close();
            this.toolT.closeAllResources();
            this.toolT2 = new JmsTool(14, this.user, this.password, lookupDurableTopicFactory, this.mode);
            this.setupGlobalVarsT2();
            logger.log(System.Logger.Level.INFO, "Create a Durable Subscription and a MessageConsumer for it");
            tCon = this.session.createDurableConsumer(this.topic, "createDurableConsumerTopicTest1");
            logger.log(System.Logger.Level.INFO, "Send TextMessage message1 to Topic");
            expTextMessage = this.session.createTextMessage(message1);
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "createDurableConsumerTopicTest1");
            this.producer.send((Message)expTextMessage);
            logger.log(System.Logger.Level.INFO, "TextMessage message1 sent");
            logger.log(System.Logger.Level.INFO, "Receive TextMessage message1");
            TextMessage actTextMessage = (TextMessage)tCon.receive(this.timeout);
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            logger.log(System.Logger.Level.INFO, "Check the value in TextMessage message1");
            if (actTextMessage.getText().equals(expTextMessage.getText())) {
                logger.log(System.Logger.Level.INFO, "TextMessage is correct");
            } else {
                logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText());
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Close durable MessageConsumer");
            tCon.close();
            logger.log(System.Logger.Level.INFO, "Send TextMessage message2 to Topic");
            expTextMessage = this.session.createTextMessage(message1);
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "createDurableConsumerTopicTest1");
            this.producer.send((Message)expTextMessage);
            logger.log(System.Logger.Level.INFO, "TextMessage message2 sent");
            logger.log(System.Logger.Level.INFO, "Recreate a Durable Subscription and a MessageConsumer for it");
            tCon = this.session.createDurableConsumer(this.topic, "createDurableConsumerTopicTest1");
            logger.log(System.Logger.Level.INFO, "Receive TextMessage message2");
            actTextMessage = (TextMessage)tCon.receive(this.timeout);
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            logger.log(System.Logger.Level.INFO, "Check the value in TextMessage message2");
            if (actTextMessage.getText().equals(expTextMessage.getText())) {
                logger.log(System.Logger.Level.INFO, "TextMessage is correct");
            } else {
                logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText());
                pass = false;
            }
        }
        catch (Exception e) {
            try {
                logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
                e.printStackTrace();
                throw new Exception("createDurableConsumerTopicTest1", e);
            }
            catch (Throwable throwable) {
                try {
                    this.cleanupSubscription(tCon, this.session, "createDurableConsumerTopicTest1");
                    throw throwable;
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        try {
            this.cleanupSubscription(tCon, this.session, "createDurableConsumerTopicTest1");
        }
        catch (Exception expTextMessage) {}
        if (pass) return;
        throw new Exception("createDurableConsumerTopicTest1 failed");
    }

    /*
     * Loose catch block
     */
    @Test
    public void createDurableConsumerTopicTest2() throws Exception {
        TextMessage tempMsg;
        MessageConsumer tCon;
        boolean pass;
        block29: {
            block27: {
                pass = true;
                String message = "Where are you!";
                tCon = null;
                this.toolT.getDefaultConnection().close();
                this.toolT.closeAllResources();
                this.toolT2 = new JmsTool(14, this.user, this.password, lookupDurableTopicFactory, this.mode);
                this.setupGlobalVarsT2();
                logger.log(System.Logger.Level.INFO, "Create a Durable Subscription and a MessageConsumer with message selector, noLocal=false");
                tCon = this.session.createDurableConsumer(this.topic, "createDurableConsumerTopicTest2", "lastMessage = TRUE", false);
                logger.log(System.Logger.Level.INFO, "Send 3 to Topic");
                for (int i = 1; i <= 3; ++i) {
                    tempMsg = this.session.createTextMessage("Message " + i);
                    tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "createDurableConsumerTopicTest2" + i);
                    if (i == 3) {
                        tempMsg.setBooleanProperty("lastMessage", true);
                    } else {
                        tempMsg.setBooleanProperty("lastMessage", false);
                    }
                    this.producer.send((Message)tempMsg);
                    logger.log(System.Logger.Level.INFO, "Message " + i + " sent");
                }
                logger.log(System.Logger.Level.INFO, "Receive TextMessage");
                logger.log(System.Logger.Level.INFO, "This is noLacal=false case so expect to get just last message");
                TextMessage expTextMessage = this.session.createTextMessage("Message 3");
                TextMessage actTextMessage = (TextMessage)tCon.receive(this.timeout);
                if (actTextMessage == null) {
                    throw new Exception("Did not receive TextMessage");
                }
                logger.log(System.Logger.Level.INFO, "Check the value in TextMessage");
                if (actTextMessage.getText().equals(expTextMessage.getText())) {
                    logger.log(System.Logger.Level.INFO, "TextMessage is correct");
                    break block27;
                }
                logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText());
                pass = false;
            }
            try {
                this.cleanupSubscription(tCon, this.session, "createDurableConsumerTopicTest2");
            }
            catch (Exception expTextMessage) {}
            break block29;
            catch (Exception e) {
                try {
                    logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
                    e.printStackTrace();
                    throw new Exception("createDurableConsumerTopicTest2", e);
                }
                catch (Throwable throwable) {
                    try {
                        this.cleanupSubscription(tCon, this.session, "createDurableConsumerTopicTest2");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        try {
            logger.log(System.Logger.Level.INFO, "Create a Durable Subscription and a MessageConsumer with message selector, noLocal=true");
            tCon = this.session.createDurableConsumer(this.topic, "createDurableConsumerTopicTest2", "lastMessage = TRUE", true);
            logger.log(System.Logger.Level.INFO, "Send 3 to Topic");
            for (int i = 1; i <= 3; ++i) {
                tempMsg = this.session.createTextMessage("Message " + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "createDurableConsumerTopicTest2" + i);
                if (i == 3) {
                    tempMsg.setBooleanProperty("lastMessage", true);
                } else {
                    tempMsg.setBooleanProperty("lastMessage", false);
                }
                this.producer.send((Message)tempMsg);
                logger.log(System.Logger.Level.INFO, "Message " + i + " sent");
            }
            logger.log(System.Logger.Level.INFO, "Receive TextMessage");
            TextMessage actTextMessage = (TextMessage)tCon.receive(this.timeout);
            if (actTextMessage != null) {
                logger.log(System.Logger.Level.ERROR, "Message was delivered when noLocal=true");
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            e.printStackTrace();
            throw new Exception("createDurableConsumerTopicTest2", e);
        }
        finally {
            try {
                this.cleanupSubscription(tCon, this.session, "createDurableConsumerTopicTest2");
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new Exception("createDurableConsumerTopicTest2 failed");
        }
    }

    @Test
    public void createSharedConsumerTopicTest1() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        String sharedSubscriptionName = "createSharedConsumerTopicTest1";
        TextMessage expTextMessage = null;
        try {
            this.setupGlobalVarsT();
            logger.log(System.Logger.Level.INFO, "Create a shared non-durable Subscription and a MessageConsumer for it");
            this.consumer.close();
            this.consumer = this.session.createSharedConsumer(this.topic, sharedSubscriptionName);
            logger.log(System.Logger.Level.INFO, "Create a second MessageConsumer for the Subscription");
            this.consumer2 = this.session.createSharedConsumer(this.topic, sharedSubscriptionName);
            logger.log(System.Logger.Level.INFO, "Send message to Topic");
            expTextMessage = this.session.createTextMessage(message);
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", sharedSubscriptionName);
            this.producer.send((Message)expTextMessage);
            logger.log(System.Logger.Level.INFO, "Message sent");
            logger.log(System.Logger.Level.INFO, "Receive TextMessage from consumer1");
            TextMessage actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage == null) {
                logger.log(System.Logger.Level.ERROR, "Did not receive TextMessage");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Check the value in TextMessage");
                if (actTextMessage.getText().equals(expTextMessage.getText())) {
                    logger.log(System.Logger.Level.INFO, "TextMessage is correct");
                } else {
                    logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText());
                    pass = false;
                }
            }
            logger.log(System.Logger.Level.INFO, "Attempt to Receive TextMessage from consumer2 - there should be none");
            actTextMessage = (TextMessage)this.consumer2.receive(this.timeout);
            if (actTextMessage != null) {
                throw new Exception("Did receive TextMessage - unexpected.");
            }
            logger.log(System.Logger.Level.INFO, "Did not receive TextMessage - expected.");
            logger.log(System.Logger.Level.INFO, "Send another message to Topic");
            expTextMessage = this.session.createTextMessage(message);
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", sharedSubscriptionName);
            this.producer.send((Message)expTextMessage);
            logger.log(System.Logger.Level.INFO, "Message sent");
            logger.log(System.Logger.Level.INFO, "Receive TextMessage from consumer2");
            actTextMessage = (TextMessage)this.consumer2.receive(this.timeout);
            if (actTextMessage == null) {
                logger.log(System.Logger.Level.ERROR, "Did not receive TextMessage");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Check the value in TextMessage");
                if (actTextMessage.getText().equals(expTextMessage.getText())) {
                    logger.log(System.Logger.Level.INFO, "TextMessage is correct");
                } else {
                    logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText());
                    pass = false;
                }
            }
            logger.log(System.Logger.Level.INFO, "Attempt to Receive TextMessage from consumer1 - there should be none");
            actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage != null) {
                throw new Exception("Did receive TextMessage - unexpected.");
            }
            logger.log(System.Logger.Level.INFO, "Did not receive TextMessage - expected.");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            e.printStackTrace();
            throw new Exception("createSharedConsumerTopicTest1", e);
        }
        finally {
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                }
                if (this.consumer2 != null) {
                    this.consumer2.close();
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.INFO, "Ignoring exception closing consumers: " + e);
            }
        }
        if (!pass) {
            throw new Exception("createSharedConsumerTopicTest1 failed");
        }
    }

    @Test
    public void createSharedConsumerTopicTest2() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        String sharedSubscriptionName = "createSharedConsumerTopicTest2";
        try {
            this.setupGlobalVarsT();
            logger.log(System.Logger.Level.INFO, "Create a shared non-durable Subscription and a MessageConsumer for it");
            this.consumer.close();
            this.consumer = this.session.createSharedConsumer(this.topic, sharedSubscriptionName, "lastMessage = TRUE");
            logger.log(System.Logger.Level.INFO, "Create a second MessageConsumer for the Subscription");
            this.consumer2 = this.session.createSharedConsumer(this.topic, sharedSubscriptionName, "lastMessage = TRUE");
            logger.log(System.Logger.Level.INFO, "Send 3 to Topic");
            for (int i = 1; i <= 3; ++i) {
                TextMessage tempMsg = this.session.createTextMessage("Message " + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", sharedSubscriptionName + i);
                if (i == 3) {
                    tempMsg.setBooleanProperty("lastMessage", true);
                } else {
                    tempMsg.setBooleanProperty("lastMessage", false);
                }
                this.producer.send((Message)tempMsg);
                logger.log(System.Logger.Level.INFO, "Message " + i + " sent");
            }
            logger.log(System.Logger.Level.INFO, "Receive TextMessage from consumer1");
            TextMessage expTextMessage = this.session.createTextMessage("Message 3");
            TextMessage actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage == null) {
                logger.log(System.Logger.Level.ERROR, "Did not receive TextMessage");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Check the value in TextMessage");
                if (actTextMessage.getText().equals(expTextMessage.getText())) {
                    logger.log(System.Logger.Level.INFO, "TextMessage is correct");
                } else {
                    logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText());
                    pass = false;
                }
            }
            logger.log(System.Logger.Level.INFO, "Attempt to Receive TextMessage from consumer2 - there should be none");
            actTextMessage = (TextMessage)this.consumer2.receive(this.timeout);
            if (actTextMessage != null) {
                throw new Exception("Did receive TextMessage - unexpected.");
            }
            logger.log(System.Logger.Level.INFO, "Did not receive TextMessage - expected.");
            logger.log(System.Logger.Level.INFO, "Send 3 to Topic");
            for (int i = 1; i <= 3; ++i) {
                TextMessage tempMsg = this.session.createTextMessage("Message " + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", sharedSubscriptionName + i);
                if (i == 3) {
                    tempMsg.setBooleanProperty("lastMessage", true);
                } else {
                    tempMsg.setBooleanProperty("lastMessage", false);
                }
                this.producer.send((Message)tempMsg);
                logger.log(System.Logger.Level.INFO, "Message " + i + " sent");
            }
            logger.log(System.Logger.Level.INFO, "Receive TextMessage from consumer2");
            expTextMessage = this.session.createTextMessage("Message 3");
            actTextMessage = (TextMessage)this.consumer2.receive(this.timeout);
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            logger.log(System.Logger.Level.INFO, "Check the value in TextMessage");
            if (actTextMessage.getText().equals(expTextMessage.getText())) {
                logger.log(System.Logger.Level.INFO, "TextMessage is correct");
            } else {
                logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText());
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Attempt to Receive TextMessage from consumer1 - there should be none");
            actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage != null) {
                throw new Exception("Did receive TextMessage - unexpected.");
            }
            logger.log(System.Logger.Level.INFO, "Did not receive TextMessage - expected.");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            e.printStackTrace();
            throw new Exception("createSharedConsumerTopicTest2", e);
        }
        finally {
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                }
                if (this.consumer2 != null) {
                    this.consumer2.close();
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.INFO, "Ignoring exception closing consumers: " + e);
            }
        }
        if (!pass) {
            throw new Exception("createSharedConsumerTopicTest2 failed");
        }
    }

    @Test
    public void createSharedDurableConsumerTopicTest1() throws Exception {
        boolean pass = true;
        String message1 = "Message1!";
        String message2 = "Message2!";
        String durableSubscriptionName = "createSharedDurableConsumerTopicTest1";
        try {
            this.toolT.getDefaultConnection().close();
            this.toolT.closeAllResources();
            this.toolT2 = new JmsTool(14, this.user, this.password, lookupDurableTopicFactory, this.mode);
            this.setupGlobalVarsT2();
            TextMessage expTextMessage = null;
            logger.log(System.Logger.Level.INFO, "Create a shared Durable Subscription and 1st JMSConsumer for it");
            this.consumer = this.session.createSharedDurableConsumer(this.topic, durableSubscriptionName);
            logger.log(System.Logger.Level.INFO, "Create 2nd JMSConsumer for it");
            this.consumer2 = this.session.createSharedDurableConsumer(this.topic, durableSubscriptionName);
            logger.log(System.Logger.Level.INFO, "Send TextMessage message1 to Topic");
            expTextMessage = this.session.createTextMessage(message1);
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "createSharedDurableConsumerTopicTest1");
            this.producer.send((Message)expTextMessage);
            logger.log(System.Logger.Level.INFO, "TextMessage message1 sent");
            logger.log(System.Logger.Level.INFO, "Receive TextMessage message1 from consumer1");
            TextMessage actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage == null) {
                logger.log(System.Logger.Level.ERROR, "Did not receive TextMessage");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Check the value in TextMessage message1");
                if (actTextMessage.getText().equals(expTextMessage.getText())) {
                    logger.log(System.Logger.Level.INFO, "TextMessage is correct");
                } else {
                    logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText());
                    pass = false;
                }
            }
            logger.log(System.Logger.Level.INFO, "Close 1st shared durable JMSConsumer");
            this.consumer.close();
            logger.log(System.Logger.Level.INFO, "Send TextMessage message2 to Topic");
            expTextMessage = this.session.createTextMessage(message2);
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "createSharedDurableConsumerTopicTest1");
            this.producer.send((Message)expTextMessage);
            logger.log(System.Logger.Level.INFO, "TextMessage message2 sent");
            logger.log(System.Logger.Level.INFO, "Receive TextMessage message2 from consumer2");
            actTextMessage = (TextMessage)this.consumer2.receive(this.timeout);
            if (actTextMessage == null) {
                logger.log(System.Logger.Level.ERROR, "Did not receive TextMessage");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Check the value in TextMessage message2");
                if (actTextMessage.getText().equals(expTextMessage.getText())) {
                    logger.log(System.Logger.Level.INFO, "TextMessage is correct");
                } else {
                    logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText());
                    pass = false;
                }
            }
            logger.log(System.Logger.Level.INFO, "Now there should be no more messages to receive from topic");
            logger.log(System.Logger.Level.INFO, "Recreate Durable Subscription and 1st JMSConsumer for it");
            this.consumer = this.session.createSharedDurableConsumer(this.topic, durableSubscriptionName);
            logger.log(System.Logger.Level.INFO, "Try and receive a message from consumer1 (should get NONE)");
            actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage != null) {
                logger.log(System.Logger.Level.ERROR, "Consumer1 received a message (FAIL)");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Consumer1 didn't receive a message (PASS)");
            }
            logger.log(System.Logger.Level.INFO, "Try and receive a message from consumer2 (should get NONE)");
            actTextMessage = (TextMessage)this.consumer2.receive(this.timeout);
            if (actTextMessage != null) {
                logger.log(System.Logger.Level.ERROR, "Consumer2 received a message (FAIL)");
                pass = false;
                throw new Exception("Consumer2 received a message (FAIL)");
            }
            logger.log(System.Logger.Level.INFO, "Consumer2 didn't receive a message (PASS)");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            e.printStackTrace();
            throw new Exception("createSharedDurableConsumerTopicTest1", e);
        }
        finally {
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                }
                this.cleanupSubscription(this.consumer2, this.session, durableSubscriptionName);
                this.toolT2.getDefaultConnection().close();
                this.toolT2.closeAllResources();
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            }
        }
        if (!pass) {
            throw new Exception("createSharedDurableConsumerTopicTest1 failed");
        }
    }

    @Test
    public void createSharedDurableConsumerTopicTest2() throws Exception {
        boolean pass = true;
        String durableSubscriptionName = "createSharedDurableConsumerTopicTest2";
        try {
            this.toolT.getDefaultConnection().close();
            this.toolT.closeAllResources();
            this.toolT2 = new JmsTool(14, this.user, this.password, lookupDurableTopicFactory, this.mode);
            this.setupGlobalVarsT2();
            logger.log(System.Logger.Level.INFO, "Create shared Durable Subscription and 1st JMSConsumer with message selector");
            this.consumer = this.session.createSharedDurableConsumer(this.topic, durableSubscriptionName, "lastMessage = TRUE");
            logger.log(System.Logger.Level.INFO, "Create 2nd JMSConsumer with message selector");
            this.consumer2 = this.session.createSharedDurableConsumer(this.topic, durableSubscriptionName, "lastMessage = TRUE");
            logger.log(System.Logger.Level.INFO, "Send 3 messages to Topic");
            for (int i = 1; i <= 3; ++i) {
                TextMessage tempMsg = this.session.createTextMessage("Message " + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "createSharedDurableConsumerTopicTest2" + i);
                if (i == 3) {
                    tempMsg.setBooleanProperty("lastMessage", true);
                } else {
                    tempMsg.setBooleanProperty("lastMessage", false);
                }
                this.producer.send((Message)tempMsg);
                logger.log(System.Logger.Level.INFO, "Message " + i + " sent");
            }
            logger.log(System.Logger.Level.INFO, "Receive TextMessage from consumer1");
            TextMessage expTextMessage = this.session.createTextMessage("Message 3");
            TextMessage actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage == null) {
                logger.log(System.Logger.Level.ERROR, "Did not receive TextMessage");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Check the value in TextMessage");
                if (actTextMessage.getText().equals(expTextMessage.getText())) {
                    logger.log(System.Logger.Level.INFO, "TextMessage is correct");
                } else {
                    logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText());
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            e.printStackTrace();
            throw new Exception("createSharedDurableConsumerTopicTest2", e);
        }
        finally {
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                }
                this.cleanupSubscription(this.consumer2, this.session, durableSubscriptionName);
                this.toolT2.getDefaultConnection().close();
                this.toolT2.closeAllResources();
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            }
        }
        if (!pass) {
            throw new Exception("createSharedDurableConsumerTopicTest2 failed");
        }
    }

    @Test
    public void createSharedDurableConsumerTopicTest3() throws Exception {
        boolean pass = true;
        String message1 = "Message1!";
        String message2 = "Message2!";
        String durableSubscriptionName = "createSharedDurableConsumerTopicTest3";
        try {
            this.setupGlobalVarsT();
            TextMessage expTextMessage = null;
            logger.log(System.Logger.Level.INFO, "Create a shared Durable Subscription and 1st JMSConsumer for it");
            this.consumer = this.session.createSharedDurableConsumer(this.topic, durableSubscriptionName);
            logger.log(System.Logger.Level.INFO, "Create 2nd JMSConsumer for it");
            this.consumer2 = this.session.createSharedDurableConsumer(this.topic, durableSubscriptionName);
            logger.log(System.Logger.Level.INFO, "Send TextMessage message1 to Topic");
            expTextMessage = this.session.createTextMessage(message1);
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "createSharedDurableConsumerTopicTest3");
            this.producer.send((Message)expTextMessage);
            logger.log(System.Logger.Level.INFO, "TextMessage message1 sent");
            logger.log(System.Logger.Level.INFO, "Receive TextMessage message1 from consumer1");
            TextMessage actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage == null) {
                logger.log(System.Logger.Level.ERROR, "Did not receive TextMessage");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Check the value in TextMessage message1");
                if (actTextMessage.getText().equals(expTextMessage.getText())) {
                    logger.log(System.Logger.Level.INFO, "TextMessage is correct");
                } else {
                    logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText());
                    pass = false;
                }
            }
            logger.log(System.Logger.Level.INFO, "Close 1st shared durable JMSConsumer");
            this.consumer.close();
            logger.log(System.Logger.Level.INFO, "Send TextMessage message2 to Topic");
            expTextMessage = this.session.createTextMessage(message2);
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "createSharedDurableConsumerTopicTest3");
            this.producer.send((Message)expTextMessage);
            logger.log(System.Logger.Level.INFO, "TextMessage message2 sent");
            logger.log(System.Logger.Level.INFO, "Receive TextMessage message2 from consumer2");
            actTextMessage = (TextMessage)this.consumer2.receive(this.timeout);
            if (actTextMessage == null) {
                logger.log(System.Logger.Level.ERROR, "Did not receive TextMessage");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Check the value in TextMessage message2");
                if (actTextMessage.getText().equals(expTextMessage.getText())) {
                    logger.log(System.Logger.Level.INFO, "TextMessage is correct");
                } else {
                    logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText());
                    pass = false;
                }
            }
            logger.log(System.Logger.Level.INFO, "Now there should be no more messages to receive from topic");
            logger.log(System.Logger.Level.INFO, "Recreate Durable Subscription and 1st JMSConsumer for it");
            this.consumer = this.session.createSharedDurableConsumer(this.topic, durableSubscriptionName);
            logger.log(System.Logger.Level.INFO, "Try and receive a message from consumer1 (should get NONE)");
            actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage != null) {
                logger.log(System.Logger.Level.ERROR, "Consumer1 received a message (FAIL)");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Consumer1 didn't receive a message (PASS)");
            }
            logger.log(System.Logger.Level.INFO, "Try and receive a message from consumer2 (should get NONE)");
            actTextMessage = (TextMessage)this.consumer2.receive(this.timeout);
            if (actTextMessage != null) {
                logger.log(System.Logger.Level.ERROR, "Consumer2 received a message (FAIL)");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Consumer2 didn't receive a message (PASS)");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            e.printStackTrace();
            throw new Exception("createSharedDurableConsumerTopicTest3", e);
        }
        finally {
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                }
                this.cleanupSubscription(this.consumer2, this.session, durableSubscriptionName);
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new Exception("createSharedDurableConsumerTopicTest3 failed");
        }
    }

    @Test
    public void invalidDestinationExceptionTests() throws Exception {
        boolean pass = true;
        Object invalidDestination = null;
        Topic invalidTopic = null;
        try {
            this.toolT.getDefaultConnection().close();
            this.toolT.closeAllResources();
            this.toolT2 = new JmsTool(14, this.user, this.password, lookupDurableTopicFactory, this.mode);
            this.setupGlobalVarsT2();
            logger.log(System.Logger.Level.INFO, "Testing Session.createDurableSubscriber(Topic, String) for InvalidDestinationException");
            try {
                logger.log(System.Logger.Level.INFO, "Calling Session.createDurableSubscriber(Topic, String) -> expect InvalidDestinationException");
                this.session.createDurableSubscriber(invalidTopic, "InvalidDestinationException");
            }
            catch (InvalidDestinationException e) {
                logger.log(System.Logger.Level.INFO, "Got InvalidDestinationException as expected.");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected InvalidDestinationException, received " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Testing Session.createDurableSubscriber(Topic, String, String, boolean) for InvalidDestinationException");
            try {
                logger.log(System.Logger.Level.INFO, "Calling Session.createDurableSubscriber(Topic, String, String, boolean) -> expect InvalidDestinationException");
                this.session.createDurableSubscriber(invalidTopic, "InvalidDestinationException", "lastMessage = TRUE", false);
            }
            catch (InvalidDestinationException e) {
                logger.log(System.Logger.Level.INFO, "Got InvalidDestinationException as expected.");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected InvalidDestinationException, received " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Testing Session.createDurableConsumer(Topic, String) for InvalidDestinationException");
            try {
                logger.log(System.Logger.Level.INFO, "Calling Session.createDurableConsumer(Topic, String) -> expect InvalidDestinationException");
                this.session.createDurableConsumer(invalidTopic, "InvalidDestinationException");
            }
            catch (InvalidDestinationException e) {
                logger.log(System.Logger.Level.INFO, "Got InvalidDestinationException as expected.");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected InvalidDestinationException, received " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Testing Session.createDurableConsumer(Topic, String, String, boolean) for InvalidDestinationException");
            try {
                logger.log(System.Logger.Level.INFO, "Calling Session.createDurableConsumer(Topic, String, String, boolean) -> expect InvalidDestinationException");
                this.session.createDurableConsumer(invalidTopic, "InvalidDestinationException", "lastMessage = TRUE", false);
            }
            catch (InvalidDestinationException e) {
                logger.log(System.Logger.Level.INFO, "Got InvalidDestinationException as expected.");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected InvalidDestinationException, received " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Testing Session.createSharedConsumer(Topic, String) for InvalidDestinationException");
            try {
                logger.log(System.Logger.Level.INFO, "Calling Session.createSharedConsumer(Topic, String) for InvalidDestinationException");
                this.session.createSharedConsumer(invalidTopic, "InvalidDestinationException");
            }
            catch (InvalidDestinationException e) {
                logger.log(System.Logger.Level.INFO, "Got InvalidDestinationException as expected.");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected InvalidDestinationException, received " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Testing Session.createSharedConsumer(Topic, String, String) for InvalidDestinationException");
            try {
                logger.log(System.Logger.Level.INFO, "Calling Session.createSharedConsumer(Topic, String, String) for InvalidDestinationException");
                this.session.createSharedConsumer(invalidTopic, "InvalidDestinationException", "lastMessage = TRUE");
            }
            catch (InvalidDestinationException e) {
                logger.log(System.Logger.Level.INFO, "Got InvalidDestinationException as expected.");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected InvalidDestinationException, received " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Testing Session.createSharedDurableConsumer(Topic, String) for InvalidDestinationException");
            try {
                logger.log(System.Logger.Level.INFO, "Calling Session.createSharedDurableConsumer(Topic, String) -> expect InvalidDestinationException");
                this.session.createSharedDurableConsumer(invalidTopic, "InvalidDestinationException");
            }
            catch (InvalidDestinationException e) {
                logger.log(System.Logger.Level.INFO, "Got InvalidDestinationException as expected.");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected InvalidDestinationException, received " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Testing Session.createSharedDurableConsumer(Topic, String, String) for InvalidDestinationException");
            try {
                logger.log(System.Logger.Level.INFO, "Calling Session.createSharedDurableConsumer(Topic, String, String) -> expect InvalidDestinationException");
                this.session.createSharedDurableConsumer(invalidTopic, "InvalidDestinationException", "lastMessage = TRUE");
            }
            catch (InvalidDestinationException e) {
                logger.log(System.Logger.Level.INFO, "Got InvalidDestinationException as expected.");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected InvalidDestinationException, received " + e);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            throw new Exception("invalidDestinationExceptionTests", e);
        }
        if (!pass) {
            throw new Exception("invalidDestinationExceptionTests failed");
        }
    }

    @Test
    public void invalidSelectorExceptionTopicTests() throws Exception {
        boolean pass = true;
        String invalidMessageSelector = "=TEST 'test'";
        try {
            this.toolT.getDefaultConnection().close();
            this.toolT.closeAllResources();
            this.toolT2 = new JmsTool(14, this.user, this.password, lookupDurableTopicFactory, this.mode);
            this.setupGlobalVarsT2();
            logger.log(System.Logger.Level.INFO, "Testing Session.createDurableConsumer(Topic, String, String, boolean) for InvalidSelectorException");
            try {
                logger.log(System.Logger.Level.INFO, "Calling Session.createDurableConsumer(Topic, String, String, boolean) -> expect InvalidSelectorException");
                this.session.createDurableConsumer(this.topic, "InvalidSelectorException", invalidMessageSelector, false);
            }
            catch (InvalidSelectorException e) {
                logger.log(System.Logger.Level.INFO, "Got InvalidSelectorException as expected.");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected InvalidSelectorException, received " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Testing Session.createSharedConsumer(Topic, String, String) for InvalidSelectorException");
            try {
                logger.log(System.Logger.Level.INFO, "Calling Session.createSharedConsumer(Topic, String, String) for InvalidSelectorException");
                this.session.createSharedConsumer(this.topic, "InvalidSelectorException", invalidMessageSelector);
            }
            catch (InvalidSelectorException e) {
                logger.log(System.Logger.Level.INFO, "Got InvalidSelectorException as expected.");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected InvalidSelectorException, received " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Testing Session.createSharedDurableConsumer(Topic, String, String) for InvalidSelectorException");
            try {
                logger.log(System.Logger.Level.INFO, "Calling Session.createSharedDurableConsumer(Topic, String, String) -> expect InvalidSelectorException");
                this.session.createSharedDurableConsumer(this.topic, "InvalidSelectorException", invalidMessageSelector);
            }
            catch (InvalidSelectorException e) {
                logger.log(System.Logger.Level.INFO, "Got InvalidSelectorException as expected.");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected InvalidSelectorException, received " + e);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            throw new Exception("invalidSelectorExceptionTopicTests", e);
        }
        if (!pass) {
            throw new Exception("invalidSelectorExceptionTopicTests failed");
        }
    }

    @Test
    public void illegalStateExceptionTests() throws Exception {
        JmsTool toolq = null;
        String lookupNormalTopicFactory = lookupNormalTopicFactory;
        boolean pass = true;
        MessageConsumer consumer = null;
        TopicSubscriber subscriber = null;
        try {
            toolq = new JmsTool(0, this.user, this.password, this.mode);
            Destination destination = this.toolT.getDefaultDestination();
            Topic topic = (Topic)destination;
            try {
                logger.log(System.Logger.Level.INFO, "Calling QueueSession.createDurableConsumer(Topic, String)");
                toolq.getDefaultQueueSession().createDurableConsumer(topic, "mySub1");
                pass = false;
                logger.log(System.Logger.Level.ERROR, "QueueSession.createDurableConsumer(Topic, String) didn't throw expected IllegalStateException.");
            }
            catch (IllegalStateException ex) {
                logger.log(System.Logger.Level.INFO, "Got expected IllegalStateException from QueueSession.createDurableConsumer(Topic, String)");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                pass = false;
            }
            try {
                logger.log(System.Logger.Level.INFO, "Calling QueueSession.createDurableConsumer(Topic, String, String, boolean)");
                toolq.getDefaultQueueSession().createDurableConsumer(topic, "mySub1", "TEST = 'test'", false);
                pass = false;
                logger.log(System.Logger.Level.ERROR, "QueueSession.createDurableConsumer(Topic, String, String, boolean) didn't throw expected IllegalStateException.");
            }
            catch (IllegalStateException ex) {
                logger.log(System.Logger.Level.INFO, "Got expected IllegalStateException from QueueSession.createDurableConsumer(Topic, String, String, boolean)");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                pass = false;
            }
            try {
                logger.log(System.Logger.Level.INFO, "Calling QueueSession.createSharedConsumer(Topic, String)");
                toolq.getDefaultQueueSession().createSharedConsumer(topic, "mySub1");
                pass = false;
                logger.log(System.Logger.Level.ERROR, "QueueSession.createSharedConsumer(Topic, String) didn't throw expected IllegalStateException.");
            }
            catch (IllegalStateException ex) {
                logger.log(System.Logger.Level.INFO, "Got expected IllegalStateException from QueueSession.createSharedConsumer(Topic, String)");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                pass = false;
            }
            try {
                logger.log(System.Logger.Level.INFO, "Calling QueueSession.createSharedConsumer(Topic, String, String)");
                toolq.getDefaultQueueSession().createSharedConsumer(topic, "mySub1", "TEST = 'test'");
                pass = false;
                logger.log(System.Logger.Level.ERROR, "QueueSession.createSharedConsumer(Topic, String, String) didn't throw expected IllegalStateException.");
            }
            catch (IllegalStateException ex) {
                logger.log(System.Logger.Level.INFO, "Got expected IllegalStateException from QueueSession.createSharedConsumer(Topic, String, String)");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                pass = false;
            }
            try {
                logger.log(System.Logger.Level.INFO, "Calling QueueSession.createSharedDurableConsumer(Topic, String)");
                toolq.getDefaultQueueSession().createSharedDurableConsumer(topic, "mySub1");
                pass = false;
                logger.log(System.Logger.Level.ERROR, "QueueSession.createSharedDurableConsumer(Topic, String) didn't throw expected IllegalStateException.");
            }
            catch (IllegalStateException ex) {
                logger.log(System.Logger.Level.INFO, "Got expected IllegalStateException from QueueSession.createSharedDurableConsumer(Topic, String)");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                pass = false;
            }
            try {
                logger.log(System.Logger.Level.INFO, "Calling QueueSession.createSharedDurableConsumer(Topic, String, String)");
                toolq.getDefaultQueueSession().createSharedDurableConsumer(topic, "mySub1", "TEST = 'test'");
                pass = false;
                logger.log(System.Logger.Level.ERROR, "QueueSession.createSharedDurableConsumer(Topic, String, String) didn't throw expected IllegalStateException.");
            }
            catch (IllegalStateException ex) {
                logger.log(System.Logger.Level.INFO, "Got expected IllegalStateException from QueueSession.createSharedDurableConsumer(Topic, String, String)");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                pass = false;
            }
            try {
                logger.log(System.Logger.Level.INFO, "Create a Durable Subscriber with clientid unset (expect IllegalStateException");
                logger.log(System.Logger.Level.INFO, "Calling Session.createDurableSubscriber(Topic, String)");
                subscriber = this.toolT.getDefaultSession().createDurableSubscriber(topic, "mySub1");
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Session.createDurableSubscriber(Topic, String) didn't throw expected IllegalStateException.");
                try {
                    subscriber.close();
                    this.toolT.getDefaultSession().unsubscribe("mySub1");
                }
                catch (Exception e) {}
            }
            catch (IllegalStateException ex) {
                logger.log(System.Logger.Level.INFO, "Got expected IllegalStateException from Session.createDurableSubscriber(Topic, String)");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                pass = false;
            }
            try {
                logger.log(System.Logger.Level.INFO, "Create a Durable Subscriber with noLocal=true and clientid unset (expect IllegalStateException");
                logger.log(System.Logger.Level.INFO, "Calling Session.createDurableSubscriber(Topic, String, String, boolean)");
                subscriber = this.toolT.getDefaultSession().createDurableSubscriber(topic, "mySub1", "TEST = 'test'", true);
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Session.createDurableSubscriber(Topic, String, String, boolean) didn't throw expected IllegalStateException.");
                try {
                    subscriber.close();
                    this.toolT.getDefaultSession().unsubscribe("mySub1");
                }
                catch (Exception e) {}
            }
            catch (IllegalStateException ex) {
                logger.log(System.Logger.Level.INFO, "Got expected IllegalStateException from Session.createDurableSubscriber(Topic, String, String, boolean)");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                pass = false;
            }
            try {
                logger.log(System.Logger.Level.INFO, "Create a Durable Consumer with clientid unset (expect IllegalStateException");
                logger.log(System.Logger.Level.INFO, "Calling Session.createDurableConsumer(Topic, String)");
                consumer = this.toolT.getDefaultSession().createDurableConsumer(topic, "mySub1");
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Session.createDurableConsumer(Topic, String) didn't throw expected IllegalStateException.");
                try {
                    consumer.close();
                    this.toolT.getDefaultSession().unsubscribe("mySub1");
                }
                catch (Exception e) {}
            }
            catch (IllegalStateException ex) {
                logger.log(System.Logger.Level.INFO, "Got expected IllegalStateException from Session.createDurableConsumer(Topic, String)");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                pass = false;
            }
            try {
                logger.log(System.Logger.Level.INFO, "Create a Durable Consumer with noLocal=true and clientid unset (expect IllegalStateException");
                logger.log(System.Logger.Level.INFO, "Calling Session.createDurableConsumer(Topic, String, String, boolean)");
                consumer = this.toolT.getDefaultSession().createDurableConsumer(topic, "mySub1", "TEST = 'test'", true);
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Session.createDurableConsumer(Topic, String, String, boolean) didn't throw expected IllegalStateException.");
                try {
                    consumer.close();
                    this.toolT.getDefaultSession().unsubscribe("mySub1");
                }
                catch (Exception e) {
                }
            }
            catch (IllegalStateException ex) {
                logger.log(System.Logger.Level.INFO, "Got expected IllegalStateException from Session.createDurableConsumer(Topic, String, String, boolean)");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            throw new Exception("illegalStateExceptionTests Failed");
        }
        finally {
            try {
                toolq.getDefaultQueueConnection().close();
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                pass = false;
            }
        }
        if (!pass) {
            throw new Exception("illegalStateExceptionTests Failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void jMSExceptionTests() throws Exception {
        boolean pass = true;
        JmsTool toolt = null;
        Topic mytopic = null;
        try {
            this.setupGlobalVarsT();
            mytopic = this.toolT.createNewTopic("MY_TOPIC2");
            toolt = new JmsTool(1, this.user, this.password, lookupNormalTopicFactory, this.mode);
            try {
                logger.log(System.Logger.Level.INFO, "Create a Durable TopicSubscriber with noLocal=true and clientid unset (expect JMSException");
                logger.log(System.Logger.Level.INFO, "Calling TopicSession.createDurableSubscriber(Topic, String, String, boolean)");
                this.subscriber = toolt.getDefaultTopicSession().createDurableSubscriber(this.topic, "mySub1", "TEST = 'test'", true);
                pass = false;
                logger.log(System.Logger.Level.ERROR, "TopicSession.createDurableSubscriber(Topic, String, String, boolean) didn't throw expected JMSException.");
            }
            catch (JMSException ex) {
                logger.log(System.Logger.Level.INFO, "Got expected JMSException from TopicSession.createDurableSubscriber(Topic, String, String, boolean)");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                pass = false;
            }
            finally {
                try {
                    if (this.subscriber != null) {
                        this.subscriber.close();
                    }
                    toolt.getDefaultTopicConnection().close();
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                    pass = false;
                }
            }
            try {
                logger.log(System.Logger.Level.INFO, "Create a Durable Consumer with noLocal=true and clientid unset (expect JMSException");
                logger.log(System.Logger.Level.INFO, "Calling Session.createDurableConsumer(Topic, String, String, boolean)");
                this.consumer = null;
                this.consumer = this.session.createDurableConsumer(this.topic, "mySub1", "TEST = 'test'", true);
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Session.createDurableConsumer(Topic, String, String, boolean) didn't throw expected JMSException.");
            }
            catch (JMSException ex) {
                logger.log(System.Logger.Level.INFO, "Got expected JMSException from Session.createDurableConsumer(Topic, String, String, boolean)");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                pass = false;
            }
            finally {
                try {
                    if (this.consumer != null) {
                        this.consumer.close();
                    }
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                    pass = false;
                }
            }
            try {
                logger.log(System.Logger.Level.INFO, "Create a Durable TopicSubscriber with noLocal=true and clientid unset (expect JMSException");
                logger.log(System.Logger.Level.INFO, "Calling Session.createDurableSubscriber(Topic, String, String, boolean)");
                this.subscriber = null;
                this.subscriber = this.session.createDurableSubscriber(this.topic, "mySub1", "TEST = 'test'", true);
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Session.createDurableSubscriber(Topic, String, String, boolean) didn't throw expected JMSException.");
            }
            catch (JMSException ex) {
                logger.log(System.Logger.Level.INFO, "Got expected JMSException from Session.createDurableSubscriber(Topic, String, String, boolean)");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                pass = false;
            }
            finally {
                try {
                    if (this.subscriber != null) {
                        this.subscriber.close();
                    }
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            throw new Exception("jMSExceptionTests Failed");
        }
        try {
            this.toolT.getDefaultConnection().close();
            this.toolT.closeAllResources();
            this.toolT2 = new JmsTool(14, this.user, this.password, lookupDurableTopicFactory, this.mode);
            this.setupGlobalVarsT2();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            throw new Exception("jMSExceptionTests Failed");
        }
        try {
            logger.log(System.Logger.Level.INFO, "Create durable subscriber");
            logger.log(System.Logger.Level.INFO, "Calling Session.createDurableSubscriber(Topic, String)");
            this.subscriber2 = null;
            this.subscriber = null;
            this.subscriber = this.session.createDurableSubscriber(this.topic, "dummySubSCJMSException");
            logger.log(System.Logger.Level.INFO, "Create second durable subscriber with same name but different topic");
            logger.log(System.Logger.Level.INFO, "Calling Session.createDurableSubscriber(Topic, String)");
            this.subscriber2 = this.session.createDurableSubscriber(mytopic, "dummySubSCJMSException");
            logger.log(System.Logger.Level.INFO, "Verify that JMSException is thrown");
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Didn't throw expected JMSException");
        }
        catch (JMSException ex) {
            logger.log(System.Logger.Level.INFO, "Got expected JMSException from Session.createDurableSubscriber(Topic, String)");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            pass = false;
        }
        finally {
            try {
                if (this.subscriber != null) {
                    this.subscriber.close();
                }
                if (this.subscriber2 != null) {
                    this.subscriber2.close();
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            }
        }
        try {
            logger.log(System.Logger.Level.INFO, "Create durable subscriber");
            logger.log(System.Logger.Level.INFO, "Calling Session.createDurableSubscriber(Topic, String, String, boolean)");
            this.subscriber2 = null;
            this.subscriber = null;
            this.subscriber = this.session.createDurableSubscriber(this.topic, "dummySubSCJMSException", "TEST = 'test'", false);
            logger.log(System.Logger.Level.INFO, "Create second durable subscriber with same name but different topic");
            logger.log(System.Logger.Level.INFO, "Calling Session.createDurableSubscriber(Topic, String, String, boolean)");
            this.subscriber2 = this.session.createDurableSubscriber(mytopic, "dummySubSCJMSException", "TEST = 'test'", false);
            logger.log(System.Logger.Level.INFO, "Verify that JMSException is thrown");
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Didn't throw expected JMSException");
        }
        catch (JMSException ex) {
            logger.log(System.Logger.Level.INFO, "Got expected JMSException from Session.createDurableSubscriber(Topic, String, String, boolean)");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            pass = false;
        }
        finally {
            try {
                if (this.subscriber != null) {
                    this.subscriber.close();
                }
                if (this.subscriber2 != null) {
                    this.subscriber2.close();
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            }
        }
        try {
            logger.log(System.Logger.Level.INFO, "Create shared consumer");
            logger.log(System.Logger.Level.INFO, "Calling Session.createSharedConsumer(Topic, String)");
            this.consumer2 = null;
            this.consumer = null;
            this.consumer = this.session.createSharedConsumer(this.topic, "dummySubSCJMSException");
            logger.log(System.Logger.Level.INFO, "Create second shared consumer with same name but different topic");
            logger.log(System.Logger.Level.INFO, "Calling Session.createSharedConsumer(Topic, String)");
            this.consumer2 = this.session.createSharedConsumer(mytopic, "dummySubSCJMSException");
            logger.log(System.Logger.Level.INFO, "Verify that JMSException is thrown");
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Didn't throw expected JMSException");
        }
        catch (JMSException ex) {
            logger.log(System.Logger.Level.INFO, "Got expected JMSException from Session.createSharedConsumer(Topic, String)");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            pass = false;
        }
        finally {
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                }
                if (this.consumer2 != null) {
                    this.consumer2.close();
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            }
        }
        try {
            logger.log(System.Logger.Level.INFO, "Create shared consumer");
            logger.log(System.Logger.Level.INFO, "Calling Session.createSharedConsumer(Topic, String, String)");
            this.consumer2 = null;
            this.consumer = null;
            this.consumer = this.session.createSharedConsumer(this.topic, "dummySubSCJMSException", "TEST = 'test'");
            logger.log(System.Logger.Level.INFO, "Create second shared consumer with same name but different topic");
            logger.log(System.Logger.Level.INFO, "Calling Session.createSharedConsumer(Topic, String, String)");
            this.consumer2 = this.session.createSharedConsumer(mytopic, "dummySubSCJMSException", "TEST = 'test'");
            logger.log(System.Logger.Level.INFO, "Verify that JMSException is thrown");
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Didn't throw expected JMSException");
        }
        catch (JMSException ex) {
            logger.log(System.Logger.Level.INFO, "Got expected JMSException from Session.createSharedConsumer(Topic, String, String)");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            pass = false;
        }
        finally {
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                }
                if (this.consumer2 != null) {
                    this.consumer2.close();
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            }
        }
        try {
            logger.log(System.Logger.Level.INFO, "Create shared durable subscription");
            logger.log(System.Logger.Level.INFO, "Calling Session.createSharedDurableConsumer(Topic, String, String)");
            this.consumer2 = null;
            this.consumer = null;
            this.consumer = this.session.createSharedDurableConsumer(this.topic, "dummySubSJMSException", "TEST = 'test'");
            logger.log(System.Logger.Level.INFO, "Create second shared durable subscription with same name but different other args");
            logger.log(System.Logger.Level.INFO, "Calling Session.createSharedDurableConsumer(Topic, String, String)");
            this.consumer2 = this.session.createSharedDurableConsumer(mytopic, "dummySubSJMSException", "TEST = 'test2'");
            logger.log(System.Logger.Level.INFO, "Verify that JMSException is thrown");
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Didn't throw expected JMSException");
        }
        catch (JMSException ex) {
            logger.log(System.Logger.Level.INFO, "Got expected JMSException from Session.createSharedDurableConsumer(Topic, String, String)");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            pass = false;
        }
        finally {
            try {
                if (this.consumer2 != null) {
                    this.consumer2.close();
                }
                this.cleanupSubscription(this.consumer, this.session, "dummySubSJMSException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            }
        }
        try {
            logger.log(System.Logger.Level.INFO, "Create durable subscription");
            logger.log(System.Logger.Level.INFO, "Calling Session.createDurableConsumer(Topic, String)");
            this.consumer2 = null;
            this.consumer = null;
            this.consumer = this.session.createDurableConsumer(this.topic, "dummySubDJMSException");
            logger.log(System.Logger.Level.INFO, "Create second durable subscription with same name but different topic");
            logger.log(System.Logger.Level.INFO, "Calling Session.createDurableConsumer(Topic, String)");
            this.consumer2 = this.session.createDurableConsumer(mytopic, "dummySubDJMSException");
            logger.log(System.Logger.Level.INFO, "Verify that JMSException is thrown");
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Didn't throw expected JMSException");
        }
        catch (JMSException ex) {
            logger.log(System.Logger.Level.INFO, "Got expected JMSException from Session.createDurableConsumer(Topic, String)");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            pass = false;
        }
        finally {
            try {
                if (this.consumer2 != null) {
                    this.consumer2.close();
                }
                this.cleanupSubscription(this.consumer, this.session, "dummySubDJMSException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            }
        }
        try {
            logger.log(System.Logger.Level.INFO, "Create shared durable subscription");
            logger.log(System.Logger.Level.INFO, "Calling Session.createSharedDurableConsumer(Topic, String)");
            this.consumer2 = null;
            this.consumer = null;
            this.consumer = this.session.createSharedDurableConsumer(this.topic, "dummySubSDJMSException");
            logger.log(System.Logger.Level.INFO, "Create second shared durable subscription with same name but different topic");
            logger.log(System.Logger.Level.INFO, "Calling Session.createSharedDurableConsumer(Topic, String)");
            this.consumer2 = this.session.createSharedDurableConsumer(mytopic, "dummySubSDJMSException");
            logger.log(System.Logger.Level.INFO, "Verify that JMSException is thrown");
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Didn't throw expected JMSException");
        }
        catch (JMSException ex) {
            logger.log(System.Logger.Level.INFO, "Got expected JMSException from Session.createSharedDurableConsumer(Topic, String)");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            pass = false;
        }
        finally {
            try {
                if (this.consumer2 != null) {
                    this.consumer2.close();
                }
                this.cleanupSubscription(this.consumer, this.session, "dummySubSDJMSException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            }
        }
        try {
            logger.log(System.Logger.Level.INFO, "Create durable subscription");
            logger.log(System.Logger.Level.INFO, "Calling Session.createDurableConsumer(Topic, String, String, boolean)");
            this.consumer2 = null;
            this.consumer = null;
            this.consumer = this.session.createDurableConsumer(this.topic, "dummySubDJMSException", "TEST = 'test'", false);
            logger.log(System.Logger.Level.INFO, "Create second durable subscription with same name but different other args");
            logger.log(System.Logger.Level.INFO, "Calling Session.createDurableConsumer(Topic, String, String, boolean)");
            this.consumer2 = this.session.createDurableConsumer(mytopic, "dummySubDJMSException", "TEST = 'test2'", false);
            logger.log(System.Logger.Level.INFO, "Verify that JMSException is thrown");
            pass = false;
            logger.log(System.Logger.Level.ERROR, "Didn't throw expected JMSException");
        }
        catch (JMSException ex) {
            logger.log(System.Logger.Level.INFO, "Got expected JMSException from Session.createDurableConsumer(Topic, String, String, boolean)");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            pass = false;
        }
        finally {
            try {
                if (this.consumer2 != null) {
                    this.consumer2.close();
                }
                this.cleanupSubscription(this.consumer, this.session, "dummySubDJMSException");
                this.toolT.getDefaultConnection().close();
                this.toolT.closeAllResources();
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            }
        }
        if (!pass) {
            throw new Exception("jMSExceptionTests Failed");
        }
    }

    @Test
    public void sendAndRecvMsgsOfEachMsgTypeQueueTest() throws Exception {
        boolean pass = true;
        try {
            this.setupGlobalVarsQ();
            logger.log(System.Logger.Level.INFO, "Send Message");
            Message msg = this.session.createMessage();
            logger.log(System.Logger.Level.INFO, "Set some values in Message");
            msg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvMsgsOfEachMsgTypeQueueTest");
            msg.setBooleanProperty("booleanProperty", true);
            this.producer.send(msg);
            logger.log(System.Logger.Level.INFO, "Receive Message");
            Message msgRecv = this.consumer.receive(this.timeout);
            if (msgRecv == null) {
                throw new Exception("Did not receive Message");
            }
            logger.log(System.Logger.Level.INFO, "Check the values in Message");
            if (msgRecv.getBooleanProperty("booleanProperty")) {
                logger.log(System.Logger.Level.INFO, "booleanproperty is correct");
            } else {
                logger.log(System.Logger.Level.INFO, "booleanproperty is incorrect");
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Send BytesMessage");
            BytesMessage bMsg = this.session.createBytesMessage();
            logger.log(System.Logger.Level.INFO, "Set some values in BytesMessage");
            bMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvMsgsOfEachMsgTypeQueueTest");
            bMsg.writeByte((byte)1);
            bMsg.writeInt(22);
            this.producer.send((Message)bMsg);
            logger.log(System.Logger.Level.INFO, "Receive BytesMessage");
            BytesMessage bMsgRecv = (BytesMessage)this.consumer.receive(this.timeout);
            if (bMsgRecv == null) {
                throw new Exception("Did not receive BytesMessage");
            }
            logger.log(System.Logger.Level.INFO, "Check the values in BytesMessage");
            if (bMsgRecv.readByte() == 1) {
                logger.log(System.Logger.Level.INFO, "bytevalue is correct");
            } else {
                logger.log(System.Logger.Level.INFO, "bytevalue is incorrect");
                pass = false;
            }
            if (bMsgRecv.readInt() == 22) {
                logger.log(System.Logger.Level.INFO, "intvalue is correct");
            } else {
                logger.log(System.Logger.Level.INFO, "intvalue is incorrect");
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Send MapMessage");
            MapMessage mMsg = this.session.createMapMessage();
            logger.log(System.Logger.Level.INFO, "Set some values in MapMessage");
            mMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvMsgsOfEachMsgTypeQueueTest");
            mMsg.setBoolean("booleanvalue", true);
            mMsg.setInt("intvalue", 10);
            this.producer.send((Message)mMsg);
            logger.log(System.Logger.Level.INFO, "Receive MapMessage");
            MapMessage mMsgRecv = (MapMessage)this.consumer.receive(this.timeout);
            if (mMsgRecv == null) {
                throw new Exception("Did not receive MapMessage");
            }
            logger.log(System.Logger.Level.INFO, "Check the values in MapMessage");
            Enumeration list = mMsgRecv.getMapNames();
            String name = null;
            while (list.hasMoreElements()) {
                name = (String)list.nextElement();
                if (name.equals("booleanvalue")) {
                    if (mMsgRecv.getBoolean(name)) {
                        logger.log(System.Logger.Level.INFO, "booleanvalue is correct");
                        continue;
                    }
                    logger.log(System.Logger.Level.ERROR, "booleanvalue is incorrect");
                    pass = false;
                    continue;
                }
                if (name.equals("intvalue")) {
                    if (mMsgRecv.getInt(name) == 10) {
                        logger.log(System.Logger.Level.INFO, "intvalue is correct");
                        continue;
                    }
                    logger.log(System.Logger.Level.ERROR, "intvalue is incorrect");
                    pass = false;
                    continue;
                }
                logger.log(System.Logger.Level.ERROR, "Unexpected name of [" + name + "] in MapMessage");
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Send ObjectMessage");
            StringBuffer sb1 = new StringBuffer("This is a StringBuffer");
            logger.log(System.Logger.Level.INFO, "Set some values in ObjectMessage");
            ObjectMessage oMsg = this.session.createObjectMessage();
            oMsg.setObject((Serializable)sb1);
            oMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvMsgsOfEachMsgTypeQueueTest");
            this.producer.send((Message)oMsg);
            logger.log(System.Logger.Level.INFO, "Receive ObjectMessage");
            ObjectMessage oMsgRecv = (ObjectMessage)this.consumer.receive(this.timeout);
            if (oMsgRecv == null) {
                throw new Exception("Did not receive ObjectMessage");
            }
            logger.log(System.Logger.Level.INFO, "Check the value in ObjectMessage");
            StringBuffer sb2 = (StringBuffer)oMsgRecv.getObject();
            if (sb2.toString().equals(sb1.toString())) {
                logger.log(System.Logger.Level.INFO, "objectvalue is correct");
            } else {
                logger.log(System.Logger.Level.ERROR, "objectvalue is incorrect");
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Send ObjectMessage passing object as param");
            sb1 = new StringBuffer("This is a StringBuffer");
            logger.log(System.Logger.Level.INFO, "Set some values in ObjectMessage passing object as param");
            oMsg = this.session.createObjectMessage((Serializable)sb1);
            oMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvMsgsOfEachMsgTypeQueueTest");
            this.producer.send((Message)oMsg);
            logger.log(System.Logger.Level.INFO, "Receive ObjectMessage");
            oMsgRecv = (ObjectMessage)this.consumer.receive(this.timeout);
            if (oMsgRecv == null) {
                throw new Exception("Did not receive ObjectMessage");
            }
            logger.log(System.Logger.Level.INFO, "Check the value in ObjectMessage");
            sb2 = (StringBuffer)oMsgRecv.getObject();
            if (sb2.toString().equals(sb1.toString())) {
                logger.log(System.Logger.Level.INFO, "objectvalue is correct");
            } else {
                logger.log(System.Logger.Level.ERROR, "objectvalue is incorrect");
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Send StreamMessage");
            StreamMessage sMsg = this.session.createStreamMessage();
            logger.log(System.Logger.Level.INFO, "Set some values in StreamMessage");
            sMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvMsgsOfEachMsgTypeQueueTest");
            sMsg.writeBoolean(true);
            sMsg.writeInt(22);
            this.producer.send((Message)sMsg);
            logger.log(System.Logger.Level.INFO, "Receive StreamMessage");
            StreamMessage sMsgRecv = (StreamMessage)this.consumer.receive(this.timeout);
            if (sMsgRecv == null) {
                throw new Exception("Did not receive StreamMessage");
            }
            logger.log(System.Logger.Level.INFO, "Check the values in StreamMessage");
            if (sMsgRecv.readBoolean()) {
                logger.log(System.Logger.Level.INFO, "booleanvalue is correct");
            } else {
                logger.log(System.Logger.Level.INFO, "booleanvalue is incorrect");
                pass = false;
            }
            if (sMsgRecv.readInt() == 22) {
                logger.log(System.Logger.Level.INFO, "intvalue is correct");
            } else {
                logger.log(System.Logger.Level.INFO, "intvalue is incorrect");
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Send TextMessage");
            TextMessage tMsg = this.session.createTextMessage();
            logger.log(System.Logger.Level.INFO, "Set some values in MapMessage");
            tMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvMsgsOfEachMsgTypeQueueTest");
            tMsg.setText("Hello There!");
            this.producer.send((Message)tMsg);
            logger.log(System.Logger.Level.INFO, "Receive TextMessage");
            TextMessage tMsgRecv = (TextMessage)this.consumer.receive(this.timeout);
            if (tMsgRecv == null) {
                throw new Exception("Did not receive TextMessage");
            }
            logger.log(System.Logger.Level.INFO, "Check the value in TextMessage");
            if (tMsgRecv.getText().equals("Hello There!")) {
                logger.log(System.Logger.Level.INFO, "TextMessage is correct");
            } else {
                logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect");
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Send TextMessage");
            tMsg = this.session.createTextMessage("Where are you!");
            logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
            tMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvMsgsOfEachMsgTypeQueueTest");
            this.producer.send((Message)tMsg);
            logger.log(System.Logger.Level.INFO, "Receive TextMessage");
            tMsgRecv = (TextMessage)this.consumer.receive(this.timeout);
            if (tMsgRecv == null) {
                throw new Exception("Did not receive TextMessage");
            }
            logger.log(System.Logger.Level.INFO, "Check the value in TextMessage");
            if (tMsgRecv.getText().equals("Where are you!")) {
                logger.log(System.Logger.Level.INFO, "TextMessage is correct");
            } else {
                logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect");
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            e.printStackTrace();
            throw new Exception("sendAndRecvMsgsOfEachMsgTypeQueueTest", e);
        }
        if (!pass) {
            throw new Exception("sendAndRecvMsgsOfEachMsgTypeQueueTest failed");
        }
    }

    @Test
    public void createTemporayQueueTest() throws Exception {
        boolean pass = true;
        MessageConsumer tConsumer = null;
        try {
            String message = "a text message";
            this.setupGlobalVarsQ();
            logger.log(System.Logger.Level.INFO, "Creating TemporaryQueue");
            TemporaryQueue tempQueue = this.session.createTemporaryQueue();
            logger.log(System.Logger.Level.INFO, "Creating MessageConsumer");
            tConsumer = this.session.createConsumer((Destination)tempQueue);
            logger.log(System.Logger.Level.INFO, "Creating MessageProducer");
            MessageProducer tProducer = this.session.createProducer((Destination)tempQueue);
            logger.log(System.Logger.Level.INFO, "Creating TextMessage with text [" + message + "]");
            TextMessage tMsg = this.session.createTextMessage(message);
            logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
            tMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "createTemporayQueueTest");
            logger.log(System.Logger.Level.INFO, "Send TextMessage to temporaty queue");
            tProducer.send((Message)tMsg);
            logger.log(System.Logger.Level.INFO, "Receive TextMessage from temporaty queue");
            TextMessage tMsgRecv = null;
            if (tConsumer != null) {
                tMsgRecv = (TextMessage)tConsumer.receive(this.timeout);
            }
            if (tMsgRecv == null) {
                throw new Exception("Did not receive TextMessage");
            }
            logger.log(System.Logger.Level.INFO, "Check the value in TextMessage");
            if (tMsgRecv.getText().equals(message)) {
                logger.log(System.Logger.Level.INFO, "TextMessage is correct");
            } else {
                logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect");
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Attempting to delete temporary queue with an open consumer should not be allowed");
            try {
                tempQueue.delete();
                pass = false;
                logger.log(System.Logger.Level.ERROR, "TemporaryQueue.delete() didn't throw expected Exception");
            }
            catch (JMSException em) {
                logger.log(System.Logger.Level.INFO, "Received expected JMSException: ");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Received unexpected JMSException: " + e);
                pass = false;
            }
            try {
                if (tConsumer != null) {
                    tConsumer.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            logger.log(System.Logger.Level.INFO, "Attempting to delete temporary queue with no open consumer should be allowed");
            try {
                tempQueue.delete();
            }
            catch (Exception e) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Received unexpected Exception: ", (Throwable)e);
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            e.printStackTrace();
            throw new Exception("createTemporayQueueTest");
        }
        if (!pass) {
            throw new Exception("createTemporayQueueTest failed");
        }
    }

    @Test
    public void createQueueBrowserTest() throws Exception {
        boolean pass = true;
        QueueBrowser qBrowser = null;
        try {
            TextMessage tempMsg = null;
            Enumeration msgs = null;
            this.setupGlobalVarsQ();
            this.consumer.close();
            logger.log(System.Logger.Level.INFO, "Send 3 to Queue");
            for (int i = 1; i <= 3; ++i) {
                tempMsg = this.session.createTextMessage("Message " + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "createQueueBrowserTest" + i);
                if (i == 3) {
                    tempMsg.setBooleanProperty("lastMessage", true);
                } else {
                    tempMsg.setBooleanProperty("lastMessage", false);
                }
                this.producer.send((Message)tempMsg);
                logger.log(System.Logger.Level.INFO, "Message " + i + " sent");
            }
            logger.log(System.Logger.Level.INFO, "Create QueueBrowser to peek at last message in Queue using message selector");
            qBrowser = this.session.createBrowser(this.queue, "lastMessage = TRUE");
            logger.log(System.Logger.Level.INFO, "Check that browser has just the last message");
            int msgCount = 0;
            msgs = qBrowser.getEnumeration();
            while (msgs.hasMoreElements()) {
                tempMsg = (TextMessage)msgs.nextElement();
                if (!tempMsg.getText().equals("Message 3")) {
                    logger.log(System.Logger.Level.ERROR, "Found [" + tempMsg.getText() + "] in browser expected [Message 3]");
                    pass = false;
                } else {
                    logger.log(System.Logger.Level.INFO, "Found correct [Message 3] in browser");
                }
                ++msgCount;
            }
            if (msgCount != 1) {
                logger.log(System.Logger.Level.ERROR, "Found " + msgCount + " messages in browser expected 1");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Found 1 message in browser (correct)");
            }
            qBrowser.close();
            logger.log(System.Logger.Level.INFO, "Create QueueBrowser to browse all messages in the Queue");
            qBrowser = this.session.createBrowser(this.queue);
            logger.log(System.Logger.Level.INFO, "Check that browser contains all 3 messages");
            msgCount = 0;
            int msgIndex = 1;
            msgs = qBrowser.getEnumeration();
            while (msgs.hasMoreElements()) {
                tempMsg = (TextMessage)msgs.nextElement();
                if (!tempMsg.getText().equals("Message " + msgIndex)) {
                    logger.log(System.Logger.Level.ERROR, "Found [" + tempMsg.getText() + "] in browser expected [Message " + msgIndex + "]");
                    pass = false;
                }
                ++msgCount;
                ++msgIndex;
            }
            if (msgCount != 3) {
                logger.log(System.Logger.Level.ERROR, "Found " + msgCount + " messages in browser expected 3");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Found 3 messages in browser (correct)");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            e.printStackTrace();
            throw new Exception("createQueueBrowserTest");
        }
        finally {
            try {
                if (qBrowser != null) {
                    qBrowser.close();
                }
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new Exception("createQueueBrowserTest failed");
        }
    }

    @Test
    public void getTransactedQueueTest() throws Exception {
        boolean actTransacted;
        boolean pass = true;
        try {
            this.setupGlobalVarsQ();
            this.session.close();
            this.session = this.connection.createSession(1);
            boolean expTransacted = false;
            logger.log(System.Logger.Level.INFO, "Calling getTransacted and expect " + expTransacted + " to be returned");
            actTransacted = this.session.getTransacted();
            if (actTransacted != expTransacted) {
                logger.log(System.Logger.Level.ERROR, "getTransacted() returned " + actTransacted + ", expected " + expTransacted);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            throw new Exception("getTransactedQueueTest", e);
        }
        finally {
            try {
                if (this.session != null) {
                    this.session.close();
                }
            }
            catch (Exception exception) {}
        }
        if (this.vehicle.equals("appclient") || this.vehicle.equals("standalone")) {
            try {
                this.session = this.connection.createSession(0);
                boolean expTransacted = true;
                logger.log(System.Logger.Level.INFO, "Calling getTransacted and expect " + expTransacted + " to be returned");
                actTransacted = this.session.getTransacted();
                if (actTransacted != expTransacted) {
                    logger.log(System.Logger.Level.ERROR, "getTransacted() returned " + actTransacted + ", expected " + expTransacted);
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
                throw new Exception("getTransactedQueueTest", e);
            }
            finally {
                try {
                    if (this.session != null) {
                        this.session.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        if (!pass) {
            throw new Exception("getTransactedQueueTest failed");
        }
    }

    @Test
    public void getAcknowledgeModeQueueTest() throws Exception {
        int actAcknowledgeMode;
        boolean pass = true;
        try {
            this.setupGlobalVarsQ();
            this.session.close();
            this.session = this.connection.createSession(1);
            int expAcknowledgeMode = 1;
            logger.log(System.Logger.Level.INFO, "Calling getAcknowledgeMode and expect " + expAcknowledgeMode + " to be returned");
            actAcknowledgeMode = this.session.getAcknowledgeMode();
            if (actAcknowledgeMode != expAcknowledgeMode) {
                logger.log(System.Logger.Level.ERROR, "getAcknowledgeMode() returned " + actAcknowledgeMode + ", expected " + expAcknowledgeMode);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            throw new Exception("getAcknowledgeModeTopicTest", e);
        }
        finally {
            try {
                if (this.session != null) {
                    this.session.close();
                }
            }
            catch (Exception exception) {}
        }
        try {
            this.session = this.connection.createSession(3);
            int expAcknowledgeMode = 3;
            logger.log(System.Logger.Level.INFO, "Calling getAcknowledgeMode and expect " + expAcknowledgeMode + " to be returned");
            actAcknowledgeMode = this.session.getAcknowledgeMode();
            if (actAcknowledgeMode != expAcknowledgeMode) {
                logger.log(System.Logger.Level.ERROR, "getAcknowledgeMode() returned " + actAcknowledgeMode + ", expected " + expAcknowledgeMode);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            throw new Exception("getAcknowledgeModeTopicTest", e);
        }
        finally {
            try {
                if (this.session != null) {
                    this.session.close();
                }
            }
            catch (Exception exception) {}
        }
        if (this.vehicle.equals("appclient") || this.vehicle.equals("standalone")) {
            try {
                this.session = this.connection.createSession(0);
                int expAcknowledgeMode = 0;
                logger.log(System.Logger.Level.INFO, "Calling getAcknowledgeMode and expect " + expAcknowledgeMode + " to be returned");
                actAcknowledgeMode = this.session.getAcknowledgeMode();
                if (actAcknowledgeMode != expAcknowledgeMode) {
                    logger.log(System.Logger.Level.ERROR, "getAcknowledgeMode() returned " + actAcknowledgeMode + ", expected " + expAcknowledgeMode);
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
                throw new Exception("getAcknowledgeModeTopicTest", e);
            }
            finally {
                try {
                    if (this.session != null) {
                        this.session.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        if (!pass) {
            throw new Exception("getAcknowledgeModeQueueTest failed");
        }
    }

    @Test
    public void createConsumerProducerQueueTest() throws Exception {
        boolean pass = true;
        try {
            TextMessage tempMsg = null;
            Object msgs = null;
            this.setupGlobalVarsQ();
            this.consumer.close();
            logger.log(System.Logger.Level.INFO, "Send 3 messages to Queue");
            for (int i = 1; i <= 3; ++i) {
                tempMsg = this.session.createTextMessage("Message " + i);
                tempMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "createConsumerProducerQueueTest" + i);
                tempMsg.setJMSType("");
                if (i == 3) {
                    tempMsg.setBooleanProperty("lastMessage", true);
                } else {
                    tempMsg.setBooleanProperty("lastMessage", false);
                }
                this.producer.send((Message)tempMsg);
                logger.log(System.Logger.Level.INFO, "Message " + i + " sent");
            }
            logger.log(System.Logger.Level.INFO, "Create selective consumer to consume messages in Queue with boolproperty (lastMessage=TRUE)");
            this.consumer = this.session.createConsumer(this.destination, "lastMessage=TRUE");
            logger.log(System.Logger.Level.INFO, "Consume messages with selective consumer which has boolproperty (lastMessage=TRUE)");
            if (this.consumer != null) {
                tempMsg = (TextMessage)this.consumer.receive(this.timeout);
            }
            if (tempMsg == null) {
                logger.log(System.Logger.Level.ERROR, "MessageConsumer.receive() returned NULL");
                logger.log(System.Logger.Level.ERROR, "Message 3 missing from Queue");
                pass = false;
            } else if (!tempMsg.getText().equals("Message 3")) {
                logger.log(System.Logger.Level.ERROR, "Received [" + tempMsg.getText() + "] expected [Message 3]");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Received expected message: " + tempMsg.getText());
            }
            logger.log(System.Logger.Level.INFO, "Make sure selective consumer receives no more messages");
            if (this.consumer != null) {
                tempMsg = (TextMessage)this.consumer.receive(this.timeout);
            }
            if (tempMsg != null) {
                logger.log(System.Logger.Level.ERROR, "MessageConsumer.receive() returned NULL");
                logger.log(System.Logger.Level.ERROR, "MessageConsumer with selector should have returned just 1 message");
                pass = false;
            }
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                }
            }
            catch (Exception i) {
                // empty catch block
            }
            logger.log(System.Logger.Level.INFO, "Consume rest of messages with normal consumer");
            this.consumer = this.session.createConsumer(this.destination);
            for (int msgCount = 1; msgCount < 3; ++msgCount) {
                tempMsg = (TextMessage)this.consumer.receive(this.timeout);
                if (tempMsg == null) {
                    logger.log(System.Logger.Level.ERROR, "MessageConsumer.receive() returned NULL");
                    logger.log(System.Logger.Level.ERROR, "Message " + msgCount + " missing from Queue");
                    pass = false;
                    continue;
                }
                if (!tempMsg.getText().equals("Message " + msgCount)) {
                    logger.log(System.Logger.Level.ERROR, "Received [" + tempMsg.getText() + "] expected [Message " + msgCount + "]");
                    pass = false;
                    continue;
                }
                logger.log(System.Logger.Level.INFO, "Received message: " + tempMsg.getText());
            }
            logger.log(System.Logger.Level.INFO, "Make sure normal consumer receives no more messages");
            tempMsg = (TextMessage)this.consumer.receive(this.timeout);
            if (tempMsg != null) {
                logger.log(System.Logger.Level.ERROR, "MessageConsumer should have returned 2 message");
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            e.printStackTrace();
            throw new Exception("createConsumerProducerQueueTest");
        }
        finally {
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                }
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new Exception("createConsumerProducerQueueTest failed");
        }
    }
}

