/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee.mdb.mdb_msgHdrQ;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsUtil;
import jakarta.ejb.EJBException;
import jakarta.ejb.MessageDrivenBean;
import jakarta.ejb.MessageDrivenContext;
import jakarta.jms.BytesMessage;
import jakarta.jms.Destination;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class MsgBeanMsgTestHdrQ
implements MessageDrivenBean,
MessageListener {
    private Properties p = null;
    private TSNamingContext context = null;
    private MessageDrivenContext mdc = null;
    private QueueConnectionFactory qFactory = null;
    private QueueConnection qConnection = null;
    private Queue queueR = null;
    private Queue queue = null;
    private QueueSender mSender = null;
    private QueueSession qSession = null;
    private TextMessage messageSent = null;
    private StreamMessage messageSentStreamMessage = null;
    private BytesMessage messageSentBytesMessage = null;
    private MapMessage messageSentMapMessage = null;
    private ObjectMessage messageSentObjectMessage = null;
    private static final System.Logger logger = System.getLogger(MsgBeanMsgTestHdrQ.class.getName());

    public MsgBeanMsgTestHdrQ() {
        logger.log(System.Logger.Level.TRACE, "@MsgBeanMsgTestHdrQ()!");
    }

    public void ejbCreate() {
        logger.log(System.Logger.Level.TRACE, "jms.ee.mdb.mdb_msgHdrQ  - @MsgBeanMsgTestHdrQ-ejbCreate() !!");
        try {
            this.context = new TSNamingContext();
            this.qFactory = (QueueConnectionFactory)this.context.lookup("java:comp/env/jms/MyQueueConnectionFactory");
            if (this.qFactory == null) {
                logger.log(System.Logger.Level.TRACE, "qFactory error");
            }
            this.queueR = (Queue)this.context.lookup("java:comp/env/jms/MDB_QUEUE_REPLY");
            if (this.queueR == null) {
                logger.log(System.Logger.Level.TRACE, "queueR error");
            }
            this.queue = (Queue)this.context.lookup("java:comp/env/jms/MDB_QUEUE");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("MDB ejbCreate Error!", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message msg) {
        try {
            this.p = new Properties();
            JmsUtil.initHarnessProps((Message)msg, (Properties)this.p);
            logger.log(System.Logger.Level.TRACE, "from jms.ee.mdb.mdb_msgHdrQ @onMessage!" + msg);
            logger.log(System.Logger.Level.TRACE, "onMessage will run TestCase: " + msg.getStringProperty("TestCase"));
            this.qConnection = this.qFactory.createQueueConnection();
            if (this.qConnection == null) {
                throw new Exception("Null QueueConnection created");
            }
            this.qConnection.start();
            this.qSession = this.qConnection.createQueueSession(true, 0);
            Vector<Object> mVec = new Vector<Object>();
            this.messageSent = this.qSession.createTextMessage();
            mVec.addElement(this.messageSent);
            this.messageSentStreamMessage = this.qSession.createStreamMessage();
            mVec.addElement(this.messageSentStreamMessage);
            this.messageSentBytesMessage = this.qSession.createBytesMessage();
            mVec.addElement(this.messageSentBytesMessage);
            this.messageSentMapMessage = this.qSession.createMapMessage();
            mVec.addElement(this.messageSentMapMessage);
            this.messageSentObjectMessage = this.qSession.createObjectMessage();
            mVec.addElement(this.messageSentObjectMessage);
            Enumeration vNum = mVec.elements();
            while (vNum.hasMoreElements()) {
                JmsUtil.addPropsToMessage((Message)((Message)vNum.nextElement()), (Properties)this.p);
            }
            if (msg.getStringProperty("TestCase").equals("msgHdrTimeStampQTest")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running msgHdrTimeStampQTest - create the message");
                this.msgHdrTimeStampQTest();
            } else if (msg.getStringProperty("TestCase").equals("dummy")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - ignore this!");
            } else if (msg.getStringProperty("TestCase").equals("msgHdrCorlIdQTextTestCreate")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - msgHdrCorlIdQTextTestCreate!");
                this.msgHdrCorlIdQTextTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgHdrCorlIdQTextTest")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - msgHdrCorlIdQTextTest!");
                this.msgHdrCorlIdQTest(msg);
            } else if (msg.getStringProperty("TestCase").equals("msgHdrCorlIdQBytesTestCreate")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - msgHdrCorlIdQBytesTestCreate!");
                this.msgHdrCorlIdQBytesTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgHdrCorlIdQBytesTest")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage -msgHdrCorlIdQBytesTest!");
                this.msgHdrCorlIdQTest(msg);
            } else if (msg.getStringProperty("TestCase").equals("msgHdrCorlIdQMapTestCreate")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - msgHdrCorlIdQMapTestCreate!");
                this.msgHdrCorlIdQMapTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgHdrCorlIdQMapTest")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - msgHdrCorlIdQMapTest!");
                this.msgHdrCorlIdQTest(msg);
            } else if (msg.getStringProperty("TestCase").equals("msgHdrCorlIdQStreamTestCreate")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - msgHdrCorlIdQStreamTestCreate!");
                this.msgHdrCorlIdQStreamTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgHdrCorlIdQStreamTest")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - msgHdrCorlIdQStreamTest!");
                this.msgHdrCorlIdQTest(msg);
            } else if (msg.getStringProperty("TestCase").equals("msgHdrCorlIdQObjectTestCreate")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage -msgHdrCorlIdQObjectTestCreate!");
                this.msgHdrCorlIdQObjectTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgHdrCorlIdQObjectTest")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - msgHdrCorlIdQObjectTest!");
                this.msgHdrCorlIdQTest(msg);
            } else if (msg.getStringProperty("TestCase").equals("msgHdrReplyToQTestCreate")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - msgHdrReplyToQTestCreate!");
                this.msgHdrReplyToQTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgHdrReplyToQTest")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - msgHdrReplyToQTest!");
                this.msgHdrReplyToQTest(msg);
            } else if (msg.getStringProperty("TestCase").equals("msgHdrJMSTypeQTestCreate")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - msgHdrJMSTypeQTestCreate!");
                this.msgHdrJMSTypeQTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgHdrJMSTypeQTest")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - msgHdrJMSTypeQTest!");
                this.msgHdrJMSTypeQTest(msg);
            } else if (msg.getStringProperty("TestCase").equals("msgHdrJMSPriorityQTestCreate")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - msgHdrJMSPriorityQTestCreate!");
                this.msgHdrJMSPriorityQTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgHdrJMSPriorityQTest")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - msgHdrJMSPriorityQTest!");
                this.msgHdrJMSPriorityQTest(msg);
            } else if (msg.getStringProperty("TestCase").equals("msgHdrJMSExpirationQueueTestCreate")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - msgHdrJMSExpirationQueueTestCreate!");
                this.msgHdrJMSExpirationQueueTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgHdrJMSExpirationQueueTest")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - msgHdrJMSExpirationQueueTest!");
                this.msgHdrJMSExpirationQueueTest(msg);
            } else if (msg.getStringProperty("TestCase").equals("msgHdrJMSDestinationQTestCreate")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - msgHdrJMSDestinationQTestCreate!");
                this.msgHdrJMSDestinationQTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgHdrJMSDestinationQTest")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - msgHdrJMSDestinationQTest!");
                this.msgHdrJMSDestinationQTest(msg);
            } else if (msg.getStringProperty("TestCase").equals("msgHdrJMSDeliveryModeQTestCreate")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - msgHdrJMSDeliveryModeQTestCreate!");
                this.msgHdrJMSDeliveryModeQTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgHdrJMSDeliveryModeQTest")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - msgHdrJMSDeliveryModeQTest!");
                this.msgHdrJMSDeliveryModeQTest(msg);
            } else if (msg.getStringProperty("TestCase").equals("msgHdrIDQTestCreate")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - msgHdrIDQTestCreate!");
                this.msgHdrIDQTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgHdrIDQTest")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - msgHdrIDQTest!");
                this.msgHdrIDQTest(msg);
            } else {
                logger.log(System.Logger.Level.TRACE, "@onMessage - invalid message type found in StringProperty");
                logger.log(System.Logger.Level.TRACE, "Do not have a method for this testcase: " + msg.getStringProperty("TestCase"));
            }
            logger.log(System.Logger.Level.TRACE, "@onMessage - Finished for this test!");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            if (this.qConnection != null) {
                try {
                    this.qConnection.close();
                }
                catch (Exception e) {
                    TestUtil.printStackTrace((Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgHdrTimeStampQTest() {
        boolean pass = true;
        byte bValue = 127;
        Object id = null;
        String testCase = "msgHdrTimeStampQTest";
        try {
            logger.log(System.Logger.Level.TRACE, "Send ObjectMessage to Queue.");
            this.messageSentObjectMessage.setObject((Serializable)((Object)"msgHdrTimeStampQTest for Object Message"));
            this.messageSentObjectMessage.setStringProperty("TestCase", "dummy");
            long timeBeforeSend = System.currentTimeMillis();
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)this.messageSentObjectMessage);
            long timeAfterSend = System.currentTimeMillis();
            logger.log(System.Logger.Level.TRACE, " getJMSTimestamp");
            logger.log(System.Logger.Level.TRACE, " " + this.messageSentObjectMessage.getJMSTimestamp());
            logger.log(System.Logger.Level.TRACE, "Time at send is: " + timeBeforeSend);
            logger.log(System.Logger.Level.TRACE, "Time after return fromsend is:" + timeAfterSend);
            if (timeBeforeSend <= this.messageSentObjectMessage.getJMSTimestamp() && timeAfterSend >= this.messageSentObjectMessage.getJMSTimestamp()) {
                logger.log(System.Logger.Level.TRACE, "Object Message TimeStamp pass");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: invalid timestamp from ObjectMessage");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "Send MapMessage to Queue.");
            this.messageSentMapMessage.setStringProperty("TestCase", "dummy");
            this.messageSentMapMessage.setString("aString", "value");
            timeBeforeSend = System.currentTimeMillis();
            this.mSender.send((Message)this.messageSentMapMessage);
            timeAfterSend = System.currentTimeMillis();
            logger.log(System.Logger.Level.TRACE, " getJMSTimestamp");
            logger.log(System.Logger.Level.TRACE, " " + this.messageSentMapMessage.getJMSTimestamp());
            logger.log(System.Logger.Level.TRACE, "Time at send is: " + timeBeforeSend);
            logger.log(System.Logger.Level.TRACE, "Time after return fromsend is:" + timeAfterSend);
            if (timeBeforeSend <= this.messageSentMapMessage.getJMSTimestamp() && timeAfterSend >= this.messageSentMapMessage.getJMSTimestamp()) {
                logger.log(System.Logger.Level.TRACE, "MapMessage TimeStamp pass");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: invalid timestamp from MapMessage");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "Send BytesMessage to Queue.");
            this.messageSentBytesMessage.setStringProperty("TestCase", "dummy");
            this.messageSentBytesMessage.writeByte(bValue);
            timeBeforeSend = System.currentTimeMillis();
            this.mSender.send((Message)this.messageSentBytesMessage);
            timeAfterSend = System.currentTimeMillis();
            logger.log(System.Logger.Level.TRACE, " getJMSTimestamp");
            logger.log(System.Logger.Level.TRACE, " " + this.messageSentBytesMessage.getJMSTimestamp());
            logger.log(System.Logger.Level.TRACE, "Time at send is: " + timeBeforeSend);
            logger.log(System.Logger.Level.TRACE, "Time after return fromsend is:" + timeAfterSend);
            if (timeBeforeSend <= this.messageSentBytesMessage.getJMSTimestamp() && timeAfterSend >= this.messageSentBytesMessage.getJMSTimestamp()) {
                logger.log(System.Logger.Level.TRACE, "BytesMessage TimeStamp pass");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: invalid timestamp from BytesMessage");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "sending a Stream message");
            this.messageSentStreamMessage.setStringProperty("TestCase", "dummy");
            this.messageSentStreamMessage.writeString("Testing...");
            logger.log(System.Logger.Level.TRACE, "Sending message");
            timeBeforeSend = System.currentTimeMillis();
            this.mSender.send((Message)this.messageSentStreamMessage);
            timeAfterSend = System.currentTimeMillis();
            logger.log(System.Logger.Level.TRACE, " getJMSTimestamp");
            logger.log(System.Logger.Level.TRACE, " " + this.messageSentStreamMessage.getJMSTimestamp());
            logger.log(System.Logger.Level.TRACE, "Time at send is: " + timeBeforeSend);
            logger.log(System.Logger.Level.TRACE, "Time after return fromsend is:" + timeAfterSend);
            if (timeBeforeSend <= this.messageSentStreamMessage.getJMSTimestamp() && timeAfterSend >= this.messageSentStreamMessage.getJMSTimestamp()) {
                logger.log(System.Logger.Level.TRACE, "StreamMessage TimeStamp pass");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: invalid timestamp from StreamMessage");
                pass = false;
            }
            this.messageSent.setText("sending a Text message");
            this.messageSent.setStringProperty("TestCase", "dummy");
            logger.log(System.Logger.Level.TRACE, "sending a Text message");
            timeBeforeSend = System.currentTimeMillis();
            this.mSender.send((Message)this.messageSent);
            timeAfterSend = System.currentTimeMillis();
            logger.log(System.Logger.Level.TRACE, " getJMSTimestamp");
            logger.log(System.Logger.Level.TRACE, " " + this.messageSent.getJMSTimestamp());
            logger.log(System.Logger.Level.TRACE, "Time at send is: " + timeBeforeSend);
            logger.log(System.Logger.Level.TRACE, "Time after return fromsend is:" + timeAfterSend);
            if (timeBeforeSend <= this.messageSent.getJMSTimestamp() && timeAfterSend >= this.messageSent.getJMSTimestamp()) {
                logger.log(System.Logger.Level.TRACE, "TextMessage TimeStamp pass");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: invalid timestamp from TextMessage");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            this.sendTestResults(testCase, pass);
        }
    }

    private void msgHdrCorlIdQTextTestCreate() {
        String jmsCorrelationID = "test Correlation id";
        try {
            this.messageSent.setText("sending a message");
            this.messageSent.setStringProperty("TestCase", "msgHdrCorlIdQTextTest");
            logger.log(System.Logger.Level.TRACE, "Send Text Message to Queue.");
            this.messageSent.setJMSCorrelationID(jmsCorrelationID);
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)this.messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void msgHdrCorlIdQStreamTestCreate() {
        String jmsCorrelationID = "test Correlation id";
        try {
            this.messageSentStreamMessage.setStringProperty("TestCase", "msgHdrCorlIdQStreamTest");
            this.messageSentStreamMessage.setJMSCorrelationID(jmsCorrelationID);
            this.messageSentStreamMessage.writeString("Testing...");
            logger.log(System.Logger.Level.TRACE, "Sending Stream message");
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)this.messageSentStreamMessage);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void msgHdrCorlIdQBytesTestCreate() {
        byte bValue = 127;
        String jmsCorrelationID = "test Correlation id";
        try {
            logger.log(System.Logger.Level.TRACE, "Send BytesMessage to Queue.");
            this.messageSentBytesMessage.setStringProperty("TestCase", "msgHdrCorlIdQBytesTest");
            this.messageSentBytesMessage.setJMSCorrelationID(jmsCorrelationID);
            this.messageSentBytesMessage.writeByte(bValue);
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)this.messageSentBytesMessage);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void msgHdrCorlIdQMapTestCreate() {
        String jmsCorrelationID = "test Correlation id";
        try {
            logger.log(System.Logger.Level.TRACE, "Send MapMessage to Queue.");
            this.messageSentMapMessage.setStringProperty("TestCase", "msgHdrCorlIdQMapTest");
            this.messageSentMapMessage.setJMSCorrelationID(jmsCorrelationID);
            this.messageSentMapMessage.setString("aString", "value");
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)this.messageSentMapMessage);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void msgHdrCorlIdQObjectTestCreate() {
        String jmsCorrelationID = "test Correlation id";
        try {
            logger.log(System.Logger.Level.TRACE, "Send ObjectMessage to Queue.");
            this.messageSentObjectMessage.setObject((Serializable)((Object)"msgHdrIDQObjectTest for Object Message"));
            this.messageSentObjectMessage.setStringProperty("TestCase", "msgHdrCorlIdQObjectTest");
            this.messageSentObjectMessage.setJMSCorrelationID(jmsCorrelationID);
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)this.messageSentObjectMessage);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgHdrCorlIdQTest(Message messageReceived) {
        boolean pass = true;
        String jmsCorrelationID = "test Correlation id";
        try {
            logger.log(System.Logger.Level.TRACE, "jmsCorrelationID:  " + messageReceived.getJMSCorrelationID());
            if (messageReceived.getJMSCorrelationID() == null) {
                pass = false;
                logger.log(System.Logger.Level.INFO, "Text Message Error: JMSCorrelationID returned a  null");
            } else if (messageReceived.getJMSCorrelationID().equals(jmsCorrelationID)) {
                logger.log(System.Logger.Level.TRACE, "pass");
            } else {
                pass = false;
                logger.log(System.Logger.Level.INFO, "Text Message Error: JMSCorrelationID is incorrect");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            try {
                this.sendTestResults(messageReceived.getStringProperty("TestCase"), pass);
            }
            catch (Exception j) {
                TestUtil.printStackTrace((Throwable)j);
            }
        }
    }

    public void msgHdrReplyToQTestCreate() {
        Object replyQueue = null;
        try {
            this.messageSent.setText("sending a message");
            this.messageSent.setStringProperty("TestCase", "msgHdrReplyToQTest");
            this.messageSent.setJMSReplyTo((Destination)this.queue);
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)this.messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgHdrReplyToQTest(Message messageReceived) {
        boolean pass = true;
        Queue replyQueue = null;
        String testCase = "msgHdrReplyToQTest";
        try {
            replyQueue = (Queue)messageReceived.getJMSReplyTo();
            logger.log(System.Logger.Level.TRACE, "Queue name is " + replyQueue.getQueueName());
            if (replyQueue.getQueueName().equals(this.queue.getQueueName())) {
                logger.log(System.Logger.Level.TRACE, "Pass ");
            } else {
                logger.log(System.Logger.Level.INFO, "ReplyTo Failed");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            this.sendTestResults(testCase, pass);
        }
    }

    public void msgHdrJMSTypeQTestCreate() {
        boolean pass = true;
        int bValue = 127;
        String type = "TESTMSG";
        try {
            this.messageSent.setText("sending a message");
            this.messageSent.setStringProperty("TestCase", "msgHdrJMSTypeQTest");
            logger.log(System.Logger.Level.TRACE, "JMSType test - Send a Text message");
            this.messageSent.setJMSType(type);
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)this.messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgHdrJMSTypeQTest(Message messageReceived) {
        boolean pass = true;
        String type = "TESTMSG";
        String testCase = "msgHdrJMSTypeQTest";
        try {
            logger.log(System.Logger.Level.TRACE, "JMSType is " + messageReceived.getJMSType());
            if (messageReceived.getJMSType().equals(type)) {
                logger.log(System.Logger.Level.TRACE, "Pass");
            } else {
                logger.log(System.Logger.Level.INFO, "Text Message Failed");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            this.sendTestResults(testCase, pass);
        }
    }

    public void msgHdrJMSPriorityQTestCreate() {
        boolean pass = true;
        int bValue = 127;
        int priority = 2;
        try {
            this.messageSent.setText("sending a message");
            this.messageSent.setStringProperty("TestCase", "msgHdrJMSPriorityQTest");
            logger.log(System.Logger.Level.TRACE, "JMSPriority test - Send a Text message");
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.setPriority(priority);
            this.mSender.send((Message)this.messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgHdrJMSPriorityQTest(Message messageReceived) {
        boolean pass = true;
        int priority = 2;
        String testCase = "msgHdrJMSPriorityQTest";
        try {
            logger.log(System.Logger.Level.TRACE, "JMSPriority is " + messageReceived.getJMSPriority());
            if (messageReceived.getJMSPriority() == priority) {
                logger.log(System.Logger.Level.TRACE, "Pass ");
            } else {
                logger.log(System.Logger.Level.INFO, "JMSPriority test Failed");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            this.sendTestResults(testCase, pass);
        }
    }

    public void msgHdrJMSExpirationQueueTestCreate() {
        boolean pass = true;
        long forever = 0L;
        try {
            this.messageSent.setText("sending a message");
            this.messageSent.setStringProperty("TestCase", "msgHdrJMSExpirationQueueTest");
            logger.log(System.Logger.Level.TRACE, "JMSExpiration test - Send a Text message");
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.setTimeToLive(forever);
            this.mSender.send((Message)this.messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgHdrJMSExpirationQueueTest(Message messageReceived) {
        boolean pass = true;
        long forever = 0L;
        String testCase = "msgHdrJMSExpirationQueueTest";
        try {
            logger.log(System.Logger.Level.TRACE, "JMSExpiration is " + messageReceived.getJMSExpiration());
            if (messageReceived.getJMSExpiration() == forever) {
                logger.log(System.Logger.Level.TRACE, "Pass ");
            } else {
                logger.log(System.Logger.Level.INFO, "Text Message Failed");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            this.sendTestResults(testCase, pass);
        }
    }

    public void msgHdrJMSDestinationQTestCreate() {
        Object replyDestination = null;
        try {
            this.messageSent.setText("sending a message");
            this.messageSent.setStringProperty("TestCase", "msgHdrJMSDestinationQTest");
            logger.log(System.Logger.Level.TRACE, "send msg for JMSDestination test.");
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)this.messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgHdrJMSDestinationQTest(Message messageReceived) {
        boolean pass = true;
        Queue replyDestination = null;
        String testCase = "msgHdrJMSDestinationQTest";
        try {
            logger.log(System.Logger.Level.TRACE, "JMSDestination:  " + messageReceived.getJMSDestination());
            replyDestination = (Queue)messageReceived.getJMSDestination();
            if (replyDestination != null) {
                logger.log(System.Logger.Level.TRACE, "Queue name is " + replyDestination.getQueueName());
            }
            if (replyDestination == null) {
                pass = false;
                logger.log(System.Logger.Level.INFO, "Text Message Error: JMSDestination returned a  null");
            } else if (replyDestination.getQueueName().equals(this.queue.getQueueName())) {
                logger.log(System.Logger.Level.TRACE, "Pass ");
            } else {
                logger.log(System.Logger.Level.INFO, "Text Message Failed");
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception thrown in msgHdrJMSDestinationQTest:", (Throwable)e);
        }
        finally {
            this.sendTestResults(testCase, pass);
        }
    }

    public void msgHdrJMSDeliveryModeQTestCreate() {
        try {
            this.messageSent.setText("sending a message");
            this.messageSent.setStringProperty("TestCase", "msgHdrJMSDeliveryModeQTest");
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)this.messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgHdrJMSDeliveryModeQTest(Message messageReceived) {
        boolean pass = true;
        String testCase = "msgHdrJMSDeliveryModeQTest";
        try {
            logger.log(System.Logger.Level.TRACE, "JMSDeliveryMode:  " + messageReceived.getJMSDeliveryMode());
            if (messageReceived.getJMSDeliveryMode() != 2) {
                pass = false;
                logger.log(System.Logger.Level.INFO, "Error: JMSDeliveryMode should be set to persistent as default");
            } else {
                logger.log(System.Logger.Level.TRACE, "Pass: Default delivery mode is persistent");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            this.sendTestResults(testCase, pass);
        }
    }

    public void msgHdrIDQTestCreate() {
        Object id = null;
        try {
            this.messageSent.setText("sending a Text message");
            this.messageSent.setStringProperty("TestCase", "msgHdrIDQTest");
            this.mSender = this.qSession.createSender(this.queue);
            this.mSender.send((Message)this.messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgHdrIDQTest(Message messageReceived) {
        boolean pass = true;
        String id = null;
        String testCase = "msgHdrIDQTest";
        try {
            logger.log(System.Logger.Level.TRACE, "getJMSMessageID ");
            logger.log(System.Logger.Level.TRACE, " " + messageReceived.getJMSMessageID());
            id = messageReceived.getJMSMessageID();
            if (id.startsWith("ID:")) {
                logger.log(System.Logger.Level.TRACE, "Pass: JMSMessageID start with ID:");
            } else {
                logger.log(System.Logger.Level.INFO, "Error: JMSMessageID does not start with ID:");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            this.sendTestResults(testCase, pass);
        }
    }

    private void sendTestResults(String testCase, boolean results) {
        TextMessage msg = null;
        try {
            this.mSender = this.qSession.createSender(this.queueR);
            msg = this.qSession.createTextMessage();
            msg.setStringProperty("TestCase", testCase);
            msg.setText(testCase);
            if (results) {
                msg.setStringProperty("Status", "Pass");
            } else {
                msg.setStringProperty("Status", "Fail");
            }
            this.mSender.send((Message)msg);
        }
        catch (JMSException je) {
            TestUtil.printStackTrace((Throwable)je);
            System.out.println("Error: " + ((Object)((Object)je)).getClass().getName() + " was thrown");
        }
        catch (Exception ee) {
            TestUtil.printStackTrace((Throwable)ee);
            System.out.println("Error: " + ee.getClass().getName() + " was thrown");
        }
    }

    public void setMessageDrivenContext(MessageDrivenContext mdc) {
        logger.log(System.Logger.Level.TRACE, "jms.ee.mdb.mdb_msgHdrQ  In MsgBeanMsgTestHdrQ::setMessageDrivenContext()!!");
        this.mdc = mdc;
    }

    public void ejbRemove() {
        logger.log(System.Logger.Level.TRACE, "jms.ee.mdb.mdb_msgHdrQ  In MsgBeanMsgTestHdrQ::remove()!!");
    }
}

