/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee.mdb.mdb_msgTypesT3;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsUtil;
import jakarta.ejb.EJBException;
import jakarta.ejb.MessageDrivenBean;
import jakarta.ejb.MessageDrivenContext;
import jakarta.jms.BytesMessage;
import jakarta.jms.JMSException;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.MessageNotReadableException;
import jakarta.jms.MessageNotWriteableException;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicConnection;
import jakarta.jms.TopicConnectionFactory;
import jakarta.jms.TopicPublisher;
import jakarta.jms.TopicSession;
import java.io.Serializable;
import java.util.Properties;

public class MsgBeanMsgTestT3
implements MessageDrivenBean,
MessageListener {
    private Properties p = null;
    private TSNamingContext context = null;
    private MessageDrivenContext mdc = null;
    private static final System.Logger logger = System.getLogger(MsgBeanMsgTestT3.class.getName());
    private QueueConnectionFactory qFactory = null;
    private TopicConnectionFactory tFactory = null;
    private QueueConnection qConnection = null;
    private TopicConnection tConnection = null;
    private Queue queueR = null;
    private Queue queue = null;
    private Topic topic = null;
    private QueueSender mSender = null;
    private QueueSession qSession = null;
    private TopicPublisher tPublisher = null;
    private TopicSession tSession = null;

    public MsgBeanMsgTestT3() {
        logger.log(System.Logger.Level.TRACE, "@MsgBeanMsgTest3()!");
    }

    public void ejbCreate() {
        logger.log(System.Logger.Level.TRACE, "jms.ee.mdb.mdb_msgTypesT3  - @MsgBeanMsgTest3-ejbCreate() !!");
        try {
            this.context = new TSNamingContext();
            this.qFactory = (QueueConnectionFactory)this.context.lookup("java:comp/env/jms/MyQueueConnectionFactory");
            if (this.qFactory == null) {
                System.out.println("qFactory error");
            }
            System.out.println("got a qFactory !!");
            this.tFactory = (TopicConnectionFactory)this.context.lookup("java:comp/env/jms/MyTopicConnectionFactory");
            if (this.tFactory == null) {
                System.out.println("tFactory error");
            }
            System.out.println("got a tFactory !!");
            this.queueR = (Queue)this.context.lookup("java:comp/env/jms/MDB_QUEUE_REPLY");
            if (this.queueR == null) {
                System.out.println("queueR error");
            }
            this.topic = (Topic)this.context.lookup("java:comp/env/jms/MDB_TOPIC");
            if (this.topic == null) {
                System.out.println("topic error");
            }
            this.p = new Properties();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("MDB ejbCreate Error!", e);
        }
    }

    public void onMessage(Message msg) {
        JmsUtil.initHarnessProps((Message)msg, (Properties)this.p);
        logger.log(System.Logger.Level.TRACE, "from jms.ee.mdb.mdb_msgTypesT3 @onMessage!" + msg);
        try {
            this.qConnection = this.qFactory.createQueueConnection();
            if (this.qConnection == null) {
                System.out.println("connection error");
            } else {
                this.qConnection.start();
                this.qSession = this.qConnection.createQueueSession(true, 0);
            }
            this.tConnection = this.tFactory.createTopicConnection();
            if (this.tConnection == null) {
                System.out.println("connection error");
            } else {
                this.tConnection.start();
                this.tSession = this.tConnection.createTopicSession(true, 0);
            }
            if (msg.getStringProperty("TestCase").equals("msgClearBodyTopicTextTestCreate")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running msgClearBodyTopicTextTestCreate - create the message");
                this.msgClearBodyTopicTextTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgClearBodyTopicTextTest")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running msgClearBodyTopicTextTest - read and verify the message");
                this.msgClearBodyTopicTextTest((TextMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("msgClearBodyTopicObjectTestCreate")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running msgClearBodyTopicObjectTestCreate - create the message");
                this.msgClearBodyTopicObjectTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgClearBodyTopicObjectTest")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running msgClearBodyTopicObjectTest - read and verify the message");
                this.msgClearBodyTopicObjectTest((ObjectMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("msgClearBodyTopicMapTestCreate")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running msgClearBodyTopicMapTestCreate - create the message");
                this.msgClearBodyTopicMapTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgClearBodyTopicMapTest")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running msgClearBodyTopicMapTest - read and verify the message");
                this.msgClearBodyTopicMapTest((MapMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("msgClearBodyTopicBytesTestCreate")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running msgClearBodyTopicBytesTestCreate - create the message");
                this.msgClearBodyTopicBytesTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgClearBodyTopicBytesTest")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running msgClearBodyTopicBytesTest - read and verify the message");
                this.msgClearBodyTopicBytesTest((BytesMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("msgClearBodyTopicStreamTestCreate")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running msgClearBodyTopicStreamTestCreate - create the message");
                this.msgClearBodyTopicStreamTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("msgClearBodyTopicStreamTest")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running msgClearBodyTopicStreamTest - read and verify the message");
                this.msgClearBodyTopicStreamTest((StreamMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("msgResetTopicTest")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running msgResetTopicTest - read and verify the message");
                this.msgResetTopicTest();
            } else if (msg.getStringProperty("TestCase").equals("readNullCharNotValidTopicStreamTestCreate")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running readNullCharNotValidTopicStreamTestCreate - read and verify the message");
                this.readNullCharNotValidTopicStreamTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("readNullCharNotValidTopicStreamTest")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running readNullCharNotValidTopicStreamTest - read and verify the message");
                this.readNullCharNotValidTopicStreamTest((StreamMessage)msg);
            } else if (msg.getStringProperty("TestCase").equals("readNullCharNotValidTopicMapTestCreate")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running readNullCharNotValidTopicMapTestCreate - read and verify the message");
                this.readNullCharNotValidTopicMapTestCreate();
            } else if (msg.getStringProperty("TestCase").equals("readNullCharNotValidTopicMapTest")) {
                logger.log(System.Logger.Level.TRACE, "@onMessage - running readNullCharNotValidTopicMapTest - read and verify the message");
                this.readNullCharNotValidTopicMapTest((MapMessage)msg);
            } else {
                logger.log(System.Logger.Level.TRACE, "@onMessage - invalid message type found in StringProperty");
                logger.log(System.Logger.Level.TRACE, "Do not have a method for this testcase: " + msg.getStringProperty("TestCase"));
            }
            logger.log(System.Logger.Level.TRACE, "@onMessage - Finished for this test!");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            if (this.qConnection != null) {
                try {
                    this.qConnection.close();
                }
                catch (Exception e) {
                    TestUtil.printStackTrace((Throwable)e);
                }
            }
            if (this.tConnection != null) {
                try {
                    this.tConnection.close();
                }
                catch (Exception e) {
                    TestUtil.printStackTrace((Throwable)e);
                }
            }
        }
    }

    private void msgClearBodyTopicTextTestCreate() {
        try {
            TextMessage messageSent = null;
            messageSent = this.qSession.createTextMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, (Properties)this.p);
            messageSent.setText("sending a Text message");
            messageSent.setStringProperty("TestCase", "msgClearBodyTopicTextTest");
            logger.log(System.Logger.Level.TRACE, "sending a Text message");
            this.tPublisher = this.tSession.createPublisher(this.topic);
            this.tPublisher.publish((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void msgClearBodyTopicObjectTestCreate() {
        try {
            ObjectMessage messageSentObjectMsg = null;
            logger.log(System.Logger.Level.TRACE, "Send ObjectMessage to Topic.");
            messageSentObjectMsg = this.qSession.createObjectMessage();
            JmsUtil.addPropsToMessage((Message)messageSentObjectMsg, (Properties)this.p);
            messageSentObjectMsg.setObject((Serializable)((Object)"Initial message"));
            messageSentObjectMsg.setStringProperty("TestCase", "msgClearBodyTopicObjectTest");
            this.tPublisher = this.tSession.createPublisher(this.topic);
            this.tPublisher.publish((Message)messageSentObjectMsg);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void msgClearBodyTopicMapTestCreate() {
        try {
            MapMessage messageSentMapMessage = null;
            logger.log(System.Logger.Level.TRACE, "Send MapMessage to Topic.");
            messageSentMapMessage = this.qSession.createMapMessage();
            JmsUtil.addPropsToMessage((Message)messageSentMapMessage, (Properties)this.p);
            messageSentMapMessage.setStringProperty("TestCase", "msgClearBodyTopicMapTest");
            messageSentMapMessage.setString("aString", "Initial message");
            this.tPublisher = this.tSession.createPublisher(this.topic);
            this.tPublisher.publish((Message)messageSentMapMessage);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void msgClearBodyTopicBytesTestCreate() {
        byte bValue = 127;
        try {
            BytesMessage messageSentBytesMessage = null;
            logger.log(System.Logger.Level.TRACE, "Send BytesMessage to Topic.");
            messageSentBytesMessage = this.qSession.createBytesMessage();
            JmsUtil.addPropsToMessage((Message)messageSentBytesMessage, (Properties)this.p);
            messageSentBytesMessage.setStringProperty("TestCase", "msgClearBodyTopicBytesTest");
            messageSentBytesMessage.writeByte(bValue);
            this.tPublisher = this.tSession.createPublisher(this.topic);
            this.tPublisher.publish((Message)messageSentBytesMessage);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void msgClearBodyTopicStreamTestCreate() {
        try {
            StreamMessage messageSentStreamMessage = null;
            logger.log(System.Logger.Level.TRACE, "sending a Stream message");
            messageSentStreamMessage = this.qSession.createStreamMessage();
            JmsUtil.addPropsToMessage((Message)messageSentStreamMessage, (Properties)this.p);
            messageSentStreamMessage.setStringProperty("TestCase", "msgClearBodyTopicStreamTest");
            messageSentStreamMessage.writeString("Testing...");
            logger.log(System.Logger.Level.TRACE, "Sending message");
            this.tPublisher = this.tSession.createPublisher(this.topic);
            this.tPublisher.publish((Message)messageSentStreamMessage);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgClearBodyTopicTextTest(TextMessage messageReceived) {
        String testCase = "msgClearBodyTopicTextTest";
        boolean pass = true;
        try {
            logger.log(System.Logger.Level.TRACE, "Test TextMessage ");
            logger.log(System.Logger.Level.TRACE, "read 1st contents");
            logger.log(System.Logger.Level.TRACE, "  " + messageReceived.getText());
            logger.log(System.Logger.Level.TRACE, "Call to clearBody !!!!!!!!!!!!!!!");
            messageReceived.clearBody();
            if (messageReceived.getText() == null) {
                logger.log(System.Logger.Level.TRACE, "Empty body after clearBody as expected: null");
            } else {
                logger.log(System.Logger.Level.TRACE, "Fail: message body was not empty");
                pass = false;
            }
            if (messageReceived.getStringProperty("TestCase").equals("msgClearBodyTopicTextTest")) {
                logger.log(System.Logger.Level.TRACE, "Pass: Text properties read ok after clearBody called");
            } else {
                logger.log(System.Logger.Level.TRACE, "Fail: Text properties cleared after clearBody called");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "write and read 2nd contents");
            messageReceived.setText("new data");
            if (messageReceived.getText().equals("new data")) {
                logger.log(System.Logger.Level.TRACE, "Pass:");
            } else {
                logger.log(System.Logger.Level.TRACE, "Fail:");
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, "Error: " + e.getClass().getName() + " was thrown");
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        finally {
            this.sendTestResults(testCase, pass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgClearBodyTopicObjectTest(ObjectMessage messageReceivedObjectMsg) {
        String testCase = "msgClearBodyTopicObjectTest";
        boolean pass = true;
        try {
            logger.log(System.Logger.Level.TRACE, "Testing Object message");
            logger.log(System.Logger.Level.TRACE, "read 1st contents");
            logger.log(System.Logger.Level.TRACE, "  " + messageReceivedObjectMsg.getObject());
            logger.log(System.Logger.Level.TRACE, "Call to clearBody !!!!!!!!!!!!!!!");
            messageReceivedObjectMsg.clearBody();
            if (messageReceivedObjectMsg.getObject() == null) {
                logger.log(System.Logger.Level.TRACE, "Empty body after clearBody as expected: null");
            } else {
                logger.log(System.Logger.Level.TRACE, "Fail: message body was not empty");
                pass = false;
            }
            if (messageReceivedObjectMsg.getStringProperty("TestCase").equals("msgClearBodyTopicObjectTest")) {
                logger.log(System.Logger.Level.TRACE, "Pass: Object properties read ok after clearBody called");
            } else {
                logger.log(System.Logger.Level.TRACE, "Fail: Object properties cleared after clearBody called");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "write 2nd contents");
            messageReceivedObjectMsg.setObject((Serializable)((Object)"new stuff here!!!!!!"));
            logger.log(System.Logger.Level.TRACE, "read 2nd contents");
            if (messageReceivedObjectMsg.getObject().equals("new stuff here!!!!!!")) {
                logger.log(System.Logger.Level.TRACE, "Pass:");
            } else {
                logger.log(System.Logger.Level.TRACE, "Fail: ");
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, "Error: " + e.getClass().getName() + " was thrown");
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        finally {
            this.sendTestResults(testCase, pass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void msgClearBodyTopicMapTest(MapMessage messageReceivedMapMessage) {
        String testCase = "msgClearBodyTopicMapTest";
        boolean pass = true;
        try {
            logger.log(System.Logger.Level.TRACE, "Test for MapMessage ");
            logger.log(System.Logger.Level.TRACE, "read 1st contents");
            logger.log(System.Logger.Level.TRACE, "  " + messageReceivedMapMessage.getString("aString"));
            logger.log(System.Logger.Level.TRACE, "Call to clearBody !!!!!!!!!!!!!!!");
            messageReceivedMapMessage.clearBody();
            if (messageReceivedMapMessage.getString("aString") == null) {
                logger.log(System.Logger.Level.TRACE, "Empty body after clearBody as expected: null");
            } else {
                logger.log(System.Logger.Level.TRACE, "Fail: message body was not empty");
                pass = false;
            }
            if (messageReceivedMapMessage.getStringProperty("TestCase").equals("msgClearBodyTopicMapTest")) {
                logger.log(System.Logger.Level.TRACE, "Pass: Map properties read ok after clearBody called");
            } else {
                logger.log(System.Logger.Level.TRACE, "Fail: Map properties cleared after clearBody called");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "write 2nd contents");
            messageReceivedMapMessage.setString("yes", "new stuff !!!!!");
            logger.log(System.Logger.Level.TRACE, "read 2nd contents");
            if (messageReceivedMapMessage.getString("yes").equals("new stuff !!!!!")) {
                logger.log(System.Logger.Level.TRACE, "PASS:");
            } else {
                logger.log(System.Logger.Level.TRACE, "FAIL:");
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, "Error: " + e.getClass().getName() + " was thrown");
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        finally {
            this.sendTestResults(testCase, pass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgClearBodyTopicBytesTest(BytesMessage messageReceivedBytesMessage) {
        String testCase = "msgClearBodyTopicBytesTest";
        boolean pass = true;
        byte bValue2 = 22;
        try {
            logger.log(System.Logger.Level.TRACE, "Test BytesMessage ");
            logger.log(System.Logger.Level.TRACE, "read 1st contents");
            logger.log(System.Logger.Level.TRACE, "  " + messageReceivedBytesMessage.readByte());
            logger.log(System.Logger.Level.TRACE, "Call to clearBody !!!!!!!!!!!!!!!");
            messageReceivedBytesMessage.clearBody();
            logger.log(System.Logger.Level.TRACE, "Bytes message body should now be empty and in writeonly mode");
            try {
                byte b = messageReceivedBytesMessage.readByte();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageNotReadableException not thrown as expected");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageNotReadableException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageNotReadableException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            if (messageReceivedBytesMessage.getStringProperty("TestCase").equals("msgClearBodyTopicBytesTest")) {
                logger.log(System.Logger.Level.TRACE, "Pass: Bytes msg properties read ok after clearBody called");
            } else {
                logger.log(System.Logger.Level.TRACE, "Fail: Bytes msg properties cleared after clearBody called");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "write 2nd contents");
            messageReceivedBytesMessage.writeByte(bValue2);
            logger.log(System.Logger.Level.TRACE, "read 2nd contents");
            messageReceivedBytesMessage.reset();
            if (messageReceivedBytesMessage.readByte() == bValue2) {
                logger.log(System.Logger.Level.TRACE, "Pass:");
            } else {
                logger.log(System.Logger.Level.TRACE, "Fail:");
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, "Error: " + e.getClass().getName() + " was thrown");
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        finally {
            this.sendTestResults(testCase, pass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void msgClearBodyTopicStreamTest(StreamMessage messageReceivedStreamMessage) {
        String testCase = "msgClearBodyTopicStreamTest";
        boolean pass = true;
        try {
            logger.log(System.Logger.Level.TRACE, "Test StreamMessage ");
            logger.log(System.Logger.Level.TRACE, "read 1st contents");
            logger.log(System.Logger.Level.TRACE, "  " + messageReceivedStreamMessage.readString());
            logger.log(System.Logger.Level.TRACE, "Call to clearBody !!!!!!!!!!!!!!!");
            messageReceivedStreamMessage.clearBody();
            logger.log(System.Logger.Level.TRACE, "Stream message body should now be empty and in writeonly mode");
            try {
                String s = messageReceivedStreamMessage.readString();
                logger.log(System.Logger.Level.TRACE, "Fail: MessageNotReadableException should have been thrown");
                pass = false;
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                if (e instanceof MessageNotReadableException) {
                    logger.log(System.Logger.Level.TRACE, "Pass: MessageNotReadableException thrown as expected");
                }
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            if (messageReceivedStreamMessage.getStringProperty("TestCase").equals("msgClearBodyTopicStreamTest")) {
                logger.log(System.Logger.Level.TRACE, "Pass: Stream msg properties read ok after clearBody called");
            } else {
                logger.log(System.Logger.Level.TRACE, "Fail: Stream msg properties cleared after clearBody called");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "write 2nd contents");
            messageReceivedStreamMessage.writeString("new data");
            logger.log(System.Logger.Level.TRACE, "read 2nd contents");
            messageReceivedStreamMessage.reset();
            if (messageReceivedStreamMessage.readString().equals("new data")) {
                logger.log(System.Logger.Level.TRACE, "Pass:");
            } else {
                logger.log(System.Logger.Level.TRACE, "Fail:");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.TRACE, "Error: " + e.getClass().getName() + " was thrown");
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        finally {
            this.sendTestResults(testCase, pass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void msgResetTopicTest() {
        boolean pass = true;
        int nInt = 1000;
        String testCase = "msgResetTopicTest";
        try {
            StreamMessage messageSentStreamMessage = null;
            BytesMessage messageSentBytesMessage = null;
            try {
                logger.log(System.Logger.Level.TRACE, "creating a Stream message");
                messageSentStreamMessage = this.qSession.createStreamMessage();
                JmsUtil.addPropsToMessage((Message)messageSentStreamMessage, (Properties)this.p);
                messageSentStreamMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgResetTopicTest1");
                messageSentStreamMessage.writeString("Testing...");
                logger.log(System.Logger.Level.TRACE, "reset stream message -  now  should be in readonly mode");
                messageSentStreamMessage.reset();
                messageSentStreamMessage.writeString("new data");
                logger.log(System.Logger.Level.TRACE, "Fail: message did not throw MessageNotWriteable exception as expected");
                pass = false;
            }
            catch (MessageNotWriteableException nw) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageNotWriteable thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: " + e.getClass().getName() + " was thrown");
                pass = false;
            }
            try {
                logger.log(System.Logger.Level.TRACE, "creating a Byte message");
                messageSentBytesMessage = this.qSession.createBytesMessage();
                JmsUtil.addPropsToMessage((Message)messageSentBytesMessage, (Properties)this.p);
                messageSentBytesMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgResetTopicTest2");
                messageSentBytesMessage.writeInt(nInt);
                logger.log(System.Logger.Level.TRACE, "reset Byte message -  now  should be in readonly mode");
                messageSentBytesMessage.reset();
                messageSentBytesMessage.writeInt(nInt);
                logger.log(System.Logger.Level.TRACE, "Fail: message did not throw MessageNotWriteable exception as expected");
                pass = false;
            }
            catch (MessageNotWriteableException nw) {
                logger.log(System.Logger.Level.TRACE, "Pass: MessageNotWriteable thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: " + e.getClass().getName() + " was thrown");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            this.sendTestResults(testCase, pass);
        }
    }

    public void readNullCharNotValidTopicMapTestCreate() {
        try {
            MapMessage mapSent = null;
            boolean pass = true;
            mapSent = this.qSession.createMapMessage();
            JmsUtil.addPropsToMessage((Message)mapSent, (Properties)this.p);
            mapSent.setStringProperty("TestCase", "readNullCharNotValidTopicMapTest");
            logger.log(System.Logger.Level.TRACE, "Write a null string to the map message object with mapMessage.setString");
            mapSent.setString("WriteANull", null);
            logger.log(System.Logger.Level.TRACE, " Send the message");
            this.tPublisher = this.tSession.createPublisher(this.topic);
            this.tPublisher.publish((Message)mapSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    public void readNullCharNotValidTopicStreamTestCreate() {
        try {
            StreamMessage messageSent = null;
            boolean pass = true;
            messageSent = this.qSession.createStreamMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, (Properties)this.p);
            messageSent.setStringProperty("TestCase", "readNullCharNotValidTopicStreamTest");
            messageSent = this.qSession.createStreamMessage();
            JmsUtil.addPropsToMessage((Message)messageSent, (Properties)this.p);
            messageSent.setStringProperty("TestCase", "readNullCharNotValidTopicStreamTest");
            logger.log(System.Logger.Level.TRACE, "Write a null string to the map message object with streamMessage.setString");
            messageSent.writeString(null);
            logger.log(System.Logger.Level.TRACE, " Send the message");
            this.tPublisher = this.tSession.createPublisher(this.topic);
            this.tPublisher.publish((Message)messageSent);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readNullCharNotValidTopicMapTest(MapMessage mapReceived) {
        String testCase = "readNullCharNotValidTopicMapTest";
        boolean pass = true;
        try {
            logger.log(System.Logger.Level.TRACE, "Use readChar to read a null  ");
            try {
                char c = mapReceived.getChar("WriteANull");
                logger.log(System.Logger.Level.TRACE, "Fail: NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: NullPointerException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            this.sendTestResults(testCase, pass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readNullCharNotValidTopicStreamTest(StreamMessage messageReceived) {
        String testCase = "readNullCharNotValidTopicStreamTest";
        boolean pass = true;
        try {
            logger.log(System.Logger.Level.TRACE, "Use readChar to read a null  ");
            try {
                char c = messageReceived.readChar();
                logger.log(System.Logger.Level.TRACE, "Fail: NullPointerException was not thrown");
                pass = false;
            }
            catch (NullPointerException e) {
                logger.log(System.Logger.Level.TRACE, "Pass: NullPointerException thrown as expected");
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                logger.log(System.Logger.Level.TRACE, "Error: Unexpected exception " + e.getClass().getName() + " was thrown");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            this.sendTestResults(testCase, pass);
        }
    }

    private void sendTestResults(String testCase, boolean results) {
        TextMessage msg = null;
        try {
            this.mSender = this.qSession.createSender(this.queueR);
            msg = this.qSession.createTextMessage();
            msg.setStringProperty("TestCase", testCase);
            msg.setText(testCase);
            if (results) {
                msg.setStringProperty("Status", "Pass");
            } else {
                msg.setStringProperty("Status", "Fail");
            }
            logger.log(System.Logger.Level.TRACE, "Sending response message");
            logger.log(System.Logger.Level.TRACE, "==================================Test Results from: " + testCase);
            logger.log(System.Logger.Level.TRACE, "==================================Status: " + results);
            this.mSender.send((Message)msg);
        }
        catch (JMSException je) {
            TestUtil.printStackTrace((Throwable)je);
            logger.log(System.Logger.Level.TRACE, "Error: " + ((Object)((Object)je)).getClass().getName() + " was thrown");
        }
        catch (Exception ee) {
            TestUtil.printStackTrace((Throwable)ee);
            logger.log(System.Logger.Level.TRACE, "Error: " + ee.getClass().getName() + " was thrown");
        }
    }

    public void setMessageDrivenContext(MessageDrivenContext mdc) {
        logger.log(System.Logger.Level.TRACE, "jms.ee.mdb.mdb_msgTypesT3  In MsgBeanMsgTest3::setMessageDrivenContext()!!");
        this.mdc = mdc;
    }

    public void ejbRemove() {
        logger.log(System.Logger.Level.TRACE, "jms.ee.mdb.mdb_msgTypesT3  In MsgBeanMsgTest3::remove()!!");
    }
}

