/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee.mdb.mdb_sndToTopic;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsUtil;
import jakarta.ejb.EJBException;
import jakarta.ejb.MessageDrivenBean;
import jakarta.ejb.MessageDrivenContext;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.jms.TextMessage;
import jakarta.jms.TopicConnectionFactory;
import java.util.Properties;
import javax.sql.DataSource;

public class MsgBeanTopic
implements MessageDrivenBean,
MessageListener {
    private Properties p = null;
    private TSNamingContext context = null;
    private MessageDrivenContext mdc = null;
    private static final System.Logger logger = System.getLogger(MsgBeanTopic.class.getName());
    private QueueConnectionFactory queueConFactory = null;
    private TopicConnectionFactory topicConFactory = null;
    private DataSource dataSource = null;
    private QueueConnectionFactory qcFactory = null;
    private QueueConnection connection = null;
    private Queue replyQueue = null;

    public MsgBeanTopic() {
        logger.log(System.Logger.Level.TRACE, "@MsgBeanTopic - @MsgBean()!");
    }

    public void ejbCreate() {
        logger.log(System.Logger.Level.TRACE, "@MsgBeanTopic - @MsgBean-ejbCreate() !!");
        try {
            TSNamingContext context = new TSNamingContext();
            this.qcFactory = (QueueConnectionFactory)context.lookup("java:comp/env/jms/MyQueueConnectionFactory");
            this.replyQueue = (Queue)context.lookup("java:comp/env/jms/MDB_QUEUE_REPLY");
            this.p = new Properties();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("MDB ejbCreate Error!", e);
        }
    }

    public void onMessage(Message msg) {
        JmsUtil.initHarnessProps((Message)msg, (Properties)this.p);
        logger.log(System.Logger.Level.TRACE, "@MsgBeanTopic - MsgBeanTopic - onMessage! " + msg);
        try {
            logger.log(System.Logger.Level.TRACE, "In MsgBeanForTopic::onMessage() : " + msg);
            logger.log(System.Logger.Level.TRACE, "calling sendReply");
            this.sendReply(msg);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendReply(Message msg) {
        try {
            this.connection = this.qcFactory.createQueueConnection();
            System.out.println("From sendReply");
            this.connection.start();
            System.out.println("started the connection");
            QueueSession session = this.connection.createQueueSession(true, 0);
            TextMessage reply = session.createTextMessage();
            QueueSender replier = session.createSender(this.replyQueue);
            reply.setText("MDB Responding to message receipt");
            reply.setStringProperty("MessageType", msg.getStringProperty("MessageType"));
            logger.log(System.Logger.Level.TRACE, "sending a msg to MDB_QUEUE_REPLY");
            replier.send((Message)reply);
            System.out.println("Sent the message");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (Exception ee) {
                    TestUtil.printStackTrace((Throwable)ee);
                }
            }
        }
    }

    public void setMessageDrivenContext(MessageDrivenContext mdc) {
        logger.log(System.Logger.Level.TRACE, "In MsgBean::setMessageDrivenContext()!!");
        this.mdc = mdc;
    }

    public void ejbRemove() {
        logger.log(System.Logger.Level.TRACE, "In MsgBean::remove()!!");
    }
}

