/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee.mdb.xa;

import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsUtil;
import jakarta.ejb.EJBException;
import jakarta.ejb.MessageDrivenBean;
import jakarta.ejb.MessageDrivenContext;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnection;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.QueueSender;
import jakarta.jms.QueueSession;
import jakarta.transaction.UserTransaction;
import java.util.Properties;

public class MsgBeanxa
implements MessageDrivenBean,
MessageListener {
    private Properties p = null;
    private TSNamingContext context = null;
    protected MessageDrivenContext mdc = null;
    private static final System.Logger logger = System.getLogger(MsgBeanxa.class.getName());
    private QueueConnectionFactory qFactory = null;
    private QueueConnection qConnection = null;
    private Queue queueR = null;
    private Queue queue = null;
    private QueueSender mSender = null;

    public MsgBeanxa() {
        logger.log(System.Logger.Level.TRACE, "@MsgBeanMsgTestPropsQ()!");
    }

    public void ejbCreate() {
        logger.log(System.Logger.Level.TRACE, "mdb -ejbCreate() !!");
        try {
            this.context = new TSNamingContext();
            this.qFactory = (QueueConnectionFactory)this.context.lookup("java:comp/env/jms/MyQueueConnectionFactory");
            this.queueR = (Queue)this.context.lookup("java:comp/env/jms/MDB_QUEUE_REPLY");
            this.p = new Properties();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EJBException("MDB ejbCreate Error!", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message msg) {
        QueueSession qSession = null;
        JmsUtil.initHarnessProps((Message)msg, (Properties)this.p);
        logger.log(System.Logger.Level.TRACE, " @onMessage!" + msg);
        Object messageSent = null;
        try {
            logger.log(System.Logger.Level.TRACE, "TestCase:=====================" + msg.getStringProperty("COM_SUN_JMS_TESTNAME"));
            this.qConnection = this.qFactory.createQueueConnection();
            if (this.qConnection == null) {
                logger.log(System.Logger.Level.TRACE, "connection error");
            } else {
                qSession = this.qConnection.createQueueSession(false, 1);
            }
            logger.log(System.Logger.Level.TRACE, "will run TestCase: " + msg.getStringProperty("COM_SUN_JMS_TESTNAME"));
            this.runTests(msg, qSession);
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        finally {
            if (this.qConnection != null) {
                try {
                    this.qConnection.close();
                }
                catch (Exception e) {
                    TestUtil.printStackTrace((Throwable)e);
                }
            }
        }
    }

    private void runTests(Message msg, QueueSession qSession) {
        try {
            if (msg.getIntProperty("TestCaseNum") > 0) {
                switch (msg.getIntProperty("TestCaseNum")) {
                    case 1: {
                        this.runTest1(msg, qSession);
                        break;
                    }
                    case 2: {
                        this.runTest2(msg, qSession);
                        break;
                    }
                    case 3: {
                        this.runTest3(msg, qSession);
                        break;
                    }
                    case 4: {
                        this.runTest4(msg, qSession);
                        break;
                    }
                    case 5: {
                        this.runTest5(msg, qSession);
                        break;
                    }
                    case 6: {
                        this.runTest6(msg, qSession);
                        break;
                    }
                    case 7: {
                        this.runTest7(msg, qSession);
                        break;
                    }
                    case 8: {
                        this.runTest8(msg, qSession);
                        break;
                    }
                    case 9: {
                        this.runTest9(msg, qSession);
                        break;
                    }
                    case 10: {
                        this.runTest10(msg, qSession);
                        break;
                    }
                    default: {
                        logger.log(System.Logger.Level.TRACE, "Error in mdb - No test match for TestCaseNum: " + msg.getIntProperty("TestCaseNum"));
                    }
                }
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void runTest1(Message msg, QueueSession qSession) {
        try {
            logger.log(System.Logger.Level.TRACE, "Second time? = " + this.isJmsRedelivered(msg));
            if (!this.isJmsRedelivered(msg)) {
                logger.log(System.Logger.Level.TRACE, "Test1 message: first time thru");
                logger.log(System.Logger.Level.TRACE, "Message Number: " + msg.getIntProperty("TestCaseNum"));
                this.mdc.setRollbackOnly();
            } else {
                logger.log(System.Logger.Level.TRACE, "Test1 message: again - Pass!");
                JmsUtil.sendTestResults((String)"xaTest1", (boolean)true, (QueueSession)qSession, (Queue)this.queueR);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void runTest2(Message msg, QueueSession qSession) {
        try {
            if (!this.isJmsRedelivered(msg)) {
                logger.log(System.Logger.Level.TRACE, "Test2 message: first time thru");
                logger.log(System.Logger.Level.TRACE, "Message Number: " + msg.getIntProperty("TestCaseNum"));
                JmsUtil.sendTestResults((String)"xaTest2", (boolean)false, (QueueSession)qSession, (Queue)this.queueR);
                this.mdc.setRollbackOnly();
            } else {
                logger.log(System.Logger.Level.TRACE, "Test2 message: again - Pass!");
                JmsUtil.sendTestResults((String)"xaTest2", (boolean)true, (QueueSession)qSession, (Queue)this.queueR);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void runTest3(Message msg, QueueSession qSession) {
        if (this.mdc.getRollbackOnly()) {
            logger.log(System.Logger.Level.TRACE, "runTest3! =====    FAIL!");
            JmsUtil.sendTestResults((String)"xaTest3", (boolean)false, (QueueSession)qSession, (Queue)this.queueR);
        } else {
            logger.log(System.Logger.Level.TRACE, "runTest3 =====    PASS!");
            JmsUtil.sendTestResults((String)"xaTest3", (boolean)true, (QueueSession)qSession, (Queue)this.queueR);
        }
    }

    private void runTest4(Message msg, QueueSession qSession) {
        try {
            UserTransaction ut = this.mdc.getUserTransaction();
            int status = ut.getStatus();
            if (status != 6) {
                JmsUtil.sendTestResults((String)"xaTest4", (boolean)false, (QueueSession)qSession, (Queue)this.queueR);
                logger.log(System.Logger.Level.TRACE, "runTest4 =====    FAIL!");
            } else {
                logger.log(System.Logger.Level.TRACE, "runTest4 =====    PASS!");
                JmsUtil.sendTestResults((String)"xaTest4", (boolean)true, (QueueSession)qSession, (Queue)this.queueR);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void runTest5(Message msg, QueueSession qSession) {
        try {
            UserTransaction ut = this.mdc.getUserTransaction();
            ut.begin();
            JmsUtil.sendTestResults((String)"xaTest5", (boolean)true, (QueueSession)qSession, (Queue)this.queueR);
            ut.commit();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void runTest6(Message msg, QueueSession session) {
        try {
            UserTransaction ut = this.mdc.getUserTransaction();
            ut.begin();
            JmsUtil.sendTestResults((String)"xaTest6", (boolean)true, (QueueSession)session, (Queue)this.queueR);
            ut.commit();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void runTest7(Message msg, QueueSession qSession) {
        try {
            logger.log(System.Logger.Level.TRACE, "JmsRedelivered flag = " + this.isJmsRedelivered(msg));
            if (!this.isJmsRedelivered(msg)) {
                logger.log(System.Logger.Level.TRACE, "Test7 message: first time thru");
                logger.log(System.Logger.Level.TRACE, "Message Number: " + msg.getIntProperty("TestCaseNum"));
                this.mdc.setRollbackOnly();
            } else {
                logger.log(System.Logger.Level.TRACE, "Test7 message: again - Pass!");
                JmsUtil.sendTestResults((String)"xaTest7", (boolean)true, (QueueSession)qSession, (Queue)this.queueR);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void runTest8(Message msg, QueueSession qSession) {
        try {
            UserTransaction ut = this.mdc.getUserTransaction();
            ut.begin();
            JmsUtil.sendTestResults((String)"xaTest8", (boolean)false, (QueueSession)qSession, (Queue)this.queueR);
            ut.rollback();
            ut.begin();
            JmsUtil.sendTestResults((String)"xaTest8", (boolean)true, (QueueSession)qSession, (Queue)this.queueR);
            ut.commit();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void runTest9(Message msg, QueueSession qSession) {
        try {
            UserTransaction ut = this.mdc.getUserTransaction();
            ut.begin();
            JmsUtil.sendTestResults((String)"xaTest9", (boolean)false, (QueueSession)qSession, (Queue)this.queueR);
            ut.rollback();
            ut.begin();
            JmsUtil.sendTestResults((String)"xaTest9", (boolean)true, (QueueSession)qSession, (Queue)this.queueR);
            ut.commit();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private void runTest10(Message msg, QueueSession qSession) {
        try {
            logger.log(System.Logger.Level.TRACE, "Second time? = " + this.isJmsRedelivered(msg));
            if (!this.isJmsRedelivered(msg)) {
                logger.log(System.Logger.Level.TRACE, "Test10 message: first time thru");
                logger.log(System.Logger.Level.TRACE, "Message Number: " + msg.getIntProperty("TestCaseNum"));
                JmsUtil.sendTestResults((String)"xaTest10", (boolean)false, (QueueSession)qSession, (Queue)this.queueR);
                this.mdc.setRollbackOnly();
            } else {
                logger.log(System.Logger.Level.TRACE, "Test10 message: again - Pass!");
                JmsUtil.sendTestResults((String)"xaTest10", (boolean)true, (QueueSession)qSession, (Queue)this.queueR);
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
    }

    private boolean isJmsRedelivered(Message msg) {
        boolean redelivered = false;
        try {
            redelivered = msg.getJMSRedelivered();
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
        }
        return redelivered;
    }

    public void setMessageDrivenContext(MessageDrivenContext mdc) {
        logger.log(System.Logger.Level.TRACE, "setMessageDrivenContext()!!");
        this.mdc = mdc;
    }

    public void ejbRemove() {
        logger.log(System.Logger.Level.TRACE, "remove()!!");
    }
}

