/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee20.cditests.ejbweb;

import com.sun.ts.lib.util.RemoteLoggingInitException;
import com.sun.ts.lib.util.TestUtil;
import jakarta.annotation.ManagedBean;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import jakarta.inject.Inject;
import jakarta.jms.Destination;
import jakarta.jms.JMSConnectionFactory;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSContext;
import jakarta.jms.Message;
import jakarta.jms.Queue;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import java.io.Serializable;
import java.util.Properties;

@ManagedBean(value="mybean")
public class MyManagedBean
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Properties p = new Properties();
    private long timeout;
    private static final System.Logger logger = System.getLogger(MyManagedBean.class.getName());
    @Inject
    @JMSConnectionFactory(value="jms/ConnectionFactory")
    private transient JMSContext context;
    @Resource(name="jms/MY_QUEUE")
    private transient Queue queue;
    @Resource(name="jms/MY_TOPIC")
    private transient Topic topic;

    @PostConstruct
    public void postConstruct() {
        System.out.println("MyManageBean:postConstruct()");
        System.out.println("queue=" + this.queue);
        System.out.println("topic=" + this.topic);
        if (this.queue == null || this.topic == null || this.context == null) {
            throw new RuntimeException("postConstruct failed: injection failure");
        }
    }

    public void init(Properties p) {
        System.out.println("MyManageBean:init()");
        try {
            TestUtil.init((Properties)p);
            this.timeout = Long.parseLong(System.getProperty("jms_timeout"));
        }
        catch (RemoteLoggingInitException e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new RuntimeException("init: failed");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new RuntimeException("init: failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendRecvQueueTestUsingCDIFromManagedBean() {
        boolean pass = true;
        JMSConsumer consumer = null;
        logger.log(System.Logger.Level.INFO, "sendRecvQueueTestUsingCDIFromManagedBean");
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            consumer = this.context.createConsumer((Destination)this.queue);
            logger.log(System.Logger.Level.INFO, "Creating TextMessage");
            messageSent = this.context.createTextMessage();
            messageSent.setText("just a test");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "sendRecvQueueTestUsingCDIFromManagedBean");
            logger.log(System.Logger.Level.INFO, "Sending TextMessage");
            this.context.createProducer().send((Destination)this.queue, (Message)messageSent);
            logger.log(System.Logger.Level.INFO, "Receiving TextMessage");
            messageReceived = (TextMessage)consumer.receive(this.timeout);
            if (messageReceived == null) {
                logger.log(System.Logger.Level.ERROR, "No message was received");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Message Sent: \"" + messageSent.getText() + "\"");
                logger.log(System.Logger.Level.INFO, "Message Received: \"" + messageReceived.getText() + "\"");
                if (messageReceived.getText().equals(messageSent.getText())) {
                    logger.log(System.Logger.Level.INFO, "Received correct message");
                } else {
                    logger.log(System.Logger.Level.ERROR, "Received incorrect message");
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            pass = false;
        }
        finally {
            try {
                consumer.receive(this.timeout);
                while (consumer.receiveNoWait() != null) {
                }
                consumer.close();
            }
            catch (Exception exception) {}
        }
        return pass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendRecvTopicTestUsingCDIFromManagedBean() {
        boolean pass = true;
        JMSConsumer consumer = null;
        logger.log(System.Logger.Level.INFO, "sendRecvTopicTestUsingCDIFromManagedBean");
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            consumer = this.context.createConsumer((Destination)this.queue);
            logger.log(System.Logger.Level.INFO, "Creating TextMessage");
            messageSent = this.context.createTextMessage();
            messageSent.setText("just a test");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "sendRecvTopicTestUsingCDIFromManagedBean");
            logger.log(System.Logger.Level.INFO, "Sending TextMessage");
            this.context.createProducer().send((Destination)this.queue, (Message)messageSent);
            logger.log(System.Logger.Level.INFO, "Receiving TextMessage");
            messageReceived = (TextMessage)consumer.receive(this.timeout);
            if (messageReceived == null) {
                logger.log(System.Logger.Level.ERROR, "No message was received");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Message Sent: \"" + messageSent.getText() + "\"");
                logger.log(System.Logger.Level.INFO, "Message Received: \"" + messageReceived.getText() + "\"");
                if (messageReceived.getText().equals(messageSent.getText())) {
                    logger.log(System.Logger.Level.INFO, "Received correct message");
                } else {
                    logger.log(System.Logger.Level.ERROR, "Received incorrect message");
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            pass = false;
        }
        finally {
            try {
                consumer.receive(this.timeout);
                while (consumer.receiveNoWait() != null) {
                }
                consumer.close();
            }
            catch (Exception exception) {}
        }
        return pass;
    }
}

