/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee20.cditests.ejbweb;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.ee20.cditests.ejbweb.MyManagedBean;
import jakarta.annotation.Resource;
import jakarta.inject.Inject;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.IllegalStateRuntimeException;
import jakarta.jms.JMSConnectionFactory;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSPasswordCredential;
import jakarta.jms.JMSSessionMode;
import jakarta.jms.Message;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnectionFactory;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicConnectionFactory;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;

public class ServletClient
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private Properties harnessProps = null;
    long timeout;
    String user;
    String password;
    String mode;
    ArrayList queues = null;
    ArrayList connections = null;
    private static final int numMessages = 3;
    private static final int iterations = 5;
    private static int testsExecuted = 0;
    private static final System.Logger logger = System.getLogger(ServletClient.class.getName());
    @Inject
    @JMSConnectionFactory(value="jms/QueueConnectionFactory")
    transient JMSContext context1;
    @Inject
    @JMSConnectionFactory(value="jms/TopicConnectionFactory")
    transient JMSContext context2;
    @Inject
    @JMSConnectionFactory(value="jms/ConnectionFactory")
    @JMSPasswordCredential(userName="j2ee", password="j2ee")
    @JMSSessionMode(value=3)
    transient JMSContext context3;
    @Inject
    transient JMSContext context4;
    @Resource(name="jms/MyConnectionFactory")
    private transient ConnectionFactory cfactory;
    @Resource(name="jms/MyQueueConnectionFactory")
    private transient QueueConnectionFactory qcfactory;
    @Resource(name="jms/MyTopicConnectionFactory")
    private transient TopicConnectionFactory tcfactory;
    @Resource(name="jms/MY_QUEUE")
    private transient Queue queue;
    @Resource(name="jms/MY_TOPIC")
    private transient Topic topic;
    @Resource(name="mybean")
    private MyManagedBean mybean;

    private String printSessionMode(int sessionMode) {
        switch (sessionMode) {
            case 0: {
                return "SESSION_TRANSACTED";
            }
            case 1: {
                return "AUTO_ACKNOWLEDGE";
            }
            case 2: {
                return "CLIENT_ACKNOWLEDGE";
            }
            case 3: {
                return "DUPS_OK_ACKNOWLEDGE";
            }
        }
        return "UNEXPECTED_SESSIONMODE";
    }

    private void cleanup() {
        logger.log(System.Logger.Level.INFO, "cleanup");
    }

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        System.out.println("ServletClient:init() Entering");
        System.out.println("queue=" + this.queue);
        System.out.println("topic=" + this.topic);
        System.out.println("cfactory=" + this.cfactory);
        System.out.println("qcfactory=" + this.qcfactory);
        System.out.println("tcfactory=" + this.tcfactory);
        System.out.println("mybean=" + this.mybean);
        if (this.queue == null || this.topic == null || this.context1 == null || this.context2 == null || this.context3 == null || this.context4 == null || this.cfactory == null || this.qcfactory == null || this.tcfactory == null || this.mybean == null) {
            throw new ServletException("init() failed: port injection failed");
        }
        System.out.println("ServletClient:init() Leaving");
    }

    public void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        boolean pass = true;
        Properties p = new Properties();
        res.setContentType("text/plain");
        PrintWriter out = res.getWriter();
        try {
            String test = System.getProperty("TEST");
            System.out.println("doGet: test to execute is: " + test);
            if (test.equals("sendRecvQueueTestUsingCDIFromServlet")) {
                if (this.sendRecvQueueTestUsingCDIFromServlet()) {
                    p.setProperty("TESTRESULT", "pass");
                } else {
                    p.setProperty("TESTRESULT", "fail");
                }
            } else if (test.equals("sendRecvTopicTestUsingCDIFromServlet")) {
                if (this.sendRecvTopicTestUsingCDIFromServlet()) {
                    p.setProperty("TESTRESULT", "pass");
                } else {
                    p.setProperty("TESTRESULT", "fail");
                }
            } else if (test.equals("sendRecvUsingCDIDefaultFactoryFromServlet")) {
                if (this.sendRecvUsingCDIDefaultFactoryFromServlet()) {
                    p.setProperty("TESTRESULT", "pass");
                } else {
                    p.setProperty("TESTRESULT", "fail");
                }
            } else if (test.equals("verifySessionModeOnCDIJMSContextFromServlet")) {
                if (this.verifySessionModeOnCDIJMSContextFromServlet()) {
                    p.setProperty("TESTRESULT", "pass");
                } else {
                    p.setProperty("TESTRESULT", "fail");
                }
            } else if (test.equals("testRestrictionsOnCDIJMSContextFromServlet")) {
                if (this.testRestrictionsOnCDIJMSContextFromServlet()) {
                    p.setProperty("TESTRESULT", "pass");
                } else {
                    p.setProperty("TESTRESULT", "fail");
                }
            } else if (test.equals("sendRecvQueueTestUsingCDIFromManagedBean")) {
                if (this.sendRecvQueueTestUsingCDIFromManagedBean()) {
                    p.setProperty("TESTRESULT", "pass");
                } else {
                    p.setProperty("TESTRESULT", "fail");
                }
            } else if (test.equals("sendRecvTopicTestUsingCDIFromManagedBean")) {
                if (this.sendRecvTopicTestUsingCDIFromManagedBean()) {
                    p.setProperty("TESTRESULT", "pass");
                } else {
                    p.setProperty("TESTRESULT", "fail");
                }
            } else {
                p.setProperty("TESTRESULT", "fail");
            }
            this.cleanup();
            p.list(out);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "doGet: Exception: " + e);
            System.out.println("doGet: Exception: " + e);
            p.setProperty("TESTRESULT", "fail");
            p.list(out);
        }
        out.close();
    }

    public void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        this.harnessProps = new Properties();
        Enumeration enumlist = req.getParameterNames();
        while (enumlist.hasMoreElements()) {
            String name = (String)enumlist.nextElement();
            String value = req.getParameter(name);
            this.harnessProps.setProperty(name, value);
        }
        try {
            TestUtil.init((Properties)this.harnessProps);
            this.mybean.init(this.harnessProps);
            this.timeout = Long.parseLong(System.getProperty("jms_timeout"));
            this.user = System.getProperty("user");
            this.password = System.getProperty("password");
        }
        catch (Exception e) {
            System.out.println("doPost: Exception: " + e);
            e.printStackTrace();
            throw new ServletException("unable to initialize remote logging");
        }
        this.doGet(req, res);
        this.harnessProps = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendRecvQueueTestUsingCDIFromServlet() {
        boolean pass = true;
        JMSConsumer consumer = null;
        System.out.println("sendRecvQueueTestUsingCDIFromServlet");
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            logger.log(System.Logger.Level.INFO, "Using CDI injected context1 specifying QueueConnectionFactory");
            consumer = this.context1.createConsumer((Destination)this.queue);
            logger.log(System.Logger.Level.INFO, "Creating TextMessage");
            messageSent = this.context1.createTextMessage();
            messageSent.setText("just a test");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "sendRecvQueueTestUsingCDIFromServlet");
            logger.log(System.Logger.Level.INFO, "Sending TextMessage");
            this.context1.createProducer().send((Destination)this.queue, (Message)messageSent);
            logger.log(System.Logger.Level.INFO, "Receiving TextMessage");
            messageReceived = (TextMessage)consumer.receive(this.timeout);
            if (messageReceived == null) {
                logger.log(System.Logger.Level.ERROR, "No message was received");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Message Sent: \"" + messageSent.getText() + "\"");
                logger.log(System.Logger.Level.INFO, "Message Received: \"" + messageReceived.getText() + "\"");
                if (messageReceived.getText().equals(messageSent.getText())) {
                    logger.log(System.Logger.Level.INFO, "Received correct message");
                } else {
                    logger.log(System.Logger.Level.ERROR, "Received incorrect message");
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            pass = false;
        }
        finally {
            try {
                consumer.receive(this.timeout);
                while (consumer.receiveNoWait() != null) {
                }
                consumer.close();
            }
            catch (Exception exception) {}
        }
        return pass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendRecvTopicTestUsingCDIFromServlet() {
        boolean pass = true;
        JMSConsumer consumer = null;
        System.out.println("sendRecvTopicTestUsingCDIFromServlet");
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            logger.log(System.Logger.Level.INFO, "Using CDI injected context2 specifying TopicConnectionFactory");
            consumer = this.context2.createConsumer((Destination)this.topic);
            logger.log(System.Logger.Level.INFO, "Creating TextMessage");
            messageSent = this.context2.createTextMessage();
            messageSent.setText("just a test");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "sendRecvTopicTestUsingCDIFromServlet");
            logger.log(System.Logger.Level.INFO, "Sending TextMessage");
            this.context2.createProducer().send((Destination)this.topic, (Message)messageSent);
            logger.log(System.Logger.Level.INFO, "Receiving TextMessage");
            messageReceived = (TextMessage)consumer.receive(this.timeout);
            if (messageReceived == null) {
                logger.log(System.Logger.Level.ERROR, "No message was received");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Message Sent: \"" + messageSent.getText() + "\"");
                logger.log(System.Logger.Level.INFO, "Message Received: \"" + messageReceived.getText() + "\"");
                if (messageReceived.getText().equals(messageSent.getText())) {
                    logger.log(System.Logger.Level.INFO, "Received correct message");
                } else {
                    logger.log(System.Logger.Level.ERROR, "Received incorrect message");
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            pass = false;
        }
        finally {
            try {
                consumer.close();
            }
            catch (Exception exception) {}
        }
        return pass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sendRecvUsingCDIDefaultFactoryFromServlet() {
        boolean pass = true;
        JMSConsumer consumer = null;
        JMSConsumer consumer2 = null;
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            TextMessage messageReceived2 = null;
            logger.log(System.Logger.Level.INFO, "Using CDI injected context4 using default system connection factory");
            logger.log(System.Logger.Level.INFO, "Creating Consumer for Queue");
            consumer = this.context4.createConsumer((Destination)this.queue);
            logger.log(System.Logger.Level.INFO, "Creating Consumer for Topic");
            consumer2 = this.context4.createConsumer((Destination)this.topic);
            logger.log(System.Logger.Level.INFO, "Creating TextMessage");
            messageSent = this.context4.createTextMessage();
            messageSent.setText("just a test");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "sendRecvUsingCDIDefaultFactoryFromServlet");
            logger.log(System.Logger.Level.INFO, "Sending TextMessage to Queue");
            this.context4.createProducer().send((Destination)this.queue, (Message)messageSent);
            logger.log(System.Logger.Level.INFO, "Sending TextMessage to Topic");
            this.context4.createProducer().send((Destination)this.topic, (Message)messageSent);
            logger.log(System.Logger.Level.INFO, "Receiving TextMessage from Queue consumer");
            messageReceived = (TextMessage)consumer.receive(this.timeout);
            logger.log(System.Logger.Level.INFO, "Receiving TextMessage from Topic consumer");
            messageReceived2 = (TextMessage)consumer2.receive(this.timeout);
            logger.log(System.Logger.Level.INFO, "Check received message from Queue consumer");
            if (messageReceived == null) {
                logger.log(System.Logger.Level.ERROR, "No message was received");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Message Sent: \"" + messageSent.getText() + "\"");
                logger.log(System.Logger.Level.INFO, "Message Received: \"" + messageReceived.getText() + "\"");
                if (messageReceived.getText().equals(messageSent.getText())) {
                    logger.log(System.Logger.Level.INFO, "Received correct message");
                } else {
                    logger.log(System.Logger.Level.ERROR, "Received incorrect message");
                    pass = false;
                }
            }
            logger.log(System.Logger.Level.INFO, "Check received message from Topic consumer");
            if (messageReceived2 == null) {
                logger.log(System.Logger.Level.ERROR, "No message was received");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Message Sent: \"" + messageSent.getText() + "\"");
                logger.log(System.Logger.Level.INFO, "Message Received: \"" + messageReceived2.getText() + "\"");
                if (messageReceived2.getText().equals(messageSent.getText())) {
                    logger.log(System.Logger.Level.INFO, "Received correct message");
                } else {
                    logger.log(System.Logger.Level.ERROR, "Received incorrect message");
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            pass = false;
        }
        finally {
            try {
                consumer.receive(this.timeout);
                while (consumer.receiveNoWait() != null) {
                }
                consumer.close();
                consumer2.close();
            }
            catch (Exception exception) {}
        }
        return pass;
    }

    public boolean verifySessionModeOnCDIJMSContextFromServlet() {
        boolean pass = true;
        System.out.println("verifySessionModeOnCDIJMSContextFromServlet");
        try {
            logger.log(System.Logger.Level.INFO, "Checking session mode of context3 should be " + this.printSessionMode(3));
            if (this.context3.getSessionMode() != 3) {
                logger.log(System.Logger.Level.ERROR, "Incorrect session mode returned: " + this.printSessionMode(this.context3.getSessionMode()) + "  expected: " + this.printSessionMode(3));
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Returned correct session mode: " + this.printSessionMode(3));
            }
            logger.log(System.Logger.Level.INFO, "Checking session mode of context2 should be " + this.printSessionMode(1));
            if (this.context2.getSessionMode() != 1) {
                logger.log(System.Logger.Level.ERROR, "Incorrect session mode returned: " + this.printSessionMode(this.context2.getSessionMode()) + "  expected: " + this.printSessionMode(1));
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Returned correct session mode: " + this.printSessionMode(1));
            }
            logger.log(System.Logger.Level.INFO, "Checking session mode of context1 should be " + this.printSessionMode(1));
            if (this.context1.getSessionMode() != 1) {
                logger.log(System.Logger.Level.ERROR, "Incorrect session mode returned: " + this.printSessionMode(this.context1.getSessionMode()) + "  expected: " + this.printSessionMode(1));
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Returned correct session mode: " + this.printSessionMode(1));
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            pass = false;
        }
        return pass;
    }

    public boolean testRestrictionsOnCDIJMSContextFromServlet() {
        boolean pass = true;
        System.out.println("testRestrictionsOnCDIJMSContextFromServlet");
        try {
            logger.log(System.Logger.Level.INFO, "Calling JMSContext.acknowledge() MUST throw IllegalStateRuntimeException");
            try {
                this.context1.acknowledge();
            }
            catch (IllegalStateRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected IllegalStateRuntimeException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected Exception: " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Calling JMSContext.setClientID(String) MUST throw IllegalStateRuntimeException");
            try {
                this.context1.setClientID("test");
            }
            catch (IllegalStateRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected IllegalStateRuntimeException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected Exception: " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Calling JMSContext.setExceptionListener(ExceptionListener) MUST throw IllegalStateRuntimeException");
            try {
                this.context1.setExceptionListener(null);
            }
            catch (IllegalStateRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected IllegalStateRuntimeException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected Exception: " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Calling JMSContext.start() MUST throw IllegalStateRuntimeException");
            try {
                this.context1.start();
            }
            catch (IllegalStateRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected IllegalStateRuntimeException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected Exception: " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Calling JMSContext.stop() MUST throw IllegalStateRuntimeException");
            try {
                this.context1.stop();
            }
            catch (IllegalStateRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected IllegalStateRuntimeException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected Exception: " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Calling JMSContext.commit() MUST throw IllegalStateRuntimeException");
            try {
                this.context1.commit();
            }
            catch (IllegalStateRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected IllegalStateRuntimeException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected Exception: " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Calling JMSContext.rollback() MUST throw IllegalStateRuntimeException");
            try {
                this.context1.rollback();
            }
            catch (IllegalStateRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected IllegalStateRuntimeException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected Exception: " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Calling JMSContext.recover() MUST throw IllegalStateRuntimeException");
            try {
                this.context1.recover();
            }
            catch (IllegalStateRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected IllegalStateRuntimeException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected Exception: " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Calling JMSContext.setAutoStart(boolean) MUST throw IllegalStateRuntimeException");
            try {
                this.context1.setAutoStart(true);
            }
            catch (IllegalStateRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected IllegalStateRuntimeException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected Exception: " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Calling JMSContext.close() MUST throw IllegalStateRuntimeException");
            try {
                this.context1.close();
            }
            catch (IllegalStateRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected IllegalStateRuntimeException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected Exception: " + e);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            pass = false;
        }
        return pass;
    }

    public boolean sendRecvQueueTestUsingCDIFromManagedBean() {
        logger.log(System.Logger.Level.INFO, "DEBUG: sendRecvQueueTestUsingCDIFromManagedBean");
        return this.mybean.sendRecvQueueTestUsingCDIFromManagedBean();
    }

    public boolean sendRecvTopicTestUsingCDIFromManagedBean() {
        logger.log(System.Logger.Level.INFO, "DEBUG: sendRecvTopicTestUsingCDIFromManagedBean");
        return this.mybean.sendRecvTopicTestUsingCDIFromManagedBean();
    }
}

