/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee20.ra.common.messaging;

import com.sun.ts.tests.jms.commonee.Client;
import com.sun.ts.tests.jms.ee20.ra.common.messaging.Constants;
import com.sun.ts.tests.jms.ee20.ra.common.messaging.TLogger;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.QueueConnectionFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Properties;
import org.junit.jupiter.api.BeforeEach;

public abstract class QueueClientBase
extends Client
implements Constants {
    private String currentTestName;
    private Queue sendQ;
    private static final System.Logger logger = System.getLogger(QueueClientBase.class.getName());

    protected abstract void initSendQueue();

    protected abstract void initReceiveQueue();

    protected abstract void initQueueConnectionFactory();

    protected Queue getSendQueue() {
        return this.sendQ;
    }

    protected void setSendQueue(Queue q) {
        this.sendQ = q;
    }

    protected Queue getReceiveQueue() {
        return this.rcvrQueue;
    }

    protected void setReceiveQueue(Queue q) {
        this.rcvrQueue = q;
    }

    protected QueueConnectionFactory getQueueConnectionFactory() {
        return this.qFactory;
    }

    protected void setQueueConnectionFactory(QueueConnectionFactory qf) {
        this.qFactory = qf;
    }

    protected String getCurrentTestName() {
        return this.currentTestName;
    }

    protected void setCurrentTestName(String tn) {
        this.currentTestName = tn;
    }

    protected void sendReceive() throws Exception {
        this.sendReceive(this.getCurrentTestName(), 0);
    }

    protected void sendReceiveNegative(String testname, int testnum) throws Exception {
        this.sendOnly(testname, testnum);
        if (this.checkOnResponse(testname)) {
            throw new Exception("This is a negative test that expects no response, but actually got a response.");
        }
        TLogger.log("No response, as expected");
    }

    protected void sendReceive(String testname, int testnum) throws Exception {
        this.sendOnly(testname, testnum);
        if (!this.checkOnResponse(testname)) {
            throw new Exception("checkOnResponse for " + testname + " returned false.");
        }
    }

    protected void sendOnly(String testname, int testnum) throws Exception {
        try {
            this.createTestMessage(testname, testnum);
            MessageProducer producer = this.getMessageProducer();
            producer.setTimeToLive(30000L);
            producer.send((Message)this.msg);
            TLogger.log("message sent from testname: " + testname + ", testnum: " + testnum + ", using producer: " + producer);
        }
        catch (Exception e) {
            throw new Exception(e);
        }
    }

    @BeforeEach
    public void setup() throws Exception {
        this.setCurrentTestName(System.getProperty("testName"));
        this.initReceiveQueue();
        try {
            this.configureQueue();
            this.configureTopic();
        }
        catch (JMSException ex) {
            throw new Exception(ex);
        }
        TLogger.log("get the connection and start up");
        TLogger.log("Client: connection started, now send initialization msg!");
    }

    protected MessageProducer getMessageProducer() throws JMSException {
        this.qSender = this.session.createSender(this.getSendQueue());
        return this.qSender;
    }

    protected void configureQueue() throws JMSException {
        this.initQueueConnectionFactory();
        this.qConnect = this.qFactory.createQueueConnection(this.jmsUser, this.jmsPassword);
        this.session = this.qConnect.createQueueSession(false, 1);
        this.qConnect.start();
        this.initSendQueue();
    }

    protected void configureTopic() throws JMSException {
    }

    protected void urlTest(URL url) throws Exception {
        this.urlTest(url, "PASSED");
    }

    protected void urlTest(URL url, String expectedFirstLine) throws Exception {
        HttpURLConnection conn = null;
        InputStream is = null;
        TLogger.log("About to connect to url: ");
        TLogger.log(url.toString());
        try {
            conn = (HttpURLConnection)url.openConnection();
            int code = conn.getResponseCode();
            if (code != 200) {
                throw new Exception("Unexpected return code: " + code);
            }
            is = conn.getInputStream();
            BufferedReader input = new BufferedReader(new InputStreamReader(is));
            String line = input.readLine();
            if (line != null) {
                line = line.trim();
            }
            if (!expectedFirstLine.equals(line)) {
                throw new Exception("Wrong response. Expected: " + expectedFirstLine + ", received: " + line);
            }
            TLogger.log("Got expected response: " + line);
            try {
                input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        catch (IOException e) {
            throw new Exception(e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    private void initTestProperties(Properties p) throws Exception {
        this.jmsUser = System.getProperty("user");
        if (this.jmsUser == null) {
            logger.log(System.Logger.Level.TRACE, "user is null");
            throw new Exception("Error getting user");
        }
        this.jmsPassword = System.getProperty("password");
        if (this.jmsPassword == null) {
            logger.log(System.Logger.Level.TRACE, "passwd is null");
            throw new Exception("Error getting pwd");
        }
        String time = System.getProperty("jms_timeout");
        if (time == null) {
            logger.log(System.Logger.Level.TRACE, "time is null");
            throw new Exception("Error getting time");
        }
        this.timeout = Integer.parseInt(time);
    }
}

