/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.integration.sec.propagation;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.lib.util.WebUtil;
import java.net.InetAddress;
import java.util.Properties;

public class Client
extends EETest {
    private String protocol = "http";
    private String hostname = null;
    private int portnum = 0;
    private String pageBase = "/integration_sec_propagation_web";
    private String pageWebToEjbAuth = this.pageBase + "/web_to_ejb_auth.jsp";
    private String pageWebToEjbNoauth = this.pageBase + "/web_to_ejb_noauth.jsp";
    private String pageEjbToEjb = this.pageBase + "/ejb_to_ejb.jsp";
    private String username = "";
    private String password = "";
    private String authusername = "";
    private String authpassword = "";
    private String nobodyuser = "";
    private final String WEBHOSTPROP = "webServerHost";
    private final String WEBPORTPROP = "webServerPort";
    private final String USERNAMEPROP = "user";
    private final String PASSWORDPROP = "password";
    private final String AUTHUSERNAMEPROP = "authuser";
    private final String AUTHPASSWORDPROP = "authpassword";
    private final String NOBODYUSERNAMEPROP = "nobodyuser";
    private Properties props = null;
    private String request = null;
    private WebUtil.Response response = null;
    private TSURL ctsurl = new TSURL();

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.props = p;
        try {
            this.hostname = p.getProperty("webServerHost");
            this.portnum = Integer.parseInt(p.getProperty("webServerPort"));
            this.username = p.getProperty("user");
            this.password = p.getProperty("password");
            this.authusername = p.getProperty("authuser");
            this.authpassword = p.getProperty("authpassword");
            this.nobodyuser = p.getProperty("nobodyuser");
            TestUtil.logMsg((String)"setup complete");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Error: got exception: ", (Throwable)e);
            throw new Exception("Got Exception " + e.getMessage() + " during setup.", e);
        }
    }

    public void test_web_to_ejb_auth() throws Exception {
        try {
            String web1Search = this.username;
            String ejbSearch = this.username;
            String web2Search = this.username;
            this.request = this.pageWebToEjbAuth;
            TestUtil.logMsg((String)("Sending request \"" + this.request + "\""));
            this.response = WebUtil.sendAuthenticatedRequest((String)"GET", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.ctsurl.getRequest(this.request), null, null, (String)this.username, (String)this.password);
            if (this.response.isError()) {
                TestUtil.logErr((String)("Could not access " + this.request));
                throw new Exception("test failed.");
            }
            if (this.response.content.indexOf(web1Search) == -1) {
                TestUtil.logErr((String)"Web1 Principal incorrect.  Page received: ");
                TestUtil.logErr((String)this.response.content);
                TestUtil.logErr((String)("Should say: \"" + web1Search + "\")"));
                throw new Exception("test failed.");
            }
            TestUtil.logMsg((String)"Web User Principal correct.");
            if (this.response.content.indexOf(ejbSearch) == -1) {
                TestUtil.logErr((String)"Ejb Principal incorrect.  Page received: ");
                TestUtil.logErr((String)this.response.content);
                TestUtil.logErr((String)("Should say: \"" + ejbSearch + "\")"));
                throw new Exception("test failed.");
            }
            TestUtil.logMsg((String)"Ejb User Principal correct.");
            if (this.response.content.indexOf(web2Search) == -1) {
                TestUtil.logErr((String)"Web2 Principal incorrect.  Page received: ");
                TestUtil.logErr((String)this.response.content);
                TestUtil.logErr((String)("Should say: \"" + web2Search + "\")"));
                throw new Exception("test failed.");
            }
            TestUtil.logMsg((String)"Web User Principal still correct.");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            throw new Exception("test failed: ", e);
        }
    }

    public void test_web_to_ejb_noauth() throws Exception {
        try {
            String web1Search = "null";
            String ejbSearch = "true";
            String web2Search = "null";
            this.request = this.pageWebToEjbNoauth;
            TestUtil.logMsg((String)("Sending request \"" + this.request + "\""));
            this.response = WebUtil.sendRequest((String)"GET", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.ctsurl.getRequest(this.request), null, null);
            if (this.response.isError()) {
                TestUtil.logErr((String)("Could not access " + this.request));
                throw new Exception("test failed.");
            }
            if (this.response.content.indexOf(web1Search) == -1) {
                TestUtil.logErr((String)"Web1 Principal incorrect.  Page received: ");
                TestUtil.logErr((String)this.response.content);
                TestUtil.logErr((String)("Should say: \"" + web1Search + "\")"));
                throw new Exception("test failed.");
            }
            TestUtil.logMsg((String)"Web User Principal correct.");
            if (this.response.content.indexOf(ejbSearch) == -1) {
                TestUtil.logErr((String)"Call to ejb Principal failed.  Page received: ");
                TestUtil.logErr((String)this.response.content);
                TestUtil.logErr((String)("Should say: \"" + ejbSearch + "\")"));
                throw new Exception("test failed.");
            }
            TestUtil.logMsg((String)"Call to ejb successful.");
            if (this.response.content.indexOf(web2Search) == -1) {
                TestUtil.logErr((String)"Web2 Principal incorrect.  Page received: ");
                TestUtil.logErr((String)this.response.content);
                TestUtil.logErr((String)("Should say: \"" + web2Search + "\")"));
                throw new Exception("test failed.");
            }
            TestUtil.logMsg((String)"Web User Principal still correct.");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            throw new Exception("test failed: ", e);
        }
    }

    public void test_ejb_to_ejb() throws Exception {
        try {
            String webSearch = this.authusername;
            String ejb1Search = this.authusername;
            String ejb2Search = this.authusername;
            this.request = this.pageEjbToEjb;
            TestUtil.logMsg((String)("Sending request \"" + this.request + "\""));
            this.response = WebUtil.sendAuthenticatedRequest((String)"GET", (InetAddress)InetAddress.getByName(this.hostname), (int)this.portnum, (String)this.ctsurl.getRequest(this.request), null, null, (String)this.authusername, (String)this.authpassword);
            if (this.response.isError()) {
                TestUtil.logErr((String)("Could not access " + this.request));
                throw new Exception("test failed.");
            }
            if (this.response.content.indexOf(webSearch) == -1) {
                TestUtil.logErr((String)"Web Principal incorrect.  Page received: ");
                TestUtil.logErr((String)this.response.content);
                TestUtil.logErr((String)("Should say: \"" + webSearch + "\")"));
                throw new Exception("test failed.");
            }
            TestUtil.logMsg((String)"Web User Principal correct.");
            if (this.response.content.indexOf(ejb1Search) == -1) {
                TestUtil.logErr((String)"Principal did not propagate from web to ejb.  Page received: ");
                TestUtil.logErr((String)this.response.content);
                TestUtil.logErr((String)("Should say: \"" + ejb1Search + "\")"));
                throw new Exception("test failed.");
            }
            TestUtil.logMsg((String)"Principal propagated from web to ejb.");
            if (this.response.content.indexOf(ejb2Search) == -1) {
                TestUtil.logErr((String)"Principal did not propagate from ejb to ejb.  Page received: ");
                TestUtil.logErr((String)this.response.content);
                TestUtil.logErr((String)("Should say: \"" + ejb2Search + "\")"));
                throw new Exception("test failed.");
            }
            TestUtil.logMsg((String)"Principal propagated from ejb to ejb.");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            throw new Exception("test failed: ", e);
        }
    }

    public void cleanup() throws Exception {
        this.logMsg("cleanup complete");
    }
}

