/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.bb.session.stateful.basic;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.Status;
import com.sun.ts.tests.ejb30.bb.session.stateful.basic.StatefulRemoteCalculator;
import com.sun.ts.tests.ejb30.common.calc.CalculatorException;
import com.sun.ts.tests.ejb30.common.helper.ServiceLocator;
import com.sun.ts.tests.ejb30.common.helper.TLogger;
import jakarta.ejb.NoSuchEJBException;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.NamingException;

public class Client
extends EETest {
    private static final String refName = "java:comp/env/ejb/RemoteCalculatorBean";
    private static int postConstructCallsCount;
    private Properties props;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws Exception {
        this.props = p;
    }

    private static void postConstruct() {
        ++postConstructCallsCount;
    }

    public void postConstructInvokedEvenNoResourceInjection() throws Exception {
        if (postConstructCallsCount <= 0) {
            throw new Exception("Expecting the Client.PostConstruct to be invoked  at least once, but actual " + postConstructCallsCount);
        }
        TLogger.log("Got expected result.  Client.PostConstruct method is invoked " + postConstructCallsCount + " times");
    }

    public void testOperations() throws Exception {
        StatefulRemoteCalculator bean = null;
        boolean passed = false;
        try {
            bean = (StatefulRemoteCalculator)ServiceLocator.lookup(refName, new Context[0]);
        }
        catch (NamingException e) {
            throw new Exception(e);
        }
        this.logMsg("About to call bean " + bean.toString());
        this.testRemoteAdd(bean);
        this.testRemoteThrowIt(bean);
        try {
            bean.remoteAdd(1, 2);
        }
        catch (NoSuchEJBException e) {
            TLogger.log("Got expected exception: " + e.toString());
        }
    }

    private void testRemoteAdd(StatefulRemoteCalculator bean) throws Exception {
        int op1 = 2;
        int op2 = 3;
        int expected = op1 + op2;
        int result = 0;
        try {
            result = bean.remoteAdd(op1, op2);
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
        if (result != expected) {
            throw new Exception("Expected " + expected + ", actual " + result);
        }
    }

    private void testRemoteThrowIt(StatefulRemoteCalculator bean) throws Exception {
        boolean passed = false;
        try {
            bean.remoteThrowIt();
        }
        catch (CalculatorException e) {
            passed = true;
        }
        catch (Exception e) {
            throw new Exception("Unexpected exception:", e);
        }
        if (!passed) {
            throw new Exception("Expected CalculatorException, actual no exception");
        }
    }

    public void cleanup() throws Exception {
    }
}

