/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.common.allowed;

import com.sun.ts.tests.ejb30.common.allowed.AllowedIF;
import com.sun.ts.tests.ejb30.common.allowed.AllowedLocalIF;
import com.sun.ts.tests.ejb30.common.allowed.CancelInterceptor;
import com.sun.ts.tests.ejb30.common.helper.TLogger;
import com.sun.ts.tests.ejb30.common.helper.TestFailedException;
import jakarta.ejb.SessionContext;
import jakarta.ejb.Timer;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.InvocationContext;
import java.util.Map;
import java.util.Properties;

public abstract class AllowedBeanBase
implements AllowedIF,
AllowedLocalIF {
    protected SessionContext sessionContext;
    protected Properties preInvokeResults;
    protected Properties postInvokeResults = new Properties();

    public abstract Properties runOperations(SessionContext var1);

    public void timeout(Timer timer) {
    }

    public void setSessionContext(SessionContext sc) {
        this.sessionContext = sc;
    }

    @AroundInvoke
    public Object intercept(InvocationContext inv) throws Exception {
        String methodName = inv.getMethod().getName();
        TLogger.log("calling interceptor method prior to " + methodName);
        boolean isPreInvokeTest = false;
        boolean isPostInvokeTest = false;
        if (methodName.equalsIgnoreCase("preInvokeTest")) {
            isPreInvokeTest = true;
        } else if (methodName.equalsIgnoreCase("getResultsPostInvoke")) {
            isPostInvokeTest = true;
        }
        try {
            Object result;
            if (isPreInvokeTest) {
                this.preInvokeResults = null;
                this.preInvokeResults = this.runOperations(this.sessionContext);
            }
            Object object = result = inv.proceed();
            return object;
        }
        catch (TestFailedException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        finally {
            if (isPostInvokeTest) {
                Properties prps = this.runOperations(this.sessionContext);
                this.postInvokeResults.clear();
                this.postInvokeResults.putAll((Map<?, ?>)prps);
                this.cancelTimersPostInvoke(this.sessionContext);
            }
        }
    }

    protected void cancelTimersPostInvoke(SessionContext sctx) {
        CancelInterceptor.getInstance().cancelTimers(sctx);
    }

    @Override
    public void remove() {
    }

    @Override
    public void txNotSupported() throws TestFailedException {
    }

    @Override
    public void txSupports() throws TestFailedException {
    }

    @Override
    public void txNever() throws TestFailedException {
    }

    @Override
    public void utBeginTest() throws TestFailedException {
    }

    @Override
    public Properties business() {
        return this.runOperations(this.sessionContext);
    }

    @Override
    public Properties preInvokeTest() {
        return this.preInvokeResults;
    }

    @Override
    public void postInvokeTest() {
    }

    @Override
    public Properties getResultsPostInvoke() {
        return this.postInvokeResults;
    }

    @Override
    public void setTestMethod(String testMethod) {
    }

    @Override
    public Properties getResultsAfterCompletion() {
        return null;
    }

    @Override
    public Properties beforeCompletionTest() {
        return null;
    }

    @Override
    public void afterCompletionTest() {
    }

    @Override
    public Properties afterBeginTest() {
        return null;
    }
}

