/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jta.ee.transactional;

import com.sun.ts.lib.util.TestUtil;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class Helper {
    private static Logger logger = Logger.getLogger("com.sun.ts.tests.ejb30");

    private Helper() {
    }

    public static Logger getLogger() {
        return logger;
    }

    public static String compareResultList(List expected, List actual) {
        if (!expected.equals(actual)) {
            String reason = TestUtil.NEW_LINE + "Expecting result list: " + expected + TestUtil.NEW_LINE + "         , but actual: " + actual;
            throw new RuntimeException(reason);
        }
        String reason = "Got expected result list: " + expected;
        logger.info(reason);
        return reason;
    }

    public static String compareResult(String expected, String actual) {
        if (!expected.equals(actual)) {
            String reason = TestUtil.NEW_LINE + "Expecting result : " + expected + TestUtil.NEW_LINE + "         , but actual: " + actual;
            throw new RuntimeException(reason);
        }
        String reason = "Got expected result : " + expected;
        logger.info(reason);
        return reason;
    }

    public static String compareResultList(String[] expected, List actual) {
        return Helper.compareResultList(Arrays.asList(expected), actual);
    }

    public static String assertEquals(String messagePrefix, Object expected, Object actual) throws RuntimeException {
        StringBuilder sb = new StringBuilder();
        Helper.assertEquals(messagePrefix, expected, actual, sb);
        return sb.toString();
    }

    public static void assertEquals(String messagePrefix, Object expected, Object actual, StringBuilder sb) throws RuntimeException {
        sb.append(TestUtil.NEW_LINE);
        if (messagePrefix != null) {
            sb.append(TestUtil.NEW_LINE).append(messagePrefix).append(" ");
        }
        if (!Helper.equalsOrNot(expected, actual)) {
            sb.append("Expecting ").append(expected).append(", but actual ").append(actual);
            throw new RuntimeException(sb.toString());
        }
        sb.append("Got the expected result:").append(actual).append("\t");
    }

    public static String assertNotEquals(String messagePrefix, Object expected, Object actual) throws RuntimeException {
        StringBuilder sb = new StringBuilder();
        Helper.assertNotEquals(messagePrefix, expected, actual, sb);
        return sb.toString();
    }

    public static void assertNotEquals(String messagePrefix, Object expected, Object actual, StringBuilder sb) throws RuntimeException {
        sb.append(TestUtil.NEW_LINE);
        if (messagePrefix != null) {
            sb.append(messagePrefix).append(" ");
        }
        if (Helper.equalsOrNot(expected, actual)) {
            sb.append("Expecting NotEquals, but got equals. compareTo:").append(expected).append(", and actual: ").append(actual);
            throw new RuntimeException(sb.toString());
        }
        sb.append("Got the expected NotEquals result. compareTo:").append(expected).append(", actual:").append(actual).append("\t");
    }

    public static void assertCloseEnough(String messagePrefix, long expected, long actual, long ignoreableDiff, StringBuilder sb) {
        long dif;
        sb.append(TestUtil.NEW_LINE);
        if (messagePrefix != null) {
            sb.append(messagePrefix).append(" ");
        }
        if ((dif = Math.abs(actual - expected)) > ignoreableDiff) {
            throw new RuntimeException("the diff between expected " + expected + ", and actual " + actual + " is " + dif + ", greater than the ignoreableDiff " + ignoreableDiff);
        }
        sb.append("Got the expected result:");
        sb.append("the diff between expected " + expected + ", and actual " + actual + " is " + dif + ", equals or less than the ignoreableDiff " + ignoreableDiff);
    }

    public static String assertGreaterThan(String messagePrefix, long arg1, long arg2) throws RuntimeException {
        StringBuilder sb = new StringBuilder();
        Helper.assertGreaterThan(messagePrefix, arg1, arg2, sb);
        return sb.toString();
    }

    public static void assertGreaterThan(String messagePrefix, long arg1, long arg2, StringBuilder sb) throws RuntimeException {
        sb.append(TestUtil.NEW_LINE);
        if (messagePrefix != null) {
            sb.append(messagePrefix).append(" ");
        }
        if (arg1 <= arg2) {
            sb.append("Expecting ").append(arg1).append(">").append(arg2).append(", but failed");
            throw new RuntimeException(sb.toString());
        }
        sb.append("Got the expected result:").append(arg1).append(">").append(arg2).append("\t");
    }

    public static void busyWait(long millis) {
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Begin busy wait " + millis + " milliseconds");
        }
        long end = System.currentTimeMillis() + millis;
        while (System.currentTimeMillis() < end) {
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.finer("Finished busy wait " + millis + " milliseconds");
        }
    }

    public static void preDestroy(Object obj) {
        logger.info("In PreDestroy of " + obj);
    }

    public static void main(String[] args) {
        System.out.println(Helper.assertEquals("compare strings", "a", "a"));
        System.out.println(Helper.assertEquals("compare primitives", 100, 100));
        int i = 0;
        int j = 0;
        System.out.println(Helper.assertEquals("compare declared primitives", i, j));
        StringBuilder sb = new StringBuilder();
        sb.append("Check the following: ");
        Helper.assertEquals("String:", "a", "a", sb);
        Helper.assertEquals("int:", 5, 5, sb);
        Helper.assertEquals("double:", 5.5, 5.5, sb);
        Helper.assertEquals("long:", 9999L, 9999L, sb);
        Helper.assertEquals("Object:", new String("st"), new String("st"), sb);
        System.out.println(sb.toString());
        Helper.busyWait(4000L);
    }

    private static boolean equalsOrNot(Object expected, Object actual) {
        boolean sameOrNot = false;
        if (expected == null) {
            if (actual == null) {
                sameOrNot = true;
            }
        } else {
            sameOrNot = expected.equals(actual);
        }
        return sameOrNot;
    }
}

