/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.lib.util.sec.security.provider;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.security.AccessController;
import java.security.Identity;
import java.security.IdentityScope;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyManagementException;
import java.security.MessageDigest;
import java.security.PrivilegedAction;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signer;
import java.util.Enumeration;
import java.util.Hashtable;

public class IdentityDatabase
extends IdentityScope
implements Serializable {
    private static final long serialVersionUID = 4923799573357658384L;
    private static final boolean debug = false;
    private static final boolean error = true;
    File sourceFile;
    Hashtable<String, Identity> identities = new Hashtable();

    IdentityDatabase() throws InvalidParameterException {
        this("restoring...");
    }

    public IdentityDatabase(File file) throws InvalidParameterException {
        this(file.getName());
        this.sourceFile = file;
    }

    public IdentityDatabase(String name) throws InvalidParameterException {
        super(name);
    }

    public static IdentityDatabase fromStream(InputStream is) throws IOException {
        IdentityDatabase db = null;
        try {
            ObjectInputStream ois = new ObjectInputStream(is);
            db = (IdentityDatabase)ois.readObject();
        }
        catch (ClassNotFoundException e) {
            IdentityDatabase.debug("This should not be happening.", e);
            IdentityDatabase.error("The version of the database is obsolete. Cannot initialize.");
        }
        catch (InvalidClassException e) {
            IdentityDatabase.debug("This should not be happening.", e);
            IdentityDatabase.error("Unable to initialize system identity scope:  InvalidClassException. \nThis is most likely due to a serialization versioning problem: a class used in key management was obsoleted");
        }
        catch (StreamCorruptedException e) {
            IdentityDatabase.debug("The serialization stream is corrupted. Unable to load.", e);
            IdentityDatabase.error("Unable to initialize system identity scope. StreamCorruptedException.");
        }
        if (db == null) {
            db = new IdentityDatabase("uninitialized");
        }
        return db;
    }

    public static IdentityDatabase fromFile(File f) throws IOException {
        FileInputStream fis = new FileInputStream(f);
        IdentityDatabase edb = IdentityDatabase.fromStream(fis);
        edb.sourceFile = f;
        return edb;
    }

    @Override
    public int size() {
        return this.identities.size();
    }

    @Override
    public Identity getIdentity(String name) {
        Identity id = this.identities.get(name);
        if (id instanceof Signer) {
            this.localCheck("get.signer");
        }
        return id;
    }

    @Override
    public Identity getIdentity(PublicKey key) {
        if (key == null) {
            return null;
        }
        Enumeration<Identity> e = this.identities();
        while (e.hasMoreElements()) {
            Identity i = e.nextElement();
            PublicKey k = i.getPublicKey();
            if (k == null || !this.keyEqual(k, key)) continue;
            if (i instanceof Signer) {
                this.localCheck("get.signer");
            }
            return i;
        }
        return null;
    }

    private boolean keyEqual(Key key1, Key key2) {
        if (key1 == key2) {
            return true;
        }
        return MessageDigest.isEqual(key1.getEncoded(), key2.getEncoded());
    }

    @Override
    public void addIdentity(Identity identity) throws KeyManagementException {
        this.localCheck("add.identity");
        Identity byName = this.getIdentity(identity.getName());
        Identity byKey = this.getIdentity(identity.getPublicKey());
        String msg = null;
        if (byName != null) {
            msg = "name conflict";
        }
        if (byKey != null) {
            msg = "key conflict";
        }
        if (msg != null) {
            throw new KeyManagementException(msg);
        }
        this.identities.put(identity.getName(), identity);
    }

    @Override
    public void removeIdentity(Identity identity) throws KeyManagementException {
        this.localCheck("remove.identity");
        String name = identity.getName();
        if (this.identities.get(name) == null) {
            throw new KeyManagementException("there is no identity named " + name + " in " + String.valueOf(this));
        }
        this.identities.remove(name);
    }

    @Override
    public Enumeration<Identity> identities() {
        return this.identities.elements();
    }

    void setSourceFile(File f) {
        this.sourceFile = f;
    }

    File getSourceFile() {
        return this.sourceFile;
    }

    public void save(OutputStream os) throws IOException {
        try {
            ObjectOutputStream oos = new ObjectOutputStream(os);
            oos.writeObject(this);
            oos.flush();
        }
        catch (InvalidClassException e) {
            IdentityDatabase.debug("This should not be happening.", e);
            return;
        }
    }

    void save(File f) throws IOException {
        this.setSourceFile(f);
        FileOutputStream fos = new FileOutputStream(f);
        this.save(fos);
    }

    public void save() throws IOException {
        if (this.sourceFile == null) {
            throw new IOException("this database has no source file");
        }
        this.save(this.sourceFile);
    }

    private static File systemDatabaseFile() {
        Object dbPath = Security.getProperty("identity.database");
        if (dbPath == null) {
            dbPath = System.getProperty("user.home") + File.separatorChar + "identitydb.obj";
        }
        return new File((String)dbPath);
    }

    private static void initializeSystem() {
        File dbFile = IdentityDatabase.systemDatabaseFile();
        try {
            IdentityDatabase systemDatabase;
            if (dbFile.exists()) {
                IdentityDatabase.debug("loading system database from file: " + String.valueOf(dbFile));
                systemDatabase = IdentityDatabase.fromFile(dbFile);
            } else {
                systemDatabase = new IdentityDatabase(dbFile);
            }
            IdentityScope.setSystemScope(systemDatabase);
            IdentityDatabase.debug("System database initialized: " + String.valueOf(systemDatabase));
        }
        catch (IOException e) {
            IdentityDatabase.debug("Error initializing identity database: " + String.valueOf(dbFile), e);
            return;
        }
        catch (InvalidParameterException e) {
            IdentityDatabase.debug("Error trying to instantiate a system identities db in " + String.valueOf(dbFile), e);
            return;
        }
    }

    @Override
    public String toString() {
        return "sun.security.provider.IdentityDatabase, source file: " + String.valueOf(this.sourceFile);
    }

    private static void debug(String s) {
    }

    private static void debug(String s, Throwable t) {
    }

    private static void error(String s) {
        System.err.println(s);
    }

    void localCheck(String directive) {
    }

    String localFullName() {
        Object parsable = this.getName();
        if (this.getScope() != null) {
            parsable = (String)parsable + "." + this.getScope().getName();
        }
        return parsable;
    }

    private synchronized void writeObject(ObjectOutputStream stream) throws IOException {
        this.localCheck("serialize.identity.database");
        stream.writeObject(this.identities);
        stream.writeObject(this.sourceFile);
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                IdentityDatabase.initializeSystem();
                return null;
            }
        });
    }
}

