/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec.template;

import com.sun.interview.Interview;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.exec.ContextManager;
import com.sun.javatest.exec.InterviewEditor;
import com.sun.javatest.tool.UIFactory;
import java.io.File;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;

public class TemplateEditor
extends InterviewEditor {
    static final String TEMPLATE_EXTENSION = ".jtm";
    static final String JTM = ".jtm";
    static final String TEMPLATE_HISTORY = "templateHistory.jtl";

    public TemplateEditor(JComponent parent, UIFactory uif, InterviewParameters ip, ContextManager cm) {
        super(parent, uif, ip, cm);
        this.viewConfig.setTemplate(true);
        this.templateMode = true;
    }

    @Override
    public String getExtention() {
        return ".jtm";
    }

    @Override
    protected String getHistoryFileName() {
        return TEMPLATE_HISTORY;
    }

    @Override
    protected void notifyObservers() {
        this.viewConfig.setTemplate(true);
        super.notifyObservers();
    }

    @Override
    protected void doSave(File file) throws Interview.Fault, IOException {
        this.viewConfig.save(file, true);
        this.viewConfig.setTemplate(true);
    }

    @Override
    protected String getRestorerWindowKey(boolean isFullView) {
        return "confEdit.template" + (isFullView ? ".f" : ".s");
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        JMenuBar bar = super.getJMenuBar();
        if (bar != null) {
            for (int i = bar.getMenuCount() - 1; i >= 0; --i) {
                String mName;
                JMenu jm = bar.getMenu(i);
                if (jm == null || (mName = jm.getName()) == null || !mName.endsWith("help")) continue;
                JMenuItem mainItem = this.uif.createHelpMenuItem("te.help.maint", "confEdit.templateDialog.csh");
                jm.insert(mainItem, 1);
                break;
            }
        }
    }

    @Override
    public int getFileChooserMode() {
        return 3;
    }
}

