/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ant.taskdefs.common;

import com.sun.ant.TSBuildListener;
import com.sun.ant.taskdefs.common.ArchiveInfo;
import com.sun.ant.taskdefs.common.TaskUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.taskdefs.Expand;
import org.apache.tools.ant.taskdefs.Filter;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.FilterSet;

public class Make2Ant
extends Task {
    public static final String FS = File.separator;
    public static final String NL = System.getProperty("line.separator");
    public static final String SIX = "      ";
    public static final String EIGHT = "        ";
    private boolean makeFilePresent = true;
    private String emptyContentDir = "${ts.home}/src/web/empty";
    private String tsHome;
    private File template;
    private Properties known = new Properties();
    private ArrayList alreadyIncludedClasses = new ArrayList();
    private ArrayList vehicleClasses = new ArrayList(4);
    private Set processedJarWars = new HashSet();
    private boolean sccscreate = true;
    private boolean sccsedit = true;
    private boolean sccsdelget = true;
    private Properties tokenVals = new Properties();
    private final File tmpDir = new File("/tmp/antgen");
    public static List serviceList = new ArrayList(15);
    private boolean isCompatDir;
    private boolean vehicleDirsSet;
    private boolean nonopkg;

    public void setNonopkg(boolean b) {
        this.nonopkg = b;
    }

    public void setSccscreate(boolean b) {
        this.sccscreate = b;
    }

    public void setSccsedit(boolean b) {
        this.sccsedit = b;
    }

    public void setSccsdelget(boolean b) {
        this.sccsdelget = b;
    }

    public boolean getSccscreate() {
        return this.sccscreate;
    }

    public boolean getSccsedit() {
        return this.sccsedit;
    }

    public boolean getSccsdelget() {
        return this.sccsdelget;
    }

    public void setTemplate(File template) {
        this.template = template;
    }

    public void init() {
        this.tsHome = this.project.getProperty("ts.home");
        this.known.setProperty("ts.home", this.tsHome);
        this.known.setProperty("TS_HOME", this.tsHome);
        this.known.setProperty("SLASH", "/");
        this.known.setProperty("SEP", ":");
        if (!this.tmpDir.exists()) {
            this.tmpDir.mkdir();
        }
        String vehicleDir = this.project.getProperty("vehicle.dir");
        String vehiclePkg = vehicleDir.replace('/', '.');
        this.vehicleClasses.add(vehiclePkg + ".ejb.EJBVehicle.class");
        this.vehicleClasses.add(vehiclePkg + ".ejb.EJBVehicleRemote.class");
        this.vehicleClasses.add(vehiclePkg + ".ejb.EJBVehicleHome.class");
        this.vehicleClasses.add(vehiclePkg + ".servlet.ServletVehicle.class");
    }

    private void initTemplate() {
        if (this.template == null) {
            File serviceTemplate = new File(this.tsHome + "/tools/make2ant", "service.template");
            File nonServiceTemplate = new File(this.tsHome + "/tools/make2ant", "nonservice.template");
            String sUserDir = System.getProperty("user.dir");
            if (sUserDir.indexOf(FS + "samples" + FS) != -1) {
                if (sUserDir.indexOf(FS + "ejb" + FS) != -1) {
                    this.template = nonServiceTemplate;
                    return;
                }
                this.template = serviceTemplate;
                return;
            }
            String toFind = "com" + FS + "sun" + FS + "ts" + FS + "tests" + FS;
            int i = sUserDir.indexOf(toFind);
            if (i != -1) {
                int endPos = sUserDir.indexOf(FS, i + toFind.length());
                String testArea = null;
                testArea = endPos == -1 ? sUserDir.substring(i + toFind.length()) : sUserDir.substring(i + toFind.length(), endPos);
                this.log("Current test area is:" + testArea);
                this.template = serviceList.contains(testArea) ? serviceTemplate : nonServiceTemplate;
            }
        }
        if (!this.template.exists()) {
            throw new BuildException("template file does not exist:" + this.template.getPath());
        }
    }

    public void execute() throws BuildException {
        this.initTemplate();
        String testDir = this.tsHome + FS + "src" + FS + "com" + FS + "sun" + FS + "ts" + FS + "tests";
        String sUserDir = this.project.getProperty("user.dir");
        if (sUserDir.replace('\\', '/').indexOf(testDir.replace('\\', '/')) == -1) {
            this.log("user.dir=" + sUserDir + " does not contain:" + testDir);
            throw new BuildException("The current directory is not a test dir.");
        }
        this.log("Creating build.xml for tests starting " + sUserDir);
        this.handleDir(new File(sUserDir));
    }

    private boolean isLeafDir(File userDir, Properties mkp) {
        try {
            this.makeProps(new File(userDir, "Makefile"), mkp);
        }
        catch (IOException ex) {
            this.makeFilePresent = false;
            throw new BuildException("Makefile does not exist.");
        }
        return !mkp.containsKey("SUBDIRS");
    }

    private void handleDir(File userDir) throws BuildException {
        Properties mkp = new Properties();
        if (this.isLeafDir(userDir, mkp)) {
            this.log("In leaf dir=" + userDir.getPath());
            this.doLeaf(userDir, mkp);
        } else {
            String subDirs = mkp.getProperty("SUBDIRS");
            this.log("In non-leaf=" + userDir.getPath());
            StringTokenizer st = new StringTokenizer(subDirs);
            while (st.hasMoreTokens()) {
                String val = st.nextToken();
                this.handleDir(new File(userDir, val));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleEjbClasses(File leafDir, Properties props, String pkg) {
        String intfs = props.getProperty("INTERFACE");
        if (intfs != null) {
            StringTokenizer st = new StringTokenizer(intfs);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                this.alreadyIncludedClasses.add(pkg + "." + token);
            }
        }
        intfs = null;
        String beans = props.getProperty("BEANS");
        if (beans != null) {
            StringTokenizer st = new StringTokenizer(beans);
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                this.alreadyIncludedClasses.add(pkg + "." + token);
            }
        }
        FileFilter propsFileFilter = new FileFilter(){

            public boolean accept(File pathname) {
                if (!pathname.isFile()) {
                    return false;
                }
                String fname = pathname.getName();
                return fname.endsWith(".props") || fname.endsWith(".webprops");
            }
        };
        File[] propsFile = leafDir.listFiles(propsFileFilter);
        for (int i = 0; i < propsFile.length; ++i) {
            Properties ps = new Properties();
            FileInputStream ins = null;
            try {
                ins = new FileInputStream(propsFile[i]);
                ps.load(ins);
                Enumeration<?> enu = ps.propertyNames();
                while (enu.hasMoreElements()) {
                    String val;
                    String key = (String)enu.nextElement();
                    if (!this.isClassKey(key) || (val = ps.getProperty(key)) == null || val.startsWith("java.") || val.startsWith("javax.")) continue;
                    this.log("Add to alreadyIncludedClass:" + val + ".class", 3);
                    this.alreadyIncludedClasses.add(val + ".class");
                }
                continue;
            }
            catch (Exception ex) {
                this.log("Cannot load props file:" + propsFile[i]);
                continue;
            }
            finally {
                if (ins != null) {
                    try {
                        ins.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private boolean isClassKey(String s) {
        if (s == null || s.length() == 0) {
            return false;
        }
        ArrayList<String> classKeys = new ArrayList<String>(610);
        classKeys.add("remoteInterface");
        classKeys.add("homeInterface");
        classKeys.add("localInterface");
        classKeys.add("localHomeInterface");
        for (int i = 0; i < 200; ++i) {
            classKeys.add("ejb" + i + ".name");
            classKeys.add("ejb" + i + ".entity.primaryKey");
            classKeys.add("webComponent" + i + ".classname");
        }
        int pos = -1;
        int n = classKeys.size();
        for (int i = 0; i < n; ++i) {
            pos = s.indexOf((String)classKeys.get(i));
            if (pos == -1) continue;
            return true;
        }
        return false;
    }

    private void doLeaf(File leafDir, Properties props) throws BuildException {
        String toFind;
        int pos;
        this.isCompatDir = false;
        this.vehicleDirsSet = true;
        this.tokenVals.clear();
        this.alreadyIncludedClasses.clear();
        this.processedJarWars.clear();
        this.tokenVals.setProperty("pkgDirWarn", "");
        this.alreadyIncludedClasses.addAll(this.vehicleClasses);
        this.loadOtherMakefiles(leafDir, props);
        props.setProperty("SLASH", "/");
        this.known.putAll((Map<?, ?>)props);
        this.resolveAllProperties(props, this.known);
        if (!props.containsKey("VEHICLE_DIRS")) {
            this.vehicleDirsSet = false;
        }
        String pkg = props.getProperty("PACKAGE");
        String projectName = null;
        boolean pkgWarn = false;
        if (pkg == null || pkg.trim().length() == 0) {
            pkg = TaskUtil.path2PkgDir(leafDir).replace('/', '.');
        }
        if ((pos = pkg.indexOf(toFind = "com.sun.ts.tests.")) == -1) {
            pkg = TaskUtil.path2PkgDir(leafDir).replace('/', '.');
            pkgWarn = true;
        }
        if ((pos = pkg.indexOf(toFind)) != -1) {
            projectName = pkg.substring(pos + toFind.length()).replace('.', '_');
        } else {
            pkgWarn = true;
            projectName = pkg.replace('.', '_');
        }
        if (pkgWarn) {
            this.tokenVals.setProperty("pkgDirWarn", "<!-- WARNING: package does not mirror source tree. -->");
        }
        this.addFilterProps("projectName", projectName);
        String pkgDir = pkg.replace('.', '/');
        this.addFilterProps("pkgDir", pkgDir);
        if (pkg == null || pkg.trim().length() == 0) {
            throw new BuildException("Cannot get pkg from Makefile or path.");
        }
        this.handleEjbClasses(leafDir, props, pkg);
        String appName = props.getProperty("APP_NAME");
        if (appName == null || appName.length() == 0) {
            appName = props.getProperty("TESTNAME");
        }
        this.addFilterProps("appName", appName);
        if (appName == null || appName.length() == 0) {
            this.tokenVals.setProperty("appNameElement", "");
        } else {
            this.tokenVals.setProperty("appNameElement", "  <property> name=\"app.name\" value=\"" + appName + "\"/>");
        }
        String clientName = props.getProperty("CLIENT_NAME");
        String mainClass = null;
        if (clientName != null && clientName.length() != 0 && Character.isUpperCase(clientName.charAt(0))) {
            mainClass = pkg + "." + clientName;
        } else {
            String client;
            mainClass = props.getProperty("FULLCLIENT");
            if ((mainClass == null || mainClass.length() == 0) && (client = props.getProperty("CLIENT")) != null && client.length() != 0) {
                int i = client.lastIndexOf(".class");
                if (i != -1) {
                    client = client.substring(0, i);
                }
                mainClass = pkg + "." + client;
            }
        }
        if (mainClass != null) {
            this.addFilterProps("mainClass", mainClass);
            this.alreadyIncludedClasses.add(mainClass + ".class");
        }
        String testClasses = props.getProperty("TEST_CLASSES");
        if (this.template.getName().equals("service.template")) {
            if (testClasses != null && testClasses.length() != 0) {
                if (testClasses.indexOf("${SLASH}") != -1) {
                    testClasses = TaskUtil.replace(testClasses, "${SLASH}", "/");
                }
                StringTokenizer st = new StringTokenizer(testClasses, ":");
                String supportIncludes = "";
                while (st.hasMoreTokens()) {
                    String oneClass = st.nextToken();
                    if (!oneClass.endsWith(".class") && !oneClass.endsWith("*") || ArchiveInfo.isIncluded(this.alreadyIncludedClasses, oneClass)) continue;
                    supportIncludes = supportIncludes + oneClass + ", ";
                }
                if ((supportIncludes = supportIncludes.trim()).endsWith(",")) {
                    supportIncludes = supportIncludes.substring(0, supportIncludes.length() - 1);
                }
                if (supportIncludes.length() == 0) {
                    this.tokenVals.setProperty("supportIncludes", "");
                    this.tokenVals.setProperty("supportElement", "");
                } else {
                    this.tokenVals.setProperty("supportIncludes", supportIncludes);
                    this.tokenVals.setProperty("supportElement", NL + EIGHT + "<support includes=\"" + supportIncludes + "\"/>");
                }
            }
        } else {
            this.inspectArchives(leafDir);
        }
        this.copyFile(leafDir);
    }

    private void addFilterProps(String key, String val) {
        if (val != null && val.length() != 0) {
            this.tokenVals.setProperty(key, val.trim());
        }
    }

    private void inspectArchives(File leafDir) {
        File[] sccsEars;
        File fullDist;
        File[] ears = leafDir.listFiles(ArchiveInfo.earFilter);
        File[] jarWars = leafDir.listFiles(ArchiveInfo.jarWarFilter);
        if (ears.length == 0 && jarWars.length == 0 && (fullDist = new File(TSBuildListener.tsHome + "/dist", TaskUtil.path2PkgDir(leafDir))).exists()) {
            int i;
            for (i = 0; i < ears.length; ++i) {
                ears[i].setLastModified(System.currentTimeMillis());
            }
            for (i = 0; i < jarWars.length; ++i) {
                jarWars[i].setLastModified(System.currentTimeMillis());
            }
            FileSet fs = new FileSet();
            fs.setDir(fullDist);
            fs.setIncludes("*.ear,*.jar,*.war,*.rar");
            Copy copyTask = new Copy();
            copyTask.setProject(this.project);
            copyTask.init();
            copyTask.setTodir(leafDir);
            copyTask.addFileset(fs);
            copyTask.perform();
        }
        ears = leafDir.listFiles(ArchiveInfo.earFilter);
        jarWars = leafDir.listFiles(ArchiveInfo.jarWarFilter);
        File sccsDir = new File(leafDir, "SCCS");
        if (sccsDir.exists() && (sccsEars = sccsDir.listFiles(ArchiveInfo.earFilter)) != null && ears.length == sccsEars.length && ears.length > 0) {
            this.isCompatDir = true;
            return;
        }
        String earElement = "";
        this.genJarWarElement(jarWars, leafDir);
        if (ears != null) {
            if (ears.length == 0) {
                this.log("WARNING:no ear in leafDir:" + leafDir.getPath(), 1);
                this.tokenVals.put("earElement", "");
                return;
            }
            if (ears.length == 1) {
                String fileName = ears[0].getName();
                String appName = fileName.substring(0, fileName.indexOf(".ear"));
                if (jarWars.length == 0) {
                    earElement = "      <appear name=\"" + appName + "\"/>";
                } else {
                    String includeJarWar = ArchiveInfo.jarWarInEar(ears[0]);
                    if (includeJarWar == null) {
                        includeJarWar = "@includeJarWar@";
                    }
                    earElement = earElement + SIX + "<appear name=\"" + appName + "\">" + NL + EIGHT + "<support includes=\"" + includeJarWar + "\"/>" + NL + SIX + "</appear>" + NL;
                }
                this.tokenVals.put("earElement", earElement);
            } else {
                for (int i = 0; i < ears.length; ++i) {
                    String fileName = ears[i].getName();
                    String appName = fileName.substring(0, fileName.indexOf(".ear"));
                    String includeJarWar = ArchiveInfo.jarWarInEar(ears[i]);
                    earElement = includeJarWar != null ? earElement + SIX + "<appear name=\"" + appName + "\">" + NL + EIGHT + "<support includes=\"" + includeJarWar + "\"/>" + NL + SIX + "</appear>" + NL : "      <appear name=\"" + appName + "\"/>";
                }
                this.tokenVals.put("earElement", earElement);
            }
            this.expandEars(ears);
            this.genJarWarElement(this.tmpDir.listFiles(ArchiveInfo.jarWarFilter), leafDir);
        } else {
            this.tokenVals.put("earElement", "");
            if (jarWars == null || jarWars.length == 0) {
                this.log("WARNING:no ear/jar/war in leafDir:" + leafDir.getPath(), 1);
            }
        }
    }

    private void genJarWarElement(File[] jarWars, File leafDir) {
        String jarWarElement = this.tokenVals.getProperty("jarWarElement", "");
        if (jarWars == null || jarWars.length == 0) {
            if (jarWarElement.equals("")) {
                this.tokenVals.put("jarWarElement", "");
            }
            return;
        }
        for (int i = 0; i < jarWars.length; ++i) {
            if (this.processedJarWars.contains(jarWars[i].getName())) continue;
            Properties attrs = ArchiveInfo.getAttrs(jarWars[i], this.tokenVals, leafDir);
            String smain = this.tokenVals.getProperty("mainClass");
            if (smain != null) {
                this.alreadyIncludedClasses.add(smain + ".class");
            }
            String taskName = attrs.getProperty("taskName");
            jarWarElement = jarWarElement + SIX + "<" + taskName + " descriptor=\"" + attrs.getProperty("descriptor") + "\" name=\"" + attrs.getProperty("name") + "\"" + attrs.getProperty("mainClassElement") + ">" + NL;
            String supportIncludes = this.handleJarWar(jarWars[i]);
            if (supportIncludes != null) {
                jarWarElement = jarWarElement + EIGHT + "<support includes=\"" + supportIncludes + "\"/>" + NL;
            }
            if (taskName.equals("webwar")) {
                jarWarElement = this.checkContentDir(leafDir, jarWars[i], jarWarElement);
            }
            jarWarElement = jarWarElement + SIX + "</" + taskName + ">" + NL;
            this.processedJarWars.add(jarWars[i].getName());
        }
        this.tokenVals.put("jarWarElement", jarWarElement);
    }

    private String handleJarWar(File file) {
        String result = "";
        try {
            JarFile jar = new JarFile(file);
            Enumeration<JarEntry> enu = jar.entries();
            while (enu.hasMoreElements()) {
                String cleanName;
                String name;
                ZipEntry infile = enu.nextElement();
                if (infile.isDirectory() || !(name = infile.getName()).endsWith(".class") || name.indexOf("$") != -1 || ArchiveInfo.isIncluded(this.alreadyIncludedClasses, cleanName = ArchiveInfo.cleanName(name))) continue;
                result = result + cleanName + ", ";
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (result.endsWith(", ")) {
            result = result.substring(0, result.length() - 2);
            return result;
        }
        System.out.println("No support class files in jar/war file:" + file.getPath());
        return null;
    }

    private void expandEars(File[] ears) {
        FileSet fs = new FileSet();
        fs.setDir(this.tmpDir);
        fs.setIncludes("**/*");
        Delete del = new Delete();
        del.setProject(this.project);
        del.init();
        del.setIncludeEmptyDirs(true);
        del.addFileset(fs);
        del.setFailOnError(false);
        del.perform();
        for (int i = 0; i < ears.length; ++i) {
            Expand dfr = new Expand();
            dfr.setProject(this.project);
            dfr.init();
            dfr.setSrc(ears[i]);
            dfr.setDest(this.tmpDir);
            dfr.perform();
        }
    }

    private void copyFile(File leafDir) {
        File toFile = new File(leafDir, "build.xml");
        boolean newFile = true;
        if (toFile.exists()) {
            if (!new File(leafDir, "SCCS/s.build.xml").exists()) {
                toFile.renameTo(new File(leafDir, "build.xml." + System.currentTimeMillis()));
            } else if (this.sccsedit) {
                this.log("build file " + toFile.getPath() + " already exists, sccs edit it.");
                TaskUtil.sccsEdit(this.project, toFile);
                newFile = false;
            } else {
                this.log("build file " + toFile.getPath() + " already exists, skip.");
                return;
            }
        }
        File templateLocal = this.changeTemplate(leafDir);
        Copy copyTask = new Copy();
        copyTask.setProject(this.project);
        copyTask.init();
        copyTask.setFile(templateLocal);
        copyTask.setTofile(toFile);
        copyTask.setOverwrite(true);
        FilterSet filters = copyTask.createFilterSet();
        Enumeration<?> enu = this.tokenVals.propertyNames();
        while (enu.hasMoreElements()) {
            Filter filter = new Filter();
            String key = (String)enu.nextElement();
            filter.setToken(key);
            String val = this.tokenVals.getProperty(key);
            filter.setValue(val);
            filters.addFilter(key, val);
        }
        copyTask.setFiltering(true);
        copyTask.perform();
        if (newFile && this.sccscreate) {
            TaskUtil.sccsCreate(this.project, toFile);
        } else if (!newFile && this.sccsdelget && this.sccsedit) {
            TaskUtil.sccsDelget(this.project, toFile, "generated build.xml from template " + this.template.getPath());
        }
    }

    private void loadOtherMakefiles(File leafDir, Properties props) {
        File[] otherMake = leafDir.listFiles(ArchiveInfo.otherMakeFileFilter);
        for (int i = 0; i < otherMake.length; ++i) {
            Properties p2 = new Properties();
            try {
                this.makeProps(otherMake[i], p2);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return;
            }
            this.log("Reading other Makefile:" + otherMake[i].getName());
            Enumeration<?> enu = p2.propertyNames();
            while (enu.hasMoreElements()) {
                String toSet;
                String key = (String)enu.nextElement();
                String existingVal = props.getProperty(key);
                if (existingVal != null && existingVal.length() != 0 || (toSet = p2.getProperty(key)) == null) continue;
                props.setProperty(key, toSet.trim());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeProps(File mk, Properties props) throws IOException {
        FileInputStream ins = null;
        try {
            ins = new FileInputStream(mk);
            props.load(ins);
        }
        finally {
            if (ins != null) {
                try {
                    ins.close();
                }
                catch (IOException iOException) {}
            }
        }
        Enumeration<?> enu = props.propertyNames();
        while (enu.hasMoreElements()) {
            String key = (String)enu.nextElement();
            String val = props.getProperty(key);
            if (val.indexOf("$(") == -1) continue;
            val = val.replace('(', '{').replace(')', '}').trim();
            props.setProperty(key, val);
        }
    }

    private String checkContentDir(File leafDir, File warFile, String jarWarElement) {
        String webFiles = "";
        try {
            JarFile jar = new JarFile(warFile);
            Enumeration<JarEntry> enu = jar.entries();
            while (enu.hasMoreElements()) {
                String name;
                String upperName;
                ZipEntry infile = enu.nextElement();
                if (infile.isDirectory() || (upperName = (name = infile.getName()).toUpperCase().replace('\\', '/')).equals("WEB-INF/WEB.XML") || upperName.equals("META-INF/MANIFEST.MF") || upperName.startsWith("WEB-INF/CLASSES/")) continue;
                webFiles = webFiles + name + ", ";
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        int commaPos = webFiles.lastIndexOf(", ");
        String result = null;
        boolean useCurrentDir = false;
        String sContentDir = null;
        if (commaPos != -1) {
            sContentDir = null;
            String aFile = webFiles.substring(0, webFiles.indexOf(", "));
            if (new File(leafDir, "contentRoot/" + aFile).exists()) {
                sContentDir = "contentRoot";
            } else if (new File(leafDir, "webFiles/" + aFile).exists()) {
                sContentDir = "webFiles";
            } else if (new File(leafDir, aFile).exists()) {
                sContentDir = ".";
                useCurrentDir = true;
            } else {
                File[] dirs = leafDir.listFiles(ArchiveInfo.dirFilter);
                for (int i = 0; i < dirs.length; ++i) {
                    if (!new File(dirs[i], aFile).exists()) continue;
                    sContentDir = dirs[i].getName();
                    break;
                }
            }
            webFiles = webFiles.substring(0, commaPos);
            if (sContentDir == null) {
                sContentDir = "@contentDir@";
                this.log("Cannot find contentDir for web content:" + webFiles);
            } else {
                this.log("Found " + aFile + " in " + sContentDir);
            }
        } else {
            return jarWarElement;
        }
        result = useCurrentDir ? jarWarElement + EIGHT + "<content dir=\"" + sContentDir + "\" includes=\"*.jsp, *.html\"/>" + NL : jarWarElement + EIGHT + "<content dir=\"" + sContentDir + "\"/>" + NL;
        return result;
    }

    private File changeTemplate(File leafDir) {
        if (this.nonopkg || leafDir == null) {
            return this.template;
        }
        File[] propsFile = leafDir.listFiles(ArchiveInfo.propsFileFilter);
        File[] xmlDescriptors = leafDir.listFiles(ArchiveInfo.xmlDescriptorFilter);
        if ((propsFile.length == 0 && xmlDescriptors.length == 0 || this.isCompatDir) && !this.vehicleDirsSet && !this.template.getName().endsWith(".nopkg")) {
            return new File(this.template.getPath() + ".nopkg");
        }
        return this.template;
    }

    private void resolveAllProperties(Properties props, Properties known) {
        Enumeration<Object> e = props.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = props.getProperty(name);
            boolean resolved = false;
            while (!resolved) {
                Vector fragments = new Vector();
                Vector propertyRefs = new Vector();
                ProjectHelper.parsePropertyString((String)value, fragments, propertyRefs);
                resolved = true;
                if (propertyRefs.size() == 0) continue;
                StringBuffer sb = new StringBuffer();
                Enumeration i = fragments.elements();
                Enumeration j = propertyRefs.elements();
                while (i.hasMoreElements()) {
                    String fragment = (String)i.nextElement();
                    if (fragment == null) {
                        String propertyName = (String)j.nextElement();
                        if (propertyName.equals(name)) {
                            throw new BuildException("Property " + name + " was circularly defined.");
                        }
                        fragment = known.getProperty(propertyName);
                        if (fragment == null) {
                            if (props.containsKey(propertyName)) {
                                fragment = props.getProperty(propertyName);
                                resolved = false;
                            } else {
                                fragment = "${" + propertyName + "}";
                            }
                        }
                    }
                    sb.append(fragment);
                }
                value = sb.toString();
                props.put(name, value);
            }
        }
    }

    static {
        String[] ss = new String[]{"jdbc", "jta", "javamail", "jaxp", "jaas", "j2eetools"};
        serviceList = Arrays.asList(ss);
    }
}

