/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.transformations;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.ldap.sdk.schema.AttributeTypeDefinition;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldap.sdk.transformations.EntryTransformation;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class AddAttributeTransformation
implements EntryTransformation {
    private final Attribute attributeToAdd;
    private final boolean examineFilter;
    private final boolean examineScope;
    private final boolean onlyIfMissing;
    private final DN baseDN;
    private final Filter filter;
    private final Schema schema;
    private final SearchScope scope;
    private final Set<String> names;

    public AddAttributeTransformation(Schema schema, DN baseDN, SearchScope scope, Filter filter, Attribute attributeToAdd, boolean onlyIfMissing) {
        AttributeTypeDefinition at;
        this.attributeToAdd = attributeToAdd;
        this.onlyIfMissing = onlyIfMissing;
        Schema s = schema;
        if (s == null) {
            try {
                s = Schema.getDefaultStandardSchema();
            }
            catch (Exception e) {
                Debug.debugException(e);
            }
        }
        this.schema = s;
        HashSet<String> attrNames = new HashSet<String>(5);
        String baseName = StaticUtils.toLowerCase(attributeToAdd.getBaseName());
        attrNames.add(baseName);
        if (s != null && (at = s.getAttributeType(baseName)) != null) {
            attrNames.add(StaticUtils.toLowerCase(at.getOID()));
            for (String name : at.getNames()) {
                attrNames.add(StaticUtils.toLowerCase(name));
            }
        }
        this.names = Collections.unmodifiableSet(attrNames);
        this.baseDN = baseDN == null ? DN.NULL_DN : baseDN;
        this.scope = scope == null ? SearchScope.SUB : scope;
        if (filter == null) {
            this.filter = Filter.createANDFilter(new Filter[0]);
            this.examineFilter = false;
        } else {
            this.filter = filter;
            this.examineFilter = filter.getFilterType() == -96 ? filter.getComponents().length > 0 : true;
        }
        this.examineScope = !this.baseDN.isNullDN() || this.scope != SearchScope.SUB;
    }

    @Override
    public Entry transformEntry(Entry e) {
        if (e == null) {
            return null;
        }
        if (this.onlyIfMissing) {
            for (String name : this.names) {
                if (!e.hasAttribute(name)) continue;
                return e;
            }
        }
        try {
            if (this.examineScope && !e.matchesBaseAndScope(this.baseDN, this.scope)) {
                return e;
            }
        }
        catch (Exception ex) {
            Debug.debugException(ex);
            return e;
        }
        try {
            if (this.examineFilter && !this.filter.matchesEntry(e, this.schema)) {
                return e;
            }
        }
        catch (Exception ex) {
            Debug.debugException(ex);
            return e;
        }
        Entry copy = e.duplicate();
        Attribute existingAttribute = copy.getAttribute(this.attributeToAdd.getName(), this.schema);
        if (existingAttribute == null) {
            copy.addAttribute(this.attributeToAdd);
        } else {
            copy.addAttribute(existingAttribute.getName(), this.attributeToAdd.getValueByteArrays());
        }
        return copy;
    }

    @Override
    public Entry translate(Entry original, long firstLineNumber) {
        return this.transformEntry(original);
    }

    @Override
    public Entry translateEntryToWrite(Entry original) {
        return this.transformEntry(original);
    }
}

