/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http.internal.websocket;

import java.nio.ByteBuffer;
import jdk.incubator.http.internal.common.Utils;
import jdk.incubator.http.internal.websocket.FailWebSocketException;

final class Frame {
    static final int MAX_HEADER_SIZE_BYTES = 14;

    private Frame() {
    }

    static final class Reader {
        private static final int AWAITING_FIRST_BYTE = 1;
        private static final int AWAITING_SECOND_BYTE = 2;
        private static final int READING_16_LENGTH = 4;
        private static final int READING_64_LENGTH = 8;
        private static final int READING_MASK = 16;
        private static final int READING_PAYLOAD = 32;
        private final ByteBuffer accumulator = ByteBuffer.allocate(8);
        private int state = 1;
        private boolean mask;
        private long remainingPayloadLength;

        Reader() {
        }

        void readFrame(ByteBuffer byteBuffer, Consumer consumer) {
            block8: while (true) {
                switch (this.state) {
                    case 1: {
                        if (!byteBuffer.hasRemaining()) break block8;
                        byte by = byteBuffer.get();
                        consumer.fin((by & 0x80) != 0);
                        consumer.rsv1((by & 0x40) != 0);
                        consumer.rsv2((by & 0x20) != 0);
                        consumer.rsv3((by & 0x10) != 0);
                        consumer.opcode(Opcode.ofCode(by));
                        this.state = 2;
                        continue block8;
                    }
                    case 2: {
                        if (!byteBuffer.hasRemaining()) break block8;
                        byte by = byteBuffer.get();
                        this.mask = (by & 0x80) != 0;
                        consumer.mask(this.mask);
                        byte by2 = (byte)(by & 0x7F);
                        if (by2 < 126) {
                            assert (by2 >= 0) : by2;
                            this.remainingPayloadLength = by2;
                            consumer.payloadLen(this.remainingPayloadLength);
                            this.state = this.mask ? 16 : 32;
                            continue block8;
                        }
                        if (by2 < 127) {
                            this.state = 4;
                            continue block8;
                        }
                        this.state = 8;
                        continue block8;
                    }
                    case 4: {
                        if (!byteBuffer.hasRemaining()) break block8;
                        byte by = byteBuffer.get();
                        if (this.accumulator.put(by).position() < 2) continue block8;
                        this.remainingPayloadLength = ((ByteBuffer)this.accumulator.flip()).getChar();
                        if (this.remainingPayloadLength < 126L) {
                            throw Reader.notMinimalEncoding(this.remainingPayloadLength);
                        }
                        consumer.payloadLen(this.remainingPayloadLength);
                        this.accumulator.clear();
                        this.state = this.mask ? 16 : 32;
                        continue block8;
                    }
                    case 8: {
                        if (!byteBuffer.hasRemaining()) break block8;
                        byte by = byteBuffer.get();
                        if (this.accumulator.put(by).position() < 8) continue block8;
                        this.remainingPayloadLength = ((ByteBuffer)this.accumulator.flip()).getLong();
                        if (this.remainingPayloadLength < 0L) {
                            throw Reader.negativePayload(this.remainingPayloadLength);
                        }
                        if (this.remainingPayloadLength < 65536L) {
                            throw Reader.notMinimalEncoding(this.remainingPayloadLength);
                        }
                        consumer.payloadLen(this.remainingPayloadLength);
                        this.accumulator.clear();
                        this.state = this.mask ? 16 : 32;
                        continue block8;
                    }
                    case 16: {
                        if (!byteBuffer.hasRemaining()) break block8;
                        byte by = byteBuffer.get();
                        if (this.accumulator.put(by).position() != 4) continue block8;
                        consumer.maskingKey(((ByteBuffer)this.accumulator.flip()).getInt());
                        this.accumulator.clear();
                        this.state = 32;
                        continue block8;
                    }
                    case 32: {
                        int n;
                        int n2 = (int)Math.min(this.remainingPayloadLength, (long)byteBuffer.remaining());
                        int n3 = byteBuffer.limit();
                        byteBuffer.limit(byteBuffer.position() + n2);
                        if (n2 != 0 || this.remainingPayloadLength == 0L) {
                            consumer.payloadData(byteBuffer);
                        }
                        if ((n = n2 - byteBuffer.remaining()) < 0) {
                            throw new InternalError();
                        }
                        byteBuffer.limit(n3);
                        this.remainingPayloadLength -= (long)n;
                        if (this.remainingPayloadLength != 0L) break block8;
                        consumer.endFrame();
                        this.state = 1;
                        break block8;
                    }
                    default: {
                        throw new InternalError(String.valueOf(this.state));
                    }
                }
                break;
            }
        }

        private static FailWebSocketException negativePayload(long l) {
            return new FailWebSocketException("Negative payload length: " + l);
        }

        private static FailWebSocketException notMinimalEncoding(long l) {
            return new FailWebSocketException("Not minimally-encoded payload length:" + l);
        }
    }

    static interface Consumer {
        public void fin(boolean var1);

        public void rsv1(boolean var1);

        public void rsv2(boolean var1);

        public void rsv3(boolean var1);

        public void opcode(Opcode var1);

        public void mask(boolean var1);

        public void payloadLen(long var1);

        public void maskingKey(int var1);

        public void payloadData(ByteBuffer var1);

        public void endFrame();
    }

    static final class HeaderWriter {
        private char firstChar;
        private long payloadLen;
        private int maskingKey;
        private boolean mask;

        HeaderWriter() {
        }

        HeaderWriter fin(boolean bl) {
            this.firstChar = bl ? (char)(this.firstChar | 0x8000) : (char)(this.firstChar & 0xFFFF7FFF);
            return this;
        }

        HeaderWriter rsv1(boolean bl) {
            this.firstChar = bl ? (char)(this.firstChar | 0x4000) : (char)(this.firstChar & 0xFFFFBFFF);
            return this;
        }

        HeaderWriter rsv2(boolean bl) {
            this.firstChar = bl ? (char)(this.firstChar | 0x2000) : (char)(this.firstChar & 0xFFFFDFFF);
            return this;
        }

        HeaderWriter rsv3(boolean bl) {
            this.firstChar = bl ? (char)(this.firstChar | 0x1000) : (char)(this.firstChar & 0xFFFFEFFF);
            return this;
        }

        HeaderWriter opcode(Opcode opcode) {
            this.firstChar = (char)(this.firstChar & 0xF0FF | opcode.code << 8);
            return this;
        }

        HeaderWriter payloadLen(long l) {
            if (l < 0L) {
                throw new IllegalArgumentException("Negative: " + l);
            }
            this.payloadLen = l;
            this.firstChar = (char)(this.firstChar & 0xFF80);
            this.firstChar = this.payloadLen < 126L ? (char)((long)this.firstChar | this.payloadLen) : (this.payloadLen < 65536L ? (char)(this.firstChar | 0x7E) : (char)(this.firstChar | 0x7F));
            return this;
        }

        HeaderWriter mask(int n) {
            this.firstChar = (char)(this.firstChar | 0x80);
            this.maskingKey = n;
            this.mask = true;
            return this;
        }

        HeaderWriter noMask() {
            this.firstChar = (char)(this.firstChar & 0xFFFFFF7F);
            this.mask = false;
            return this;
        }

        void write(ByteBuffer byteBuffer) {
            byteBuffer.putChar(this.firstChar);
            if (this.payloadLen >= 126L) {
                if (this.payloadLen < 65536L) {
                    byteBuffer.putChar((char)this.payloadLen);
                } else {
                    byteBuffer.putLong(this.payloadLen);
                }
            }
            if (this.mask) {
                byteBuffer.putInt(this.maskingKey);
            }
        }
    }

    static final class Masker {
        private final ByteBuffer acc = ByteBuffer.allocate(8);
        private final int[] maskBytes = new int[4];
        private int offset;
        private long maskLong;

        Masker() {
        }

        static void transferMasking(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, int n) {
            if (byteBuffer.remaining() > byteBuffer2.remaining()) {
                throw new IllegalArgumentException(Utils.dump(byteBuffer, byteBuffer2));
            }
            new Masker().mask(n).transferMasking(byteBuffer, byteBuffer2);
        }

        Masker mask(int n) {
            ((ByteBuffer)this.acc.clear()).putInt(n).putInt(n).flip();
            for (int i = 0; i < this.maskBytes.length; ++i) {
                this.maskBytes[i] = this.acc.get(i);
            }
            this.offset = 0;
            this.maskLong = this.acc.getLong(0);
            return this;
        }

        Masker transferMasking(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
            this.begin(byteBuffer, byteBuffer2);
            this.loop(byteBuffer, byteBuffer2);
            this.end(byteBuffer, byteBuffer2);
            return this;
        }

        private void begin(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
            if (this.offset == 0) {
                return;
            }
            int n = byteBuffer.position();
            int n2 = byteBuffer2.position();
            int n3 = byteBuffer.limit();
            int n4 = byteBuffer2.limit();
            while (this.offset < 4 && n < n3 && n2 < n4) {
                byteBuffer2.put(n2, (byte)(byteBuffer.get(n) ^ this.maskBytes[this.offset]));
                ++n;
                ++n2;
                ++this.offset;
            }
            this.offset &= 3;
            byteBuffer.position(n);
            byteBuffer2.position(n2);
        }

        private void loop(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
            int n;
            int n2 = byteBuffer.position();
            int n3 = byteBuffer.limit() - 7;
            int n4 = byteBuffer2.limit() - 7;
            for (n = byteBuffer2.position(); n2 < n3 && n < n4; n2 += 8, n += 8) {
                byteBuffer2.putLong(n, byteBuffer.getLong(n2) ^ this.maskLong);
            }
            if (n2 > byteBuffer.limit()) {
                byteBuffer.position(n2 - 8);
            } else {
                byteBuffer.position(n2);
            }
            if (n > byteBuffer2.limit()) {
                byteBuffer2.position(n - 8);
            } else {
                byteBuffer2.position(n);
            }
        }

        private void end(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
            int n;
            assert (Math.min(byteBuffer.remaining(), byteBuffer2.remaining()) < 8);
            int n2 = byteBuffer.limit();
            int n3 = byteBuffer2.limit();
            int n4 = byteBuffer.position();
            for (n = byteBuffer2.position(); n4 < n2 && n < n3; ++n4, ++n) {
                byteBuffer2.put(n, (byte)(byteBuffer.get(n4) ^ this.maskBytes[this.offset]));
                this.offset = this.offset + 1 & 3;
            }
            byteBuffer.position(n4);
            byteBuffer2.position(n);
        }
    }

    static enum Opcode {
        CONTINUATION(0),
        TEXT(1),
        BINARY(2),
        NON_CONTROL_0x3(3),
        NON_CONTROL_0x4(4),
        NON_CONTROL_0x5(5),
        NON_CONTROL_0x6(6),
        NON_CONTROL_0x7(7),
        CLOSE(8),
        PING(9),
        PONG(10),
        CONTROL_0xB(11),
        CONTROL_0xC(12),
        CONTROL_0xD(13),
        CONTROL_0xE(14),
        CONTROL_0xF(15);

        private static final Opcode[] opcodes;
        private final byte code;

        private Opcode(int n2) {
            this.code = (byte)n2;
        }

        boolean isControl() {
            return (this.code & 8) != 0;
        }

        static Opcode ofCode(int n) {
            return opcodes[n & 0xF];
        }

        static {
            Opcode[] opcodeArray = Opcode.values();
            opcodes = new Opcode[opcodeArray.length];
            Opcode[] opcodeArray2 = opcodeArray;
            int n = opcodeArray2.length;
            for (int i = 0; i < n; ++i) {
                Opcode opcode;
                Opcode.opcodes[opcode.code] = opcode = opcodeArray2[i];
            }
        }
    }
}

