/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaspic.tssv.config;

import com.sun.ts.tests.jaspic.tssv.config.TSServerAuthContext;
import com.sun.ts.tests.jaspic.tssv.util.TSLogger;
import jakarta.security.auth.message.AuthException;
import jakarta.security.auth.message.MessageInfo;
import jakarta.security.auth.message.config.ServerAuthConfig;
import jakarta.security.auth.message.config.ServerAuthContext;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;

public class TSServerAuthConfig
implements ServerAuthConfig {
    protected static String messageLayer = null;
    protected static String appContext = null;
    protected static CallbackHandler handler = null;
    protected static TSLogger logger = TSLogger.getTSLogger("jsr196");
    protected static Map properties = null;
    protected static Map authMandatoryMap;

    protected TSServerAuthConfig(String layer, String applicationCtxt, CallbackHandler cbkHandler, Map props) {
        messageLayer = layer;
        appContext = applicationCtxt;
        handler = cbkHandler;
        properties = props;
    }

    public TSServerAuthConfig(String layer, String applicationCtxt, CallbackHandler cbkHandler, Map props, TSLogger tsLogger) {
        this(layer, applicationCtxt, cbkHandler, props);
        if (tsLogger != null) {
            logger = tsLogger;
        }
        String str = "TSServerAuthConfig called for layer=" + layer + " : appContext=" + applicationCtxt;
        logger.log(Level.INFO, str);
    }

    public String getMessageLayer() {
        logger.log(Level.INFO, "getMessageLayer called");
        return messageLayer;
    }

    public String getAppContext() {
        logger.log(Level.INFO, "getAppContext called");
        return appContext;
    }

    public String getAuthContextID(MessageInfo messageInfo) {
        logger.log(Level.INFO, "getAuthContextID called");
        String rval = null;
        if (messageLayer.equals("HttpServlet")) {
            HttpServletRequest request = (HttpServletRequest)messageInfo.getRequestMessage();
            rval = request.getServletPath() + " " + request.getMethod();
            this.dumpServletProfileKeys(messageInfo, "getAuthContextID", "HttpServlet");
        } else {
            rval = null;
        }
        String logMsg = "getAuthContextID() called for layer=" + messageLayer;
        logMsg = logMsg + " shows AuthContextId=" + rval;
        logger.log(Level.INFO, logMsg);
        return rval;
    }

    private void dumpServletProfileKeys(MessageInfo msgInfo, String callerMethod, String messageLayer) {
        Map map = msgInfo.getMap();
        HttpServletRequest request = (HttpServletRequest)msgInfo.getRequestMessage();
        String servletName = request.getServletPath();
        String strKey = "jakarta.security.auth.message.MessagePolicy.isMandatory";
        if (map != null) {
            String keyVal = (String)map.get(strKey);
            String msg = "dumpServletProfileKeys() called with attrs: ";
            msg = msg + " layer=" + messageLayer;
            msg = msg + " servletName=" + servletName;
            msg = msg + " callerMethod=" + callerMethod;
            msg = msg + " key=" + strKey;
            if (keyVal == null) {
                msg = msg + " value=Invalid";
                this.addMandatoryStatusToMap(msgInfo, messageLayer, appContext, false);
            } else {
                msg = msg + " value=Valid";
                this.addMandatoryStatusToMap(msgInfo, messageLayer, appContext, true);
            }
            logger.log(Level.INFO, msg);
        }
    }

    private void addMandatoryStatusToMap(MessageInfo msgInfo, String layer, String appContext, boolean isMandatory) {
        Boolean booleanObj;
        if (authMandatoryMap == null) {
            authMandatoryMap = new Hashtable();
        }
        if ((booleanObj = (Boolean)authMandatoryMap.get(layer + appContext)) == null) {
            authMandatoryMap.put(layer + appContext, new Boolean(isMandatory));
        }
    }

    private boolean getMandatoryStatusFromMap(String layer, String appContext) {
        boolean bval = false;
        if (layer.equals("JASPICData.LAYER_SERVLET")) {
            if (authMandatoryMap != null) {
                Boolean booleanObj = (Boolean)authMandatoryMap.get(layer + appContext);
                bval = booleanObj;
            } else {
                String msg = "Could Not properly determine isMandatory status.";
                msg = msg + "  Will return false.";
                logger.log(Level.INFO, msg);
                bval = false;
            }
        }
        return bval;
    }

    private void dumpAllKeyValues(Map map) {
        if (map == null) {
            logger.log(Level.INFO, "map is null");
            return;
        }
        Set keys = map.keySet();
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            String msg = "";
            String key = (String)iterator.next();
            if (key == null) continue;
            msg = "key=" + key;
            String val = (String)map.get(key);
            msg = val != null ? msg + " value=" + val : msg + " value=null";
            logger.log(Level.INFO, msg);
        }
    }

    public void refresh() {
        logger.log(Level.INFO, "refresh called");
    }

    public boolean isProtected() {
        return true;
    }

    public ServerAuthContext getAuthContext(String operation, Subject serviceSubject, Map properties) throws AuthException {
        String logStr = "TSServerAuthConfig.getAuthContext:  layer=" + messageLayer + " : appContext=" + appContext;
        logger.log(Level.INFO, logStr);
        logger.log(Level.INFO, "TSServerAuthConfig.getAuthContext:  layer=" + messageLayer + " : appContext=" + appContext + " operationId=" + operation);
        if (serviceSubject != null) {
            properties.put("com.sun.ts.tests.jaspic.serviceSubjectKey", serviceSubject);
            logger.log(Level.INFO, "found a non-null serviceSubject in getAuthContext()");
        }
        try {
            if (TSServerAuthConfig.properties != null && properties != null) {
                TSServerAuthConfig.properties.putAll(properties);
            }
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "Exception : " + ex.getMessage());
        }
        this.checkIf115Compatible(properties);
        this.validateOperationId(operation, messageLayer);
        try {
            boolean bIsMand = this.getMandatoryStatusFromMap(messageLayer, appContext);
            TSServerAuthContext sac = new TSServerAuthContext(messageLayer, appContext, handler, operation, serviceSubject, TSServerAuthConfig.properties, bIsMand, logger);
            logStr = "TSServerAuthConfig.getAuthContext: returned non-null ServerAuthContext";
            logger.log(Level.INFO, logStr);
            logStr = "TSServerAuthConfig.getAuthContext: returned non-null ServerAuthContext for operationId=" + operation;
            logger.log(Level.INFO, logStr);
            return sac;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Got AuthException in TSServerAuthConfig.getAuthContext");
            logger.log(Level.SEVERE, e.getMessage());
            throw new AuthException(e.getMessage());
        }
    }

    private void checkIf115Compatible(Map properties) {
        String msg = "layer=" + messageLayer + " appContext=" + appContext;
        String strKey = "jakarta.security.jacc.PolicyContext";
        msg = msg + " Key=" + strKey;
        if (properties != null) {
            String keyVal = (String)properties.get(strKey);
            if (keyVal == null) {
                msg = msg + " does NOT exist thus Not 115 compatible";
            } else if (keyVal != null) {
                msg = msg + " does exist thus 115 compatible";
                logger.log(Level.INFO, "key=" + strKey + "  value=" + keyVal);
            }
        } else {
            msg = msg + " does NOT exist thus Not 115 compatible";
        }
        logger.log(Level.INFO, msg);
    }

    private void validateOperationId(String operation, String layer) {
        String MNAME = "TSServerAuthConfig.validateOperationId() : ";
        boolean bPassed = true;
        if ((operation = operation.trim()) == null) {
            logger.log(Level.SEVERE, MNAME + " there was a null operationId and should not be!");
        }
        if (layer.equals("HttpServlet")) {
            String lstr;
            String sProfile = "HttpServlet profile";
            if (operation.startsWith("http:")) {
                lstr = MNAME + sProfile + " should not start with a context path";
                logger.log(Level.SEVERE, lstr);
                bPassed = false;
            }
            if (operation.indexOf(" ") != operation.lastIndexOf(" ")) {
                lstr = MNAME + sProfile + " found more than one whitespace.";
                logger.log(Level.SEVERE, lstr);
                bPassed = false;
            }
            int ii = operation.indexOf(" ");
            String httpMethod = operation.substring(ii);
            if (!((httpMethod = httpMethod.trim()).equalsIgnoreCase("GET") || httpMethod.equalsIgnoreCase("POST") || httpMethod.equalsIgnoreCase("PUT"))) {
                lstr = MNAME + sProfile + " invalid http method type :" + httpMethod + ".  Must be  POST|GET|PUT";
                logger.log(Level.SEVERE, lstr);
                bPassed = false;
            }
            if (bPassed) {
                logger.log(Level.INFO, MNAME + sProfile + " : PASSED");
            } else {
                logger.log(Level.SEVERE, MNAME + sProfile + " : FAILED");
            }
        } else if (layer.equals("SOAP")) {
            // empty if block
        }
    }
}

