/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.updater;

import com.sun.tdk.signaturetest.updater.AddClass;
import com.sun.tdk.signaturetest.updater.AddMember;
import com.sun.tdk.signaturetest.updater.ChangeMember;
import com.sun.tdk.signaturetest.updater.Command;
import com.sun.tdk.signaturetest.updater.RemoveClass;
import com.sun.tdk.signaturetest.updater.RemoveMember;
import com.sun.tdk.signaturetest.updater.RemovePackage;
import com.sun.tdk.signaturetest.util.SwissKnife;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Updater
extends DefaultHandler {
    private UpdateRecord ur;
    private List<Command> commands;
    private String lastData;
    private PrintWriter log;

    public boolean perform(String updFile, String fromFile, String toFile, PrintWriter log) {
        if (log != null) {
            this.log = log;
        }
        SAXParserFactory spf = SAXParserFactory.newInstance();
        try {
            SAXParser sp = spf.newSAXParser();
            sp.parse(updFile, (DefaultHandler)this);
            return this.applyUpdate(fromFile, toFile);
        }
        catch (Exception e) {
            SwissKnife.reportThrowable(e);
            return false;
        }
    }

    @Override
    public void startDocument() throws SAXException {
        this.commands = new LinkedList<Command>();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equalsIgnoreCase("update")) {
            this.ur = new UpdateRecord();
            this.fillUR(this.ur, attributes);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.lastData = this.lastData == null ? new String(ch, start, length) : this.lastData + new String(ch, start, length);
        this.lastData = this.lastData.trim();
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        Command c = null;
        if (this.ur != null) {
            if (this.ur.atype.equalsIgnoreCase("removeclass")) {
                RemoveClass rc = new RemoveClass(this.log);
                rc.comments = this.ur.acomments;
                rc.id = this.ur.aid;
                rc.className = this.ur.aclassname;
                c = rc;
            } else if (this.ur.atype.equalsIgnoreCase("removepackage")) {
                RemovePackage rp = new RemovePackage(this.log);
                rp.comments = this.ur.acomments;
                rp.id = this.ur.aid;
                rp.packageName = this.ur.apackagename;
                c = rp;
            } else if (this.ur.atype.equalsIgnoreCase("addclass")) {
                AddClass ac = new AddClass(this.log);
                ac.comments = this.ur.acomments;
                ac.id = this.ur.aid;
                ac.className = this.ur.aclassname;
                ac.body = this.lastData;
                c = ac;
            } else if (this.ur.atype.equalsIgnoreCase("removemember")) {
                RemoveMember rm = new RemoveMember(this.log);
                rm.comments = this.ur.acomments;
                rm.id = this.ur.aid;
                rm.className = this.ur.aclassname;
                rm.memberName = this.ur.amember;
                c = rm;
            } else if (this.ur.atype.equalsIgnoreCase("addmember")) {
                AddMember am = new AddMember(this.log);
                am.comments = this.ur.acomments;
                am.id = this.ur.aid;
                am.className = this.ur.aclassname;
                am.memberName = this.ur.amember;
                c = am;
            } else if (this.ur.atype.equalsIgnoreCase("changemember")) {
                ChangeMember cm = new ChangeMember(this.log);
                cm.comments = this.ur.acomments;
                cm.id = this.ur.aid;
                cm.className = this.ur.aclassname;
                cm.memberName = this.ur.amember;
                cm.newMemberName = this.ur.anewmember;
                c = cm;
            }
            if (c == null) {
                throw new IllegalArgumentException("Unknown type \"" + this.ur.atype + "\" for update");
            }
            ((Command)c).validate();
            this.commands.add(c);
        }
        this.ur = null;
        this.lastData = null;
    }

    private void fillUR(UpdateRecord ur, Attributes attributes) {
        Field[] fs = UpdateRecord.class.getDeclaredFields();
        try {
            for (Field f : fs) {
                String fName = f.getName();
                if (!fName.startsWith("a")) continue;
                f.set(ur, attributes.getValue(fName.substring(1)));
            }
        }
        catch (IllegalAccessException e) {
            SwissKnife.reportThrowable(e);
        }
    }

    private void processCommands(Collection<Command> commands, SigList sl) {
        for (Command command : commands) {
            command.perform(sl);
        }
    }

    private boolean applyUpdate(String from, String to) {
        try {
            SigList sl = this.readInput(from);
            this.processCommands(this.commands, sl);
            this.commands.clear();
            sl.pack();
            this.writeOut(to, sl);
            return true;
        }
        catch (IOException e) {
            SwissKnife.reportThrowable(e);
            return false;
        }
    }

    private void writeOut(String to, SigList sl) throws FileNotFoundException {
        try (PrintWriter pw = new PrintWriter(new FileOutputStream(to));){
            sl.print(pw);
        }
    }

    /*
     * Exception decompiling
     */
    private SigList readInput(String from) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private class UpdateRecord {
        String atype;
        String aclassname;
        String aid;
        String acomments;
        String apackagename;
        String amember;
        String anewmember;

        private UpdateRecord() {
        }
    }

    class SigList {
        private final List<String> sigList = new ArrayList<String>();
        private int startPos = -1;

        SigList() {
        }

        public boolean findClass(String className) {
            this.startPos = -1;
            for (int i = 0; i < this.sigList.size(); ++i) {
                String l = this.sigList.get(i);
                if (!l.startsWith("CLSS ") || !l.endsWith(" " + className)) continue;
                this.startPos = i;
                return true;
            }
            return false;
        }

        public void removeCurrentClass() {
            if (this.startPos >= 0) {
                while (!this.sigList.get(this.startPos).trim().isEmpty()) {
                    this.sigList.remove(this.startPos);
                }
            }
        }

        public void addText(String body) {
            StringTokenizer st = new StringTokenizer(body, "\n");
            this.sigList.add("");
            while (st.hasMoreTokens()) {
                this.sigList.add(st.nextToken().trim());
            }
            this.sigList.add("");
        }

        public boolean findPackageMember(String packageName) {
            this.startPos = -1;
            String pSig = " " + packageName + ".";
            for (int i = 0; i < this.sigList.size(); ++i) {
                String l = this.sigList.get(i);
                if (!l.startsWith("CLSS ")) continue;
                int x = l.indexOf(60);
                int y = l.indexOf(pSig);
                if (y <= 0 || y >= x && x != -1) continue;
                this.startPos = i;
                return true;
            }
            return false;
        }

        public boolean removeMember(String memberName) {
            if (this.startPos >= 0) {
                for (int i = this.startPos; i < this.sigList.size(); ++i) {
                    String l = this.sigList.get(i).trim();
                    if (memberName.equals(l)) {
                        this.sigList.remove(i);
                        return true;
                    }
                    if (l.isEmpty()) break;
                }
            }
            return false;
        }

        public boolean changeMember(String oldMember, String newMember) {
            if (this.startPos >= 0) {
                for (int i = this.startPos; i < this.sigList.size(); ++i) {
                    String l = this.sigList.get(i).trim();
                    if (oldMember.equals(l)) {
                        this.sigList.set(i, newMember);
                        return true;
                    }
                    if (l.isEmpty()) break;
                }
            }
            return false;
        }

        public void pack() {
            boolean empty = false;
            for (int i = 0; i < this.sigList.size(); ++i) {
                String l = this.sigList.get(i);
                if (l.trim().isEmpty()) {
                    if (empty) {
                        this.sigList.remove(i--);
                        continue;
                    }
                    empty = true;
                    continue;
                }
                empty = false;
            }
        }

        public boolean addMember(String memberName) {
            if (this.startPos >= 0) {
                for (int i = this.startPos + 1; i < this.sigList.size(); ++i) {
                    String l = this.sigList.get(i).trim();
                    if (l.startsWith("anno")) continue;
                    this.sigList.add(i, memberName);
                    return true;
                }
            }
            return false;
        }

        public boolean add(String s) {
            return this.sigList.add(s);
        }

        public void print(PrintWriter pw) {
            for (String o : this.sigList) {
                pw.write(o + '\n');
            }
        }
    }
}

