/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest;

import com.sun.tdk.signaturetest.SigTest;
import com.sun.tdk.signaturetest.Version;
import com.sun.tdk.signaturetest.core.ClassHierarchyImpl;
import com.sun.tdk.signaturetest.core.Log;
import com.sun.tdk.signaturetest.core.MemberCollectionBuilder;
import com.sun.tdk.signaturetest.merge.JSR68Merger;
import com.sun.tdk.signaturetest.merge.MergedSigFile;
import com.sun.tdk.signaturetest.model.ClassDescription;
import com.sun.tdk.signaturetest.sigfile.FeaturesHolder;
import com.sun.tdk.signaturetest.sigfile.MultipleFileReader;
import com.sun.tdk.signaturetest.util.CommandLineParser;
import com.sun.tdk.signaturetest.util.CommandLineParserException;
import com.sun.tdk.signaturetest.util.I18NResourceBundle;
import com.sun.tdk.signaturetest.util.OptionInfo;
import com.sun.tdk.signaturetest.util.SwissKnife;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Logger;

public class Merge
extends SigTest {
    public static final String FILES_OPTION = "-Files";
    public static final String WRITE_OPTION = "-Write";
    public static final String BINARY_OPTION = "-Binary";
    private static I18NResourceBundle i18n;
    private boolean binary = false;
    private String resultedFile;
    private String[] signatureFiles;
    static /* synthetic */ Class class$com$sun$tdk$signaturetest$Merge;

    public static void main(String[] args) {
        Merge m = Merge.getInstance();
        m.run(args, new PrintWriter(System.err, true), null);
        m.exit();
    }

    protected static Merge getInstance() {
        return new Merge();
    }

    public void run(String[] args, PrintWriter pw, PrintWriter ref) {
        this.setLog(pw);
        if (this.parseParameters(args)) {
            this.perform();
            this.getLog().flush();
        } else if (args.length > 0 && args[0].equalsIgnoreCase("-Version")) {
            System.err.println(Version.getVersionInfo());
        } else {
            this.usage();
        }
    }

    private boolean parseParameters(String[] args) {
        CommandLineParser parser = new CommandLineParser(this, "-");
        this.initErrors();
        if (args == null || args.length == 0 || args.length == 1 && (parser.isOptionSpecified(args[0], "-Help") || parser.isOptionSpecified(args[0], "-?"))) {
            return false;
        }
        String optionsDecoder = "decodeOptions";
        parser.addOption(FILES_OPTION, OptionInfo.requiredOption(1), "decodeOptions");
        parser.addOption(WRITE_OPTION, OptionInfo.option(1), "decodeOptions");
        parser.addOption(BINARY_OPTION, OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption("-Help", OptionInfo.optionalFlag(), "decodeOptions");
        parser.addOption("-TestURL", OptionInfo.option(1), "decodeOptions");
        parser.addOption("-Version", OptionInfo.optionalFlag(), "decodeOptions");
        try {
            parser.processArgs(args);
            if (this.resultedFile != null) {
                this.checkValidWriteFile();
            }
        }
        catch (CommandLineParserException e) {
            this.getLog().println(e.getMessage());
            return this.failed(e.getMessage());
        }
        return this.passed();
    }

    private void checkValidWriteFile() throws CommandLineParserException {
        File canonicalFile = null;
        try {
            canonicalFile = new File(this.resultedFile).getCanonicalFile();
        }
        catch (IOException e) {
            throw new CommandLineParserException(i18n.getString("Merge.could.not.resolve.file", this.resultedFile));
        }
        int i = 0;
        while (i < this.signatureFiles.length) {
            try {
                File sigFile = new File(this.signatureFiles[i]).getCanonicalFile();
                if (canonicalFile.equals(sigFile)) {
                    throw new CommandLineParserException(i18n.getString("Merge.notunique.writefile"));
                }
            }
            catch (IOException ex) {
                throw new CommandLineParserException(i18n.getString("Merge.could.not.resolve.file", this.signatureFiles[i]));
            }
            ++i;
        }
        try {
            FileOutputStream f = new FileOutputStream(this.resultedFile);
            f.close();
        }
        catch (IOException e) {
            throw new CommandLineParserException(i18n.getString("Merge.could.not.create.write.file"));
        }
    }

    public void decodeOptions(String optionName, String[] args) throws CommandLineParserException {
        if (optionName.equalsIgnoreCase(FILES_OPTION)) {
            StringTokenizer st = new StringTokenizer(args[0], File.pathSeparator);
            ArrayList<String> list = new ArrayList<String>();
            while (st.hasMoreElements()) {
                list.add(st.nextToken());
            }
            this.signatureFiles = list.toArray(new String[list.size()]);
        } else if (optionName.equalsIgnoreCase(WRITE_OPTION)) {
            this.resultedFile = args[0];
        } else if (optionName.equalsIgnoreCase(BINARY_OPTION)) {
            this.binary = true;
        } else if (optionName.equalsIgnoreCase("-TestURL")) {
            this.testURL = args[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void perform() {
        block49: {
            block52: {
                block47: {
                    files = new MergedSigFile[this.signatureFiles.length];
                    log = new PrintWriter(System.out);
                    fh = new FeaturesHolder();
                    i = 0;
                    block13: while (true) {
                        if (i >= this.signatureFiles.length) {
                            merger = new JSR68Merger(this, this, fh);
                        }
                        sigFiles = this.signatureFiles[i];
                        in = new MultipleFileReader(log, 1, this.getFileManager());
                        if (!in.readSignatureFiles(this.testURL, sigFiles)) {
                            msg = Merge.i18n.getString("SignatureTest.error.sigfile.invalid", sigFiles);
                            in.close();
                            this.error(msg);
                        }
                        files[i] = new MergedSigFile(in, this);
                        if (i == 0) {
                            fh.setFeatures(in.getSupportedFeatures());
                        } else {
                            fh.retainFeatures(in.getSupportedFeatures());
                        }
                        builder = new MemberCollectionBuilder(new SilentLog());
                        it = files[i].getClassSet().values().iterator();
                        while (true) {
                            if (!it.hasNext()) {
                                ++i;
                                continue block13;
                            }
                            c = (ClassDescription)it.next();
                            c.setHierarchy(files[i].getClassHierarchy());
                            try {
                                if (in.isFeatureSupported(FeaturesHolder.BuildMembers)) {
                                    builder.createMembers(c, true, true, false);
                                }
                                this.normalizer.normThrows(c, true);
                            }
                            catch (ClassNotFoundException e) {
                                // empty catch block
                            }
                        }
                        break;
                    }
                    result = merger.merge(files, this.binary != false ? 1 : 0);
                    if (!this.isPassed()) {
                        this.printErrors();
                        return;
                    }
                    ch = new ClassHierarchyImpl(result, 2);
                    i = result.getClassIterator();
                    while (true) {
                        if (!i.hasNext()) break;
                        c = (ClassDescription)i.next();
                        c.setHierarchy(ch);
                    }
                    builder = new MemberCollectionBuilder(new SilentLog());
                    i = result.getClassIterator();
                    while (true) {
                        if (!i.hasNext()) {
                            writer = null;
                            fos = null;
                            osw = null;
                            pw = null;
                            ** try [egrp 2[TRYBLOCK] [3 : 455->693)] { 
lbl56:
                            // 1 sources

                            break;
                        }
                        c = (ClassDescription)i.next();
                        try {
                            builder.createMembers(c, false, true, false);
                            this.normalizer.normThrows(c, true);
                        }
                        catch (ClassNotFoundException e) {
                            this.storeError(Merge.i18n.getString("Merge.warning.message.classnotfound", e.getMessage()), null);
                        }
                    }
                    {
                        try {
                            writer = this.getFileManager().getWriter(merger.getSupportedFeatures());
                            if (writer == null) {
                                this.failed("Could not find a writer for given sigtest file formats.");
                                var20_18 = null;
                                if (writer != null) {
                                    writer.close();
                                }
                                break block47;
                            }
                            writer.setApiVersion("");
                            if (this.resultedFile != null) {
                                fos = new FileOutputStream(this.resultedFile);
                                osw = new OutputStreamWriter((OutputStream)fos, "UTF8");
                                pw = new PrintWriter(osw);
                            } else {
                                pw = new PrintWriter(System.out);
                            }
                            writer.init(pw);
                            it = merger.getSupportedFeatures().iterator();
                            while (true) {
                                if (!it.hasNext()) {
                                    writer.writeHeader();
                                    i = result.getClassIterator();
                                    break;
                                }
                                f = (FeaturesHolder.Feature)it.next();
                                if (f == FeaturesHolder.CopyRight) continue;
                                writer.addFeature(f);
                            }
                            while (i.hasNext()) {
                                c = (ClassDescription)i.next();
                                writer.write(c);
                            }
                        }
                        catch (IOException e) {
                            block50: {
                                SwissKnife.reportThrowable(e);
                                this.error(e.getMessage());
                                var20_20 = null;
                                if (writer != null) {
                                    writer.close();
                                }
                                ** try [egrp 4[TRYBLOCK] [7 : 715->738)] { 
lbl106:
                                // 1 sources

                                if (fos != null) {
                                    fos.close();
                                }
                                if (osw != null) {
                                    osw.close();
                                }
                                break block50;
lbl111:
                                // 1 sources

                                catch (IOException ex) {
                                    SwissKnife.reportThrowable(ex);
                                }
                            }
                            if (pw != null) {
                                pw.close();
                            }
                            break block49;
                        }
                        var20_19 = null;
                        if (writer != null) {
                            writer.close();
                        }
                        try {
                            if (fos != null) {
                                fos.close();
                            }
                            if (osw != null) {
                                osw.close();
                            }
                        }
                        catch (IOException ex) {
                            SwissKnife.reportThrowable(ex);
                        }
                        if (pw != null) {
                            pw.close();
                        }
                        break block49;
                    }
lbl132:
                    // 1 sources

                    catch (Throwable var19_30) {
                        block51: {
                            var20_21 = null;
                            if (writer != null) {
                                writer.close();
                            }
                            ** try [egrp 4[TRYBLOCK] [7 : 715->738)] { 
lbl138:
                            // 1 sources

                            if (fos != null) {
                                fos.close();
                            }
                            if (osw != null) {
                                osw.close();
                            }
                            break block51;
lbl143:
                            // 1 sources

                            catch (IOException ex) {
                                SwissKnife.reportThrowable(ex);
                            }
                        }
                        if (pw != null) {
                            pw.close();
                        }
                        throw var19_30;
                    }
                }
                ** try [egrp 4[TRYBLOCK] [7 : 715->738)] { 
lbl151:
                // 1 sources

                if (fos != null) {
                    fos.close();
                }
                if (osw != null) {
                    osw.close();
                }
                break block52;
lbl156:
                // 1 sources

                catch (IOException ex) {
                    SwissKnife.reportThrowable(ex);
                }
            }
            if (pw != null) {
                pw.close();
            }
            return;
        }
        this.printErrors();
    }

    protected void usage() {
        String nl = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        sb.append(nl).append(this.getComponentName() + " - " + i18n.getString("SignatureTest.usage.version", "3.0"));
        sb.append(nl).append(i18n.getString("Setup.usage.start"));
        sb.append(nl).append(i18n.getString("Sigtest.usage.delimiter"));
        sb.append(nl).append(i18n.getString("Merge.usage.files", FILES_OPTION));
        sb.append(nl).append(i18n.getString("Merge.usage.write", WRITE_OPTION));
        sb.append(nl).append(i18n.getString("Merge.usage.binary", BINARY_OPTION));
        sb.append(nl).append(i18n.getString("Sigtest.usage.delimiter"));
        sb.append(nl).append(i18n.getString("SetupAndTest.helpusage.version", "-Version"));
        sb.append(nl).append(i18n.getString("Setup.usage.help", "-Help"));
        sb.append(nl).append(i18n.getString("Sigtest.usage.delimiter"));
        sb.append(nl).append(i18n.getString("Setup.usage.end"));
        System.err.println(sb.toString());
    }

    protected String getComponentName() {
        return "Merge";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        FILES_OPTION = FILES_OPTION;
        WRITE_OPTION = WRITE_OPTION;
        BINARY_OPTION = BINARY_OPTION;
        i18n = I18NResourceBundle.getBundleForClass(class$com$sun$tdk$signaturetest$Merge == null ? (class$com$sun$tdk$signaturetest$Merge = Merge.class$("com.sun.tdk.signaturetest.Merge")) : class$com$sun$tdk$signaturetest$Merge);
    }

    static class SilentLog
    implements Log {
        SilentLog() {
        }

        public void storeError(String s, Logger utilLogger) {
        }

        public void storeWarning(String s, Logger utilLogger) {
        }
    }
}

