/*
 * Decompiled with CFR 0.152.
 */
package com.steadystate.css.parser;

import com.steadystate.css.format.CSSFormat;
import com.steadystate.css.format.CSSFormatable;
import com.steadystate.css.parser.LocatableImpl;
import java.io.Serializable;
import org.w3c.css.sac.LexicalUnit;

public class LexicalUnitImpl
extends LocatableImpl
implements LexicalUnit,
CSSFormatable,
Serializable {
    private static final long serialVersionUID = -7260032046960116891L;
    private short lexicalUnitType_;
    private LexicalUnit nextLexicalUnit_;
    private LexicalUnit previousLexicalUnit_;
    private float floatValue_;
    private String dimension_;
    private String functionName_;
    private LexicalUnit parameters_;
    private String stringValue_;
    private String sourceStringValue_;
    private transient String toString_;

    public void setLexicalUnitType(short type) {
        this.lexicalUnitType_ = type;
        this.toString_ = null;
    }

    public void setNextLexicalUnit(LexicalUnit next) {
        this.nextLexicalUnit_ = next;
    }

    public void setPreviousLexicalUnit(LexicalUnit prev) {
        this.previousLexicalUnit_ = prev;
    }

    public void setFloatValue(float floatVal) {
        this.floatValue_ = floatVal;
        this.toString_ = null;
    }

    public String getDimension() {
        return this.dimension_;
    }

    public void setDimension(String dimension) {
        this.dimension_ = dimension;
        this.toString_ = null;
    }

    public void setFunctionName(String function) {
        this.functionName_ = function;
        this.toString_ = null;
    }

    public void setParameters(LexicalUnit params) {
        this.parameters_ = params;
        this.toString_ = null;
    }

    public void setStringValue(String stringVal) {
        this.stringValue_ = stringVal;
        this.toString_ = null;
    }

    protected LexicalUnitImpl(LexicalUnit previous, short type) {
        this();
        this.lexicalUnitType_ = type;
        this.previousLexicalUnit_ = previous;
        if (this.previousLexicalUnit_ != null) {
            ((LexicalUnitImpl)this.previousLexicalUnit_).nextLexicalUnit_ = this;
        }
    }

    protected LexicalUnitImpl(LexicalUnit previous, int value) {
        this(previous, 13);
        this.floatValue_ = value;
    }

    protected LexicalUnitImpl(LexicalUnit previous, short type, float value) {
        this(previous, type);
        this.floatValue_ = value;
    }

    protected LexicalUnitImpl(LexicalUnit previous, short type, String dimension, float value) {
        this(previous, type);
        this.dimension_ = dimension;
        this.floatValue_ = value;
    }

    protected LexicalUnitImpl(LexicalUnit previous, short type, String value) {
        this(previous, type);
        this.stringValue_ = value;
    }

    protected LexicalUnitImpl(LexicalUnit previous, short type, String name, LexicalUnit params) {
        this(previous, type);
        this.functionName_ = name;
        this.parameters_ = params;
    }

    protected LexicalUnitImpl(LexicalUnit previous, short type, String name, String stringValue) {
        this(previous, type);
        this.functionName_ = name;
        this.stringValue_ = stringValue;
    }

    protected LexicalUnitImpl() {
    }

    public short getLexicalUnitType() {
        return this.lexicalUnitType_;
    }

    public LexicalUnit getNextLexicalUnit() {
        return this.nextLexicalUnit_;
    }

    public LexicalUnit getPreviousLexicalUnit() {
        return this.previousLexicalUnit_;
    }

    public int getIntegerValue() {
        return (int)this.floatValue_;
    }

    public float getFloatValue() {
        return this.floatValue_;
    }

    public String getDimensionUnitText() {
        switch (this.lexicalUnitType_) {
            case 15: {
                return "em";
            }
            case 16: {
                return "ex";
            }
            case 17: {
                return "px";
            }
            case 18: {
                return "in";
            }
            case 19: {
                return "cm";
            }
            case 20: {
                return "mm";
            }
            case 21: {
                return "pt";
            }
            case 22: {
                return "pc";
            }
            case 23: {
                return "%";
            }
            case 28: {
                return "deg";
            }
            case 29: {
                return "grad";
            }
            case 30: {
                return "rad";
            }
            case 31: {
                return "ms";
            }
            case 32: {
                return "s";
            }
            case 33: {
                return "Hz";
            }
            case 34: {
                return "kHz";
            }
            case 42: {
                return this.dimension_;
            }
        }
        return "";
    }

    public String getFunctionName() {
        return this.functionName_;
    }

    public LexicalUnit getParameters() {
        return this.parameters_;
    }

    public String getStringValue() {
        return this.stringValue_;
    }

    public String getSourceStringValue() {
        return this.sourceStringValue_;
    }

    public LexicalUnit getSubValues() {
        return this.parameters_;
    }

    public String getCssText() {
        return this.getCssText(null);
    }

    public String getCssText(CSSFormat format) {
        if (!(null == this.toString_ || format != null && format.useSourceStringValues())) {
            return this.toString_;
        }
        StringBuilder sb = new StringBuilder();
        switch (this.lexicalUnitType_) {
            case 0: {
                sb.append(",");
                break;
            }
            case 1: {
                sb.append("+");
                break;
            }
            case 2: {
                sb.append("-");
                break;
            }
            case 3: {
                sb.append("*");
                break;
            }
            case 4: {
                sb.append("/");
                break;
            }
            case 5: {
                sb.append("%");
                break;
            }
            case 6: {
                sb.append("^");
                break;
            }
            case 7: {
                sb.append("<");
                break;
            }
            case 8: {
                sb.append(">");
                break;
            }
            case 9: {
                sb.append("<=");
                break;
            }
            case 10: {
                sb.append(">=");
                break;
            }
            case 11: {
                sb.append("~");
                break;
            }
            case 12: {
                sb.append("inherit");
                break;
            }
            case 13: {
                sb.append(String.valueOf(this.getIntegerValue()));
                break;
            }
            case 14: {
                sb.append(this.getTrimedFloatValue());
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 42: {
                sb.append(this.getTrimedFloatValue());
                String dimUnitText = this.getDimensionUnitText();
                if (null == dimUnitText) break;
                sb.append(dimUnitText);
                break;
            }
            case 24: {
                sb.append("url(").append(this.getStringValue()).append(")");
                break;
            }
            case 25: {
                sb.append("counter(");
                this.appendParams(sb);
                sb.append(")");
                break;
            }
            case 26: {
                sb.append("counters(");
                this.appendParams(sb);
                sb.append(")");
                break;
            }
            case 27: {
                sb.append("rgb(");
                this.appendParams(sb);
                sb.append(")");
                break;
            }
            case 35: {
                sb.append(this.getStringValue());
                break;
            }
            case 36: {
                sb.append("\"");
                String value = this.getStringValue();
                value = null != format && format.useSourceStringValues() && this.sourceStringValue_ != null && value != this.sourceStringValue_ ? this.sourceStringValue_ : value.replace("\n", "\\A ").replace("\r", "\\D ");
                sb.append(value);
                sb.append("\"");
                break;
            }
            case 37: {
                sb.append("attr(").append(this.getStringValue()).append(")");
                break;
            }
            case 38: {
                sb.append("rect(");
                this.appendParams(sb);
                sb.append(")");
                break;
            }
            case 39: {
                String range = this.getStringValue();
                if (null == range) break;
                sb.append(range);
                break;
            }
            case 40: {
                String subExpression = this.getStringValue();
                if (null == subExpression) break;
                sb.append(subExpression);
                break;
            }
            case 41: {
                String functName = this.getFunctionName();
                if (null != functName) {
                    sb.append(functName);
                }
                sb.append('(');
                this.appendParams(sb);
                sb.append(")");
                break;
            }
        }
        this.toString_ = sb.toString();
        return this.toString_;
    }

    public String toString() {
        return this.getCssText(null);
    }

    public String toDebugString() {
        StringBuilder sb = new StringBuilder();
        switch (this.lexicalUnitType_) {
            case 0: {
                sb.append("SAC_OPERATOR_COMMA");
                break;
            }
            case 1: {
                sb.append("SAC_OPERATOR_PLUS");
                break;
            }
            case 2: {
                sb.append("SAC_OPERATOR_MINUS");
                break;
            }
            case 3: {
                sb.append("SAC_OPERATOR_MULTIPLY");
                break;
            }
            case 4: {
                sb.append("SAC_OPERATOR_SLASH");
                break;
            }
            case 5: {
                sb.append("SAC_OPERATOR_MOD");
                break;
            }
            case 6: {
                sb.append("SAC_OPERATOR_EXP");
                break;
            }
            case 7: {
                sb.append("SAC_OPERATOR_LT");
                break;
            }
            case 8: {
                sb.append("SAC_OPERATOR_GT");
                break;
            }
            case 9: {
                sb.append("SAC_OPERATOR_LE");
                break;
            }
            case 10: {
                sb.append("SAC_OPERATOR_GE");
                break;
            }
            case 11: {
                sb.append("SAC_OPERATOR_TILDE");
                break;
            }
            case 12: {
                sb.append("SAC_INHERIT");
                break;
            }
            case 13: {
                sb.append("SAC_INTEGER(").append(String.valueOf(this.getIntegerValue())).append(")");
                break;
            }
            case 14: {
                sb.append("SAC_REAL(").append(this.getTrimedFloatValue()).append(")");
                break;
            }
            case 15: {
                sb.append("SAC_EM(").append(this.getTrimedFloatValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 16: {
                sb.append("SAC_EX(").append(this.getTrimedFloatValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 17: {
                sb.append("SAC_PIXEL(").append(this.getTrimedFloatValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 18: {
                sb.append("SAC_INCH(").append(this.getTrimedFloatValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 19: {
                sb.append("SAC_CENTIMETER(").append(this.getTrimedFloatValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 20: {
                sb.append("SAC_MILLIMETER(").append(this.getTrimedFloatValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 21: {
                sb.append("SAC_POINT(").append(this.getTrimedFloatValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 22: {
                sb.append("SAC_PICA(").append(this.getTrimedFloatValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 23: {
                sb.append("SAC_PERCENTAGE(").append(this.getTrimedFloatValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 28: {
                sb.append("SAC_DEGREE(").append(this.getTrimedFloatValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 29: {
                sb.append("SAC_GRADIAN(").append(this.getTrimedFloatValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 30: {
                sb.append("SAC_RADIAN(").append(this.getTrimedFloatValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 31: {
                sb.append("SAC_MILLISECOND(").append(this.getTrimedFloatValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 32: {
                sb.append("SAC_SECOND(").append(this.getTrimedFloatValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 33: {
                sb.append("SAC_HERTZ(").append(this.getTrimedFloatValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 34: {
                sb.append("SAC_KILOHERTZ(").append(this.getTrimedFloatValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 42: {
                sb.append("SAC_DIMENSION(").append(this.getTrimedFloatValue()).append(this.getDimensionUnitText()).append(")");
                break;
            }
            case 24: {
                sb.append("SAC_URI(url(").append(this.getStringValue()).append("))");
                break;
            }
            case 25: {
                sb.append("SAC_COUNTER_FUNCTION(counter(");
                this.appendParams(sb);
                sb.append("))");
                break;
            }
            case 26: {
                sb.append("SAC_COUNTERS_FUNCTION(counters(");
                this.appendParams(sb);
                sb.append("))");
                break;
            }
            case 27: {
                sb.append("SAC_RGBCOLOR(rgb(");
                this.appendParams(sb);
                sb.append("))");
                break;
            }
            case 35: {
                sb.append("SAC_IDENT(").append(this.getStringValue()).append(")");
                break;
            }
            case 36: {
                sb.append("SAC_STRING_VALUE(\"").append(this.getStringValue()).append("\")");
                break;
            }
            case 37: {
                sb.append("SAC_ATTR(attr(").append(this.getStringValue()).append("))");
                break;
            }
            case 38: {
                sb.append("SAC_RECT_FUNCTION(rect(");
                this.appendParams(sb);
                sb.append("))");
                break;
            }
            case 39: {
                sb.append("SAC_UNICODERANGE(").append(this.getStringValue()).append(")");
                break;
            }
            case 40: {
                sb.append("SAC_SUB_EXPRESSION(").append(this.getStringValue()).append(")");
                break;
            }
            case 41: {
                sb.append("SAC_FUNCTION(").append(this.getFunctionName()).append("(");
                for (LexicalUnit l = this.parameters_; l != null; l = l.getNextLexicalUnit()) {
                    sb.append(l.toString());
                }
                sb.append("))");
                break;
            }
        }
        return sb.toString();
    }

    private void appendParams(StringBuilder sb) {
        LexicalUnit l = this.parameters_;
        if (l != null) {
            sb.append(l.toString());
            for (l = l.getNextLexicalUnit(); l != null; l = l.getNextLexicalUnit()) {
                if (l.getLexicalUnitType() != 0) {
                    sb.append(" ");
                }
                sb.append(l.toString());
            }
        }
    }

    private String getTrimedFloatValue() {
        int i;
        float f = this.getFloatValue();
        if (f - (float)(i = (int)f) == 0.0f) {
            return Integer.toString((int)f);
        }
        return Float.toString(f);
    }

    public static LexicalUnit createNumber(LexicalUnit prev, int i) {
        return new LexicalUnitImpl(prev, i);
    }

    public static LexicalUnit createNumber(LexicalUnit prev, float f) {
        return new LexicalUnitImpl(prev, 14, f);
    }

    public static LexicalUnit createPercentage(LexicalUnit prev, float f) {
        return new LexicalUnitImpl(prev, 23, f);
    }

    public static LexicalUnit createPixel(LexicalUnit prev, float f) {
        return new LexicalUnitImpl(prev, 17, f);
    }

    public static LexicalUnit createCentimeter(LexicalUnit prev, float f) {
        return new LexicalUnitImpl(prev, 19, f);
    }

    public static LexicalUnit createMillimeter(LexicalUnit prev, float f) {
        return new LexicalUnitImpl(prev, 20, f);
    }

    public static LexicalUnit createInch(LexicalUnit prev, float f) {
        return new LexicalUnitImpl(prev, 18, f);
    }

    public static LexicalUnit createPoint(LexicalUnit prev, float f) {
        return new LexicalUnitImpl(prev, 21, f);
    }

    public static LexicalUnit createPica(LexicalUnit prev, float f) {
        return new LexicalUnitImpl(prev, 22, f);
    }

    public static LexicalUnit createEm(LexicalUnit prev, float f) {
        return new LexicalUnitImpl(prev, 15, f);
    }

    public static LexicalUnit createEx(LexicalUnit prev, float f) {
        return new LexicalUnitImpl(prev, 16, f);
    }

    public static LexicalUnit createDegree(LexicalUnit prev, float f) {
        return new LexicalUnitImpl(prev, 28, f);
    }

    public static LexicalUnit createRadian(LexicalUnit prev, float f) {
        return new LexicalUnitImpl(prev, 30, f);
    }

    public static LexicalUnit createGradian(LexicalUnit prev, float f) {
        return new LexicalUnitImpl(prev, 29, f);
    }

    public static LexicalUnit createMillisecond(LexicalUnit prev, float f) {
        return new LexicalUnitImpl(prev, 31, f);
    }

    public static LexicalUnit createSecond(LexicalUnit prev, float f) {
        return new LexicalUnitImpl(prev, 32, f);
    }

    public static LexicalUnit createHertz(LexicalUnit prev, float f) {
        return new LexicalUnitImpl(prev, 33, f);
    }

    public static LexicalUnit createDimension(LexicalUnit prev, float f, String dim) {
        return new LexicalUnitImpl(prev, 42, dim, f);
    }

    public static LexicalUnit createKiloHertz(LexicalUnit prev, float f) {
        return new LexicalUnitImpl(prev, 34, f);
    }

    public static LexicalUnit createCounter(LexicalUnit prev, LexicalUnit params) {
        return new LexicalUnitImpl(prev, 25, "counter", params);
    }

    public static LexicalUnit createCounters(LexicalUnit prev, LexicalUnit params) {
        return new LexicalUnitImpl(prev, 26, "counters", params);
    }

    public static LexicalUnit createAttr(LexicalUnit prev, String value) {
        return new LexicalUnitImpl(prev, 37, "name", value);
    }

    public static LexicalUnit createRect(LexicalUnit prev, LexicalUnit params) {
        return new LexicalUnitImpl(prev, 38, "rect", params);
    }

    public static LexicalUnit createRgbColor(LexicalUnit prev, LexicalUnit params) {
        return new LexicalUnitImpl(prev, 27, "rgb", params);
    }

    public static LexicalUnit createFunction(LexicalUnit prev, String name, LexicalUnit params) {
        return new LexicalUnitImpl(prev, 41, name, params);
    }

    public static LexicalUnit createString(LexicalUnit prev, String value) {
        return new LexicalUnitImpl(prev, 36, value);
    }

    public static LexicalUnit createString(LexicalUnit prev, String value, String sourceStringValue) {
        LexicalUnitImpl unit = new LexicalUnitImpl(prev, 36, value);
        unit.sourceStringValue_ = sourceStringValue;
        return unit;
    }

    public static LexicalUnit createIdent(LexicalUnit prev, String value) {
        return new LexicalUnitImpl(prev, 35, value);
    }

    public static LexicalUnit createURI(LexicalUnit prev, String value) {
        return new LexicalUnitImpl(prev, 24, value);
    }

    public static LexicalUnit createComma(LexicalUnit prev) {
        return new LexicalUnitImpl(prev, 0);
    }
}

