/*
 * Decompiled with CFR 0.152.
 */
package javasoft.sqe.apiCheck;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StreamTokenizer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javasoft.sqe.apiCheck.Main;
import javasoft.sqe.apiCheck.UFileReader;
import javasoft.sqe.apiCheck.Unit;
import javasoft.sqe.apiCheck.UnitClass;
import javasoft.sqe.apiCheck.UnitConstructor;
import javasoft.sqe.apiCheck.UnitField;
import javasoft.sqe.apiCheck.UnitMethod;
import javasoft.sqe.apiCheck.UnitPack;
import javasoft.sqe.apiCheck.XModifier;
import javasoft.sqe.apiCheck.XProg;

abstract class JReader {
    static final int syn_eof = -1;
    static final int syn_eol = 0;
    static final int syn_ident = 1;
    static final int syn_sep = 2;
    static final int syn_numb = 3;
    static final int syn_package = 10;
    static final int syn_class = 11;
    static final int syn_interface = 12;
    static final int syn_extends = 13;
    static final int syn_implements = 14;
    static final int syn_throws = 15;
    String fname;
    BufferedReader is;
    StreamTokenizer st;
    String lex;
    char chr;
    int syn;
    int errors;
    boolean trace = false;
    String defpack = null;
    HashMap classes = new HashMap();
    HashSet unknown = new HashSet();
    Vector units;
    int depth;
    static Keywords words = new Keywords();

    JReader() {
        this.defpack = Main.args.getProperty("defpack");
        if (this.defpack != null) {
            if (this.defpack.length() == 0) {
                this.defpack = null;
            } else if (!this.defpack.endsWith(".")) {
                this.defpack = this.defpack + '.';
            }
        }
    }

    boolean Open(String f) {
        String err = this.OpenStream(f);
        if (err == null) {
            this.OpenScan();
            return true;
        }
        System.err.println(err);
        return false;
    }

    String OpenStream(String f) {
        this.Close();
        if (f == null || (this.fname = f.trim().intern()).length() == 0) {
            return "Missing source file name";
        }
        try {
            this.is = new BufferedReader(new UFileReader(this.fname));
        }
        catch (IOException x) {
            return "Failed to open source file \"" + this.fname + "\"";
        }
        return null;
    }

    void OpenScan() {
        this.st = new StreamTokenizer(this.is);
        this.st.ordinaryChar(45);
        this.st.ordinaryChars(48, 57);
        this.st.wordChars(45, 45);
        this.st.wordChars(48, 57);
        this.st.wordChars(95, 95);
        this.st.wordChars(36, 36);
        this.st.wordChars(92, 92);
        this.st.wordChars(128, 65537);
        this.st.slashStarComments(true);
        this.st.slashSlashComments(true);
    }

    void Close() {
        this.lex = null;
        this.st = null;
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.is = null;
        }
        this.fname = null;
    }

    void PrintUnknown(PrintStream out) {
        if (!this.unknown.isEmpty()) {
            out.println("unknown classes:");
            Iterator i = this.unknown.iterator();
            while (i.hasNext()) {
                out.println((String)i.next());
            }
            out.println();
        }
    }

    boolean ReadUnit(Vector uu, String topname) {
        boolean r;
        this.st.eolIsSignificant(false);
        if (this.syn == 0) {
            this.ReadWord();
        }
        this.units = uu;
        this.depth = 0;
        while (this.syn == 1 && this.lex.equals("use")) {
            this.ReadWord();
            while (this.syn == 1) {
                int i = this.lex.lastIndexOf(46);
                if (i == -1) {
                    this.Err("invalid use", this.lex);
                } else if (this.classes.put(this.lex.substring(i + 1), this.lex.substring(0, i + 1)) != null) {
                    this.Err("duplicate use", this.lex);
                }
                this.ReadWord();
                if (this.syn != 2 || this.chr != ',') break;
                this.ReadWord();
            }
            this.ReadSep(';');
        }
        if (this.syn == 10) {
            this.ReadWord();
            this.CheckIdent();
            UnitPack unit = new UnitPack();
            unit.fname = this.fname;
            unit.linenb = this.st.lineno();
            int i = this.lex.lastIndexOf(46);
            if (i == -1) {
                unit.Name(null, this.lex);
            } else {
                unit.Name(this.lex.substring(0, i + 1), this.lex.substring(i + 1));
            }
            this.ReadWord();
            this.ReadSep(';');
            this.units.add(unit);
            r = true;
        } else {
            r = this.ReadInternal(topname);
        }
        this.units = null;
        return r;
    }

    boolean ReadInternal(String topname) {
        int m = this.ReadModifier();
        if (this.syn == 11 || this.syn == 12) {
            if (this.syn == 12) {
                m |= 0x200;
                m |= 0x400;
            }
            UnitClass unit = new UnitClass();
            unit.fname = this.fname;
            unit.linenb = this.st.lineno();
            unit.defined = true;
            unit.modifier = m;
            this.ReadWord();
            this.CheckIdent();
            this.CheckName(this.lex);
            unit.Name(topname, this.lex);
            this.ReadWord();
            if (this.syn == 13) {
                this.ReadWord();
                String[] w = this.ReadClassNames();
                if (w == null) {
                    this.Err("class name(s) expected after extends");
                } else if ((m & 0x200) != 0) {
                    unit.implement = w;
                } else {
                    unit.extend = w[0];
                    if (w.length > 1) {
                        this.Err("only one superclass allowed", unit.toString());
                    }
                }
            } else if ((m & 0x200) == 0 && !"java.lang.Object".equals(unit.topname + unit.name)) {
                unit.extend = "java.lang.Object".intern();
            }
            if (this.syn == 14) {
                this.ReadWord();
                unit.implement = this.ReadClassNames();
                if (unit.implement == null) {
                    this.Err("class name(s) expected after implements");
                }
                if ((m & 0x200) != 0) {
                    this.Err("implements not allowed in interfaces", unit.toString());
                }
            }
            this.units.add(unit);
            this.CheckModifier(unit, (unit.modifier & 0x200) == 0 ? 3103 : 3599);
            if (this.depth != 0) {
                this.CheckClassMember(unit);
            }
            if (this.syn == 2 && this.chr == '{') {
                this.ReadSep('{');
                ++this.depth;
                while (this.ReadInternal(unit.toString() + ".")) {
                }
                --this.depth;
                this.ReadSep('}');
            }
            return true;
        }
        if (this.syn == 1) {
            String s1 = this.lex;
            this.ReadWord();
            if (this.syn == 2 && this.chr == '(') {
                UnitConstructor unit = new UnitConstructor();
                unit.fname = this.fname;
                unit.linenb = this.st.lineno();
                unit.modifier = m;
                this.CheckName(s1);
                unit.Name(topname, s1);
                unit.args = this.ReadArgs();
                unit.xthrows = this.ReadThrows();
                this.units.add(unit);
                this.CheckClassMember(unit);
                this.CheckModifier(unit, 3391);
                this.ReadSep(';');
                return true;
            }
            while (this.syn == 2 && this.chr == '[') {
                this.ReadWord();
                this.ReadSep(']');
                s1 = s1 + "[]";
            }
            if (this.syn != 1) {
                this.Err("name of a method or field expected");
            }
            this.CheckName(this.lex);
            String s2 = this.lex;
            this.ReadWord();
            if (this.syn == 2) {
                if (this.chr == '(') {
                    UnitMethod unit = new UnitMethod();
                    unit.fname = this.fname;
                    unit.linenb = this.st.lineno();
                    unit.modifier = m;
                    this.CheckName(s2);
                    unit.Name(topname, s2);
                    unit.type = this.ExpandClassName(s1).intern();
                    unit.args = this.ReadArgs();
                    unit.xthrows = this.ReadThrows();
                    this.units.add(unit);
                    this.CheckClassMember(unit);
                    this.CheckModifier(unit, 3391);
                    this.ReadSep(';');
                    return true;
                }
                while (true) {
                    String s3 = "";
                    while (this.syn == 2 && this.chr == '[') {
                        this.ReadWord();
                        this.ReadSep(']');
                        s3 = s3 + "[]";
                    }
                    UnitField unit = new UnitField();
                    unit.fname = this.fname;
                    unit.linenb = this.st.lineno();
                    unit.modifier = m;
                    this.CheckName(s2);
                    unit.Name(topname, s2);
                    unit.type = this.ExpandClassName(s1 + s3).intern();
                    if (this.chr == '=') {
                        this.ReadWord();
                        unit.value = this.ReadExpr(unit.type);
                    }
                    this.units.add(unit);
                    this.CheckClassMember(unit);
                    this.CheckModifier(unit, 223);
                    if (this.syn != 2 || this.chr != ',') break;
                    this.ReadWord();
                    if (this.syn != 1) {
                        this.Err("field name expected");
                    }
                    s2 = this.lex;
                    this.ReadWord();
                }
                this.ReadSep(';');
                return true;
            }
        }
        return false;
    }

    void CheckName(String s) {
        if (this.depth != 0 && s.indexOf(46) != -1) {
            this.Err("only simple name allowed inside class definition");
        }
    }

    void CheckClassMember(Unit u) {
        String s = "";
        int l = u.topname.length();
        int i = u.topname.lastIndexOf(46, l - 2);
        if (i != -1) {
            s = u.topname.substring(i + 1, l - 1);
        }
        if (u.name == null || u.name.length() == 0) {
            this.Err("name empty", u);
            return;
        }
        if (s == null || s.length() == 0) {
            return;
        }
        if (u instanceof UnitConstructor && !s.equals(u.name)) {
            this.Err("invalid name of class constructor", u);
        }
    }

    void CheckModifier(Unit u, int m) {
        int x = u.modifier & ~m;
        if (x != 0) {
            this.Err("invalid modifier(s): \"" + XModifier.toString(x) + "\"", u);
        }
    }

    String[] ReadArgs() {
        Vector<String> v = new Vector<String>();
        this.ReadSep('(');
        while (this.syn == 1) {
            if (this.lex.equals("final")) {
                this.ReadWord();
                if (this.syn != 1) {
                    this.Err("type name expected after final");
                }
            }
            String s = this.ReadType();
            if (this.syn == 1) {
                this.ReadWord();
            }
            String s1 = "";
            while (this.syn == 2 && this.chr == '[') {
                this.ReadWord();
                this.ReadSep(']');
                s1 = s1 + "[]";
            }
            v.add(s + s1);
            if (this.syn != 2 || this.chr != ',') break;
            this.ReadWord();
        }
        this.ReadSep(')');
        return JReader.ToArrayString(v);
    }

    String[] ReadThrows() {
        Vector<String> v = new Vector<String>();
        if (this.syn == 15) {
            this.ReadWord();
            while (this.syn == 1) {
                v.add(this.ReadType());
                if (this.syn != 2 || this.chr != ',') break;
                this.ReadWord();
            }
            if (v.size() == 0) {
                this.Err("type name(s) expected after throws");
            }
            return JReader.ToArrayString(v);
        }
        return null;
    }

    String ReadType() {
        this.CheckIdent();
        String s = this.ExpandClassName(this.lex);
        this.ReadWord();
        while (this.syn == 2 && this.chr == '[') {
            this.ReadWord();
            this.ReadSep(']');
            s = s + "[]";
        }
        return s;
    }

    String[] ReadClassNames() {
        Vector<String> v = new Vector<String>();
        while (this.syn == 1) {
            v.add(this.ExpandClassName(this.lex));
            this.ReadWord();
            if (this.syn != 2 || this.chr != ',') break;
            this.ReadWord();
        }
        if (v.size() == 0) {
            return null;
        }
        return JReader.ToArrayString(v);
    }

    String ExpandClassName(String s) {
        if (s.indexOf(46) == -1) {
            String x;
            int i = s.indexOf("[]");
            String string = x = i == -1 ? s : s.substring(0, i);
            if (XProg.DefineTypePrimitive(x) == null) {
                return i == -1 ? this.ExpandClass(x) : this.ExpandClass(x) + s.substring(i);
            }
        }
        return s;
    }

    String ExpandClass(String x) {
        String s = (String)this.classes.get(x);
        if (s != null) {
            return s + x;
        }
        this.unknown.add(x);
        if (this.defpack != null) {
            return this.defpack + x;
        }
        return x;
    }

    static String[] ToArrayString(Vector v) {
        if (v == null | v.size() == 0) {
            return null;
        }
        String[] a = new String[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            a[i] = ((String)v.get(i)).intern();
        }
        return a;
    }

    int ReadModifier() {
        int m;
        int mask = 0;
        while (this.syn == 1 && (m = XModifier.Convert(this.lex)) != 0) {
            mask |= m;
            this.ReadWord();
        }
        return mask;
    }

    Object ReadExpr(String type) {
        Object v = null;
        if (type.equals("java.lang.String")) {
            if (this.syn != 2 || this.chr != '\"' || this.st.sval == null) {
                this.ErrStop("string expression expected");
            }
            try {
                v = new String(this.st.sval);
            }
            catch (Exception e) {
                this.ErrStop("invalid string value");
            }
            this.ReadWord();
        } else if (type.equals("char")) {
            try {
                if (this.syn == 2 && this.chr == '\'') {
                    v = new Character(this.st.sval.charAt(0));
                } else {
                    int i = Integer.decode(this.lex);
                    if (i < 0 || i > 65535) {
                        throw new Exception();
                    }
                    v = new Character((char)i);
                }
            }
            catch (Exception e) {
                this.ErrStop("invalid char value");
            }
            this.ReadWord();
        } else if (type.equals("boolean")) {
            if (this.syn != 1) {
                this.ErrStop("expression expected");
            }
            if (this.lex.equals("true")) {
                v = new Boolean(true);
            } else if (this.lex.equals("false")) {
                v = new Boolean(false);
            } else {
                this.ErrStop("invalid boolean value");
            }
            this.ReadWord();
        } else if (type.equals("byte")) {
            if (this.syn != 1) {
                this.ErrStop("expression expected");
            }
            try {
                v = Byte.decode(this.lex);
            }
            catch (Exception e) {
                this.ErrStop("invalid byte value");
            }
            this.ReadWord();
        } else if (type.equals("short")) {
            if (this.syn != 1) {
                this.ErrStop("expression expected");
            }
            try {
                v = Short.decode(this.lex);
            }
            catch (Exception e) {
                this.ErrStop("invalid short value");
            }
            this.ReadWord();
        } else if (type.equals("int")) {
            if (this.syn != 1) {
                this.ErrStop("expression expected");
            }
            try {
                v = Integer.decode(this.lex);
            }
            catch (Exception e) {
                this.ErrStop("invalid integer value");
            }
            this.ReadWord();
        } else if (type.equals("long")) {
            if (this.syn != 1) {
                this.ErrStop("expression expected");
            }
            try {
                v = this.lex.endsWith("L") || this.lex.endsWith("l") ? Long.decode(this.lex.substring(0, this.lex.length() - 1)) : Long.decode(this.lex);
            }
            catch (Exception e) {
                this.ErrStop("invalid long value");
            }
            this.ReadWord();
        } else if (type.equals("float")) {
            if (this.syn != 1) {
                this.ErrStop("expression expected");
            }
            try {
                v = this.lex.equals("Infinity") ? new Float(Float.POSITIVE_INFINITY) : (this.lex.equals("-Infinity") ? new Float(Float.NEGATIVE_INFINITY) : (this.lex.equals("NaN") ? new Float(Float.NaN) : (this.lex.endsWith("F") || this.lex.endsWith("f") ? new Float(this.lex.substring(0, this.lex.length() - 1)) : new Float(this.lex))));
            }
            catch (Exception e) {
                this.ErrStop("invalid float value");
            }
            this.ReadWord();
        } else if (type.equals("double")) {
            if (this.syn != 1) {
                this.ErrStop("expression expected");
            }
            try {
                v = this.lex.equals("Infinity") ? new Double(Double.POSITIVE_INFINITY) : (this.lex.equals("-Infinity") ? new Double(Double.NEGATIVE_INFINITY) : (this.lex.equals("NaN") ? new Double(Double.NaN) : (this.lex.endsWith("D") || this.lex.endsWith("d") ? new Double(this.lex.substring(0, this.lex.length() - 1)) : new Double(this.lex))));
            }
            catch (Exception e) {
                this.ErrStop("invalid double value");
            }
            this.ReadWord();
        } else {
            this.ErrStop("values of type \"" + type + "\" not supported");
        }
        return v;
    }

    void CheckIdent() {
        if (this.syn != 1) {
            this.ErrStop("ident expected");
        }
    }

    void ReadSep(char c) {
        if (this.syn != 2 || this.chr != c) {
            this.ErrStop("separator expected: <" + c + ">");
        }
        this.ReadWord();
    }

    void ReadEol() {
        if (this.syn != -1) {
            if (this.syn != 0) {
                this.ErrStop("extra symbol(s) on line");
            }
            while (this.syn != -1 && this.syn != 0) {
                this.ReadWord();
            }
            if (this.syn == 0) {
                this.ReadWord();
            }
        }
    }

    void ErrStop(String m) {
        ++this.errors;
        System.err.println(m);
        System.err.println(this.st.toString());
        throw new Error();
    }

    boolean Err(String m, Unit u) {
        ++this.errors;
        System.err.println(m);
        System.err.println("\"" + u.toString() + "\", line " + u.linenb);
        return false;
    }

    boolean Err(String m, String n) {
        ++this.errors;
        System.err.println(m);
        if (n != null) {
            System.err.println(n);
        }
        return false;
    }

    boolean Err(String m) {
        ++this.errors;
        System.err.println(m);
        System.err.println(this.st.toString());
        return false;
    }

    boolean ReadWord() {
        try {
            this.st.nextToken();
        }
        catch (IOException x) {
            System.err.println("Read error from file " + this.fname + "\n" + x);
            throw new Error();
        }
        switch (this.st.ttype) {
            case -1: {
                this.syn = -1;
                break;
            }
            case 10: {
                this.syn = 0;
                break;
            }
            case -2: {
                this.syn = 3;
                break;
            }
            case -3: {
                this.lex = this.st.sval;
                this.syn = words.Look(this.lex);
                break;
            }
            default: {
                this.chr = (char)this.st.ttype;
                this.syn = 2;
            }
        }
        if (this.trace) {
            System.out.println("syn=" + String.valueOf(this.syn) + "  " + this.st.toString());
        }
        return this.syn != -1;
    }

    static class Keywords
    extends Hashtable {
        Keywords() {
            this.Put("package", 10);
            this.Put("class", 11);
            this.Put("interface", 12);
            this.Put("extends", 13);
            this.Put("implements", 14);
            this.Put("throws", 15);
        }

        void Put(String word, int key) {
            super.put(word, new Integer(key));
        }

        int Look(String word) {
            Integer i = (Integer)super.get(word);
            return i == null ? 1 : i;
        }
    }
}

