/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http.internal.frame;

public abstract class Http2Frame {
    public static final int FRAME_HEADER_SIZE = 9;
    protected int streamid;
    protected int flags;

    public Http2Frame(int n, int n2) {
        this.streamid = n;
        this.flags = n2;
    }

    public int streamid() {
        return this.streamid;
    }

    public void setFlag(int n) {
        this.flags |= n;
    }

    public void setFlags(int n) {
        this.flags = n;
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean getFlag(int n) {
        return (this.flags & n) != 0;
    }

    public void clearFlag(int n) {
        this.flags &= 0xFFFFFFFF ^ n;
    }

    public void streamid(int n) {
        this.streamid = n;
    }

    public String typeAsString() {
        return Http2Frame.asString(this.type());
    }

    public int type() {
        return -1;
    }

    int length() {
        return -1;
    }

    public static String asString(int n) {
        switch (n) {
            case 0: {
                return "DATA";
            }
            case 1: {
                return "HEADERS";
            }
            case 9: {
                return "CONTINUATION";
            }
            case 3: {
                return "RESET";
            }
            case 2: {
                return "PRIORITY";
            }
            case 4: {
                return "SETTINGS";
            }
            case 7: {
                return "GOAWAY";
            }
            case 6: {
                return "PING";
            }
            case 5: {
                return "PUSH_PROMISE";
            }
            case 8: {
                return "WINDOW_UPDATE";
            }
        }
        return "UNKNOWN";
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.typeAsString()).append(": length=").append(Integer.toString(this.length())).append(", streamid=").append(this.streamid).append(", flags=");
        int n = this.flags;
        int n2 = 0;
        if (n == 0) {
            stringBuilder.append("0 ");
        } else {
            while (n != 0) {
                if ((n & 1) == 1) {
                    stringBuilder.append(this.flagAsString(1 << n2)).append(' ');
                }
                n >>= 1;
                ++n2;
            }
        }
        return stringBuilder.toString();
    }

    public String flagAsString(int n) {
        return "unknown";
    }
}

