/*
 * Copyright (c) 2012, 2020 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

package com.sun.ts.tests.jaxrs.api.rs.bindingpriority;

import java.util.concurrent.atomic.AtomicInteger;

import com.sun.ts.lib.harness.EETest.Fault;

import jakarta.annotation.Priority;
import jakarta.ws.rs.client.ClientRequestContext;

@Priority(Integer.MIN_VALUE)
// the lower the number the higher the priority
public class HigherPriorityProvider extends ContextProvider {
  private AtomicInteger counter;

  public HigherPriorityProvider(AtomicInteger counter) {
    super();
    this.counter = counter;
  }

  protected void checkFilterContext(ClientRequestContext context) throws Fault {
    assertFault(counter.incrementAndGet() == 1,
        "Lower provider priority has been called as ", counter.get(), "nd");
  }
}
