/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.sigfile;

import com.sun.tdk.signaturetest.sigfile.FeaturesHolder;
import com.sun.tdk.signaturetest.sigfile.Format;
import com.sun.tdk.signaturetest.sigfile.Reader;
import com.sun.tdk.signaturetest.sigfile.Writer;
import com.sun.tdk.signaturetest.sigfile.f21.F21Format;
import com.sun.tdk.signaturetest.sigfile.f31.F31Format;
import com.sun.tdk.signaturetest.sigfile.f40.F40Format;
import com.sun.tdk.signaturetest.sigfile.f41.F41Format;
import com.sun.tdk.signaturetest.sigfile.f42.F42Format;
import com.sun.tdk.signaturetest.sigfile.f43.F43Format;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class FileManager {
    private static final String DEFAULT_PROTOCOL = "file:";
    private Format defaultFormat = new F43Format();
    private final List<Format> formats = new ArrayList<Format>();

    public static URL getURL(String testURL, String fileName) throws MalformedURLException {
        URL result;
        File f = new File(fileName);
        if (testURL == null) {
            testURL = "";
        }
        if (f.isAbsolute()) {
            result = f.toURI().toURL();
        } else {
            if (testURL.indexOf(58) == -1) {
                testURL = DEFAULT_PROTOCOL + testURL;
            }
            result = new URL(new URL(testURL), fileName);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getFormat(URL fileURL) {
        try (BufferedReader in = new BufferedReader(new InputStreamReader(fileURL.openStream(), StandardCharsets.UTF_8));){
            String currentLine = in.readLine();
            if (currentLine == null) {
                String string = null;
                return string;
            }
            currentLine = currentLine.trim();
            return currentLine;
        }
        catch (IOException e) {
            return null;
        }
    }

    public Writer getWriter(Set<FeaturesHolder.Feature> features) {
        ArrayList<Format> applicableFormats = new ArrayList<Format>(this.formats.size());
        for (Format format : this.formats) {
            Set<FeaturesHolder.Feature> formatFeatures = format.getSupportedFeatures();
            if (!features.equals(formatFeatures)) continue;
            applicableFormats.add(format);
        }
        double latestVersion = 0.0;
        Writer latestWriter = null;
        for (Format f : applicableFormats) {
            String[] sv = f.getVersion().split(" ");
            double v = Double.parseDouble(sv[sv.length - 1].substring(1));
            if (!(v > latestVersion)) continue;
            latestVersion = v;
            latestWriter = f.getWriter();
        }
        return latestWriter;
    }

    public Reader getReader(URL fileURL) {
        String format = this.getFormat(fileURL);
        if (format != null) {
            for (Format f : this.formats) {
                if (!f.isApplicable(format)) continue;
                return f.getReader();
            }
        }
        return null;
    }

    public Format getDefaultFormat() {
        return this.defaultFormat;
    }

    public void addFormat(Format frm, boolean useByDefault) {
        this.formats.add(frm);
        if (useByDefault) {
            this.defaultFormat = frm;
        }
    }

    public void setFormat(Format frm) {
        this.formats.clear();
        this.formats.add(frm);
        this.defaultFormat = frm;
    }

    public FileManager() {
        this.formats.add(this.defaultFormat);
        this.formats.add(new F21Format());
        this.formats.add(new F31Format());
        this.formats.add(new F40Format());
        this.formats.add(new F41Format());
        this.formats.add(new F42Format());
    }
}

