/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http;

import java.util.concurrent.atomic.AtomicInteger;
import jdk.incubator.http.Http2Connection;
import jdk.incubator.http.internal.frame.WindowUpdateFrame;

abstract class WindowUpdateSender {
    final int limit;
    final Http2Connection connection;
    final AtomicInteger received = new AtomicInteger(0);

    WindowUpdateSender(Http2Connection http2Connection) {
        this(http2Connection, http2Connection.clientSettings.getParameter(4));
    }

    WindowUpdateSender(Http2Connection http2Connection, int n) {
        this(http2Connection, http2Connection.getMaxReceiveFrameSize(), n);
    }

    WindowUpdateSender(Http2Connection http2Connection, int n, int n2) {
        this.connection = http2Connection;
        int n3 = Math.max(0, n2 - n);
        int n4 = (n2 + (n - 1)) / n;
        n4 = n4 * n / 2;
        this.limit = Math.min(n3, n4);
    }

    abstract int getStreamId();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update(int n) {
        if (this.received.addAndGet(n) > this.limit) {
            WindowUpdateSender windowUpdateSender = this;
            synchronized (windowUpdateSender) {
                int n2 = this.received.get();
                if (n2 > this.limit) {
                    this.received.getAndAdd(-n2);
                    this.sendWindowUpdate(n2);
                }
            }
        }
    }

    void sendWindowUpdate(int n) {
        this.connection.sendUnorderedFrame(new WindowUpdateFrame(this.getStreamId(), n));
    }
}

