/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionPool;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.util.Debug;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

final class ParallelPoolConnectorTask
implements Runnable {
    private final AtomicReference<LDAPException> firstException;
    private final boolean throwOnConnectFailure;
    private final LDAPConnectionPool pool;
    private final List<LDAPConnection> connList;

    ParallelPoolConnectorTask(LDAPConnectionPool pool, List<LDAPConnection> connList, AtomicReference<LDAPException> firstException, boolean throwOnConnectFailure) {
        this.pool = pool;
        this.connList = connList;
        this.firstException = firstException;
        this.throwOnConnectFailure = throwOnConnectFailure;
    }

    @Override
    public void run() {
        block3: {
            try {
                if (this.throwOnConnectFailure && this.firstException.get() != null) {
                    return;
                }
                this.connList.add(this.pool.createConnection());
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                if (!this.throwOnConnectFailure) break block3;
                this.firstException.compareAndSet(null, le);
            }
        }
    }
}

