/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http.internal.hpack;

import java.nio.ByteBuffer;
import jdk.incubator.http.internal.hpack.BinaryRepresentationWriter;
import jdk.incubator.http.internal.hpack.HeaderTable;
import jdk.incubator.http.internal.hpack.IntegerWriter;

final class SizeUpdateWriter
implements BinaryRepresentationWriter {
    private final IntegerWriter intWriter = new IntegerWriter();
    private int maxSize;
    private boolean tableUpdated;

    SizeUpdateWriter() {
    }

    SizeUpdateWriter maxHeaderTableSize(int n) {
        this.intWriter.configure(n, 5, 32);
        this.maxSize = n;
        return this;
    }

    @Override
    public boolean write(HeaderTable headerTable, ByteBuffer byteBuffer) {
        if (!this.tableUpdated) {
            headerTable.setMaxSize(this.maxSize);
            this.tableUpdated = true;
        }
        return this.intWriter.write(byteBuffer);
    }

    @Override
    public BinaryRepresentationWriter reset() {
        this.intWriter.reset();
        this.maxSize = -1;
        this.tableUpdated = false;
        return this;
    }
}

