/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.lib.javatest;

import com.sun.interview.ChoiceQuestion;
import com.sun.interview.ErrorQuestion;
import com.sun.interview.ExtensionFileFilter;
import com.sun.interview.FileFilter;
import com.sun.interview.FileListQuestion;
import com.sun.interview.FinalQuestion;
import com.sun.interview.IntQuestion;
import com.sun.interview.Interview;
import com.sun.interview.Question;
import com.sun.interview.YesNoQuestion;
import com.sun.javatest.ExcludeList;
import com.sun.javatest.ExcludeListFilter;
import com.sun.javatest.InterviewParameters;
import com.sun.javatest.Parameters;
import com.sun.javatest.TestFilter;
import com.sun.javatest.TestSuite;
import com.sun.javatest.WorkDirectory;
import com.sun.javatest.util.I18NResourceBundle;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.Vector;

public class TSExcludeListInterview
extends Interview
implements Parameters.MutableExcludeListParameters {
    private YesNoQuestion qNeedExcludeLists = new YesNoQuestion(this, "needExcludeList"){
        {
            this.setValue("Yes");
        }

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            if (this.value == "Yes") {
                return TSExcludeListInterview.this.qExcludeListType;
            }
            return TSExcludeListInterview.this.qEnd;
        }
    };
    private static String initial = "initial";
    private static String latest = "latest";
    private static String custom = "custom";
    private ChoiceQuestion qExcludeListType = new ChoiceQuestion(this, "excludeListType"){
        private boolean initialized;
        {
            try {
                I18NResourceBundle rb = I18NResourceBundle.getBundleForClass(Class.forName("com.sun.ts.lib.javatest.TSExcludeListInterview"));
                initial = rb.getString("TSExcludeListInterview.excludeList.choice.initial");
                latest = rb.getString("TSExcludeListInterview.excludeList.choice.latest");
                custom = rb.getString("TSExcludeListInterview.excludeList.choice.custom");
            }
            catch (ClassNotFoundException cnfe) {
                System.err.println("Cannot load the resource bundle for the package containing the class, com.sun.ts.lib.javatest.TSExcludeListInterview");
                cnfe.printStackTrace();
            }
            this.setChoices(new String[]{null, initial, latest, custom}, true);
            this.setValue(initial);
        }

        public String[] getChoices() {
            if (!this.initialized && TSExcludeListInterview.this.parent.getTestSuite() != null) {
                this.init(TSExcludeListInterview.this.parent.getTestSuite());
            }
            return super.getChoices();
        }

        public boolean isHidden() {
            return this.getChoices().length == 2;
        }

        public String getValue() {
            return this.isHidden() ? custom : super.getValue();
        }

        protected Question getNext() {
            if (this.isHidden()) {
                return TSExcludeListInterview.this.qCustomFiles;
            }
            if (this.value == null || this.value.length() == 0) {
                return null;
            }
            if (this.value.equals(initial)) {
                return TSExcludeListInterview.this.qEnd;
            }
            if (this.value.equals(latest)) {
                return TSExcludeListInterview.this.qLatestAutoCheck;
            }
            return TSExcludeListInterview.this.qCustomFiles;
        }

        private void init(TestSuite ts) {
            Vector<String> v = new Vector<String>(4);
            v.add(null);
            if (ts.getInitialExcludeList() != null) {
                v.add(initial);
            }
            if (ts.getLatestExcludeList() != null) {
                v.add(latest);
            }
            v.add(custom);
            Object[] choices = new String[v.size()];
            v.copyInto(choices);
            this.setChoices((String[])choices, true);
            this.initialized = true;
        }
    };
    private YesNoQuestion qLatestAutoCheck = new YesNoQuestion(this, "latestAutoCheck"){
        {
            this.setValue("No");
        }

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            if (this.value == "Yes") {
                return TSExcludeListInterview.this.qLatestAutoCheckMode;
            }
            return TSExcludeListInterview.this.qEnd;
        }
    };
    private static final String EVERY_X_DAYS = "everyXDays";
    private static final String EVERY_RUN = "everyRun";
    private ChoiceQuestion qLatestAutoCheckMode = new ChoiceQuestion(this, "latestAutoCheckMode"){
        {
            this.setChoices(new String[]{TSExcludeListInterview.EVERY_X_DAYS, TSExcludeListInterview.EVERY_RUN}, true);
        }

        protected Question getNext() {
            if (this.value == null) {
                return null;
            }
            if (this.value.equals(TSExcludeListInterview.EVERY_X_DAYS)) {
                return TSExcludeListInterview.this.qLatestAutoCheckInterval;
            }
            return TSExcludeListInterview.this.qEnd;
        }
    };
    private IntQuestion qLatestAutoCheckInterval = new IntQuestion(this, "latestAutoCheckInterval"){
        {
            this.setBounds(1, 365);
            this.setValue(7);
        }

        protected Question getNext() {
            return TSExcludeListInterview.this.qEnd;
        }
    };
    private FileListQuestion qCustomFiles = new FileListQuestion(this, "customFiles"){
        {
            this.setFilter((FileFilter)new ExtensionFileFilter(".jtx", "Exclude List"));
        }

        protected Question getNext() {
            TSExcludeListInterview.this.updateCachedExcludeListData();
            if (TSExcludeListInterview.this.cachedExcludeListError != null) {
                return TSExcludeListInterview.this.cachedExcludeListError;
            }
            return TSExcludeListInterview.this.qEnd;
        }

        public File getBaseDirectory() {
            TestSuite ts = TSExcludeListInterview.this.parent.getTestSuite();
            return ts == null ? null : ts.getRootDir();
        }
    };
    private ExcludeList cachedExcludeList;
    private ExcludeListFilter cachedExcludeListFilter;
    private Question cachedExcludeListError;
    private Object[] cachedExcludeListErrorArgs;
    private TestSuite cachedExcludeList_testSuite;
    private File[] cachedExcludeList_files;
    private ErrorQuestion qExcludeListFileNotFound = new ErrorQuestion(this, "excludeListFileNotFound"){

        protected Object[] getTextArgs() {
            return TSExcludeListInterview.this.cachedExcludeListErrorArgs;
        }
    };
    private ErrorQuestion qExcludeListIOError = new ErrorQuestion(this, "excludeListIOError"){

        protected Object[] getTextArgs() {
            return TSExcludeListInterview.this.cachedExcludeListErrorArgs;
        }
    };
    private ErrorQuestion qExcludeListError = new ErrorQuestion(this, "excludeListError"){

        protected Object[] getTextArgs() {
            return TSExcludeListInterview.this.cachedExcludeListErrorArgs;
        }
    };
    private Question qEnd = new FinalQuestion((Interview)this);
    private InterviewParameters parent;

    public TSExcludeListInterview(InterviewParameters parent) throws Interview.Fault {
        super((Interview)parent, "excludeList");
        this.parent = parent;
        this.setResourceBundle("i18n");
        this.setFirstQuestion((Question)this.qNeedExcludeLists);
    }

    public File[] getExcludeFiles() {
        if (this.qNeedExcludeLists.getValue() == "Yes") {
            String t = this.qExcludeListType.getValue();
            if (t == initial) {
                File f = this.parent.getTestSuite().getInitialExcludeList();
                if (f == null) {
                    return null;
                }
                return new File[]{f};
            }
            if (t == latest) {
                URL u = this.parent.getTestSuite().getLatestExcludeList();
                if (u == null) {
                    return null;
                }
                WorkDirectory wd = this.parent.getWorkDirectory();
                return new File[]{wd.getSystemFile("latest.jtx")};
            }
            return this.qCustomFiles.getValue();
        }
        return null;
    }

    public void setExcludeFiles(File[] files) {
        if (files == null || files.length == 0) {
            this.setExcludeMode(1);
        } else {
            this.setExcludeMode(4);
            this.setCustomExcludeFiles(files);
        }
    }

    public int getExcludeMode() {
        if (this.qNeedExcludeLists.getValue() == "Yes") {
            String t = this.qExcludeListType.getValue();
            if (t == initial) {
                return 2;
            }
            if (t == latest) {
                return 3;
            }
            return 4;
        }
        return 1;
    }

    public void setExcludeMode(int mode) {
        if (mode == 1) {
            this.qNeedExcludeLists.setValue("No");
        } else {
            this.qNeedExcludeLists.setValue("Yes");
            switch (mode) {
                case 2: {
                    this.qExcludeListType.setValue(initial);
                    break;
                }
                case 3: {
                    this.qExcludeListType.setValue(latest);
                    break;
                }
                default: {
                    this.qExcludeListType.setValue(custom);
                }
            }
        }
    }

    public File[] getCustomExcludeFiles() {
        return this.qCustomFiles.getValue();
    }

    public void setCustomExcludeFiles(File[] files) {
        this.qCustomFiles.setValue(files);
    }

    public boolean isLatestExcludeAutoCheckEnabled() {
        return this.qLatestAutoCheck.getValue() == "Yes";
    }

    public void setLatestExcludeAutoCheckEnabled(boolean b) {
        this.qLatestAutoCheck.setValue(b ? "Yes" : "No");
    }

    public int getLatestExcludeAutoCheckMode() {
        return this.qLatestAutoCheckMode.getValue() == EVERY_X_DAYS ? 1 : 2;
    }

    public void setLatestExcludeAutoCheckMode(int mode) {
        if (mode == 1) {
            this.qLatestAutoCheckMode.setValue(EVERY_X_DAYS);
        } else {
            this.qLatestAutoCheckMode.setValue(EVERY_RUN);
        }
    }

    public int getLatestExcludeAutoCheckInterval() {
        return this.qLatestAutoCheckInterval.getValue();
    }

    public void setLatestExcludeAutoCheckInterval(int days) {
        this.qLatestAutoCheckInterval.setValue(days);
    }

    public ExcludeList getExcludeList() {
        if (this.qNeedExcludeLists.getValue() == "Yes") {
            this.updateCachedExcludeListData();
            return this.cachedExcludeList;
        }
        return new ExcludeList();
    }

    public TestFilter getExcludeFilter() {
        if (this.qNeedExcludeLists.getValue() == "Yes") {
            this.updateCachedExcludeListData();
            return this.cachedExcludeListFilter;
        }
        return null;
    }

    private void updateCachedExcludeListData() {
        TestSuite ts = this.parent.getTestSuite();
        File[] files = TSExcludeListInterview.getAbsoluteFiles(ts.getRoot(), this.getExcludeFiles());
        if (!TSExcludeListInterview.equal(this.cachedExcludeList_files, files) || this.cachedExcludeList_testSuite != ts) {
            try {
                ExcludeList t = ts == null || files == null || files.length == 0 ? new ExcludeList() : new ExcludeList(files);
                this.cachedExcludeList = t;
                this.cachedExcludeListFilter = new ExcludeListFilter(t);
                this.cachedExcludeListError = null;
            }
            catch (FileNotFoundException e) {
                this.cachedExcludeList = null;
                this.cachedExcludeListFilter = null;
                this.cachedExcludeListError = this.qExcludeListFileNotFound;
                this.cachedExcludeListErrorArgs = new String[]{e.getMessage()};
            }
            catch (IOException e) {
                this.cachedExcludeList = null;
                this.cachedExcludeListFilter = null;
                this.cachedExcludeListError = this.qExcludeListIOError;
                this.cachedExcludeListErrorArgs = new String[]{e.toString()};
            }
            catch (ExcludeList.Fault e) {
                this.cachedExcludeList = null;
                this.cachedExcludeListFilter = null;
                this.cachedExcludeListError = this.qExcludeListError;
                this.cachedExcludeListErrorArgs = new String[]{e.getMessage()};
            }
            this.cachedExcludeList_files = files;
        }
    }

    private static File[] getAbsoluteFiles(File baseDir, File[] files) {
        if (files == null) {
            return null;
        }
        boolean allAbsolute = true;
        for (int i = 0; i < files.length && allAbsolute; ++i) {
            allAbsolute = files[i].isAbsolute();
        }
        if (allAbsolute) {
            return files;
        }
        File[] absoluteFiles = new File[files.length];
        for (int i = 0; i < files.length; ++i) {
            File f = files[i];
            absoluteFiles[i] = f.isAbsolute() ? f : new File(baseDir, f.getPath());
        }
        return absoluteFiles;
    }

    private static boolean equal(File f1, File f2) {
        return f1 == null ? f2 == null : f1.equals(f2);
    }

    private static boolean equal(File[] f1, File[] f2) {
        if (f1 == null || f2 == null) {
            return f1 == f2;
        }
        if (f1.length != f2.length) {
            return false;
        }
        for (int i = 0; i < f1.length; ++i) {
            if (f1[i] == f2[i]) continue;
            return false;
        }
        return true;
    }
}

