/*
 * Decompiled with CFR 0.152.
 */
package javasoft.sqe.apiCheck;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Vector;
import javasoft.sqe.apiCheck.Main;
import javasoft.sqe.apiCheck.Path;
import javasoft.sqe.apiCheck.UnitClass;
import javasoft.sqe.apiCheck.UnitConstructor;
import javasoft.sqe.apiCheck.UnitField;
import javasoft.sqe.apiCheck.UnitMethod;
import javasoft.sqe.apiCheck.UnitPack;
import javasoft.sqe.apiCheck.Units;
import javasoft.sqe.apiCheck.UnitsWalk;
import javasoft.sqe.apiCheck.XClass;
import javasoft.sqe.apiCheck.XClassConstructor;
import javasoft.sqe.apiCheck.XClassField;
import javasoft.sqe.apiCheck.XClassMethod;
import javasoft.sqe.apiCheck.XPack;
import javasoft.sqe.apiCheck.XProg;
import javasoft.sqe.apiCheck.XProgWalk;
import javasoft.sqe.apiCheck.XType;
import javasoft.sqe.apiCheck.XTypes;

class Converter {
    Converter() {
    }

    static void Convert(Units units, XProg xprog) {
        long t0 = Main.GetTimer();
        Loop1 loop1 = new Loop1();
        loop1.xprog = xprog;
        loop1.Walk(units);
        loop1 = null;
        Loop2 loop2 = new Loop2();
        loop2.xprog = xprog;
        loop2.Walk(units);
        loop2 = null;
        Loop3 loop3 = new Loop3();
        loop3.Walk(xprog, null);
        Main.PrintTimer("ConvertUnitsToXProg", t0);
    }

    static XClass FindTop(XProg prog, String s) {
        return prog.DefineClass(s.substring(0, s.length() - 1));
    }

    static void Convert(XProg xprog, Units units) {
        long t0 = Main.GetTimer();
        XProgConverter c = new XProgConverter();
        c.units = units;
        c.Walk(xprog, null);
        Main.PrintTimer("ConvertXProgToUnits", t0);
    }

    static String[] ConvertStrings(Vector v) {
        if (v.size() == 0) {
            return null;
        }
        String[] x = new String[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            x[i] = ((XClass)v.elementAt(i)).FullName().intern();
        }
        return x;
    }

    static String[] Convert(XTypes v) {
        if (v.size() == 0) {
            return null;
        }
        String[] x = new String[v.size()];
        for (int i = 0; i < v.size(); ++i) {
            x[i] = ((XType)v.elementAt(i)).toString().intern();
        }
        return x;
    }

    static String Form(String[] a) {
        if (a == null || a.length == 0) {
            return "";
        }
        String s = "";
        for (int i = 0; i < a.length; ++i) {
            if (s.length() != 0) {
                s = s + ",";
            }
            s = s + a[i];
        }
        return s;
    }

    static class XProgConverter
    extends XProgWalk {
        Units units;

        XProgConverter() {
        }

        void Walk(XPack x) {
            UnitPack u = new UnitPack();
            u.fname = x.fname;
            u.linenb = x.linenb;
            u.Name(x.top == null ? null : x.top.FullName() + '.', x.toString());
            this.units.add(u);
            super.Walk(x);
        }

        void Walk(XClass x) {
            UnitClass u = new UnitClass();
            u.fname = x.fname;
            u.linenb = x.linenb;
            u.defined = x.defined;
            u.modifier = x.modifier;
            u.extend = x.extend == null ? null : x.extend.FullName().intern();
            u.implement = Converter.ConvertStrings(x.implement);
            u.Name(x.home == null ? x.pack.FullName() + '.' : x.home.FullName() + '.', x.name);
            this.units.add(u);
            if (x.defined) {
                super.Walk(x);
            }
        }

        void Walk(XClassConstructor x) {
            UnitConstructor w = new UnitConstructor();
            w.fname = x.fname;
            w.linenb = x.linenb;
            w.modifier = x.modifier;
            w.args = Converter.Convert(x.args);
            w.xthrows = Converter.Convert(x.xthrows);
            w.Name(x.home.FullName() + '.', x.name);
            this.units.add(w);
        }

        void Walk(XClassMethod x) {
            UnitMethod w = new UnitMethod();
            w.fname = x.fname;
            w.linenb = x.linenb;
            w.modifier = x.modifier;
            w.type = x.type.toString().intern();
            w.args = Converter.Convert(x.args);
            w.xthrows = Converter.Convert(x.xthrows);
            w.Name(x.home.FullName() + '.', x.name);
            this.units.add(w);
        }

        void Walk(XClassField x) {
            UnitField w = new UnitField();
            w.fname = x.fname;
            w.linenb = x.linenb;
            w.modifier = x.modifier;
            w.type = x.type.toString().intern();
            w.value = x.value;
            w.Name(x.home.FullName() + '.', x.name);
            this.units.add(w);
        }
    }

    static class Loop3
    extends XProgWalk {
        boolean xstrictfp = false;
        boolean xinterface = false;

        Loop3() {
        }

        void Walk(XClass x) {
            boolean xstrictfpold = this.xstrictfp;
            boolean xinterfaceold = this.xinterface;
            boolean bl = this.xstrictfp = (x.modifier & 0x800) != 0;
            if ((x.modifier & 0x200) != 0) {
                this.xinterface = true;
                x.modifier &= 0xFFFFFBFF;
            }
            super.Walk(x);
            this.xinterface = xinterfaceold;
            this.xstrictfp = xstrictfpold;
        }

        void Walk(XClassConstructor x) {
            if (this.xstrictfp) {
                x.modifier |= 0x800;
            }
        }

        void Walk(XClassMethod x) {
            if (this.xstrictfp) {
                x.modifier |= 0x800;
            }
            if (this.xinterface) {
                x.modifier &= 0xFFFFFBFF;
            }
        }
    }

    static class Loop2
    extends UnitsWalk {
        XProg xprog;

        Loop2() {
        }

        void Walk(UnitClass w) {
            XClass c = this.xprog.DefineClass(w.topname + w.name);
            c.fname = w.fname;
            c.linenb = w.linenb;
            c.defined = w.defined;
            c.modifier = w.modifier;
            if (w.extend != null) {
                c.extend = this.xprog.DefineClass(w.extend);
            }
            if (w.implement != null) {
                for (int i = 0; i < w.implement.length; ++i) {
                    c.implement.Add(this.xprog.DefineClass(w.implement[i]));
                }
            }
        }

        void Walk(UnitConstructor w) {
            XClassConstructor x = new XClassConstructor();
            x.fname = w.fname;
            x.linenb = w.linenb;
            x.modifier = w.modifier;
            x.name = w.name;
            x.args = this.xprog.DefineTypes(w.args);
            x.xthrows = this.xprog.DefineTypes(w.xthrows);
            x.Link(Converter.FindTop(this.xprog, w.topname));
        }

        void Walk(UnitMethod w) {
            XClassMethod x = new XClassMethod();
            x.fname = w.fname;
            x.linenb = w.linenb;
            x.modifier = w.modifier;
            x.name = w.name;
            x.type = this.xprog.DefineType(w.type);
            x.args = this.xprog.DefineTypes(w.args);
            x.xthrows = this.xprog.DefineTypes(w.xthrows);
            x.Link(Converter.FindTop(this.xprog, w.topname));
        }

        void Walk(UnitField w) {
            XClassField x = new XClassField();
            x.fname = w.fname;
            x.linenb = w.linenb;
            x.modifier = w.modifier;
            x.name = w.name;
            x.type = this.xprog.DefineType(w.type);
            x.value = w.value;
            x.Link(Converter.FindTop(this.xprog, w.topname));
        }
    }

    static class Loop1
    extends UnitsWalk {
        XProg xprog;
        HashSet classes = new HashSet();

        Loop1() {
        }

        void Walk(Units uu) {
            super.Walk(uu);
            Object[] temp = new String[this.classes.size()];
            this.classes.toArray(temp);
            this.classes = null;
            Arrays.sort(temp);
            for (int i = 0; i < temp.length; ++i) {
                if (XProg.DefineTypePrimitive((String)temp[i]) != null) continue;
                this.xprog.DefineClass((String)temp[i]);
            }
        }

        void Walk(UnitPack u) {
            this.xprog.DefinePack(new Path(u.topname + u.name), true);
        }

        void Walk(UnitClass u) {
            this.DefineType(u.topname + u.name);
            this.DefineType(u.extend);
            this.DefineType(u.implement);
        }

        void Walk(UnitConstructor u) {
            this.DefineType(u.args);
            this.DefineType(u.xthrows);
        }

        void Walk(UnitMethod u) {
            this.DefineType(u.type);
            this.DefineType(u.args);
            this.DefineType(u.xthrows);
        }

        void Walk(UnitField u) {
            this.DefineType(u.type);
        }

        void DefineType(String[] ss) {
            if (ss != null) {
                for (int i = 0; i < ss.length; ++i) {
                    this.DefineType(ss[i]);
                }
            }
        }

        void DefineType(String t) {
            if (t != null) {
                int l = t.length();
                while (t.endsWith("[]")) {
                    t = t.substring(0, l -= 2);
                }
                this.classes.add(t);
            }
        }
    }
}

