/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javatest.exec;

import com.sun.javatest.exec.MonitorState;
import com.sun.javatest.util.I18NResourceBundle;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleValue;
import javax.swing.JComponent;
import javax.swing.Timer;

class ProgressMeter
extends JComponent
implements Accessible {
    private boolean indet;
    private Timer indetTimer;
    private Color[] colors;
    private String[] actions;
    private int[] values;
    private static final int SCALE = 1024;
    private ActionListener actionListener;
    private MouseListener mouseListener;
    private MonitorState state;
    private PM_AccessibleContext ac;
    private volatile Thread myThread;
    private static I18NResourceBundle i18n;

    ProgressMeter(Color[] colors, MonitorState m) {
        this(colors);
        this.state = m;
        this.values = new int[colors.length];
    }

    ProgressMeter(Color[] colors, MonitorState m, String[] actions) {
        this(colors);
        this.actions = actions;
        this.state = m;
        this.values = new int[colors.length];
    }

    ProgressMeter(Color[] colors) {
        this.colors = colors;
        this.values = new int[colors.length];
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.ac == null) {
            this.ac = new PM_AccessibleContext(this);
        }
        return this.ac;
    }

    public void setIndeterminate(boolean state) {
        this.indet = state;
    }

    public void start() {
        if (!this.indet) {
            this.myThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    while (ProgressMeter.this.myThread == 1.currentThread()) {
                        try {
                            Thread thread = ProgressMeter.this.myThread;
                            synchronized (thread) {
                                ProgressMeter.this.update();
                                if (ProgressMeter.this.myThread == null) {
                                    break;
                                }
                                ProgressMeter.this.myThread.wait(5000L);
                            }
                        }
                        catch (InterruptedException interruptedException) {
                        }
                    }
                }
            };
            this.myThread.setPriority(3);
            this.myThread.start();
        } else {
            this.clear();
            this.indetTimer = new Timer(100, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    System.err.println("updating, width=" + ProgressMeter.this.getSize().width);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        if (this.myThread == null) {
            return;
        }
        if (!this.indet) {
            Thread old;
            Thread thread = old = this.myThread;
            synchronized (thread) {
                this.myThread = null;
                old.notify();
            }
        } else {
            this.indetTimer.stop();
            this.clear();
        }
    }

    public void addActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, l);
        if (this.actionListener != null && this.mouseListener == null) {
            this.mouseListener = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent me) {
                    int index = ProgressMeter.this.resolve(me.getX(), me.getY());
                    if (index == -1) {
                        index = ProgressMeter.this.actions.length - 1;
                    }
                    if (index != -1) {
                        ActionEvent ae = new ActionEvent(ProgressMeter.this, 1001, ProgressMeter.this.actions[index]);
                        ProgressMeter.this.actionListener.actionPerformed(ae);
                    }
                }
            };
            this.addMouseListener(this.mouseListener);
        }
    }

    public void removeActionListener(ActionListener l) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, l);
        if (this.actionListener == null) {
            this.removeMouseListener(this.mouseListener);
        }
    }

    public synchronized void clear() {
        this.values = new int[this.colors.length];
        this.repaint();
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(30, 8);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(50, 15);
    }

    public synchronized void set(int[] v) {
        int total = 0;
        for (int i = 0; i < v.length; ++i) {
            total += v[i];
        }
        this.set(v, total);
    }

    public synchronized void update() {
        int[] stats = this.state.getStats();
        this.set(stats, this.state.getTestsFoundCount());
    }

    public synchronized void set(int[] v, int total) {
        boolean changed = false;
        int totalSoFar = 0;
        for (int i = 0; i < v.length; ++i) {
            int x;
            int n = x = total == 0 ? 0 : (totalSoFar += v[i]) * 1024 / total;
            if (this.values[i] == x) continue;
            this.values[i] = x;
            changed = true;
        }
        if (changed) {
            this.repaint(100L);
            if (this.ac != null) {
                this.ac.notifyNewStats();
            }
        }
    }

    @Override
    public synchronized void paint(Graphics g) {
        Dimension dims = this.getSize();
        g.drawRect(0, 0, dims.width - 1, dims.height - 1);
        g.setColor(Color.white);
        g.fillRect(1, 1, dims.width - 2, dims.height - 2);
        int start = 0;
        for (int i = 0; i < this.values.length; ++i) {
            int end = this.values[i] * (dims.width - 2) / 1024;
            g.setColor(this.colors[i]);
            g.fillRect(1 + start, 1, end - start, dims.height - 2);
            start = end;
        }
    }

    int resolve(int x, int y) {
        Dimension dims = this.getSize();
        if (x > 0) {
            for (int i = 0; i < this.values.length; ++i) {
                int end = this.values[i] * (dims.width - 2) / 1024;
                if (x >= end) continue;
                return i;
            }
        }
        return -1;
    }

    private class PM_AccessibleContext
    extends JComponent.AccessibleJComponent
    implements AccessibleValue {
        private ProgressMeter pm;

        PM_AccessibleContext(ProgressMeter pm) {
            super(ProgressMeter.this);
            this.pm = pm;
        }

        @Override
        public String getAccessibleDescription() {
            String superdesc = super.getAccessibleDescription();
            if (superdesc == null) {
                return this.pm.getToolTipText();
            }
            if (i18n == null) {
                i18n = I18NResourceBundle.getBundleForClass(this.getClass());
            }
            return i18n.getString("pmtr.desc");
        }

        @Override
        public String getAccessibleName() {
            String supername = super.getAccessibleName();
            if (supername == null) {
                if (i18n == null) {
                    i18n = I18NResourceBundle.getBundleForClass(this.getClass());
                }
                return i18n.getString("pmtr.name");
            }
            return supername;
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PROGRESS_BAR;
        }

        @Override
        public AccessibleValue getAccessibleValue() {
            return this;
        }

        @Override
        public Number getCurrentAccessibleValue() {
            int ttl = 0;
            int[] stats = ProgressMeter.this.state.getStats();
            for (int i = 0; i < stats.length - 1; ++i) {
                ttl += stats[i];
            }
            return new Integer(ttl);
        }

        @Override
        public Number getMaximumAccessibleValue() {
            return new Integer(ProgressMeter.this.state.getTestsFoundCount());
        }

        @Override
        public Number getMinimumAccessibleValue() {
            return new Integer(0);
        }

        @Override
        public boolean setCurrentAccessibleValue(Number n) {
            return false;
        }

        void notifyNewStats() {
        }
    }
}

