/*
 * Copyright (c) 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */


package  com.sun.ts.lib.deliverable.securityapi;

import  com.sun.ts.lib.deliverable.*;
import  com.sun.javatest.*;
import  java.util.*;
import  com.sun.ts.lib.deliverable.tck.TCKPropertyManager;


/**
 * This class serves as a well known place for harness, util, and porting
 * classes to retrieve property values.
 *
 * @author
 */
public class SecurityAPIPropertyManager extends TCKPropertyManager {
    private static SecurityAPIPropertyManager jteMgr = new SecurityAPIPropertyManager();

    /**
     * This method returns
     * the singleton instance of SecurityAPIPropertyManager which provides access
     * to all ts.jte properties.  This is only called once by the test harness.
     *
     * @param	env - TestEnvironment object from JavaTest
     * @return	SecurityAPIPropertyManager - singleton property manager object
     */
    public final static SecurityAPIPropertyManager getSecurityAPIPropertyManager (TestEnvironment env) throws Exception {
        jteMgr.setTestEnvironment(env);
        return  jteMgr;
    }

    /**
     * This method returns
     * the singleton instance of SecurityAPIPropertyManager which provides access
     * to all ts.jte properties.  This is only called by the init()
     * method in ManualDeployment.java
     *
     * @param	p - Properties object from JavaTest
     * @return	SecurityAPIPropertyManager - singleton property manager object
     */
    public final static SecurityAPIPropertyManager getSecurityAPIPropertyManager (Properties p) throws Exception {
        jteMgr.setJteProperties(p);
        return  jteMgr;
    }

    public final static SecurityAPIPropertyManager getSecurityAPIPropertyManager () throws Exception {
        return  jteMgr;
    }

    /**
     * This method is called by the test harness to retrieve all properties
     * needed by a particular test.
     *
     * @param	sPropKeys - Properties to retrieve
     * @return	Properties - property/value pairs
     */
    public Properties getTestSpecificProperties (String[] sPropKeys) throws PropertyNotSetException {
        Properties pTestProps = super.getTestSpecificProperties(sPropKeys);
        String sJtePropVal = "";
        pTestProps.put("porting.ts.url.class.1", getProperty("porting.ts.url.class.1"));
        pTestProps.put("porting.ts.HttpsURLConnection.class.1", getProperty("porting.ts.HttpsURLConnection.class.1", null));
            
	String tsHome = getProperty("TS_HOME", null);
	if(tsHome == null)
	    tsHome = getProperty("cts_home", null);
	if(tsHome != null)
            pTestProps.put("cts_home", tsHome);
	
        return  pTestProps;
    }
}



