/*
 * Copyright (c) 2007, 2009, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * $Id: RemoteComponent.java 62564 2011-04-18 20:29:25Z kgrucci $
 */
package com.sun.ts.lib.tests.jbi;

import java.rmi.*;
import java.rmi.server.*;
import java.rmi.registry.*;
import javax.jbi.component.ComponentContext;
import javax.jbi.JBIException;
import javax.naming.InitialContext;
import java.lang.reflect.*;

/*
 * Extends the BaseComponent to add Remote object functionality.  All JBI TCK components
 * that are remote components should extend this class.  RMI over JRMP is the mechanism
 * used to allow test clients to speak to JBI components.
 */
public abstract class RemoteComponent extends BaseComponent {

    protected String host;
    protected int    port;
    protected String name;
    protected Result result;
    
    public RemoteComponent() {
    }

    public abstract Remote getRemoteObject();

    // Used to bind this remote object
    public void init(ComponentContext arg0) throws JBIException {
	super.init(arg0);
	try {
	    if (System.getSecurityManager() == null) {
		System.setSecurityManager(new RMISecurityManager());
	    }
	    initProps();
	    Remote r = getRemoteObject();
	    RemoteStub stub = UnicastRemoteObject.exportObject(r);
	    Registry registry = RegistryUtils.getRunningRegistry(host, port);
	    RegistryUtils.bindObject(registry, name, stub, true);
	} catch(Exception e) {
	    throw new JBIException("RemoteComponent.init(). Failed", e);
	}
    }
   
    public void stop() throws JBIException {	
	super.stop();
	try {
	    fini();
	} catch(Exception e) {
	    throw new JBIException(NAME + ".stop() Failed", e);
	}
    }

    // used to unbind a remote object
    protected void fini() throws Exception {
	try
    {
        Registry registry = RegistryUtils.getRunningRegistry(host, port);
	    registry.unbind(name);
    }
    catch(Exception e)
    {
        System.err.println(NAME + ".fini failed while trying to unbind from " + 
                            "the rmi registry running on host=" + 
                            host + " and port=" + port);
        e.printStackTrace();
    }
    }

    // default impl reads from the JNDI naming context
    protected void initProps() throws Exception {
	InitialContext ictx = ctx.getNamingContext();
	port = ((Integer)(ictx.lookup(Constants.RMI_PORT_NAME))).intValue();
	host = (String)(ictx.lookup(Constants.RMI_HOST_NAME));
	name = (String)(ictx.lookup(Constants.RMI_BIND_NAME));
    }

    protected Result invoke(ServiceRequest request) throws Exception
    {
        try
        {
	        result = new Result(false);
            String reqStr = request.getRequest();
            testInit(request.getProperties());
	        Class clazz          = this.getClass();
	        Class[] argTypes     = new Class[] {Result.class};
	        Object[] args        = new Object[] {result};
	        Method method = clazz.getDeclaredMethod(reqStr, argTypes);
	        method.invoke(this, args);
            return result;
        }
        catch(Exception e)
        {
	        throw new Exception("ERROR ", e);
        }
    }
    
} // end class RemoteComponent
