/*
* Copyright (c) 2009, 2010, Oracle and/or its affiliates. All rights reserved.
* ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
*/

package com.sun.ts.tests.common.connector.whitebox.mixedmode;


import javax.resource.spi.BootstrapContext;
import javax.resource.spi.work.WorkManager;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.WorkException;
import com.sun.ts.tests.common.connector.whitebox.WorkImpl;
import com.sun.ts.tests.common.connector.whitebox.WorkListenerImpl;
import com.sun.ts.tests.common.connector.whitebox.Debug;


public class PMDWorkManager
{
    private BootstrapContext bsc=null;
    private WorkManager wmgr;
    private String sicUser = ""; 
    private String sicPwd = ""; 
    private String eisUser = ""; 



    public PMDWorkManager(BootstrapContext val)
    {
        debug("enterred constructor");
        this.bsc = val;
        this.wmgr = bsc.getWorkManager();

        this.sicUser = System.getProperty("j2eelogin.name");
        this.sicPwd = System.getProperty("j2eelogin.password");
        this.eisUser = System.getProperty("eislogin.name");
        debug("leaving constructor");
    }


    public void runTests()
    {
        debug("enterred runTests");
        doWork();
        debug("leaving runTests");
    }


    public void doWork()
    {
        debug("enterred doWork");


        try {
            WorkImpl workimpl = new WorkImpl(wmgr);

            ExecutionContext ec = new ExecutionContext();
            WorkListenerImpl wl = new WorkListenerImpl(); 
            wmgr.doWork(workimpl, 5000, ec, wl);
            debug("PMDWorkManager Work Object Submitted");
        } catch (WorkException we) {
            System.out.println("PMDWorkManager WorkException thrown is " + we.getMessage());
        } catch (Exception ex) {
            System.out.println("PMDWorkManager Exception thrown is " + ex.getMessage());
        }

        debug("leaving doWork");
    }


    public void debug(String out) {
        Debug.trace("PMDWorkManager:  " + out);
    }


}
