/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tdk.signaturetest.core;

public class PrimitiveTypes {
    private static Pair[] types = new Pair[]{new Pair('Z', "boolean"), new Pair('V', "void"), new Pair('I', "int"), new Pair('J', "long"), new Pair('C', "char"), new Pair('B', "byte"), new Pair('D', "double"), new Pair('S', "short"), new Pair('F', "float")};

    private PrimitiveTypes() {
    }

    public static boolean isPrimitive(String string) {
        for (int i = 0; i < types.length; ++i) {
            if (!PrimitiveTypes.types[i].JLSNotation.equals(string)) continue;
            return true;
        }
        return false;
    }

    public static String getPrimitiveType(char c) {
        for (int i = 0; i < types.length; ++i) {
            if (c != PrimitiveTypes.types[i].VMNotation) continue;
            return PrimitiveTypes.types[i].JLSNotation;
        }
        return null;
    }

    public static String getVMPrimitiveType(String string) {
        for (int i = 0; i < types.length; ++i) {
            if (!PrimitiveTypes.types[i].JLSNotation.equals(string)) continue;
            return String.valueOf(PrimitiveTypes.types[i].VMNotation);
        }
        return null;
    }

    private static class Pair {
        char VMNotation;
        String JLSNotation;

        Pair(char c, String string) {
            this.VMNotation = c;
            this.JLSNotation = string;
        }
    }
}

